(*
 * Isomorphic: Union A Unit
 * Ignore: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.DecSetoids.Unit.

Section AddConstant.

   Variable A : DecSetoid.

   Definition const := inr A tt.

   Definition addConstDecSetoid : DecSetoid :=
      unionDecSetoid A unitDecSetoid.

   (**********************************************************)
   (*                     Properties                         *)
   (**********************************************************)
   
   (* NOTE:
    * All properties should be infered from union and unit setoid rules
    *)

    
   (* TO BE REMOVED *)
   (*
   Lemma addConst_IsEmpty_comp : IsEmpty_comp addConstDecSetoid.
   Proof.
      red. elimExists const. split.
   Defined.
   
   Lemma addConst_IsSingleton : IsEmpty A -> IsSingleton addConstDecSetoid.
   Proof.
      intro H; red; red in H.
      elimExists const; intros x.
      destruct x. intuition.
      simpl.
      destruct c.
      compute.
      split.
   Defined.

   Lemma addConst_IsSingleton_comp : IsEmpty_comp A -> IsSingleton_comp addConstDecSetoid.
   Proof.
      intro H; red; red in H; intro c.
      destruct H as [x xt].
      destruct c.
         elimExists const. unfold const. intros H. simpl in H. trivial.
         elimExists (inl unit x). intros H. simpl in H; trivial.
   Defined.

   Lemma twoElements : IsSingleton A -> TwoElements addConstDecSetoid.
   Proof. intros SA. apply Union.twoElements.
      apply inr; apply inr; split; trivial.
      red; elimExists tt. intros []; compute; trivial.
   Defined.

   Lemma twoElements_comp : IsSingleton_comp A -> TwoElements_comp addConstDecSetoid.
   Proof. intros sa. apply Union.twoElements_comp.
      split. apply inr; apply Unit.twoElements_comp.
      split. apply inl; apply Unit.unit_IsEmpty_comp.
      apply inl; trivial.
   Defined.

   Lemma isFinite : Finite A -> Finite addConstDecSetoid.
   Proof. intros fa. apply Union.isFinite. split. trivial.
      apply Unit.isFinite.
   Defined.
   
   Lemma isFinite_comp : Finite_comp A -> Finite_comp addConstDecSetoid.
   Proof. intros fa. apply Union.isFinite_comp. apply inl. trivial. Defined.
   *)

End AddConstant.

(* TO BE REMOVED *)
(*
Ltac decSetoids_AddConstant :=
      apply addConst_IsEmpty_comp
   || apply addConst_IsSingleton
   || apply addConst_IsSingleton_comp
   || apply twoElements
   || apply twoElements_comp
   || apply isFinite
   || apply isFinite_comp.
*)
