(*
 * Skip: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.


(*************************************************************)
(*                Swap places two operators                  *)
(*************************************************************)

Section Swap.
    Variables BS : Bisemigroup.

    Definition swapBisemigroup : Bisemigroup :=
       glueBSmg (timesSmg BS) (plusSmg BS) (dsEq_refl _).
          (* (ds_eq_refl BS (@choose BS) (@equal BS) (@refl BS) (@sym BS) (@trans BS)). *)

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)
   
   Open Scope Bisemigroup_scope.

(*   
   Lemma isLeftDistributive : IsLeftCoDistributive BS -> IsLeftDistributive swapBisemigroup.
   Proof. intros lcd x y z; simpl; apply lcd. Defined.
   
   Lemma isLeftDistributive_comp : IsLeftCoDistributive_comp BS -> IsLeftDistributive_comp swapBisemigroup.
   Proof. intros [x [y [z lcd]]]; red; exists x; exists y; exists z; simpl; apply lcd. Defined.

   Lemma isRightDistributive : IsRightCoDistributive BS -> IsRightDistributive swapBisemigroup.
   Proof. intros lcd x y z; simpl; apply lcd. Defined.
   
   Lemma isRightDistributive_comp : IsRightCoDistributive_comp BS -> IsRightDistributive_comp swapBisemigroup.
   Proof. intros [x [y [z lcd]]]; red; exists x; exists y; exists z; simpl; apply lcd. Defined.

   Lemma isLeftCoDistributive : IsLeftDistributive BS -> IsLeftCoDistributive swapBisemigroup.
   Proof. intros lcd x y z. simpl. apply lcd. Defined.
   
   Lemma isLeftCoDistributive_comp : IsLeftDistributive_comp BS -> IsLeftCoDistributive_comp swapBisemigroup.
   Proof. intros [x [y [z lcd]]]; red; exists x; exists y; exists z; simpl; apply lcd. Defined.

   Lemma isRightCoDistributive : IsRightDistributive BS -> IsRightCoDistributive swapBisemigroup.
   Proof. intros lcd x y z; simpl; apply lcd. Defined.
   
   Lemma isRightCoDistributive_comp : IsRightDistributive_comp BS -> IsRightCoDistributive_comp swapBisemigroup.
   Proof. intros [x [y [z lcd]]]; red; exists x; exists y; exists z; simpl; apply lcd. Defined.
*)
   
   Lemma plusIdentityIsTimesAnnihilator : PlusAnnihilatorIsTimesIdentity BS -> PlusIdentityIsTimesAnnihilator swapBisemigroup.
   Proof. intros p pid tann; assert (q := p tann pid); rewrite q; auto. Defined.

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusAnnihilatorIsTimesIdentity_comp BS -> PlusIdentityIsTimesAnnihilator_comp swapBisemigroup.
   Proof. intros p pid tann; assert (q := p tann pid). toProp; intros h; elim q; dseq_f; rewrite h; auto. Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusIdentityIsTimesAnnihilator BS -> PlusAnnihilatorIsTimesIdentity swapBisemigroup.
   Proof. intros p pid tann; assert (q := p tann pid); rewrite q; auto. Defined.

   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusIdentityIsTimesAnnihilator_comp BS -> PlusAnnihilatorIsTimesIdentity_comp swapBisemigroup.
   Proof. intros p pid tann; assert (q := p tann pid). toProp; intros h; elim q; dseq_f; rewrite h; auto. Defined.

End Swap.

