Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Constructions.Semigroups.SelLex. 
Require Import Metarouting.Constructions.Semigroups.Product. 
Require Import Coq.Bool.Bool.

(*********************************************************************)
(* direct product of decidable bisemigroups *)



Section LexProduct.

   Open Scope Bisemigroup_scope.

   Variable A B : Bisemigroup.

   Variable A_comm : IsCommutative (plusSmg A).
   Variable A_sel  : IsSelective (plusSmg A).
   Variable B_comm : IsCommutative (plusSmg B).

   Lemma c_idem : forall x : A, @dseq A (x + x) x.
   Proof. intros x; destruct (A_sel x x); auto. Qed.

   Definition selLexBisemigroup : Bisemigroup :=
      let pA := plusSmg A in
      let pB := plusSmg B in
      let tA := timesSmg A in
      let tB := timesSmg B in
      let s1 := selLexSemigroup pA pB A_comm A_sel in
      let s2 := prodSemigroup tA tB in
      glueBSmg s1 s2 (dsEq_refl _). (* (ds_eq_refl _ _ _ _ _ _). *)

   (*********************************************************************)
   (*                          Properties                               *)
   (*********************************************************************)


   Ltac lex_destruct x y h :=
      destruct (lex_case (plusSmg A) A_comm A_sel x y) as [[h|h]|h];
      rewrite ?h;
      rewrite ?(lexComp_equiv (plusSmg A) A_comm)
      , ?(lexComp_less  (plusSmg A) A_comm)
      , ?(lexComp_more  (plusSmg A) A_comm) in h.

   Lemma isRightDistributive : 
        IsRightDistributive A 
      * IsRightDistributive B
      * (RightCancelative (timesSmg A) + RightCondensed (timesSmg B)) -> 
      IsRightDistributive selLexBisemigroup.
   Proof. intros [[ra rb] [rc | rk]] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl;
      rewrite (ra x1 y1 z1); simpl.

      lex_destruct x1 y1 h; lex_destruct (x1 * z1) (y1 * z1) h'; 
      simpl in *; dseq_f; auto;
      destruct h as [h h1];
      destruct h' as [h2 h3].
      elim h3; dseq_f; rewrite <- (ra y1 x1 z1), h1; auto.
      elim h2; dseq_f; rewrite <- (ra x1 y1 z1), h; auto.
      elim h1; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra y1 x1 z1); auto.
      elim h1; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra y1 x1 z1); auto.
      elim h; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra x1 y1 z1); auto.
      elim h; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra x1 y1 z1); auto.

      lex_destruct x1 y1 h; lex_destruct (x1 * z1) (y1 * z1) h'; 
      simpl in *; dseq_f; auto; try (apply rk).
      rewrite <- (rb _ _ z2); apply rk.
      rewrite <- (rb _ _ z2); apply rk.
   Defined.
   
   Lemma isRightDistributive_comp : 
        IsRightDistributive_comp A 
      + IsRightDistributive_comp B
      + (RightCancelative_comp (timesSmg A) * RightCondensed_comp (timesSmg B)) -> 
      IsRightDistributive_comp selLexBisemigroup.
   Proof. intros [[[x [y [z r]]] | [x [y [z r]]]] | [[x1 [y1 [z1 ra]]] [z2 [x2 [y2 rb]]]] ].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      negb_p; rewrite r; auto.
      
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl.
      negb_p; toProp; apply or_intror.
      do 2 rewrite (lexComp_refl _ A_sel); auto.
      
      simpl in *. destruct ra as [r1 r2].
      assert (lexComp (plusSmg A) (x1 * z1) (y1 * z1) = equiv) as q1.
         rewrite (lexComp_equiv _ A_comm); simpl;
         dseq_f; rewrite r1; split; apply c_idem.
      copy_destruct ((x1 + y1 == x1)%bool) as h;
      copy_destruct ((x1 + y1 == y1)%bool) as h1.
      dseq_f; toProp; elim r2; dseq_f; rewrite <- h1, h; auto.
      assert (lexComp (plusSmg A) x1 y1 = less) as q2.
        rewrite lexComp_less; auto. simpl; dseq_f. rewrite h, (A_comm y1 x1).
        simpl. dseq_u; rewrite h1; bool_p; intuition; dseq_f; auto.
      copy_destruct ((x2 * z2 + y2 * z2 == x2 * z2)%bool) as h2.

      exists (x1, y2); exists (y1, x2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      toProp; dseq_f; apply or_intror; intros p; elim rb; dseq_f.
      rewrite p, (B_comm (y2 * z2) (x2 * z2)), h2; auto.

      exists (x1, x2); exists (y1, y2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      bool_p; negb_p; toProp; dseq_f; apply or_intror. intros p; elim h2; dseq_f.
      rewrite <- p; auto.

      assert (lexComp (plusSmg A) x1 y1 = more) as q2.
        rewrite lexComp_more; auto. simpl; dseq_f. rewrite (A_comm x1 y1) in h1.
        bool_p; toProp; tauto.
      copy_destruct ((x2 * z2 + y2 * z2 == x2 * z2)%bool) as h2.

      exists (x1, x2); exists (y1, y2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      toProp; dseq_f; apply or_intror; intros p; elim rb; dseq_f.
      rewrite <- h2, <- p; auto.

      exists (x1, y2); exists (y1, x2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      bool_p; toProp; dseq_f; apply or_intror; intros p; elim h2; dseq_f.
      rewrite (B_comm (x2 * z2) (y2 * z2)), <- p; auto.

      assert (False); [|tauto].
      bool_p; toProp; destruct (A_sel x1 y1); simpl in *; auto.
   Defined.

   Lemma isLeftDistributive : 
        IsLeftDistributive A 
      * IsLeftDistributive B
      * (LeftCancelative (timesSmg A) + LeftCondensed (timesSmg B)) -> 
      IsLeftDistributive selLexBisemigroup.
   Proof. intros [[ra rb] [rc | rk]] [x1 x2] [y1 y2] [z1 z2]; dseq_u; simpl;
      rewrite (ra x1 y1 z1); simpl.

      lex_destruct x1 y1 h; lex_destruct (z1 * x1) (z1 * y1) h'; 
      simpl in *; dseq_f; auto;
      destruct h as [h h1];
      destruct h' as [h2 h3].
      elim h3; dseq_f; rewrite <- (ra y1 x1 z1), h1; auto.
      elim h2; dseq_f; rewrite <- (ra x1 y1 z1), h; auto.
      elim h1; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra y1 x1 z1); auto.
      elim h1; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra y1 x1 z1); auto.
      elim h; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra x1 y1 z1); auto.
      elim h; dseq_f; apply (rc _ _ z1); simpl; rewrite (ra x1 y1 z1); auto.

      lex_destruct x1 y1 h; lex_destruct (z1 * x1) (z1 * y1) h'; 
      simpl in *; dseq_f; auto; try (apply rk).
      rewrite <- (rb _ _ z2); apply rk.
      rewrite <- (rb _ _ z2); apply rk.
   Defined.
   
   Lemma isLeftDistributive_comp : 
        IsLeftDistributive_comp A 
      + IsLeftDistributive_comp B
      + (LeftCancelative_comp (timesSmg A) * LeftCondensed_comp (timesSmg B)) -> 
      IsLeftDistributive_comp selLexBisemigroup.
   Proof. intros [[[x [y [z r]]] | [x [y [z r]]]] | [[x1 [y1 [z1 ra]]] [z2 [x2 [y2 rb]]]] ].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      negb_p; rewrite r; auto.
      
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl.
      negb_p; toProp; apply or_intror.
      do 2 rewrite (lexComp_refl _ A_sel); auto.
      
      simpl in *. destruct ra as [r1 r2].
      assert (lexComp (plusSmg A) (z1 * x1) (z1 * y1) = equiv) as q1.
         rewrite (lexComp_equiv _ A_comm); simpl;
         dseq_f; rewrite r1; split; apply c_idem.
      copy_destruct ((x1 + y1 == x1)%bool) as h;
      copy_destruct ((x1 + y1 == y1)%bool) as h1.
      dseq_f; toProp; elim r2; dseq_f; rewrite <- h1, h; auto.
      assert (lexComp (plusSmg A) x1 y1 = less) as q2.
        rewrite lexComp_less; auto. simpl; dseq_f. rewrite h, (A_comm y1 x1).
        simpl. dseq_u; rewrite h1; bool_p; intuition; dseq_f; auto.
      copy_destruct ((z2 * x2 + z2 * y2 == z2 * x2)%bool) as h2.

      exists (x1, y2); exists (y1, x2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      toProp; dseq_f; apply or_intror; intros p; elim rb; dseq_f.
      rewrite p, (B_comm (z2 * y2) (z2 * x2)), h2; auto.

      exists (x1, x2); exists (y1, y2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      bool_p; negb_p; toProp; dseq_f; apply or_intror. intros p; elim h2; dseq_f.
      rewrite <- p; auto.

      assert (lexComp (plusSmg A) x1 y1 = more) as q2.
        rewrite lexComp_more; auto. simpl; dseq_f. rewrite (A_comm x1 y1) in h1.
        bool_p; toProp; tauto.
      copy_destruct ((z2 * x2 + z2 * y2 == z2 * x2)%bool) as h2.

      exists (x1, x2); exists (y1, y2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      toProp; dseq_f; apply or_intror; intros p; elim rb; dseq_f.
      rewrite <- h2, <- p; auto.

      exists (x1, y2); exists (y1, x2); exists (z1, z2); simpl; negb_p; rewrite q1, q2.
      bool_p; toProp; dseq_f; apply or_intror; intros p; elim h2; dseq_f.
      rewrite (B_comm (z2 * x2) (z2 * y2)), <- p; auto.

      assert (False); [|tauto].
      bool_p; toProp; destruct (A_sel x1 y1); simpl in *; auto.
   Defined.

   Lemma isCommutative_back : IsCommutative (plusSmg selLexBisemigroup) -> IsCommutative (plusSmg B).
   Proof. intros comm a b. simpl.
     assert (p := comm (choose A, a) (choose A, b)). simpl in p.
     rewrite lexComp_refl in p; auto; dseq_u; simpl in p. toProp. tauto.
   Qed.
   
   Lemma isIdempotent_back : IsIdempotent (plusSmg selLexBisemigroup) -> IsIdempotent (plusSmg B).
   Proof.
         intros idem a. simpl.
         assert (p := idem (choose A, a)). simpl in p.
         rewrite lexComp_refl in p; auto; dseq_u; simpl in p; toProp; tauto.
   Qed.

   Ltac lex_idem idem :=
      assert (B_idem := isIdempotent_back idem);
      red in B_idem; simpl in B_idem.

   Lemma hasPlusId_back_a : HasIdentity (plusSmg selLexBisemigroup) -> HasIdentity (plusSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasPlusId_back_b : HasIdentity (plusSmg selLexBisemigroup) -> HasIdentity (plusSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp;
      rewrite lexComp_refl in *; trivial; tauto.
   Defined.

   Lemma hasPlusAnn_back_a : HasAnnihilator (plusSmg selLexBisemigroup) -> HasAnnihilator (plusSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasPlusAnn_back_b : HasAnnihilator (plusSmg selLexBisemigroup) -> HasAnnihilator (plusSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp;
      rewrite lexComp_refl in *; trivial; tauto.
   Defined.

   Lemma hasTimesId_back_a : HasIdentity (timesSmg selLexBisemigroup) -> HasIdentity (timesSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesId_back_b : HasIdentity (timesSmg selLexBisemigroup) -> HasIdentity (timesSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesAnn_back_a : HasAnnihilator (timesSmg selLexBisemigroup) -> HasAnnihilator (timesSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasTimesAnn_back_b : HasAnnihilator (timesSmg selLexBisemigroup) -> HasAnnihilator (timesSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesAnnihilator :
      PlusIdentityIsTimesAnnihilator A * PlusIdentityIsTimesAnnihilator B
      -> PlusIdentityIsTimesAnnihilator selLexBisemigroup.
   Proof. intros [pa pb] pid tann.
      assert (p1 := pa (hasPlusId_back_a pid) (hasTimesAnn_back_a tann)).
      assert (p2 := pb (hasPlusId_back_b pid) (hasTimesAnn_back_b tann)).
      simpl in *.
      destruct pid as [[ia ib] p]; simpl in *.
      destruct tann as [[ta tb] q]; simpl in *.
      dseq_u; simpl; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesAnnihilator_comp :
      PlusIdentityIsTimesAnnihilator_comp A + PlusIdentityIsTimesAnnihilator_comp B
      -> PlusIdentityIsTimesAnnihilator_comp selLexBisemigroup.
   Proof. intros [pa | pb] pid tann.
      assert (p1 := pa (hasPlusId_back_a pid) (hasTimesAnn_back_a tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p1. auto.

      assert (p2 := pb (hasPlusId_back_b pid) (hasTimesAnn_back_b tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p2, orb_true_r. auto.
   Defined. 

   Lemma plusAnnihilatorIsTimesIdentity :
      PlusAnnihilatorIsTimesIdentity A * PlusAnnihilatorIsTimesIdentity B
      -> PlusAnnihilatorIsTimesIdentity selLexBisemigroup.
   Proof. intros [pa pb] pid tann.
      assert (p1 := pa (hasPlusAnn_back_a pid) (hasTimesId_back_a tann)).
      assert (p2 := pb (hasPlusAnn_back_b pid) (hasTimesId_back_b tann)).
      simpl in *.
      destruct pid as [[ia ib] p]; simpl in *.
      destruct tann as [[ta tb] q]; simpl in *.
      dseq_u; simpl; toProp; tauto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity_comp :
      PlusAnnihilatorIsTimesIdentity_comp A + PlusAnnihilatorIsTimesIdentity_comp B
      -> PlusAnnihilatorIsTimesIdentity_comp selLexBisemigroup.
   Proof. intros [pa | pb] pid tann.
      assert (p1 := pa (hasPlusAnn_back_a pid) (hasTimesId_back_a tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p1. auto.

      assert (p2 := pb (hasPlusAnn_back_b pid) (hasTimesId_back_b tann)).
      destruct pid as [[ia ib] p]; destruct tann as [[ta tb] q]; simpl in *.
      negb_p; rewrite p2, orb_true_r. auto.
   Defined. 

   Lemma lss_eq : IsLeftStrictStable A -> forall x y z : A, (z * x <= z * y /\ ~(z * y <= z * x)) <-> (x <= y) /\ ~(y <= x).
   Proof. intros rss x y z. assert (r := rss A_comm c_idem x y z).
      toProp; tauto.
   Defined.

   Lemma isLeftStrictStable : 
         IsLeftStrictStable A
       * IsLeftStrictStable B
      -> IsLeftStrictStable selLexBisemigroup.
   Proof. intros [lssa lssb] (*lcec_ldc]*) comm idem [x1 x2] [y1 y2] [z1 z2]. simpl.
      lex_idem idem.
      rewrite (lexComp_swap _ A_comm A_sel y1 x1).
      rewrite (lexComp_swap _ A_comm A_sel (z1 * y1) (z1 * x1)).

      lex_destruct x1 y1 h; destruct h as [h q].
      lex_destruct (z1 * x1) (z1 * y1) h0.
      destruct h0 as [h0 q0]; simpl in *; rewrite h, q, h0, q0; simpl; apply (lssb B_comm B_idem).
      simpl in *. toBool. rewrite (lss_eq lssa) in h0; negb_p; toProp; rewrite h in h0; intuition.
      simpl in *. destruct h0 as [w1 w2]; assert (h0 := conj w2 w1). rewrite (lss_eq lssa) in h0; negb_p; toProp; rewrite h in h0; intuition.
      
      assert (lexComp (plusSmg A) (z1 * x1) (z1 * y1) = less).
         rewrite (lexComp_less _ A_comm). simpl. rewrite lss_eq; auto.
      rewrite H. simpl. rewrite (lexComp_less _ A_comm) in H. simpl in *. 
      do 2 rewrite refl; simpl.
      toBool; negb_p; toProp; intuition.

      assert (lexComp (plusSmg A) (z1 * x1) (z1 * y1) = more).
         rewrite (lexComp_more _ A_comm). simpl in *. assert (p := lss_eq lssa y1 x1 z1); tauto.
      rewrite H. simpl. rewrite (lexComp_more _ A_comm) in H. simpl in *. 
      do 2 rewrite refl; simpl.
      toBool; negb_p; toProp; intuition.
   Defined.

   Lemma isLeftStrictStable_comp : 
         IsLeftStrictStable_comp A
       + IsLeftStrictStable_comp B
      -> IsLeftStrictStable_comp selLexBisemigroup.
   Proof. intros [lssA | lssB] comm idem; lex_idem idem.
      destruct (lssA A_comm c_idem) as [x1 [y1 [z1 lssa]]].
      set (b := choose B).
      exists (x1, b); exists (y1, b); exists (z1, b); simpl in *.
      rewrite (lexComp_swap _ A_comm A_sel y1);
      rewrite (lexComp_swap _ A_comm A_sel (z1 * y1)).
      destruct lssa as [[p1 | p1] [p2 | p2]].
         rewrite p2 in p1; discriminate p1.
         
         assert (lexComp (plusSmg A) (z1 * x1) (z1 * y1) = less).
            rewrite (lexComp_less _ A_comm); dseq_f; negb_p; toProp; simpl in *; tauto. 
         rewrite H. rewrite (lexComp_less _ A_comm) in H. simpl in H.
         lex_destruct x1 y1 h. simpl in *.
         negb_p; toProp. rewrite refl. rewrite (B_idem b). bool_p; toProp; tauto.
         negb_p; toProp. tauto.
         negb_p; toProp. simpl in *. do 2 rewrite refl. bool_p; toProp. tauto.
         
         assert (lexComp (plusSmg A) x1 y1 = less).
            rewrite (lexComp_less _ A_comm); dseq_f; negb_p; toProp; simpl in *; tauto.
         rewrite H; rewrite (lexComp_less _ A_comm) in H; simpl in *.
         lex_destruct (z1 * x1) (z1 * y1) h; simpl in *.
         negb_p; toProp. rewrite refl. rewrite (B_idem (b * b)). bool_p; toProp; tauto.
         negb_p; toProp. tauto.
         negb_p; toProp. simpl in *. do 2 rewrite refl. bool_p; toProp. tauto.
         
         rewrite p2 in p1; discriminate p1.
      
      destruct (lssB B_comm B_idem) as [x2 [y2 [z2 lssb]]].
      set (a := choose A).
      exists (a, x2); exists (a, y2); exists (a, z2); simpl in *.
      do 2 rewrite (lexComp_refl _ A_sel). rewrite (c_idem a), (c_idem (a * a)); negb_p; toProp; bool_p; simpl. tauto.
   Defined.

   Lemma rss_eq : IsRightStrictStable A -> forall x y z : A, (x * z <= y * z /\ ~(y * z <= x * z)) <-> (x <= y) /\ ~(y <= x).
   Proof. intros rss x y z. assert (r := rss A_comm c_idem x y z).
      toProp; tauto.
   Defined.

   Lemma isRightStrictStable : 
         IsRightStrictStable A
       * IsRightStrictStable B
      -> IsRightStrictStable selLexBisemigroup.
   Proof. intros [lssa lssb] (*lcec_ldc]*) comm idem [x1 x2] [y1 y2] [z1 z2]. simpl.
      lex_idem idem.
      rewrite (lexComp_swap _ A_comm A_sel y1 x1).
      rewrite (lexComp_swap _ A_comm A_sel (y1 * z1) (x1 * z1)).

      lex_destruct x1 y1 h; destruct h as [h q].
      lex_destruct (x1 * z1) (y1 * z1) h0.
      destruct h0 as [h0 q0]; simpl in *; rewrite h, q, h0, q0; simpl; apply (lssb B_comm B_idem).
      simpl in *. toBool. rewrite (rss_eq lssa) in h0; negb_p; toProp; rewrite h in h0; intuition.
      simpl in *. destruct h0 as [w1 w2]; assert (h0 := conj w2 w1). rewrite (rss_eq lssa) in h0; negb_p; toProp; rewrite h in h0; intuition.
      
      assert (lexComp (plusSmg A) (x1 * z1) (y1 * z1) = less).
         rewrite (lexComp_less _ A_comm). simpl. rewrite rss_eq; auto.
      rewrite H. simpl. rewrite (lexComp_less _ A_comm) in H. simpl in *. 
      do 2 rewrite refl; simpl.
      toBool; negb_p; toProp; intuition.

      assert (lexComp (plusSmg A) (x1 * z1) (y1 * z1) = more).
         rewrite (lexComp_more _ A_comm). simpl in *. assert (p := rss_eq lssa y1 x1 z1); tauto.
      rewrite H. simpl. rewrite (lexComp_more _ A_comm) in H. simpl in *. 
      do 2 rewrite refl; simpl.
      toBool; negb_p; toProp; intuition.
   Defined.

   Lemma isRightStrictStable_comp : 
         IsRightStrictStable_comp A
       + IsRightStrictStable_comp B
      -> IsRightStrictStable_comp selLexBisemigroup.
   Proof. intros [lssA | lssB] comm idem; lex_idem idem.
      destruct (lssA A_comm c_idem) as [x1 [y1 [z1 lssa]]].
      set (b := choose B).
      exists (x1, b); exists (y1, b); exists (z1, b); simpl in *.
      rewrite (lexComp_swap _ A_comm A_sel y1);
      rewrite (lexComp_swap _ A_comm A_sel (y1 * z1)).
      destruct lssa as [[p1 | p1] [p2 | p2]].
         rewrite p2 in p1; discriminate p1.
         
         assert (lexComp (plusSmg A) (x1 * z1) (y1 * z1) = less).
            rewrite (lexComp_less _ A_comm); dseq_f; negb_p; toProp; simpl in *; tauto. 
         rewrite H. rewrite (lexComp_less _ A_comm) in H. simpl in H.
         lex_destruct x1 y1 h. simpl in *.
         negb_p; toProp. rewrite refl. rewrite (B_idem b). bool_p; toProp; tauto.
         negb_p; toProp. tauto.
         negb_p; toProp. simpl in *. do 2 rewrite refl. bool_p; toProp. tauto.
         
         assert (lexComp (plusSmg A) x1 y1 = less).
            rewrite (lexComp_less _ A_comm); dseq_f; negb_p; toProp; simpl in *; tauto.
         rewrite H; rewrite (lexComp_less _ A_comm) in H; simpl in *.
         lex_destruct (x1 * z1) (y1 * z1) h; simpl in *.
         negb_p; toProp. rewrite refl. rewrite (B_idem (b * b)). bool_p; toProp; tauto.
         negb_p; toProp. tauto.
         negb_p; toProp. simpl in *. do 2 rewrite refl. bool_p; toProp. tauto.
         
         rewrite p2 in p1; discriminate p1.
      
      destruct (lssB B_comm B_idem) as [x2 [y2 [z2 lssb]]].
      set (a := choose A).
      exists (a, x2); exists (a, y2); exists (a, z2); simpl in *.
      do 2 rewrite (lexComp_refl _ A_sel). rewrite (c_idem a), (c_idem (a * a)); negb_p; toProp; bool_p; simpl. tauto.
   Defined.

   Lemma isLeftCompEqCancel :
      IsLeftCompEqCancel A * IsLeftCompEqCancel B
      -> IsLeftCompEqCancel selLexBisemigroup.
   Proof. intros [lceca lcecb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem; 
      dseq_u; simpl. toProp. intros [h1 h2].
      red in lceca.
      assert (lceca' := lceca A_comm c_idem _ _ _ h1);
      assert (lcecb' := lcecb B_comm B_idem _ _ _ h2).
      rewrite (lexComp_swap _ A_comm A_sel y1 x1);
      lex_destruct x1 y1 h; simpl; negb_p; toProp;
      [ dseq_f; simpl in *; tauto
      | destruct h; dseq_f; auto
      | destruct h; dseq_f; auto ].
   Defined.   

   Lemma isLeftCompEqCancel_comp :
      IsLeftCompEqCancel_comp A + IsLeftCompEqCancel_comp B
      -> IsLeftCompEqCancel_comp selLexBisemigroup.
   Proof.
      intros [lceca | lcecb] comm idem; lex_idem idem.
      (* 1 *) destruct (lceca A_comm c_idem) as [x [y [z [p1 p2]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); simpl.
      dseq_u; simpl; negb_p; toProp; dseq_f; intuition.
      (* 2 *) destruct (lcecb B_comm B_idem) as [x [y [z [p1 p2]]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); dseq_u; simpl.
      rewrite lexComp_refl; trivial; simpl; negb_p; toProp; dseq_f; intuition.
   Defined.

   Lemma isRightCompEqCancel :
      IsRightCompEqCancel A * IsRightCompEqCancel B
      -> IsRightCompEqCancel selLexBisemigroup.
   Proof. intros [lceca lcecb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem; 
      dseq_u; simpl. toProp. intros [h1 h2].
      red in lceca.
      assert (lceca' := lceca A_comm c_idem _ _ _ h1);
      assert (lcecb' := lcecb B_comm B_idem _ _ _ h2).
      rewrite (lexComp_swap _ A_comm A_sel y1 x1);
      lex_destruct x1 y1 h; simpl; negb_p; toProp;
      [ dseq_f; simpl in *; tauto
      | destruct h; dseq_f; auto
      | destruct h; dseq_f; auto ].
   Defined.   

   Lemma isRightCompEqCancel_comp :
      IsRightCompEqCancel_comp A + IsRightCompEqCancel_comp B
      -> IsRightCompEqCancel_comp selLexBisemigroup.
   Proof.
      intros [lceca | lcecb] comm idem; lex_idem idem.
      (* 1 *) destruct (lceca A_comm c_idem) as [x [y [z [p1 p2]]]].
      set (b := choose B).
      exists (x, b); exists (y, b); exists (z, b); simpl.
      dseq_u; simpl; negb_p; toProp; dseq_f; intuition.
      (* 2 *) destruct (lcecb B_comm B_idem) as [x [y [z [p1 p2]]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); dseq_u; simpl.
      rewrite lexComp_refl; trivial; simpl; negb_p; toProp; dseq_f; intuition.
   Defined.

   Lemma isLeftCompCancel :
      IsLeftCompCancel A
      * IsLeftCompCancel B
      -> IsLeftCompCancel selLexBisemigroup.
   Proof. intros [lcca lccb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem;
      simpl.
      rewrite (lexComp_swap _ A_comm A_sel (z1 * y1) (z1 * x1));
      rewrite (lexComp_swap _ A_comm A_sel y1 x1).
      assert (lcca' := lcca A_comm c_idem x1 y1 z1);
      assert (lccb' := lccb B_comm B_idem x2 y2 z2).
      lex_destruct (z1 * x1) (z1 * y1) h; negb_p; toProp; simpl.
      lex_destruct x1 y1 h1; negb_p; toProp; simpl;
      [ intuition
      | rewrite refl; bool_p; tauto
      | rewrite refl; bool_p; tauto
      ].
      intros [[p|p] _]; [ tauto | elim p; dseq_f; auto ].
      intros [_ [p|p]]; [ tauto | elim p; dseq_f; auto ].
   Defined.

   Lemma isLeftCompCancel_comp :
        IsLeftCompCancel_comp A
      + IsLeftCompCancel_comp B
      -> IsLeftCompCancel_comp selLexBisemigroup.
   Proof. intros [lcca | lccb] comm idem; lex_idem idem.   
      destruct (lcca A_comm c_idem) as [x [y [z [p1 p2]]]].
      toProp.
      assert (False).
         destruct (A_sel x y). tauto. simpl in *. rewrite (A_comm x y) in H. tauto.
      elim H.

      destruct (lccb B_comm B_idem) as [x [y [z [p1 p2]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); simpl;
      rewrite lexComp_refl, lexComp_refl; trivial; simpl.
      negb_p; toProp; dseq_f; rewrite (c_idem a), (c_idem (a * a)); intuition.
   Defined.

   Lemma isRightCompCancel :
      IsRightCompCancel A
      * IsRightCompCancel B
      -> IsRightCompCancel selLexBisemigroup.
   Proof. intros [lcca lccb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem;
      simpl.
      rewrite (lexComp_swap _ A_comm A_sel (y1 * z1) (x1 * z1));
      rewrite (lexComp_swap _ A_comm A_sel y1 x1).
      assert (lcca' := lcca A_comm c_idem x1 y1 z1);
      assert (lccb' := lccb B_comm B_idem x2 y2 z2).
      lex_destruct (x1 * z1) (y1 * z1) h; negb_p; toProp; simpl.
      lex_destruct x1 y1 h1; negb_p; toProp; simpl;
      [ intuition
      | rewrite refl; bool_p; tauto
      | rewrite refl; bool_p; tauto
      ].
      intros [[p|p] _]; [ tauto | elim p; dseq_f; auto ].
      intros [_ [p|p]]; [ tauto | elim p; dseq_f; auto ].
   Defined.

   Lemma isRightCompCancel_comp :
        IsRightCompCancel_comp A
      + IsRightCompCancel_comp B
      -> IsRightCompCancel_comp selLexBisemigroup.
   Proof. intros [lcca | lccb] comm idem; lex_idem idem.   
      destruct (lcca A_comm c_idem) as [x [y [z [p1 p2]]]].
      toProp.
      assert (False).
         destruct (A_sel x y). tauto. simpl in *. rewrite (A_comm x y) in H. tauto.
      elim H.

      destruct (lccb B_comm B_idem) as [x [y [z [p1 p2]]]].
      set (a := choose A).
      exists (a, x); exists (a, y); exists (a, z); simpl;
      rewrite lexComp_refl, lexComp_refl; trivial; simpl.
      negb_p; toProp; dseq_f; rewrite (c_idem a), (c_idem (a * a)); intuition.
   Defined.

   Lemma leftDiscrete : LeftDiscrete A * LeftDiscrete B -> LeftDiscrete selLexBisemigroup.
   Proof. intros [lda ldb] comm idem [x1 x2] [y1 y2] [z1 z2];
      lex_idem idem;
      assert (ldb' := ldb B_comm B_idem);
      assert (lda' := lda A_comm c_idem).
      simpl.
      rewrite (lexComp_swap _ A_comm A_sel (z1 * y1)).
      assert (p1 := lda' x1 y1 z1);
      assert (p2 := ldb' x2 y2 z2);
      lex_destruct (z1 * x1) (z1 * y1) h; simpl; negb_p; toProp; simpl in *; dseq_f; tauto.
   Defined.
   
   Lemma leftDiscrete_comp : LeftDiscrete_comp A + LeftDiscrete_comp B -> LeftDiscrete_comp selLexBisemigroup.
   Proof. intros [lda | ldb] comm idem; lex_idem idem.
      destruct (lda A_comm c_idem) as [x [y [z p]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl;
      rewrite (lexComp_swap _ A_comm A_sel (z * y) (z * x)).
      assert (lexComp (plusSmg A) (z * x) (z * y) = less).
         rewrite (lexComp_less _ A_comm). simpl in *; negb_p; toProp; tauto.
      rewrite H; rewrite lexComp_less in H; simpl;
      negb_p; toProp; dseq_f; intuition.

      destruct (ldb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A,  z); simpl.
      rewrite lexComp_refl; trivial. rewrite (c_idem (choose A * choose A)). auto.
   Defined.

   Lemma rightDiscrete : RightDiscrete A * RightDiscrete B -> RightDiscrete selLexBisemigroup.
   Proof. intros [lda ldb] comm idem [x1 x2] [y1 y2] [z1 z2];
      lex_idem idem;
      assert (ldb' := ldb B_comm B_idem);
      assert (lda' := lda A_comm c_idem).
      simpl.
      rewrite (lexComp_swap _ A_comm A_sel (y1 * z1)).
      assert (p1 := lda' x1 y1 z1);
      assert (p2 := ldb' x2 y2 z2);
      lex_destruct (x1 * z1) (y1 * z1) h; simpl; negb_p; toProp; simpl in *; dseq_f; tauto.
   Defined.
   
   Lemma rightDiscrete_comp : RightDiscrete_comp A + RightDiscrete_comp B -> RightDiscrete_comp selLexBisemigroup.
   Proof. intros [lda | ldb] comm idem; lex_idem idem.
      destruct (lda A_comm c_idem) as [x [y [z p]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl;
      rewrite (lexComp_swap _ A_comm A_sel (y * z) (x * z)).
      assert (lexComp (plusSmg A) (x * z) (y * z) = less).
         rewrite (lexComp_less _ A_comm). simpl in *; negb_p; toProp; tauto.
      rewrite H; rewrite lexComp_less in H; simpl;
      negb_p; toProp; dseq_f; intuition.

      destruct (ldb B_comm B_idem) as [x [y [z p]]];
      exists (choose A, x); exists (choose A, y); exists (choose A,  z); simpl.
      rewrite lexComp_refl; trivial. rewrite (c_idem (choose A * choose A)). auto.
   Defined.

   Lemma leftComparable :
      LeftComparable A * LeftComparable B -> LeftComparable selLexBisemigroup.
   Proof. intros [lca lcb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem; simpl.
      assert (lca' := lca A_comm c_idem x1 y1 z1);
      assert (lcb' := lcb B_comm B_idem x2 y2 z2);
      rewrite (lexComp_swap _ A_comm A_sel (z1 * y1));
      lex_destruct (z1 * x1) (z1 * y1) h; simpl; negb_p; toProp;
      try (rewrite refl; bool_p; tauto).
      simpl in h. tauto.
   Defined.
   
   Lemma leftComparable_comp :
      LeftComparable_comp A + LeftComparable_comp B -> LeftComparable_comp selLexBisemigroup.
   Proof. intros [lca | lcb] comm idem; lex_idem idem.
      destruct (lca A_comm c_idem) as [x [y [z lc]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      rewrite (lexComp_swap _ A_comm A_sel (z * y)).
      lex_destruct (z * x) (z * y) h; simpl; negb_p; toProp;
      try (rewrite refl; bool_p; tauto).
      simpl in h; tauto.
      destruct (lcb B_comm B_idem) as [x [y [z lc]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl;
      rewrite lexComp_refl; trivial; negb_p; toProp; simpl;
      dseq_f; rewrite (c_idem (choose A * choose A)); intuition.
   Defined.

   Lemma rightComparable :
      RightComparable A * RightComparable B -> RightComparable selLexBisemigroup.
   Proof. intros [lca lcb] comm idem [x1 x2] [y1 y2] [z1 z2]; lex_idem idem; simpl.
      assert (lca' := lca A_comm c_idem x1 y1 z1);
      assert (lcb' := lcb B_comm B_idem x2 y2 z2);
      rewrite (lexComp_swap _ A_comm A_sel (y1 * z1));
      lex_destruct (x1 * z1) (y1 * z1) h; simpl; negb_p; toProp;
      try (rewrite refl; bool_p; tauto).
      simpl in h. tauto.
   Defined.
   
   Lemma rightComparable_comp :
      RightComparable_comp A + RightComparable_comp B -> RightComparable_comp selLexBisemigroup.
   Proof. intros [lca | lcb] comm idem; lex_idem idem.
      destruct (lca A_comm c_idem) as [x [y [z lc]]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      rewrite (lexComp_swap _ A_comm A_sel (y * z)).
      lex_destruct (x * z) (y * z) h; simpl; negb_p; toProp;
      try (rewrite refl; bool_p; tauto).
      simpl in h; tauto.
      destruct (lcb B_comm B_idem) as [x [y [z lc]]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl;
      rewrite lexComp_refl; trivial; negb_p; toProp; simpl;
      dseq_f; rewrite (c_idem (choose A * choose A)); intuition.
   Defined.

   Lemma leftIncreasing : LeftStrictIncreasing A + LeftIncreasing A * LeftIncreasing B  -> LeftIncreasing selLexBisemigroup.
   Proof. intros [ls | [la lb]] comm idem [x1 x2] [y1 y2]; dseq_u; simpl; toProp; split.
      assert (p := ls A_comm c_idem x1 y1); toProp; tauto.
      assert (lexComp (plusSmg A) x1 (y1 * x1) = less) as h.
         rewrite lexComp_less; auto. simpl. red in ls. 
         assert (p := ls A_comm c_idem x1 y1); negb_p; toProp; tauto.
      rewrite h; dseq_f; auto.
      
      apply (la A_comm c_idem).
      lex_idem idem.
      lex_destruct x1 (y1 * x1) h.
      apply (lb B_comm B_idem).
      dseq_f; auto.
      assert (p := la A_comm c_idem x1 y1). toProp. tauto.
   Defined.

   Lemma leftIncreasing_comp : LeftStrictIncreasing_comp A * (LeftIncreasing_comp A + LeftIncreasing_comp B)  -> LeftIncreasing_comp selLexBisemigroup.
   Proof. intros [ls [la | lb]] comm idem; lex_idem idem.
      destruct (la A_comm c_idem) as [x [y l]].
      exists (x, choose B); exists (y, choose B); dseq_u; simpl. negb_p; toProp; auto.
      destruct (ls A_comm c_idem) as [x1 [y1 l1]].
      destruct (lb B_comm B_idem) as [x2 [y2 l2]].
      exists (x1, x2); exists (y1, y2); dseq_u; simpl.
      lex_destruct x1 (y1 * x1) h.
      negb_p; toProp; auto.
      toProp; tauto.
      negb_p; toProp; tauto.
   Defined.

   Lemma rightIncreasing : RightStrictIncreasing A + RightIncreasing A * RightIncreasing B  -> RightIncreasing selLexBisemigroup.
   Proof. intros [ls | [la lb]] comm idem [x1 x2] [y1 y2]; dseq_u; simpl; toProp; split.
      assert (p := ls A_comm c_idem x1 y1); toProp; tauto.
      assert (lexComp (plusSmg A) x1 (x1 * y1) = less) as h.
         rewrite lexComp_less; auto. simpl. red in ls. 
         assert (p := ls A_comm c_idem x1 y1); negb_p; toProp; tauto.
      rewrite h; dseq_f; auto.
      
      apply (la A_comm c_idem).
      lex_idem idem.
      lex_destruct x1 (x1 * y1) h.
      apply (lb B_comm B_idem).
      dseq_f; auto.
      assert (p := la A_comm c_idem x1 y1). toProp. tauto.
   Defined.

   Lemma rightIncreasing_comp : RightStrictIncreasing_comp A * (RightIncreasing_comp A + RightIncreasing_comp B)  -> RightIncreasing_comp selLexBisemigroup.
   Proof. intros [ls [la | lb]] comm idem; lex_idem idem.
      destruct (la A_comm c_idem) as [x [y l]].
      exists (x, choose B); exists (y, choose B); dseq_u; simpl. negb_p; toProp; auto.
      destruct (ls A_comm c_idem) as [x1 [y1 l1]].
      destruct (lb B_comm B_idem) as [x2 [y2 l2]].
      exists (x1, x2); exists (y1, y2); dseq_u; simpl.
      lex_destruct x1 (x1 * y1) h.
      negb_p; toProp; auto.
      toProp; tauto.
      negb_p; toProp; tauto.
   Defined.
   
   Lemma leftStrictIncreasing : LeftStrictIncreasing A + (LeftIncreasing A * LeftStrictIncreasing B) 
      -> LeftStrictIncreasing selLexBisemigroup.
   Proof. intros [ls | [la lb]] comm idem [x1 x2] [y1 y2]; lex_idem idem.
      simpl. assert (p := ls A_comm c_idem x1 y1); negb_p; toProp. intuition.
      assert (lexComp (plusSmg A) x1 (y1 * x1) = less) as q1.
         rewrite lexComp_less; intuition.
      rewrite q1; dseq_f; auto.
      simpl. rewrite (lexComp_swap _ A_comm A_sel (y1 * x1)).
      assert (p := la A_comm c_idem x1 y1).
      assert (q := lb B_comm B_idem x2 y2). negb_p; toProp.
      lex_destruct x1 (y1 * x1) h; simpl; dseq_f; intuition;
      try (negb_p; toProp; tauto).
   Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp A * (LeftIncreasing_comp A + LeftStrictIncreasing_comp B) 
      -> LeftStrictIncreasing_comp selLexBisemigroup.
   Proof. intros [ls [la | lb]] comm idem; lex_idem idem.
      destruct (la A_comm c_idem) as [x [y l]].
      exists (x, choose B); exists (y, choose B); negb_p; simpl. negb_p. toProp. auto.
      destruct (ls A_comm c_idem) as [x1 [y1 l1]].
      destruct (lb B_comm B_idem) as [x2 [y2 l2]].
      exists (x1, x2); exists (y1, y2); negb_p; simpl; negb_p; toProp.
      destruct l1; auto.
      rewrite (lexComp_swap _ A_comm A_sel (y1 * x1)).
      lex_destruct x1 (y1 * x1) h; simpl.
      destruct l2; auto.
      negb_p; toProp; intuition.
      negb_p; toProp; intuition.
   Defined.

   Lemma rightStrictIncreasing : RightStrictIncreasing A + (RightIncreasing A * RightStrictIncreasing B) 
      -> RightStrictIncreasing selLexBisemigroup.
   Proof. intros [ls | [la lb]] comm idem [x1 x2] [y1 y2]; lex_idem idem.
      simpl. assert (p := ls A_comm c_idem x1 y1); negb_p; toProp. intuition.
      assert (lexComp (plusSmg A) x1 (x1 * y1) = less) as q1.
         rewrite lexComp_less; intuition.
      rewrite q1; dseq_f; auto.
      simpl. rewrite (lexComp_swap _ A_comm A_sel (x1 * y1)).
      assert (p := la A_comm c_idem x1 y1).
      assert (q := lb B_comm B_idem x2 y2). negb_p; toProp.
      lex_destruct x1 (x1 * y1) h; simpl; dseq_f; intuition;
      try (negb_p; toProp; tauto).
   Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp A * (RightIncreasing_comp A + RightStrictIncreasing_comp B) 
      -> RightStrictIncreasing_comp selLexBisemigroup.
   Proof. intros [ls [la | lb]] comm idem; lex_idem idem.
      destruct (la A_comm c_idem) as [x [y l]].
      exists (x, choose B); exists (y, choose B); negb_p; simpl. negb_p. toProp. auto.
      destruct (ls A_comm c_idem) as [x1 [y1 l1]].
      destruct (lb B_comm B_idem) as [x2 [y2 l2]].
      exists (x1, x2); exists (y1, y2); negb_p; simpl; negb_p; toProp.
      destruct l1; auto.
      rewrite (lexComp_swap _ A_comm A_sel (x1 * y1)).
      lex_destruct x1 (x1 * y1) h; simpl.
      destruct l2; auto.
      negb_p; toProp; intuition.
      negb_p; toProp; intuition.
   Defined.

   (***********************************************************)
   (*                  Identity properties                    *)
   (***********************************************************)
   
   Lemma hasId_back_a : HasIdentity (plusSmg selLexBisemigroup) -> HasIdentity (plusSmg A).
   Proof. intros [[ida idb] p].
      exists ida. intros x; simpl. destruct (p (x, idb)); dseq_u; simpl in *; toProp. tauto.
   Defined.

   Lemma hasId_back_b : HasIdentity (plusSmg selLexBisemigroup) -> HasIdentity (plusSmg B).
   Proof. intros [[ida idb] p].
      exists idb. intros x; simpl. destruct (p (ida, x)); dseq_u; simpl in *; toProp;
      rewrite lexComp_refl in *; trivial; tauto.
   Defined.
   
   (* move to semigroup properties !!!*)
   Lemma uniqueId : forall (S : Semigroup) (p1 p2 : HasIdentity S), projT1 p1 == projT1 p2.
   Proof. intros S [id1 p] [id2 p'].
      simpl. destruct (p id2) as [h1 _]; destruct (p' id1) as [_ h2]; rewrite <- h1, h2; auto.
   Qed.

   Ltac lex_id hasId :=
      assert (A_hasId := hasId_back_a hasId);
      assert (B_hasId' := hasId_back_b hasId).

   Lemma isRightTimesMapToIdConstantPlus :
         IsRightTimesMapToIdConstantPlus A
       * IsRightTimesMapToIdConstantPlus B
       * (RightDiscrete A + RightCondensed (timesSmg B))
      -> IsRightTimesMapToIdConstantPlus selLexBisemigroup.
   Proof. intros [[tica ticb] rda_rcb] hasId [x1 x2] [y1 y2] [z1 z2]. lex_id hasId.
      assert (tca := tica (hasId_back_a hasId)).
      assert (tcb := ticb (hasId_back_b hasId)).
      destruct hasId as [[ida idb] p]. simpl in *.
      unfold dseq; simpl; toProp; split. apply tca.
      lex_destruct (x1 * z1) (y1 * z1) h; simpl.
      apply tcb.
      destruct rda_rcb as [rd | rc]; [assert (q := rd A_comm c_idem x1 y1 z1); toProp; tauto | apply rc].
      destruct rda_rcb as [rd | rc]; [assert (q := rd A_comm c_idem y1 x1 z1); toProp; tauto | apply rc].
   Defined.

   Lemma isRightTimesMapToIdConstantPlus_comp :
         IsRightTimesMapToIdConstantPlus_comp A
       + IsRightTimesMapToIdConstantPlus_comp B
       + RightDiscrete_comp A * RightCondensed_comp (timesSmg B)
      -> IsRightTimesMapToIdConstantPlus_comp selLexBisemigroup.
   Proof. intros [[tica | ticb] | [rda [x [y [z rcb]]]]] hasId; lex_id hasId.
      (* 1 *) assert (tca := tica (hasId_back_a hasId)).
      destruct hasId as [[ida idb] p]; simpl in tca.
      destruct tca as [x [y [z tca']]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      lex_destruct (x * z) (y * z) h; simpl; negb_p; toProp; tauto.
      (* 2 *) assert (tcb := ticb (hasId_back_b hasId)).
      (*assert (un := uniqueId _ B_hasId (hasId_back_b hasId)).*)
      destruct hasId as [[ida idb] p]; simpl in tcb.
      destruct tcb as [x [y [z tcb']]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; 
      rewrite lexComp_refl; trivial; simpl; negb_p; toProp; tauto.
      (* 3 *) simpl in rcb.
      destruct (rda A_comm c_idem) as [a [b [c rd]]].
      (*assert (un := uniqueId _ B_hasId (hasId_back_b hasId)).*)
      destruct hasId as [[ida idb] p];
      copy_destruct ((z * x == idb * x)%bool).
      exists (a, y); exists (b, z); exists (c, x); simpl.
      assert (lexComp (plusSmg A) (a * c) (b * c) = less).
         rewrite lexComp_less; auto; simpl; toProp; auto.
      rewrite H; simpl. 
      negb_p; toProp; dseq_f; rewrite <- ew. tauto.
      exists (a, z); exists (b, y); exists (c, x); simpl.
      assert (lexComp (plusSmg A) (a * c) (b * c) = less).
         rewrite lexComp_less; auto; simpl; toProp; auto.
      rewrite H; simpl; bool_p; negb_p; toProp; tauto.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus :
         IsLeftTimesMapToIdConstantPlus A
       * IsLeftTimesMapToIdConstantPlus B
       * (LeftDiscrete A + LeftCondensed (timesSmg B))
      -> IsLeftTimesMapToIdConstantPlus selLexBisemigroup.
   Proof. intros [[tica ticb] rda_rcb] hasId [x1 x2] [y1 y2] [z1 z2]. lex_id hasId.
      assert (tca := tica (hasId_back_a hasId)).
      assert (tcb := ticb (hasId_back_b hasId)).
      destruct hasId as [[ida idb] p]. simpl in *.
      unfold dseq; simpl; toProp; split. apply tca.
      lex_destruct (z1 * x1) (z1 * y1) h; simpl.
      apply tcb.
      destruct rda_rcb as [rd | rc]; [assert (q := rd A_comm c_idem x1 y1 z1); toProp; tauto | apply rc].
      destruct rda_rcb as [rd | rc]; [assert (q := rd A_comm c_idem y1 x1 z1); toProp; tauto | apply rc].
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp :
         IsLeftTimesMapToIdConstantPlus_comp A
       + IsLeftTimesMapToIdConstantPlus_comp B
       + LeftDiscrete_comp A * LeftCondensed_comp (timesSmg B)
      -> IsLeftTimesMapToIdConstantPlus_comp selLexBisemigroup.
   Proof. intros [[tica | ticb] | [rda [x [y [z rcb]]]]] hasId; lex_id hasId.
      (* 1 *) assert (tca := tica (hasId_back_a hasId)).
      destruct hasId as [[ida idb] p]; simpl in tca.
      destruct tca as [x [y [z tca']]].
      exists (x, choose B); exists (y, choose B); exists (z, choose B); simpl.
      lex_destruct (z * x) (z * y) h; simpl; negb_p; toProp; tauto.
      (* 2 *) assert (tcb := ticb (hasId_back_b hasId)).
      (*assert (un := uniqueId _ B_hasId (hasId_back_b hasId)).*)
      destruct hasId as [[ida idb] p]; simpl in tcb.
      destruct tcb as [x [y [z tcb']]].
      exists (choose A, x); exists (choose A, y); exists (choose A, z); simpl; 
      rewrite lexComp_refl; trivial; simpl; negb_p; toProp; tauto.
      (* 3 *) simpl in rcb.
      destruct (rda A_comm c_idem) as [a [b [c rd]]].
      (*assert (un := uniqueId _ B_hasId (hasId_back_b hasId)).*)
      destruct hasId as [[ida idb] p];
      copy_destruct ((x * z == x * idb)%bool).
      exists (a, y); exists (b, z); exists (c, x); simpl.
      assert (lexComp (plusSmg A) (c * a) (c * b) = less).
         rewrite lexComp_less; auto; simpl; toProp; auto.
      rewrite H; simpl. 
      negb_p; toProp; dseq_f; rewrite <- ew. tauto.
      exists (a, z); exists (b, y); exists (c, x); simpl.
      assert (lexComp (plusSmg A) (c * a) (c * b) = less).
         rewrite lexComp_less; auto; simpl; toProp; auto.
      rewrite H; simpl; bool_p; negb_p; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator :
      PlusIdentityIsTimesLeftAnnihilator A * PlusIdentityIsTimesLeftAnnihilator B
      -> PlusIdentityIsTimesLeftAnnihilator selLexBisemigroup.
   Proof. intros [idla idlb] hasId [x1 x2].
      assert (pa := idla (hasId_back_a hasId));
      assert (pb := idlb (hasId_back_b hasId));
      destruct hasId as [[ida idb] p]; simpl in pa, pb; simpl.
      unfold dseq; simpl; toProp; split; dseq_f; auto.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp :
      PlusIdentityIsTimesLeftAnnihilator_comp A + PlusIdentityIsTimesLeftAnnihilator_comp B
      -> PlusIdentityIsTimesLeftAnnihilator_comp selLexBisemigroup.
   Proof. intros [idla | idlb] hasId.
      (* 1 *) destruct (idla (hasId_back_a hasId)) as [x pa]. simpl in pa.
      destruct hasId as [[ida idb] p]; simpl in pa; simpl.
      exists (x, idb). simpl. negb_p; toProp; tauto.
      (* 2 *) destruct (idlb (hasId_back_b hasId)) as [x pb]. simpl in pb.
      destruct hasId as [[ida idb] p]; simpl in pb; simpl.
      exists (ida, x). simpl; negb_p; toProp; tauto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator :
      PlusIdentityIsTimesRightAnnihilator A * PlusIdentityIsTimesRightAnnihilator B
      -> PlusIdentityIsTimesRightAnnihilator selLexBisemigroup.
   Proof. intros [idla idlb] hasId [x1 x2].
      assert (pa := idla (hasId_back_a hasId));
      assert (pb := idlb (hasId_back_b hasId));
      destruct hasId as [[ida idb] p]; simpl in pa, pb; simpl.
      unfold dseq; simpl; toProp; split; dseq_f; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator_comp :
      PlusIdentityIsTimesRightAnnihilator_comp A + PlusIdentityIsTimesRightAnnihilator_comp B
      -> PlusIdentityIsTimesRightAnnihilator_comp selLexBisemigroup.
   Proof. intros [idla | idlb] hasId.
      (* 1 *) destruct (idla (hasId_back_a hasId)) as [x pa]. simpl in pa.
      destruct hasId as [[ida idb] p]; simpl in pa; simpl.
      exists (x, idb). simpl. negb_p; toProp; tauto.
      (* 2 *) destruct (idlb (hasId_back_b hasId)) as [x pb]. simpl in pb.
      destruct hasId as [[ida idb] p]; simpl in pb; simpl.
      exists (ida, x). simpl; negb_p; toProp; tauto.
   Defined.      

   Close Scope Bisemigroup_scope. 

End LexProduct.