(*
 * Isomorphic: AddZero NatMinPlus
 * Ignore: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMin.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Constructions.Bisemigroups.AddZero.
Require Import Metarouting.Constructions.Bisemigroups.NatMinPlus.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Min.

Section NatIMinPlus.

   Open Scope Bisemigroup_scope.

   Definition natIMinPlusBisemigroup : Bisemigroup :=
      let s1 := unionSwapSemigroup natMinSemigroup unitSemigroup in (* add infinity *)
      let s2 := unionSemigroup unitSemigroup natPlusSemigroup in (* add infinity *)
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   Lemma natIMinPlusDsIso : DsIso natIMinPlusBisemigroup (addZeroBisemigroup natMinPlusBisemigroup).
   Proof.
      apply (@Build_DsIso natIMinPlusBisemigroup (addZeroBisemigroup natMinPlusBisemigroup)
         (fun x => match x with inl _ => inr _ tt | inr n => inl _ n end)
         (fun x => match x with inr _ => inl _ tt | inl n => inr _ n end)
      ).
      split.
      intros [[]|x] [[]|y]; auto.
      intros [x|[]] [y|[]]; auto.
      intros [x|[]]; auto.
      intros [[]|x]; auto.
   Defined.
   
   Lemma natIMinPlusBSmgIso : BSmgIso natIMinPlusBisemigroup (addZeroBisemigroup natMinPlusBisemigroup).
   Proof. split with natIMinPlusDsIso. split.
      intros [[]|x] [[]|y]; auto.
      intros [x|[]] [y|[]]; auto.
      intros [[]|x] [[]|y]; auto.
      intros [x|[]] [y|[]]; auto.
   Defined.

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
(*
   Lemma isLeftDistributive : IsLeftDistributive natIMinPlusBisemigroup.
   Proof.
      red. intros [[]|a] [[]|b] [[]|c]; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail); auto.
      induction c; simpl; auto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive natIMinPlusBisemigroup.
   Proof.
      red. intros [[]|a] [[]|b] [[]|c]; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail); auto.
      rewrite plus_comm, (plus_comm a), (plus_comm b); induction c; simpl; auto.
   Defined.
   
(*
   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp natIMinPlusBisemigroup.
   Proof.
      red. exists (inr _ 2); exists (inr _ 2); exists (inr _ 1); trivial.
   Defined.
   
   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp natIMinPlusBisemigroup.
   Proof.
      red; exists (inr _ 2); exists (inr _ 2); exists (inr _ 1); trivial.
   Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator natIMinPlusBisemigroup.
   Proof. intros pid tann.
      destruct pid as [[[]|[|n]] p]; simpl in *;
         [ | destruct (p (inl _ tt)); discriminate H
         | destruct (p (inl _ tt)); discriminate H ].
      destruct tann as [[[]|[|n]] q]; simpl in *;
         [ | destruct (q (inl _ tt)); discriminate H
         | destruct (q (inl _ tt)); discriminate H ].
      auto.
   Defined.
      
   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity natIMinPlusBisemigroup.
   Proof. intros pann tid.
      destruct pann as [[[]|[|n]] p]; simpl in *;
         [ destruct (p (inr _ 0)); discriminate H
         | | destruct (p (inr _ 0)); discriminate H ].
      destruct tid as [[[]|[|n]] q]; simpl in *;
         [ destruct (q (inr _ 0)); discriminate H
         | | destruct (q (inr _ 0)); discriminate H ].
      auto.
   Defined.
   
   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp natIMinPlusBisemigroup.
   Proof. intros comm idem.
     exists (inr _ 0); exists (inr _ 1); exists (inl _ tt); compute; intuition.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp natIMinPlusBisemigroup.
   Proof. intros comm idem.
     exists (inr _ 0); exists (inr _ 1); exists (inl _ tt); compute; intuition.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; repeat rewrite beq_nat_eq; auto;
     rewrite min_comm; destruct (min_dec y x); auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; repeat rewrite beq_nat_eq; auto;
     rewrite min_comm; destruct (min_dec y x); auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; repeat rewrite beq_nat_eq; auto;
     rewrite min_comm; destruct (min_dec y x); auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; repeat rewrite beq_nat_eq; auto;
     rewrite min_comm; destruct (min_dec y x); auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natIMinPlusBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 2); exists (inr _ 0); compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natIMinPlusBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 2); exists (inr _ 0); compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); toProp; repeat rewrite beq_nat_eq; auto.
     rewrite min_comm; destruct (min_dec (z + y) (z + x)); auto.
   Defined.

   Lemma rightComparable : RightComparable natIMinPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); toProp; repeat rewrite beq_nat_eq; auto.
     rewrite min_comm; destruct (min_dec (y + z) (x + z)); auto.
   Defined.

   Lemma rightIncreasing : RightIncreasing natIMinPlusBisemigroup.
   Proof. intros _ _ [[]|x] [[]|y]; auto. simpl. rewrite min_l; auto.
      apply le_plus_l.
   Defined.

   Lemma leftIncreasing : LeftIncreasing natIMinPlusBisemigroup.
   Proof. intros _ _ [[]|x] [[]|y]; auto. simpl. rewrite min_l; auto.
      apply le_plus_r.
   Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natIMinPlusBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natIMinPlusBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.

   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp natIMinPlusBisemigroup.
   Proof. intros hasId;
      exists (inr _ 0); exists (inr _ 0); exists (inr _ 0).
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity _ _ Unit.hasIdentity)));
      rewrite p; compute; intuition.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp natIMinPlusBisemigroup.
   Proof. intros hasId;
      exists (inr _ 0); exists (inr _ 0); exists (inr _ 0);
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity natMinSemigroup _ Unit.hasIdentity))); rewrite p;
      compute; intuition.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator natIMinPlusBisemigroup.
   Proof. intros hasId; intros [[]|x].
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity natMinSemigroup _ Unit.hasIdentity))); 
      rewrite p; simpl; compute; auto.
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity natMinSemigroup _ Unit.hasIdentity))); 
      rewrite p; simpl; compute; auto.
   Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator natIMinPlusBisemigroup.
   Proof. intros hasId; intros [[]|x].
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity natMinSemigroup _ Unit.hasIdentity))); rewrite p;
      simpl; compute; auto.
      assert (p := uniqueId _ hasId (Iso_HasIdentity (SmgIso_sym (unionSmgIso natMinSemigroup unitSemigroup)) (Union.hasIdentity natMinSemigroup _ Unit.hasIdentity))); rewrite p;
      simpl; compute; auto.
   Defined.
*)
   Close Scope Bisemigroup_scope.

End NatIMinPlus.
