Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.Semigroups.NatMax.
Require Import Metarouting.Constructions.Semigroups.NatPlus.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Coq.Arith.Arith.
Require Import Coq.Arith.Max.

Section NatIMaxPlus.

   Open Scope Bisemigroup_scope.

   Definition natIMaxPlusBisemigroup : Bisemigroup :=
      let s1 := unionSemigroup unitSemigroup natMaxSemigroup in (* add infinity *)
      let s2 := unionSemigroup unitSemigroup natPlusSemigroup in (* add infinity *)
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)

   Lemma isLeftDistributive : IsLeftDistributive natIMaxPlusBisemigroup.
   Proof.
      red. intros [[]|a] [[]|b] [[]|c]; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail).
      induction c; simpl; auto.
   Defined.

   Lemma isRightDistributive : IsRightDistributive natIMaxPlusBisemigroup.
   Proof.
      red. intros [[]|a] [[]|b] [[]|c]; simpl;
      try (compute; trivial; fail);
      try (apply eq_nat_refl; fail).
      rewrite plus_comm, (plus_comm a), (plus_comm b); induction c; simpl; auto.
   Defined.
   
(*
   Lemma isLeftCoDistributive_comp : IsLeftCoDistributive_comp natIMaxPlusBisemigroup.
   Proof.
      red. exists (inr _ 0); exists (inr _ 0); exists (inr _ 1); trivial.
   Defined.
   
   Lemma isRightCoDistributive_comp : IsRightCoDistributive_comp natIMaxPlusBisemigroup.
   Proof.
      red; exists (inr _ 0); exists (inr _ 0); exists (inr _ 1); trivial.
   Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator_comp : PlusIdentityIsTimesAnnihilator_comp natIMaxPlusBisemigroup.
   Proof. intros pid tann.
      destruct pid as [[[]|[|n]] p]; simpl in *;
         [ destruct (p (inr _ 0)); discriminate H
         | | destruct (p (inr _ 0)); discriminate H ].
      destruct tann as [[[]|[|n]] q]; simpl in *;
         [ | destruct (q (inl _ tt)); discriminate H
         | destruct (q (inl _ tt)); discriminate H ].
      auto.
   Defined.
      
   Lemma plusAnnihilatorIsTimesIdentity_comp : PlusAnnihilatorIsTimesIdentity_comp natIMaxPlusBisemigroup.
   Proof. intros pann tid.
      destruct pann as [[[]|[|n]] p]; simpl in *;
         [ | destruct (p (inl _ tt)); discriminate H
         | destruct (p (inl _ tt)); discriminate H ].
      destruct tid as [[[]|[|n]] q]; simpl in *;
         [ destruct (q (inr _ 0)); discriminate H
         | | destruct (q (inr _ 0)); discriminate H ].
      auto.
   Defined.

   (*********************************************************************)
   (*               Commitative + Idempotent properties                 *)
   (*********************************************************************)

   Ltac min_max_rewrite :=
      progress repeat (
         try (rewrite Max.max_l ; [|trivial; fail]);
         try (rewrite Max.max_r ; [|trivial; fail]);
         try (rewrite Min.min_l ; [|trivial; fail]);
         try (rewrite Min.min_r ; [|trivial; fail])
      ).

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp natIMaxPlusBisemigroup.
   Proof. intros comm idem.
     exists (inl _ tt); exists (inr _ 1); exists (inl _ tt); compute; intuition.
   Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp natIMaxPlusBisemigroup.
   Proof. intros comm idem.
     exists (inl _ tt); exists (inr _ 0); exists (inl _ tt); compute; intuition.
   Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; do 2 rewrite beq_nat_eq;
     rewrite (max_comm y x); destruct (max_dec x y); auto.
   Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; do 2 rewrite beq_nat_eq;
     rewrite (max_comm y x); destruct (max_dec x y); auto.
   Defined.
   
   Lemma isRightCompCancel : IsRightCompCancel natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; do 2 rewrite beq_nat_eq;
     rewrite (max_comm y x); destruct (max_dec x y); auto.
   Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z]; dseq_u; simpl;
     try (compute; auto; fail); intros _; toProp; do 2 rewrite beq_nat_eq;
     rewrite (max_comm y x); destruct (max_dec x y); auto.
   Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp natIMaxPlusBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 0); exists (inr _ 2); compute; intuition.
   Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp natIMaxPlusBisemigroup.
   Proof. intros comm idem.
      exists (inr _ 1); exists (inr _ 0); exists (inr _ 2); compute; intuition.
   Defined.

   Lemma leftComparable : LeftComparable natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z];
     dseq_u; simpl; try (compute; auto; fail); toProp; do 2 rewrite beq_nat_eq;
     rewrite max_comm; destruct (max_dec (z + y) (z + x)); auto.
   Defined.

   Lemma rightComparable : RightComparable natIMaxPlusBisemigroup.
   Proof. intros comm idem [[]|x] [[]|y] [[]|z];
     dseq_u; simpl; try (compute; auto; fail); toProp; do 2 rewrite beq_nat_eq;
     rewrite max_comm; destruct (max_dec (y + z) (x + z)); auto.
   Defined.
   
   Lemma rightIncreasing_comp : RightIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _; exists (inr _ 0); exists (inl _ tt); auto. Defined.

   Lemma leftIncreasing_comp : LeftIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _; exists (inr _ 0); exists (inl _ tt); auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _. exists (inl _ tt); exists (inl _ tt); auto. Defined.
(*
   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _ hid.
      exists (inr _ 1); exists (inr _ 1).
      rewrite (uniqueId _ hid (Union.hasIdentity _ _ NatMax.hasIdentity)).
      simpl. auto.
   Qed.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp natIMaxPlusBisemigroup.
   Proof. intros _ _ hid.
      exists (inr _ 1); exists (inr _ 1).
      rewrite (uniqueId _ hid (Union.hasIdentity _ _ NatMax.hasIdentity)).
      simpl. auto.
   Qed.
*)
   (*********************************************************************)
   (*                        Identity properties                        *)
   (*********************************************************************)

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp natIMaxPlusBisemigroup.
   Proof. intros hasId;
      exists (inl _ tt); exists (inl _ tt); exists (inr _ 0).
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); rewrite p;
      compute; intuition.
   Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp natIMaxPlusBisemigroup.
   Proof. intros hasId;
      exists (inl _ tt); exists (inl _ tt); exists (inr _ 0);
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); rewrite p;
      compute; intuition.
   Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator_comp : PlusIdentityIsTimesLeftAnnihilator_comp natIMaxPlusBisemigroup.
   Proof. intros hasId; exists (inl _ tt).
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); 
      rewrite p; simpl; auto.
   Defined.
      
   Lemma plusIdentityIsTimesRightAnnihilator_comp : PlusIdentityIsTimesRightAnnihilator_comp natIMaxPlusBisemigroup.
   Proof. intros hasId; exists (inl _ tt). 
      assert (p := uniqueId _ hasId (Union.hasIdentity unitSemigroup _ NatMax.hasIdentity)); 
      rewrite p; simpl; auto.
   Defined.

   Close Scope Bisemigroup_scope.

End NatIMaxPlus.
