Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Nat.
Require Import Metarouting.Constructions.DecSetoids.MultiSets.
Require Import Metarouting.Constructions.Semigroups.MultiSetsUnion.
Require Import Metarouting.Constructions.Semigroups.MultiSetsIntersection.
Require Import Metarouting.Constructions.Bisemigroups.NatMinPlus.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.
Require Import Coq.Arith.Min.

Section MultiSets.
   Set Implicit Arguments.
   
   Variable A : DecSetoid.
   
   Definition multisetBisemigroup : Bisemigroup :=
      glueBSmg (multisetIntersectionSemigroup A) (multisetUnionSemigroup A) (dsEq_refl _).

   (******************************************************)
   (*                   Properties                       *)
   (******************************************************)

   Ltac multiset_u :=
      simpl; unfold multieq, multisubset, multi_intersection; simpl; repeat rewrite refl; simpl.
   
   Ltac toCount :=
      repeat rewrite multieq_count in *;
      repeat rewrite app_count in *;
      repeat rewrite multi_intersection_count in *.

   Ltac toCount_u :=
      dseq_u; simpl in *; toCount.

   Definition sg_multiset_nat_min_plus_bsmgIso : 
      IsSingleton A -> BSmgIso multisetBisemigroup natMinPlusBisemigroup.
   Proof. intros sg.
      split with (sg_multiset_nat_dsIso sg).
      destruct sg as [a sg].
      split.
      
      intros x y; simpl. toCount_u. rewrite beq_nat_eq; auto.
      intros x y; simpl. toCount_u. intros b; toCount.
      repeat rewrite (count_pres_eq _ (sg b)).
      repeat rewrite (same_count A a). auto.
      intros x y; simpl. toCount_u; rewrite beq_nat_eq; auto.
      intros x y; simpl. toCount_u. intros b; toCount.
      repeat rewrite (count_pres_eq _ (sg b)).
      repeat rewrite (same_count A a). auto.
   Defined.

   Lemma isLeftDistributive : IsLeftDistributive multisetBisemigroup.
   Proof. intros x y z. toCount_u; intros a; toCount. toCount.
      assert (h := NatMinPlus.isLeftDistributive (count A a x) (count A a y) (count A a z)).
      simpl in h. dseq_u; simpl in h; rewrite beq_nat_eq in h; auto.
   Qed.

   Lemma isRightDistributive : IsRightDistributive multisetBisemigroup.
   Proof. intros x y z. toCount_u; intros a; toCount. toCount.
      assert (h := NatMinPlus.isRightDistributive (count A a x) (count A a y) (count A a z)).
      simpl in h. dseq_u; simpl in h; rewrite beq_nat_eq in h; auto.
   Qed.
   
   Lemma isLeftStrictStable : IsLeftStrictStable multisetBisemigroup.
   Proof. intros _ _ x y z. copy_destruct (x < y); rewrite ew.
      apply or_introl; split; auto. dseq_f.
      toProp; destruct ew as [p1 p2]; dseq_f; toCount_u. split.
      intros a; toCount. toCount.
      assert (h := p1 a); toCount.
      repeat rewrite (plus_comm (count A a z)).
      rewrite plus_pres_min_l; auto.
      
      intros h; apply p2; intros a; assert (p := h a). toCount; toCount.
      repeat rewrite (plus_comm (count A a z)) in p.
      rewrite plus_pres_min_l in p; auto.
      
      apply or_intror; split; auto; dseq_f.
      negb_p. toProp.
      rewrite <- negb_pres_eq in ew; simpl in ew; dseq_f; negb_p.
      toProp; toCount_u; destruct ew as [p|p].
      
      apply or_introl; intros h; apply p; intros a; assert (q := h a).
      toCount; toCount.
      repeat rewrite (plus_comm (count A a z)) in q;
      rewrite plus_pres_min_l in q; auto.
      
      apply or_intror; intros a; assert (h := p a); toCount; toCount.
      repeat rewrite (plus_comm (count A a z));
      rewrite plus_pres_min_l; auto.
   Qed.
      
   Lemma isRightStrictStable : IsRightStrictStable multisetBisemigroup.
   Proof. intros _ _ x y z. copy_destruct (x < y); rewrite ew.
      apply or_introl; split; auto. dseq_f.
      toProp; destruct ew as [p1 p2]; dseq_f; toCount_u. split.
      intros a; toCount. toCount.
      assert (h := p1 a); toCount.
      rewrite plus_pres_min_l; auto.
      
      intros h; apply p2; intros a; assert (p := h a). toCount; toCount.
      rewrite plus_pres_min_l in p; auto.
      
      apply or_intror; split; auto; dseq_f.
      negb_p. toProp.
      rewrite <- negb_pres_eq in ew; simpl in ew; dseq_f; negb_p.
      toProp; toCount_u; destruct ew as [p|p].
      
      apply or_introl; intros h; apply p; intros a; assert (q := h a).
      toCount; toCount.
      rewrite plus_pres_min_l in q; auto.
      
      apply or_intror; intros a; assert (h := p a); toCount; toCount.
      rewrite plus_pres_min_l; auto.
   Qed.
   
   Lemma leftDiscrete_comp : LeftDiscrete_comp multisetBisemigroup.
   Proof. intros _ _. set (a := choose A).
      exists nil; exists (a :: nil); exists nil; multiset_u. auto.
   Defined.
   
   Lemma rightDiscrete_comp : RightDiscrete_comp multisetBisemigroup.
   Proof. intros _ _. set (a := choose A).
      exists nil; exists (a :: nil); exists nil; multiset_u. auto.
   Defined.
   
   Lemma leftComparable : IsSingleton A -> LeftComparable multisetBisemigroup.
   Proof. intros sg.
      apply (Iso_LeftComparable (BSmgIso_sym (sg_multiset_nat_min_plus_bsmgIso sg))).
      apply NatMinPlus.leftComparable.
   Qed.
   
   Lemma leftComparable_comp : IsSingleton_comp A -> LeftComparable_comp multisetBisemigroup.
   Proof. intros sg _ _; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists (a :: b :: nil).
      multiset_u.
      assert (a == b = false) as q1; [|rewrite q1; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q2; [|rewrite q2; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      repeat progress rewrite ?refl, ?q1, q2; simpl.
      repeat progress rewrite ?refl, ?q1, q2; simpl.
      trivial.
   Defined.

   Lemma rightComparable : IsSingleton A -> RightComparable multisetBisemigroup.
   Proof. intros sg.
      apply (Iso_RightComparable (BSmgIso_sym (sg_multiset_nat_min_plus_bsmgIso sg))).
      apply NatMinPlus.rightComparable.
   Qed.
   
   Lemma rightComparable_comp : IsSingleton_comp A -> RightComparable_comp multisetBisemigroup.
   Proof. intros sg _ _; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists (a :: b :: nil).
      multiset_u.
      assert (a == b = false) as q1; [|rewrite q1; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q2; [|rewrite q2; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      repeat progress rewrite ?refl, ?q1, q2; simpl.
      repeat progress rewrite ?refl, ?q1, q2; simpl.
      trivial.
   Defined.
   
   Lemma isRightCompEqCancel : IsRightCompEqCancel multisetBisemigroup.
   Proof. intros _ _ x y z p. assert (q := MultiSetsUnion.rightCancelative _ _ _ p). 
      rewrite q; toProp; dseq_f; auto.
      apply or_introl; apply (MultiSetsIntersection.isIdempotent y).
   Qed.
   
   Lemma isLeftCompEqCancel : IsLeftCompEqCancel multisetBisemigroup.
   Proof. intros _ _ x y z p. assert (q := MultiSetsUnion.leftCancelative _ _ _ p). 
      rewrite q; toProp; dseq_f; auto.
      apply or_introl; apply (MultiSetsIntersection.isIdempotent y).
   Qed.
   
   Lemma isLeftCompCancel : IsSingleton A -> IsLeftCompCancel multisetBisemigroup.
   Proof. intros sg.
      apply (Iso_IsLeftCompCancel (BSmgIso_sym (sg_multiset_nat_min_plus_bsmgIso sg))).
      apply NatMinPlus.isLeftCompCancel.
   Qed.

   Lemma isLeftCompCancel_comp : IsSingleton_comp A -> IsLeftCompCancel_comp multisetBisemigroup.
   Proof. intros sg _ _; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil.
      multiset_u.
      assert (a == b = false) as q; [| rewrite q; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q1; [| rewrite q1; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      auto.
   Defined.
   
   Lemma isRightCompCancel : IsSingleton A -> IsRightCompCancel multisetBisemigroup.
   Proof. intros sg.
      apply (Iso_IsRightCompCancel (BSmgIso_sym (sg_multiset_nat_min_plus_bsmgIso sg))).
      apply NatMinPlus.isRightCompCancel.
   Qed.

   Lemma isRightCompCancel_comp : IsSingleton_comp A -> IsRightCompCancel_comp multisetBisemigroup.
   Proof. intros sg _ _; set (a := choose A); destruct (sg a) as [b pb].
      exists (a :: nil); exists (b :: nil); exists nil.
      multiset_u.
      assert (a == b = false) as q; [| rewrite q; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      assert (b == a = false) as q1; [| rewrite q1; simpl].
         bool_p; toProp; intros h; apply pb; dseq_f; rewrite h; auto.
      auto.
   Defined.
   
   Lemma leftIncreasing : LeftIncreasing multisetBisemigroup.
   Proof. intros comm idem x y; toCount_u. intros a; toCount. toCount.
      rewrite min_l; auto.
      apply le_plus_r.
   Qed.
      
   Lemma rightIncreasing : RightIncreasing multisetBisemigroup.
   Proof. intros comm idem x y; toCount_u. intros a; toCount. toCount.
      rewrite min_l; auto.
      apply le_plus_l.
   Qed.
   
   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp multisetBisemigroup.
   Proof. intros _ _. exists nil; exists nil; multiset_u; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp multisetBisemigroup.
   Proof. intros _ _. exists nil; exists nil; multiset_u; auto. Defined.
   
   (* always irrelevant *)
   Lemma isLeftTimesMapToIdConstantPlus : IsLeftTimesMapToIdConstantPlus multisetBisemigroup.
   Proof. intros [i hid].
      destruct (MultiSetsIntersection.hasIdentity_comp i) as [x p].
      assert (q := hid x); toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma isRightTimesMapToIdConstantPlus : IsRightTimesMapToIdConstantPlus multisetBisemigroup.
   Proof. intros [i hid].
      destruct (MultiSetsIntersection.hasIdentity_comp i) as [x p].
      assert (q := hid x); toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator multisetBisemigroup.
   Proof. intros [i hid].
      destruct (MultiSetsIntersection.hasIdentity_comp i) as [x p].
      assert (q := hid x); toProp; tauto.
   Qed.

   (* always irrelevant *)
   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator multisetBisemigroup.
   Proof. intros [i hid].
      destruct (MultiSetsIntersection.hasIdentity_comp i) as [x p].
      assert (q := hid x); toProp; tauto.
   Qed.

End MultiSets.