Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.DecSetoids.Bool.
Require Import Metarouting.Constructions.Semigroups.BoolOr.
Require Import Metarouting.Constructions.Semigroups.BoolAnd.
Require Import Coq.Bool.Bool.

Section BoolOrAnd.

   Open Scope Bisemigroup_scope.

   Definition boolOrAndBisemigroup : Bisemigroup :=
      glueBSmg boolOrSemigroup boolAndSemigroup (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
   
   Lemma isLeftDistributive : IsLeftDistributive boolOrAndBisemigroup.
   Proof. intros [|] [|] [|]; auto. Defined.

   Lemma isRightDistributive : IsRightDistributive boolOrAndBisemigroup.
   Proof. intros [|] [|] [|]; auto. Defined.

(*
   Lemma isLeftCoDistributive : IsLeftCoDistributive boolOrAndBisemigroup.
   Proof. intros [|] [|] [|]; auto. Defined.

   Lemma isRightCoDistributive : IsRightCoDistributive boolOrAndBisemigroup.
   Proof. intros [|] [|] [|]; auto. Defined.
*)

   Lemma plusIdentityIsTimesAnnihilator : PlusIdentityIsTimesAnnihilator boolOrAndBisemigroup.
   Proof. intros [[|] p] [[|] q]; auto; simpl in *. 
      destruct (p false); auto. destruct (q false); auto.
   Defined.

   Lemma plusAnnihilatorIsTimesIdentity : PlusAnnihilatorIsTimesIdentity boolOrAndBisemigroup.
   Proof. intros [[|] p] [[|] q]; auto; simpl in *. 
      destruct (q true); auto. destruct (p true); auto.
   Defined.

   Lemma isRightStrictStable_comp : IsRightStrictStable_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists true; exists false; exists false; simpl; auto. Defined.

   Lemma isLeftStrictStable_comp : IsLeftStrictStable_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists true; exists false; exists false; simpl; auto. Defined.

   Lemma isRightCompEqCancel : IsRightCompEqCancel boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma isLeftCompEqCancel : IsLeftCompEqCancel boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma isRightCompCancel : IsRightCompCancel boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma isLeftCompCancel : IsLeftCompCancel boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma leftDiscrete_comp : LeftDiscrete_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists true; exists false; exists true; simpl; auto. Defined.

   Lemma rightDiscrete_comp : RightDiscrete_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists true; exists false; exists true; simpl; auto. Defined.

   Lemma leftComparable : LeftComparable boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma rightComparable : RightComparable boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|] [|]; auto. Defined.

   Lemma leftIncreasing : LeftIncreasing boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|]; auto. Defined.

   Lemma rightIncreasing : RightIncreasing boolOrAndBisemigroup.
   Proof. intros _ _ [|] [|]; auto. Defined.

   Lemma leftStrictIncreasing_comp : LeftStrictIncreasing_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists false; exists false; auto. Defined.

   Lemma rightStrictIncreasing_comp : RightStrictIncreasing_comp boolOrAndBisemigroup.
   Proof. intros _ _; exists false; exists false; auto. Defined.

   Lemma leftWStrictIncreasing_comp : LeftWStrictIncreasing_comp boolOrAndBisemigroup.
   Proof. intros _ _ hid; exists false; exists false; auto.
      rewrite (uniqueAnnh _ hid (BoolOr.hasAnnihilator)). simpl. auto.
   Defined.

   Lemma rightWStrictIncreasing_comp : RightWStrictIncreasing_comp boolOrAndBisemigroup.
   Proof. intros _ _ hid; exists false; exists false; auto.
      rewrite (uniqueAnnh _ hid (BoolOr.hasAnnihilator)). simpl. auto.
   Defined.

   Lemma or_id_false : forall id : HasIdentity (plusSmg boolOrAndBisemigroup), projT1 id = false.
   Proof. intros [[|] p]; auto; simpl in *; dseq_u; assert (q := p false); simpl in q; intuition. Defined.

   Lemma isRightTimesMapToIdConstantPlus_comp : IsRightTimesMapToIdConstantPlus_comp boolOrAndBisemigroup.
   Proof. intros id; rewrite (or_id_false id); exists true; exists true; exists true; auto. Defined.

   Lemma isLeftTimesMapToIdConstantPlus_comp : IsLeftTimesMapToIdConstantPlus_comp boolOrAndBisemigroup.
   Proof. intros id; rewrite (or_id_false id); exists true; exists true; exists true; auto. Defined.

   Lemma plusIdentityIsTimesLeftAnnihilator : PlusIdentityIsTimesLeftAnnihilator boolOrAndBisemigroup.
   Proof. intros id; rewrite (or_id_false id); intros [|]; auto. Defined.

   Lemma plusIdentityIsTimesRightAnnihilator : PlusIdentityIsTimesRightAnnihilator boolOrAndBisemigroup.
   Proof. intros id; rewrite (or_id_false id); intros [|]; auto. Defined.

End BoolOrAnd.
