(*
 * Skip: true
 *)

Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Signatures.BisemigroupGlue.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.Constructions.Semigroups.Unit.

Section AddInf.

   Variable A : Bisemigroup.

   Definition addInfBisemigroup : Bisemigroup :=
      let s1 := unionSwapSemigroup (plusSmg A) unitSemigroup in (* add infinity *)
      let s2 := unionSemigroup unitSemigroup (timesSmg A) in (* add infinity *)
      glueBSmg s1 s2 (dsEq_refl _). (*(ds_eq_refl _ _ _ _ _ _).*)

   (*********************************************************************)
   (*                           Properties                              *)
   (*********************************************************************)
   
   Lemma isLeftDistributive : IsLeftDistributive A -> IsLeftDistributive addInfBisemigroup.
   Proof. intros ld; intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto. Defined.
   
   Lemma isRightDistributive : IsRightDistributive A -> IsRightDistributive addInfBisemigroup.
   Proof. intros ld; intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto. Defined.
   
   (* Strange... *)
   (*
   Lemma isLeftCoDistributive : IsLeftCoDistributive A * IsIdempotent (timesSmg A) -> IsLeftCoDistributive addInfBisemigroup.
   Proof. intros [ld idem]; intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto.
      rewrite (idem z); auto.
   Defined.
   
   Lemma isRightCoDistributive : IsRightCoDistributive A -> IsRightCoDistributive addInfBisemigroup.
   Proof. intros ld; intros [[]|x] [[]|y] [[]|z]; dseq_u; simpl; dseq_f; auto. Defined.
   *)
   

End AddInf.
