/**
 * Control which opens a URL associated with a VisualItem
 * Used by PrivilaView (see http://www.cl.cam.ac.uk/users/sjm217/projects/privila/)
 *
 * Copyright (c) 2007 Steven J. Murdoch <http://www.cl.cam.ac.uk/users/sjm217/>
 *
 * Distributed under the terms of the 3-clause BSD license (see license-prefuse.txt)
 */

import prefuse.controls.ControlAdapter;

import java.awt.event.MouseEvent;

import java.applet.AppletContext;

import java.net.URL;
import java.net.MalformedURLException;

import prefuse.Display;
import prefuse.visual.VisualItem;

class SiteOpenerControl extends ControlAdapter {

    private AppletContext context;

    public SiteOpenerControl(AppletContext c) {
        context = c;
    }

    // Based on prefuse.controls.ToolTipControl by Jeffrey Heer
    public void itemClicked(VisualItem item, MouseEvent e) {
        if (e.getClickCount() != 2)
            return;

        Display d = (Display)e.getSource();
        if ( item.canGetString("type")  && item.canGetString("name") && item.getString("type").equals("site")) {
            String name = item.getString("name");
            String url = "http://www." + name + "/";

            try {
                context.showDocument(new URL(url), "_blank");
                //System.err.println("Opening "+url);
            }
            catch (java.net.MalformedURLException ex) {
                ;
            }
        }
    }
}