/**
 * Control which opens a custom tool tip for a node
 * Used by PrivilaView (see http://www.cl.cam.ac.uk/users/sjm217/projects/privila/)
 *
 * Copyright (c) 2007 Steven J. Murdoch <http://www.cl.cam.ac.uk/users/sjm217/>
 *
 * Distributed under the terms of the 3-clause BSD license (see license-prefuse.txt)
 */

import prefuse.controls.ToolTipControl;

import java.awt.event.MouseEvent;

import prefuse.Display;
import prefuse.visual.VisualItem;

class CustomToolTipControl extends ToolTipControl {

    public CustomToolTipControl() {
        super(new String[] {});
    }

    // Based on prefuse.controls.ToolTipControl by Jeffrey Heer
    public void itemEntered(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        if ( item.canGetString("type")  && item.canGetString("articles") && item.canGetString("degree")) {
            String type = item.getString("type");
            String articles = item.getString("articles");
            String degree = item.getString("degree");
            if (type.equals("author"))
                d.setToolTipText(articles + " article(s), " + degree + " site(s)");
            else
                d.setToolTipText(articles + " article(s), " + degree + " author(s)");
        }
    }
}