module W-type where

open import Prelude
open import Quotient

----------------------------------------------------------------------
-- Signatures
----------------------------------------------------------------------
Sig : Set₁
Sig = ∑ A ∶ Set , (A → Set)

-- Signature endofunctor
S : {_ : Sig} → Set → Set
S{A , B} X = ∑ a ∶ A , (B a → X)

-- functorial action
S' :
  {Σ : Sig}
  {X Y : Set}
  (f : X → Y)
  → ----------
  S{Σ} X → S Y
S' f (a , b) = (a , f ∘ b)

----------------------------------------------------------------------
-- Algebra structure for a signature
----------------------------------------------------------------------
record Alg {Σ : Sig}(X : Set) : Set where
  constructor mkalg
  field sup : S{Σ} X → X

open Alg ⦃ ... ⦄ public

----------------------------------------------------------------------
-- (4) The property of being an S-algebra morphism
----------------------------------------------------------------------
isHom :
  {Σ : Sig}
  {X Y : Set}
  {{α : Alg{Σ} X}}
  {{β : Alg{Σ} Y}}
  (h : X → Y)
  → -----------------
  Set
isHom {Σ = (A , B)} {X} h =
  (a : A)(b : B a → X) → h(sup (a , b)) ≡ sup (a , h ∘ b)

----------------------------------------------------------------------
-- Free Sig-algebra on a set
----------------------------------------------------------------------
data T {Σ : Sig} (X : Set) : Set where
  η : X → T X
  σ : S{Σ} (T{Σ} X) → T X

instance
  AlgT : {Σ : Sig}{X : Set} → Alg (T{Σ} X)
  sup ⦃ AlgT ⦄ = σ

-- existence part of universal property
infixl 5 _>>=_
_>>=_ :
  {Σ : Sig}
  {X Y : Set}
  ⦃ _ : Alg{Σ} Y ⦄
  (t : T{Σ} X)
  (f : X → Y)
  → -----------------
  Y
η x       >>= f = f x
σ (a , b) >>= f = sup (a , λ x → b x >>= f)

-- uniqueness part of universal property
>>=-uniq :
  {Σ : Sig}
  {X Y : Set}
  ⦃ _ : Alg{Σ} Y ⦄
  (f : X → Y)
  (g : T{Σ} X → Y)
  (_ : ∀ s → g (σ s) ≡ sup (S' g s))
  (_ : ∀ x → g (η x) ≡ f x)
  (t : T{Σ} X)
  → --------------------------------
  g t ≡ t >>= f
>>=-uniq _ _ _ e (η x)       = e x
>>=-uniq f g h e (σ (a , b)) =
  proof
    g (σ (a , b))
  ≡≡[ h (a , b) ]
    sup (a , g ∘ b)
  ≡≡[ ap (λ b' → sup (a , b'))
     (funext (λ x → >>=-uniq f g h e (b x))) ]
    sup (a , (λ x → b x >>= f))
  qed

>>=η :
  {Σ : Sig}
  {X : Set}
  (t : T{Σ} X)
  → ----------
  t ≡ t >>= η
>>=η = >>=-uniq η id (λ _ → refl) (λ _ → refl)

-- functorial action
T' :
  {Σ : Sig}
  {X Y : Set}
  (f : X → Y)
  → -------------
  T{Σ} X → T{Σ} Y
T' f t =  t >>= (η ∘ f)

T>>= :
  {Σ : Sig}
  {X Y Z : Set}
  ⦃ _ : Alg{Σ} Z ⦄
  (t : T X)
  {f : X → Y}
  {g : Y → Z}
  → --------------------------
  T' f t >>= g ≡ t >>= (g ∘ f)
T>>= t {f} {g} =
  >>=-uniq
    (g ∘ f)
    (λ t → T' f t >>= g)
    (λ _ → refl)
    (λ _ → refl)
    t

>>=∘ :
  {Σ : Sig}
  {X Y Z : Set}
  ⦃ _ : Alg{Σ} Y ⦄
  ⦃ _ : Alg{Σ} Z ⦄
  (f : X → Y)
  (g : Y → Z)
  (_ : (s : S{Σ} Y) → g (sup s) ≡ sup (S' g s))
  (t : T{Σ} X)
  → -------------------------------------------
  g( t >>= f) ≡ t >>= (g ∘ f)
>>=∘ f g e =
  >>=-uniq
    (g ∘ f)
    (λ t → g (t >>= f))
    (λ{(a , b) → e (a , λ x → b x >>= f)})
    (λ _ → refl)

-- insertion
ι :
  {Σ : Sig}
  {X : Set}
  → -------------
  S{Σ} X → T{Σ} X
ι = σ ∘ S' η

----------------------------------------------------------------------
-- W types
----------------------------------------------------------------------
W : Sig → Set
W Σ = T{Σ} ⊥
