module README where

-- This code is to accompanny the paper "Constructing Infinitary
-- Quotient-Inductive Types" by Marcelo Fiore, Andrew M. Pitts,
-- and S. C. Steenkamp.

-- The files are listed below in roughly the reading order of the paper.

open import Prelude
-- Contains ∏, ∑, ×, ⊎, ∘, ⊤, ⊥, ℕ, uip, Size≤, and heterogeneous equality ≡≡ .

open import W-type
-- Contains Signatures, Sig, Signature endofunctor S, Algebra structure Alg,
-- Free Sig-algebra T, universal property _>>=_, various supporting lemmas,
-- and W-types as W Σ = T{Σ} ⊥ . (See Section 2.)

open import QW-axiomatic
-- Contains Syseq, example encoding of multisets and unordered ωTrees,
-- axioms for QW-types as a record, and a proof of Proposition 1 – derived
-- elimination and computation rules. (See Section 2.)

open import FreeAlgebras
-- Contains a proof of Remark 1.

open import EquationalSystem
-- Contains a proof of Remark 2.

open import F-type
-- Contains Example 5: an encoding of Lumsdain and Shulman's HIT not
-- constructable from pushouts and ℕ, adapted from Blass. (Semantics of higher
-- inductive types, (n.d.) https://doi.org/10.1017/S030500411900015X )
-- (See Setion 3.)

open import Quotient
-- Contains Hoffman-style quotient types with REWRITE, and derived funext.
-- See Figure 3.

open import QW-nonterminating-attempt
-- Contains a "proof" of Theorem 1 that doesn't use Sized types, but also
-- does not terminate. It may be easier to read than the Sized proof.
-- See Section 4.

open import QW-sized-construction
-- Contains a proof of Theorem 1. See Section 4.
