{-# OPTIONS --rewriting #-}
module QW-sized-construction where

open import Prelude
open import Quotient
open import W-type
open import QW-axiomatic

----------------------------------------------------------------------
-- Construction of QW-types via sized types
----------------------------------------------------------------------
module QWsized
  (Σ : Sig)
  (E : Set)
  (V : E → Set)
  (lhs rhs : (e : E) → T{Σ} (V e))
  where
  mutual
    data Q₀ (i : Size) : Set where
      sq : {j : Size< i} → T{Σ} (Q j) → Q₀ i

    data Q₁ (i : Size) : Q₀ i → Q₀ i → Set where
      sqeq :
        {j : Size< i}
        (e : E)
        {f : V e → Q j}
        → ------------------------------------------
        Q₁ i (sq (T' f (lhs e))) (sq (T' f (rhs e)))
      sqη :
        {j : Size< i}
        (x : Q₀ j)
        → -----------------------------
        Q₁ i (sq (η (qu j x))) (φ₀ i x)
      sqσ :
        {j : Size< i}
        {k : Size< j}
        (s : S (T (Q k)))
        → -----------------------------------------
        Q₁ i (sq (σ s)) (sq (ι (S' (qu j ∘ sq) s)))

    Q : Size → Set
    Q i = (Q₀ i)/ Q₁ i

    qu : (i : Size) → Q₀ i → Q i
    qu i x = [ x ]/ Q₁ i

    φ₀ : (i : Size){j : Size≤ i} → Q₀ j → Q₀ i
    φ₀ _ (sq z) = sq z
  -- end mutual

  φ₀resp :
    (i : Size)
    {j : Size≤ i}
    {x y : Q₀ j}
    (e : Q₁ j x y)
    → --------------------
    Q₁ i (φ₀ i x) (φ₀ i y)
  φ₀resp i (sqeq e)     = sqeq e
  φ₀resp i (sqη (sq x)) = sqη (sq x)
  φ₀resp i (sqσ s)      = sqσ s

  φ : (i : Size){j : Size≤ i} → Q j → Q i
  φ i = quot.lift (qu i ∘ φ₀ i) (quot.eq (Q₁ i) ∘ φ₀resp i)

  φ₀id :
    {i : Size}
    (x : Q₀ i)
    → --------
    φ₀ i x ≡ x
  φ₀id (sq _ ) = refl

  φid :
    {i : Size}
    (z : Q i)
    → --------
    φ i z ≡ z
  φid {i} =
    quot.elim (Q₁ _)
      (λ z → φ _ z ≡ z)
      (λ {(sq _) → refl})
      (λ e → uip' (quot.eq (Q₁ _) e))

  ty : Set
  ty = Q ∞

  tq : (i : Size) → T{Σ} (Q i) → ty
  tq i t = qu ∞ (sq t)

  instance
    Algty : Alg{Σ} ty
    sup ⦃ Algty ⦄ = tq ∞ ∘ ι

  tqη :
    {i : Size}
    (z : Q i)
    → ---------------
    tq i (η z) ≡ φ ∞ z
  tqη =
    quot.elim (Q₁ _)
      (λ z → tq _ (η z) ≡ φ ∞ z)
      (λ _ → quot.eq (Q₁ ∞) (sqη _))
      λ e → uip' (ap (φ ∞) (quot.eq (Q₁ _) e))

  tqσ :
    {i : Size}
    (s : S{Σ} (T (Q i)))
    → ----------------------------
    tq i (σ s) ≡ sup (S' (tq i) s)
  tqσ s = quot.eq (Q₁ ∞) (sqσ s)

  tqT :
    {X : Set}
    (t : T{Σ} X)
    {f : X → ty}
    → ---------------------
    tq ∞ (T' f t) ≡ t >>= f
  tqT t {f} =
    >>=-uniq f (tq ∞ ∘ T' f)
      (λ _ → quot.eq (Q₁ ∞) (sqσ _))
      (λ x →
        proof
          tq ∞ (T' f (η x))
        ≡≡[ tqη _ ]
          φ ∞ (f x)
        ≡≡[ φid _ ]
          f x
        qed)
      t

  eq :
    (e : E)
    (f : V e → ty)
    → -----------------------
    lhs e >>= f ≡ rhs e >>= f
  eq e f =
    proof
     lhs e >>= f
    ≡≡[ symm (tqT (lhs e)) ]
      qu ∞ (sq (T' f (lhs e)))
    ≡≡[ quot.eq (Q₁ ∞) (sqeq e) ]
      qu ∞ (sq (T' f (rhs e)))
    ≡≡[ tqT (rhs e) ]
      rhs e >>= f
    qed

  module _
    {X : Set}
    ⦃ _  : Alg{Σ} X ⦄
    (p : (e : E)(f : V e → X) →  lhs e >>= f ≡ rhs e >>= f)
    where
    mutual
      rec : {i : Size} → Q i → X
      rec = quot.lift rec₀ rec₀resp

      rec₀ : {i : Size} → Q₀ i → X
      rec₀ (sq {j} t) = t >>= rec {j}

      rec₀resp :
        {i : Size}
        {x y : Q₀ i}
        (_ : Q₁ i x y)
        → -------------
        rec₀ x ≡ rec₀ y
      rec₀resp (sqeq e {f}) =
        proof
          T' f (lhs e) >>= rec
        ≡≡[ T>>= (lhs e) ]
          lhs e >>= (rec ∘ f)
        ≡≡[ p e (rec ∘ f) ]
          rhs e >>= (rec ∘ f)
        ≡≡[ symm (T>>= (rhs e)) ]
          T' f (rhs e) >>= rec
        qed
      rec₀resp (sqη x)      = symm (recφ₀ x)
      rec₀resp (sqσ _)      = refl

      recφ₀ :
        {i  : Size}
        {i' : Size≤ i}
        (t : Q₀ i')
        → ---------------------
        rec₀ (φ₀ i t ) ≡ rec₀ t
      recφ₀ (sq _) = refl

      recφ :
        {i  : Size}
        {i' : Size≤ i}
        (z : Q i')
        → -----------------
        rec (φ i z) ≡ rec z
      recφ =
        quot.elim (Q₁ _)
          (λ z → rec (φ _ z) ≡ rec z)
          recφ₀
          (λ e → uip' (ap rec (quot.eq (Q₁ _) e)))
    -- end mutual block

    rec∞ : ty → X
    rec∞ = rec

    rechom : (s : S{Σ} ty) → sup (S' rec∞ s) ≡ rec∞ (sup s)
    rechom _ = refl

    module _
      (l    : ty → X)
      (lhom : (s : S{Σ} ty) → sup (S' l s) ≡ l (sup s))
      where
      uniq :
        {i : Size}
        (z : Q i)
        → ---------------
        rec z ≡ l (φ ∞ z)
      uniq {i} =
        quot.elim (Q₁ i)
          (λ z → rec z ≡ l (φ ∞ z))
          (λ{(sq t) → symm (h t)})
          λ e → uip (ap rec (quot.eq (Q₁ _) e))
        where
        f :
          {j : Size}
          (s : S (T (Q j)))
          → -------------------------------------
          l (tq j (σ s)) ≡ sup  (S' (l ∘ tq j) s)
        f s =
          proof
            l (tq _ (σ s))
          ≡≡[ ap l (tqσ _) ]
            l (sup (S' (tq _) s))
          ≡≡[ symm (lhom _) ]
            sup (S' l (S' (tq _) s))
          qed

        g :
          {j : Size}
          (z : Q j)
          → --------------------
          l (tq j (η z)) ≡ rec z
        g {j} z =
          proof
            l (tq j (η z))
          ≡≡[ ap l (tqη z) ]
            l (φ ∞ z)
          ≡≡[ symm (uniq {j} z) ]
            rec z
          qed

        h :
          {j : Size}
          (t : T{Σ} (Q j))
          → --------------------
          l (tq j t) ≡ t >>= rec
        h = >>=-uniq rec (l ∘ tq _) f g

      uniq∞ : rec ≡ l
      uniq∞ = funext λ z →
        proof
          rec z
        ≡≡[ uniq z ]
          l (φ _ z)
        ≡≡[ ap l (φid z) ]
          l z
        qed

  qw : QW Σ (E , V) lhs rhs
  QW.ty     qw = ty
  QW.sq     qw = sup
  QW.eq     qw = eq
  QW.rec    qw = rec∞
  QW.rechom qw = rechom
  QW.uniq   qw = uniq∞
