{-# OPTIONS  --rewriting #-}
module QW-nonterminating-attempt where

open import Prelude
open import Quotient
open import W-type
open import QW-axiomatic

----------------------------------------------------------------------
-- Construction of QW-Types via quotients and inductive-inductive
-- types, but with non-terminating recursor
----------------------------------------------------------------------
module QWnonterminating
  (Σ : Sig)
  (E : Set)
  (V : E → Set)
  (lhs rhs : (e : E) → T{Σ} (V e))
  where
  mutual
    data ty₀ : Set where
      sq :  T{Σ} ty → ty₀

    data ty₁ : ty₀ → ty₀ → Set where
      sqeq :
        (e : E)
        {f : V e → ty}
        → -----------------------------------------
        ty₁ (sq (T' f (lhs e))) (sq (T' f (rhs e)))
      sqη :
        (x : ty₀)
        → --------------------
        ty₁ (sq (η (qu x))) x
      sqσ :
        (s : S (T ty))
        → -------------------------------------
        ty₁ (sq (σ s)) (sq (ι (S'(qu ∘ sq) s)))

    ty : Set
    ty = ty₀ / ty₁

    qu : ty₀ → ty
    qu x = [ x ]/ ty₁
  -- end mutual

  tq : T{Σ} ty  → ty
  tq = qu ∘ sq

  instance
    Algty : Alg{Σ} ty
    sup ⦃ Algty ⦄ = tq ∘ ι

  tqη :
    (z : ty)
    → ----------
    tq (η z) ≡ z
  tqη =
    quot.elim ty₁
      (λ z → tq (η z) ≡ z)
      (λ _ → quot.eq ty₁ (sqη _))
      (λ e → uip' (quot.eq ty₁ e))

  tqσ :
    (s : S{Σ} (T ty))
    → ----------------------
    tq (σ s) ≡ sup (S' tq s)
  tqσ s = quot.eq ty₁ (sqσ s)

  tqT :
    {X : Set}
    (t : T{Σ} X)
    {f : X → ty}
    → -------------------
    tq (T' f t) ≡ t >>= f
  tqT t {f} =
    >>=-uniq f (tq ∘ T' f)
    (λ _ → quot.eq ty₁ (sqσ _))
    (λ _ → tqη _) t

  eq :
    (e : E)
    (f : V e → ty)
    → -----------------------
    lhs e >>= f ≡ rhs e >>= f
  eq e f =
    proof
     lhs e >>= f
    ≡≡[ symm (tqT (lhs e)) ]
      tq (T' f (lhs e))
    ≡≡[ quot.eq ty₁ (sqeq e) ]
      tq (T' f (rhs e))
    ≡≡[ tqT (rhs e) ]
      rhs e >>= f
    qed

  module _
    {X : Set}
    ⦃ _  : Alg X ⦄
    (p : (e : E)(f : V e → X) →  lhs e >>= f ≡ rhs e >>= f)
    where
    mutual
      {-# TERMINATING #-}
      rec : ty → X
      rec = quot.elim ty₁ (λ _ → X) rec₀ resp

      rec₀ : ty₀ → X
      rec₀ (sq t) = t >>= rec

      resp :
        {x y : ty₀}
        (_ : ty₁ x y)
        → -------------
        rec₀ x ≡ rec₀ y
      resp (sqeq e {f}) =
        proof
          T' f (lhs e) >>= rec
        ≡≡[ T>>= (lhs e) ]
          lhs e >>= (rec ∘ f)
        ≡≡[ p e (rec ∘ f) ]
          rhs e >>= (rec ∘ f)
        ≡≡[ symm (T>>= (rhs e)) ]
          T' f (rhs e) >>= rec
        qed
      resp (sqη _)      = refl
      resp (sqσ _)      = refl
    -- end mutual block

    rechom : (s : S{Σ} ty) → sup (S' rec s) ≡ rec (sup s)
    rechom _ = refl

    module _
      -- given...
      (l    : ty → X)
      (lhom : (s : S{Σ} ty) → sup (S' l s) ≡ l (sup s))
      -- ...we have to show that rec ≡ l
      where
      {-# TERMINATING #-}
      uniq' :
        (z : ty )
        → ---------
        rec z ≡ l z
      uniq' =
        quot.elim ty₁
          (λ z → rec z ≡ l z)
          (λ{(sq t) → symm (h t)})
          (λ e → uip' (ap l (quot.eq ty₁ e)))

        where
        f : ∀ s → l (tq (σ s)) ≡ sup  (S' (l ∘ tq) s)
        f s =
          proof
            l (tq (σ s))
          ≡≡[ ap l (tqσ _) ]
            l (sup (S' tq s))
          ≡≡[ symm (lhom _) ]
            sup (S' l (S' tq s))
          qed

        g : ∀ z → l (tq (η z)) ≡ rec z
        g z =
          proof
            l (tq (η z))
          ≡≡[ ap l (tqη _) ]
            l z
          ≡≡[ symm (uniq' _) ]
            rec z
          qed

        h : ∀ t → l (tq t) ≡ t >>= rec
        h = >>=-uniq rec (l ∘ tq) f g

      uniq : rec ≡ l
      uniq = funext uniq'

  qw : QW Σ (E , V) lhs rhs
  QW.ty     qw = ty
  QW.sq     qw = sup
  QW.eq     qw = eq
  QW.rec    qw = rec
  QW.rechom qw = rechom
  QW.uniq   qw = uniq
