{-# OPTIONS #-}
module QW-axiomatic where

open import Prelude
open import Quotient
open import W-type

----------------------------------------------------------------------
-- System of equations over a signature
----------------------------------------------------------------------
Syseq : {_ : Sig} → Set₁
Syseq {Σ} =
  ∑ E ∶ Set , ∑ V ∶ (E → Set),
  ((e : E) → T{Σ}(V e)) × ((e : E) → T{Σ}(V e))

----------------------------------------------------------------------
-- (8) satisfaction
----------------------------------------------------------------------
Sat :
  {Σ : Sig}
  {ε : Syseq{Σ}}
  (X : Set)
  {{_ : Alg{Σ} X}}
  → ----------------
  Set
Sat {ε = (E , V , l , r)} X =
  (e : E)(ρ : V e → X) → l e >>= ρ ≡ r e >>= ρ

----------------------------------------------------------------------
-- Example 1: multisets
----------------------------------------------------------------------
BagSig : Set → Sig
BagSig X = ((⊤ ⊎ X) , [ (λ _ → ⊥) ∣ (λ _ → ⊤) ])

BagSyseq : (X : Set) → Syseq {BagSig X}
BagSyseq X = (X × X , (λ _ → ⊤) , l , r)
  where
  l : X × X → T{BagSig X} ⊤
  l (x , y) = σ (inr x , (λ _ → σ (inr y , (λ _ → η tt))))

  r : X × X → T{BagSig X} ⊤
  r (x , y) = σ (inr y , (λ _ → σ (inr x , (λ _ → η tt))))

----------------------------------------------------------------------
-- Example 2: unordered countably-branching trees
----------------------------------------------------------------------
ωTreeSig : Set → Sig
ωTreeSig X = ((⊤ ⊎ X) , [ (λ _ → ⊥) ∣ (λ _ → ℕ) ])

isIso : (ℕ → ℕ) → Set
isIso f = ∑ g ∶ (ℕ → ℕ) , (∀ x → g (f x ) ≡ x) × (∀ y → f (g y) ≡ y)

ωTreeSyseq : (X : Set) → Syseq{ωTreeSig X}
ωTreeSyseq X = (E , V , l , r)
  where
  E : Set
  E = X × (∑ f ∶ (ℕ → ℕ) , isIso f)

  V : E → Set
  V _ = ℕ

  l : (e : E) → T{ωTreeSig X}ℕ
  l (x , _ , _) = σ (inr x , η)

  r : (e : E) → T{ωTreeSig X}ℕ
  r (x , f , _) = σ (inr x , η ∘ f)

----------------------------------------------------------------------
-- Axioms for QW-types
----------------------------------------------------------------------
record QW
  -- given a system of equational axioms over a signature
  (Σ Γ : Sig)
  (lhs rhs : (e : fst Γ) → T{Σ} (snd Γ e))
  : --------------------------------------
  Set₁
  where
  private
    E = fst Γ
    V = snd Γ
  field
    ty : Set
    sq : S{Σ} ty → ty
  instance
    τ : Alg{Σ} ty
    τ = mkalg sq
  field
    -- ty satisfies the equations
    eq : (e : E)(f : V e → ty) → lhs e >>= f ≡ rhs e >>= f
    -- and is intial among Sig-algebras satsifying the equations
    rec :
      {X : Set}
      ⦃ _  : Alg{Σ} X ⦄
      (_ : (e : E)(f : V e → X) → lhs e >>= f ≡ rhs e >>= f)
      → ----------------------------------------------------
      ty → X
    rechom :
      {X : Set}
      ⦃ _  : Alg{Σ} X ⦄
      (xe : (e : E)(f : V e → X) → lhs e >>= f ≡ rhs e >>= f)
      → -----------------------------------------------------
      (s : S{Σ} ty) → sup (S' (rec xe ) s) ≡ rec xe (sup s)
    uniq :
      {X : Set}
      ⦃ _  : Alg{Σ} X ⦄
      (xe : (e : E)(f : V e → X) → lhs e >>= f ≡ rhs e >>= f)
      (f : ty → X)
      (_ : (s : S{Σ} ty) → sup (S' f s) ≡ f (sup s))
      → -----------------------------------------------------
      rec xe ≡ f
  ----------------------------------------------------------------------
  -- The derived elimination and computation rules
  ----------------------------------------------------------------------
  private
    A : Set
    A = fst Σ

    B : A → Set
    B = snd Σ

  lift :
    (P : ty → Set)
    (s :
      (a : A)
      (b : B a → ty)
      (p : (x : B a) → P (b x))
      → -----------------------
      P (sup (a , b))          )
    {X : Set}
    (h : X → ∑ ty P)
    (t : T{Σ} X)
    → --------------------------
    P (t >>= (fst ∘ h))
  lift _ _ h (η x)       = snd (h x)
  lift P s h (σ (a , b)) =
    s a (λ x → b x >>= (fst ∘ h)) (λ x → lift P s h (b x))

  module _
   (P : ty → Set)
    (s :
      (a : A)
      (b : B a → ty)
      (p : (x : B a) → P (b x))
      → -----------------------
      P (sup (a , b))          )
    (s' :
      (e : E)
      (h : V e → ∑ ty P)
      → ---------------------------------------
      lift P s h (lhs e) ≡≡ lift P s h (rhs e))
    where
    private
      instance
        Alg∑tyP : Alg{Σ} (∑ ty P)
        sup {{Alg∑tyP ⦄ (a , b) =
          (sup (a , fst ∘ b) , s a (fst ∘ b) (snd ∘ b))
      module _
        {X : Set}
        (h : X → ∑ ty P)
        where
        fstlift : (t : T{Σ} X) → fst (t >>= h) ≡ t >>= (fst ∘ h)
        fstlift =
          >>=-uniq (fst ∘ h) (λ t → fst (t >>= h))
            (λ _ → refl)
            (λ _ → refl)

        sndlift : (t : T{Σ} X) → snd (t >>= h) ≡≡ lift P s h t
        sndlift (η x) = refl
        sndlift (σ (a , b)) =
          ap₂ (s a)
            (funext  λ x → fstlift (b x))
            (funext λ x → sndlift (b x))

      module _
        (e : E)
        (h : V e → ∑ ty P)
        where
        q : fst (lhs e >>= h) ≡ fst (rhs e >>= h)
        q =
          proof
            fst (lhs e >>= h)
          ≡≡[ fstlift h (lhs e) ]
            lhs e >>= (fst ∘ h)
          ≡≡[ eq e (fst ∘ h) ]
            rhs e >>= (fst ∘ h)
          ≡≡[ symm (fstlift h (rhs e)) ]
            fst (rhs e >>= h)
          qed

        p : snd (lhs e >>= h) ≡≡ snd (rhs e >>= h)
        p =
          proof
            snd (lhs e >>= h)
          ≡≡[ sndlift h (lhs e) ]
            lift P s h (lhs e)
          ≡≡[ s' e h ]
            lift P s h (rhs e)
          ≡≡[ symm ( sndlift h (rhs e)) ]
            snd (rhs e >>= h)
          qed

        ∑tyPeq : lhs e >>= h ≡ rhs e >>= h
        ∑tyPeq = ∑ext q p

      r : ty → ∑ ty P
      r = rec ∑tyPeq

      fstrhom :
        (s : S{Σ} ty)
        → ------------------------------------
        sup (S' (fst ∘ r)  s) ≡ fst (r(sup s))
      fstrhom (a , b) = ap fst (rechom ∑tyPeq (a , b))

      fstrid : fst ∘ r ≡ id {A = ty}
      fstrid =
        proof
          fst ∘ r
        ≡≡[ symm (uniq eq (fst ∘ r) fstrhom) ]
          rec eq
        ≡≡[ uniq eq id (λ _ → refl) ]
          id
        qed

    elim : (z : ty) → P z
    elim z = ap (λ f → P(f z)) fstrid ∗ snd (r z)

    comp :
      (a : A)
      (b : B a → ty)
      → -----------------------------------------
      elim (sup (a , b)) ≡ s a b λ x → elim (b x)
    comp a b =
      proof
        elim (sup (a , b))
      ≡≡[ symm (∗≡≡ _ _) ]
        snd (r (sup (a , b)))
      ≡≡[ ap snd (symm (rechom ∑tyPeq  (a , b))) ]
        s a (fst ∘ r ∘ b) (snd ∘ r ∘ b)
      ≡≡[ ap₂ (s a) (ap (_∘ b) fstrid) (funext (λ _ → ∗≡≡ _ _)) ]
        s a b (λ x → elim (b x))
      qed
