{- Section 2, Remark 1. Free algebras -}
{-# OPTIONS  --rewriting #-}
module FreeAlgebras where

open import Prelude
open import Quotient
open import W-type
open import QW-axiomatic

----------------------------------------------------------------------
-- Extending a signature with constants
----------------------------------------------------------------------
infix 4 _⊕_
_⊕_ : Set → Sig → Sig
X ⊕ (A , B) = ((X ⊎ A) , B')
  where
  B' : X ⊎ A → Set
  B' (inl x) = ⊥
  B' (inr a) = B a

inSig :
  {Σ : Sig}
  {X Y : Set}
  → -----------------------------------
  (X → Y) × Alg{Σ} Y → Alg{X ⊕ Σ} Y
sup {{inSig(f , _)}} (inl x , _) = f x
sup {{inSig(_ , s)}} (inr a , b) = sup{{s}} (a , b)

outSig :
  {Σ : Sig}
  {X Y : Set}
  → -----------------------------------
  Alg{X ⊕ Σ} Y → (X → Y) × Alg{Σ} Y
outSig {Σ} {X} {Y} xs = (f , s)
  where
  f : X → Y
  f x = sup{{xs}} (inl x , λ())

  s : Alg{Σ} Y
  sup{{s}} (a , b) = sup{{xs}} (inr a , b)

inHom :
  {Σ : Sig}
  {X Y Z : Set}
  {{α : Alg{X ⊕ Σ} Y}}
  {{β : Alg{Σ} Z}}
  {f : X → Z}
  (h : Y → Z)
  (_ : isHom{Σ}{{snd(outSig α)}} h)
  (_ : h ∘ (fst(outSig α)) ≡ f)
  → --------------------------------
  isHom{X ⊕ Σ}{{β = inSig(f , β)}} h
inHom {{α}} {f} h _ e (inl x) b =
  proof
    h (sup (inl x , b))
  ≡≡[ ap (λ b → h (sup (inl x , b))) (funext λ()) ]
    h (fst (outSig α) x)
  ≡≡[ ap (apply x) e ]
    f x
  qed
inHom h p _ (inr a)            = p a

outHom :
  {Σ : Sig}
  {X Y Z : Set}
  {{α : Alg{X ⊕ Σ} Y}}
  {{β : Alg{Σ} Z}}
  {f : X → Z}
  (h : Y → Z)
  → ---------------------------------------------------------------
  isHom{X ⊕ Σ}{{β = inSig(f , β)}} h → isHom{Σ}{{snd (outSig α)}} h
outHom _ p a b = p (inr a) b

----------------------------------------------------------------------
-- Extending a system of equation with constants
----------------------------------------------------------------------
bind :
  -- Notation for Kleisli lift (6) that makes
  -- the S-algebra structure explicit
  {Σ : Sig}
  {X Y : Set}
  {{_ : Alg{Σ} Y}}
  (f : X → Y)
  (t : T{Σ} X)
  → ---------------
  Y
bind {{_}} f t = t >>= f

infix 4 _⊚_
_⊚_ :
  (X : Set)
  {Σ : Sig}
  (ε : Syseq{Σ})
  → ------------
  Syseq{X ⊕ Σ}
_⊚_ X {Σ} (E , V , l , r) = (E , V , lX , rX)
  where
  module _
   (e : E)
   where
   α : Alg{Σ} (T{X ⊕ Σ}(V e))
   α = snd (outSig AlgT)

   lX : T{X ⊕ Σ}(V e)
   lX = bind{{α}} η (l e)

   rX : T{X ⊕ Σ}(V e)
   rX = bind{{α}} η (r e)

inSyseq :
  {Σ : Sig}
  {ε : Syseq{Σ}}
  {X Y : Set}
  (f : X → Y)
  {{β : Alg{Σ} Y}}
  → ------------------------------------------------
  Sat{Σ}{ε} Y → Sat{X ⊕ Σ}{X ⊚ ε} Y {{inSig(f , β)}}
inSyseq {Σ} {E , V , l , r} {X} f {{β}} p e ρ =
  proof
    bind{{inSig(f , β)}} ρ (bind{{α}} η (l e))
  ≡≡[ lemma (l e) ]
    bind{{β}} ρ (l e)
  ≡≡[ p e ρ  ]
    bind{{β}} ρ (r e)
  ≡≡[ symm (lemma (r e)) ]
    bind{{inSig(f , β)}} ρ (bind{{α}} η (r e))
  qed
  where
  α : Alg{Σ} (T{X ⊕ Σ}(V e))
  α = snd (outSig AlgT)

  lemma :
    (t : T{Σ}(V e))
    → ----------------------------------------------------
    bind{{inSig(f , β)}} ρ (bind{{α}} η t) ≡ bind{{β}} ρ t
  lemma (η _)       = refl
  lemma (σ (_ , b)) =
    ap (sup{{inSig (f , β)}}) (∑ext refl (funext (λ x → lemma (b x))))

outSyseq :
  {Σ : Sig}
  {ε : Syseq{Σ}}
  {X Y : Set}
  {{β : Alg{X ⊕ Σ} Y}}
  → --------------------------------------------------
  Sat{X ⊕ Σ}{X ⊚ ε} Y → Sat{Σ}{ε} Y {{snd (outSig β)}}
outSyseq {Σ} {E , V , l , r} {X} {{β}} p e ρ =
  proof
    bind{{snd (outSig β)}} ρ (l e)
  ≡≡[ lemma (l e) ]
    bind{{β}} ρ (bind{{α}} η (l e))
  ≡≡[ p e ρ ]
    bind{{β}} ρ (bind{{α}} η (r e))
  ≡≡[ symm (lemma (r e)) ]
    bind{{snd (outSig β)}} ρ (r e)
  qed
  where
  α : Alg{Σ} (T{X ⊕ Σ}(V e))
  α = snd (outSig AlgT)

  lemma :
    (t : T{Σ}(V e))
    → ------------------------------------------------------
    bind{{snd (outSig β)}} ρ t ≡ bind{{β}} ρ (bind{{α}} η t)
  lemma (η _)       = refl
  lemma (σ (_ , b)) =
    ap (sup{{β}}) (∑ext refl (funext (λ x → lemma (b x))))

