{-# OPTIONS --rewriting #-}
module F-type where

open import Prelude
open import Quotient
open import W-type
open import QW-axiomatic
open import QW-sized-construction

data JointlySurjective (f g : ℕ → ℕ) : Set where
  jointly-surjective : (n : ℕ) → ∑ ℕ (λ x → ((f x ≡ n) ⊎ (g x ≡ n))) → JointlySurjective f g

evenodd : ℕ → ℕ ⊎ ℕ
evenodd zero = inl zero
evenodd (n +1) with (evenodd n)
evenodd (n +1) | inl x = inr x
evenodd (n +1) | inr y = inl (y +1)

_∪_ : ∀ {ℓ} {A : Set ℓ} (f g : ℕ → A) → ℕ → A
(f ∪ g) = [ f ∣ g ] ∘ evenodd

-- assuming some bijection ℕ × ℕ ↔ ℕ
postulate
  ℕpair : ℕ × ℕ → ℕ
  ℕunpair : ℕ → ℕ × ℕ
  unpair-id-1 : ℕpair ∘ ℕunpair ≡ id {A = ℕ}
  unpair-id-2 : ℕunpair ∘ ℕpair ≡ id {A = ℕ × ℕ}

data FOp₀ : Set where
  Zdat : FOp₀
  Sdat : FOp₀
  supdat : FOp₀

FAr₀ : FOp₀ → Set
FAr₀ Zdat = ⊥
FAr₀ Sdat = ⊤
FAr₀ supdat = ℕ

FΣ : Sig
FΣ = (FOp₀ , FAr₀)

h-sub : {L : ℕ → ℕ → ℕ} → ℕ → ℕ → T{FΣ} ℕ
h-sub zero x = η x -- h₀ = h. h(x) is var x.
h-sub {L} (n +1) x = σ (supdat , ((h-sub {L} n) ∘ (L n)))

data FOp₁ : Set where
  F-rule-1 : (f g : ℕ → ℕ) → FOp₁
  F-rule-2 : FOp₁
  F-rule-3 : FOp₁
  F-rule-4 : (b c : ℕ → ℕ)
    (js : JointlySurjective b c)
    (L : ℕ → ℕ → ℕ)
    (st1 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (b m) l ≡ b n)))
    (st2 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (c m) l ≡ c n)))
    → FOp₁
  F-rule-5 : FOp₁

FAr₁ : FOp₁ → Set
FAr₁ (F-rule-1 f g) = ℕ
FAr₁ F-rule-2 = ℕ ⊎ ℕ
FAr₁ F-rule-3 = ℕ ⊎ ℕ
FAr₁ (F-rule-4 b c js L st1 st2) = ℕ
FAr₁ F-rule-5 = ⊥

FΓ : Sig
FΓ = (FOp₁ , FAr₁)

Feq : (p : FOp₁) → T{FΣ} (FAr₁ p) × T{FΣ} (FAr₁ p)
-- rule 1: sup(h ∘ f) = sup(h ∘ g)
Feq (F-rule-1 f g) = σ (supdat , (η ∘ f))
                   , σ (supdat , (η ∘ g))

-- rule 2: sup(f ∪ {sup(f ∪ g)}) = sup(f ∪ g)
Feq F-rule-2 = σ (supdat , ((η ∘ inl) ∪ (λ _ → σ (supdat , ((η ∘ inl) ∪ (η ∘ inr))))))
             , σ (supdat , ((η ∘ inl) ∪ (η ∘ inr)))

-- rule 3: sup(f ∪ {S(sup(f ∪ g))}) = S(sup(f ∪ g))
Feq F-rule-3 = σ (supdat , ((η ∘ inl)
                    ∪ (λ _ → σ (Sdat , (λ _ → σ (supdat , ((η ∘ inl) ∪ (η ∘ inr)))) )) ))
             , σ (Sdat , (λ _ → σ (supdat , ((η ∘ inl) ∪ (η ∘ inr)))))

-- rule 4: ∀ {b, c, L, h} → sup(bar-f) = sup(bar-g),
-- where bar-h(n) = h_{fst (unpair n)}(snd (unpair n))
Feq (F-rule-4 b c js L st1 st2) = σ (supdat , (λ x → let k , n = ℕunpair x in (h-sub {L} k (b n))))
                                , σ (supdat , (λ x → let k , n = ℕunpair x in (h-sub {L} k (c n))))

-- rule 5: sup({0}) = 0
Feq F-rule-5 = σ (supdat , (λ _ → σ (Zdat , ⊥elim)))
             , σ (Zdat , ⊥elim)

Fi = QWsized.qw FΣ FOp₁ FAr₁ (fst ∘ Feq) (snd ∘ Feq)

F : Set
F = QW.ty Fi

h-sub₂ : (h : ℕ → F) {L : ℕ → ℕ → ℕ} → ℕ → ℕ → F
h-sub₂ h {L} k x = _>>=_ ⦃ QW.τ Fi ⦄ (h-sub {L} k x) h
-- Intuitively:
-- h-sub₂ h zero = h -- h₀ = h.
-- h-sub₂ h {L} (suc n) x = W⁺.sup FL FR supdat ((h-sub₂ h {L} n) ∘ (L n))

------------------------------------------------------------------------
-- Constructors and Eliminator -----------------------------------------

Zero : F
Zero = QW.sq Fi (Zdat , ⊥elim)

Succ : F → F
Succ n = QW.sq Fi (Sdat , (λ _ → n))

Sup : (ℕ → F) → F
Sup f = QW.sq Fi (supdat , f)

F1 : (f g : ℕ → ℕ) (h : ℕ → F) → Sup (h ∘ f) ≡ Sup (h ∘ g)
F1 f g h = QW.eq Fi (F-rule-1 f g) h

F2 : (f g : ℕ → F) → Sup (f ∪ (λ _ → Sup (f ∪ g))) ≡ Sup (f ∪ g)
F2 f g =
  trans
    (cong Sup (funext p))
  (trans
    (QW.eq Fi F-rule-2 [ f ∣ g ])
    (cong Sup (funext q))
  )
  where
    p : (x : ℕ) →
      _>>=_ ⦃ QW.τ Fi ⦄ ([ (η ∘ inl) ∣ (η ∘ inr) ] (evenodd x)) [ f ∣ g ]
      ≡ (F ∋ [ f ∣ g ] (evenodd x))
    p zero = refl
    p (x +1) with evenodd x
    p (x +1) | inl x₁ = refl
    p (x +1) | inr y = refl
    q : (x : ℕ) →
      (F ∋ [ f ∣ (λ _ → Sup (λ x₁ → [ f ∣ g ] (evenodd x₁))) ] (evenodd x))
      ≡
      _>>=_ ⦃ QW.τ Fi ⦄
      ([ (η ∘ inl)
        ∣ (λ _ → σ (supdat , (λ x₁ → [ (η ∘ inl)
                                     ∣ (η ∘ inr)
                                     ] (evenodd x₁))))
        ] (evenodd x)
      ) [ f ∣ g ]
    q zero = refl
    q (x +1) with evenodd x
    q (x +1) | inl x₁ = cong Sup (funext λ x₂ → symm (p x₂))
    q (x +1) | inr y = refl

F3 : (f g : ℕ → F) → Sup (f ∪ (λ _ → Succ (Sup (f ∪ g)))) ≡ Succ (Sup (f ∪ g))
F3 f g =
  trans
    (cong Succ (cong Sup (funext p)))
  (trans
    (QW.eq Fi F-rule-3 [ f ∣ g ])
    (cong Sup (funext q))
  )
  where
    p : (x : ℕ) →
      _>>=_ ⦃ QW.τ Fi ⦄ ([ (η ∘ inl) ∣ (η ∘ inr) ] (evenodd x)) [ f ∣ g ]
      ≡ (F ∋ [ f ∣ g ] (evenodd x))
    p zero = refl
    p (x +1) with evenodd x
    p (x +1) | inl x₁ = refl
    p (x +1) | inr y = refl
    q : (x : ℕ) →
      (F ∋ [ f ∣ (λ _ → Succ (Sup (λ x₁ → [ f ∣ g ] (evenodd x₁))))] (evenodd x))
      ≡
      _>>=_ ⦃ QW.τ Fi ⦄
      ([ (η ∘ inl)
       ∣ (λ _ → σ (Sdat , (λ _ → σ (supdat , (λ x₁ → [ (η ∘ inl)
                                                     ∣ (η ∘ inr)
                                                     ] (evenodd x₁))))))
       ] (evenodd x)
      ) [ f ∣ g ]
    q zero = refl
    q (x +1) with evenodd x
    q (x +1) | inl x₁ = cong Succ (cong Sup (funext (λ x₂ → symm (p x₂))))
    q (x +1) | inr y = refl


F4 :
  (b c : ℕ → ℕ)
  (js : JointlySurjective b c)
  (L : ℕ → ℕ → ℕ)
  (st1 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (b m) l ≡ b n)))
  (st2 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (c m) l ≡ c n)))
  (h : ℕ → F)
  → ---------------------------------------------------------
  Sup ((λ {(k , n) → h-sub₂ h {L} k (b n)}) ∘ ℕunpair)
  ≡
  Sup ((λ {(k , n) → h-sub₂ h {L} k (c n)}) ∘ ℕunpair)
F4 b c js L st1 st2 h = proof
    Sup ((λ { (k , n) → h-sub₂ h k (b n) }) ∘ ℕunpair)
      ≡≡[ cong Sup (funext (λ x → refl)) ]
    Sup (λ c₁ → (_>>=_ ⦃ QW.τ Fi ⦄) (h-sub (fst (ℕunpair c₁)) (b (snd (ℕunpair c₁)))) h)
      ≡≡[ QW.eq Fi (F-rule-4 b c js L st1 st2) h ]
    Sup (λ c₁ → (_>>=_ ⦃ QW.τ Fi ⦄) (h-sub (fst (ℕunpair c₁)) (c (snd (ℕunpair c₁)))) h)
      ≡≡[ cong Sup (funext (λ x → refl)) ]
    Sup ((λ { (k , n) → h-sub₂ h k (c n) }) ∘ ℕunpair)
  qed

F5 : Sup (λ _ → Zero) ≡ Zero
F5 = proof
    Sup (λ _ → Zero)
      ≡≡[ cong (Sup) (funext (λ x → cong (QW.sq Fi ∘ (Zdat ,_)) (funext λ x₁ → ⊥elim x₁))) ]
    Sup (λ c → QW.sq Fi (Zdat , (λ c₁ → (_>>=_ ⦃ QW.τ Fi ⦄) (⊥elim c₁) ⊥elim)))
      ≡≡[ QW.eq Fi F-rule-5 ⊥elim ]
    QW.sq Fi (Zdat , (λ c → (_>>=_ ⦃ QW.τ Fi ⦄) (⊥elim c) ⊥elim))
      ≡≡[ cong (QW.sq Fi ∘ (Zdat ,_)) (funext (λ x → ⊥elim x)) ]
    Zero
  qed

------------------------------------------------------------------------
-- Collected terms
--
-- Zero : F
-- Succ : F → F
-- Sup : (ℕ → F) → F
--
-- F1 : (f g : ℕ → ℕ) (h : ℕ → F) → Sup (h ∘ f) ≡ Sup (h ∘ g)
-- F2 : (f g : ℕ → F) → Sup (f ∪ (λ _ → Sup (f ∪ g))) ≡ Sup (f ∪ g)
-- F3 : (f g : ℕ → F) → Sup (f ∪ (λ _ → Succ (Sup (f ∪ g)))) ≡ Succ (Sup (f ∪ g))
-- F4 :
--   (b c : ℕ → ℕ)
--   (js : JointlySurjective b c)
--   (L : ℕ → ℕ → ℕ)
--   (st1 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (b m) l ≡ b n)))
--   (st2 : (n : ℕ) → ∑ ℕ (λ m → ∑ ℕ (λ l → L (c m) l ≡ c n)))
--   (h : ℕ → F)
--   → ---------------------------------------------------------
--   Sup ((λ {(k , n) → h-sub₂ h {L} k (b n)}) ∘ ℕunpair)
--   ≡
--   Sup ((λ {(k , n) → h-sub₂ h {L} k (c n)}) ∘ ℕunpair)
-- F5 : Sup (λ _ → Zero) ≡ Zero
