(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

(*
load "x86_lts_monadTheory";
load "x86_programTheory";
load "x86_niceness_statementTheory";
load "utilLib";
load "HolDoc";
*)

open HolKernel boolLib Parse bossLib;
open pairLib listTheory;
open stringTheory;
open utilLib;
open x86_lts_opsTheory x86_niceness_statementTheory;
open x86_hb_machineTheory x86_axiomatic_modelTheory x86_programTheory; 
open HolDoc;

val _ = new_theory "x86_hb_machine_thms";

val machine_lts_def = Define `
(machine_lts : proc set -> state_constraint -> (machine_state,unit,machine_visible_label) LTS) ps initial_state =
  <| states := (UNIV:machine_state set);
     initial := initial_machine_state initial_state;
     final := {};
     trans := { (s1,l,s2) | machine_trans ps s1 l s2 }|> `;

val machine_execution_of_event_structure_def = Define ` 
(machine_execution_of_event_structure E initial_state) =
   let lts_prog = lts_po_of_event_structure E in
   let lts_machine = machine_lts (E.procs) initial_state in
   let lts = lts_parallel lts_prog lts_machine in
   completed_traces_of_lts lts `;

val final_states_def = Define `
  final_states init_state E trs =
    { st | ?path lbl. (({}, init_state), path) IN trs /\ 
                      final_state path (lbl, (E.events, st))}`; 

val hb_equivalence_thm1_def = Define `
  hb_equivalence_thm1 =
  !E X.
    well_formed_event_structure E /\
    FINITE E.events /\
    valid_execution E X /\
    nice_execution E X
    ==>
    ?M F G Rg. 
      (E, M, F, G, Rg, X) IN 
      final_states (initial_machine_state X.initial_state)
                   E 
                   (machine_execution_of_event_structure E X.initial_state)`;

(*
Proof:

By lexicographic induction on t = (t1,...,t|E.procs|) which is taken as an index
into the view orders of X.

Base case: t = (0,...,0)

By definition of initial_machine_state

Inductive case:
We have t = (t1,...t|procs|).  Choose p such that (X.vo p).tp+1 is
happens-before maximal, and at the end of (X.vo p).  Acyclicity of
happens-before ensures its existence, and we need a happens-before maximal
element to ensure that the induction hypothesis applies once the event is
removed from (X.vo p).
  Suppose that (X.vo p).tp+1 is a 
    reg-event.
     We show the machine can perform this event by showing that the machine_lts 
     rules do not block the transition, and the lts_prog rules can generate this 
     event.
     The machine_lts premises are satisfied if all happens_before predecessors 
     are already performed.
       All happens_before predecessors must be in X.vo p before this event.
       By induction, they are already performed by the machine. 
     The lts_prog rules can generate this event if all po_iico predecessors are
     generated. 
        All register or memory read po_iico predecessors are already performed because 
        X.vo p contains all of them, being a nice execution order. 
        Suppose the machine has a memory write which is a po_iico predecessor. 
        Perform all such write enqueuing.
     Then the machine can perform this event. 
  Suppose that (X.vo p).tp+1 is a memory 
     write Ew.
       All happens_before predecessors must be in X.vo p before this event.
       If Ew is not in (F _ p), perform the enqueue and the delivery on this
       processor.
       If Ew is in (F _ p), perform the delivery. 
       Note in both the above cases, all write_serialisation predecessors of Ew must have
       already been delivered (write_serialisation is a part of happens-before). If Ew is
       not in G a, then place it in G a (There cannot be a write_serialisation predecessor
       if this happens).
       Note 2: In both cases, Ew must be at the head of the FIFO (F _ p). 
         Otherwise, there is a write pending from the same processor as Ew,
         which must have been enqueued before Ew, and hence came before Ew 
         in po_iico order. But then it must be a happens_before predecessor
         (writes from the same processor).
  Now the final case is that (X.vo p).tp+1 is a 
     memory read Er.
       All po_iico predecessors which are reads or register events must 
       already have been performed (in t.vo). All po_iico predecessors
       which are memory writes can be enqueued. All happens_before 
       predecessors must be in X.vo p before this event. 

       Finally, we must ensure there are no events to the same location 
       pending in the (F p p) queue FIFO. Suppose not. Then there is at least
       one write Ew enqueued which is a po_iico predecessors of this read. 
       These writes are also to the same location. But then any such Ew must
       have an edge Ew -> Er in happens_before. Therefore, it must appear
       in X.vo p before Er. By induction, it must be in EV_t. But writes
       appear in EV_t only when they are dequeued, thus the queue cannot
       contain any such Ew.

QED
*)

val partial_view_orders_well_formed_def = Define `
  partial_view_orders_well_formed E vo =
    (!p :: (E.procs). 
       (?es es'. 
         (viewed_events E p = es UNION es') /\ 
         (!e :: es'. mem_store e) /\
         linear_order (vo p) es) /\
       !e :: (viewed_events E p). FINITE {e' | (e', e) IN (vo p)}) /\
    (!p. ~(p IN E.procs) ==> (vo p = {}))`; 

val partial_valid_execution_def = Define `
  partial_valid_execution E X =
       partial_view_orders_well_formed E X.vo /\
       X.write_serialization IN write_serialization_candidates E /\
       X.lock_serialization IN lock_serialization_candidates E /\
       X.rfmap IN reads_from_map_candidates E /\
       check_causality E X.vo (happens_before E X) /\
       check_rfmap_written E X.vo X.rfmap /\
       check_rfmap_initial E X.vo X.rfmap X.initial_state /\
       check_atomicity E X.vo`; 


val hb_equivalence_thm2_def_ = Define `
hb_equivalence_thm2 = 
  !E M F G Rg X. 
  FINITE E.events /\
  well_formed_event_structure E  /\
  (E, M, F, G, Rg, X) IN 
  final_states (initial_machine_state X.initial_state)
               E 
               (machine_execution_of_event_structure E X.initial_state)
  ==>
  partial_valid_execution E X`;
(*
Proof:
By induction on the length of the trace to (E, M, F, G, Rg, X), showing
simultaneously 
   1. If Rg p r = SOME (v,eo) and 
            1.1 eo = SOME e then e is 
                             1.1.1 the last write to location_reg p r in X.vo p
                             1.2.1 wrote value v
            1.2 eo = NONE then there is no write to location_reg p r in X.vo p AND v matches X.initial_state (location_reg p r)
    2. If M p a = SOME (v,eo) and 
            1.1 eo = SOME e then e is 
                             1.1.1 the last write to location_mem a in X.vo p
                             1.2.1 wrote value v
            1.2 eo = NONE then there is no write to location_mem a in X.vo p AND v matches X.initial_state (location_mem a)
    3. X.write_serialisation = UNION_a G a

 Base case:
   length = 0:
      events = {}, X = {}, trivially well-formed.
      Rg p r = SOME (v,NONE) iff initial_state (location_reg p r) = v, otherwise NONE
      M p a = SOME (v,NONE) iff initial_state (location_mem a) = v, otherwise NONE

   length = n+1:
     Call the machine state at state n (E,M,F,G,Rg,X) and at n+1 (E',M',F',G',Rg',X').
     We case analyse on the transition of the machine
        case enqueue-mem-write:
            X' = X, E' = E 
            by induction, all the cases follow
 
        case mem-read:
           X' = X with change in vo p and rfmap
           E' = E UNION {(R,location_mem a,v)}

           check vos well-formed:
             X'.vo p' (p' <> p) = X.vo p, well-formed by induction
             X'.vo p = X.vo p linearly extended with new read event, which is relevant

           check write_serialisation in candidates:
             no new events were added, check write_serialisation satisfied by induction

           check lock_serialisation in candidates:
             vacuous, no locked events

           check rfmap in candidates:
             new rfmap edge relates write event with the same value, by induction

           check_causality:
             By induction, acyclic (happens_before E X UNION X.vo p)
             happens_before E' X' can differ from happens_before E X only
             by new rfmap edge to e and new iico edges to e. 
             X'.vo p differs from X.vo p only by linear order extension by 
             the event e. Since all happens_before E' X' predecessors of e
             are present in X'.vo p, and there are no new successors of e,
             there cannot be a cycle in (happens_before E' X' UNION X'.vo p). 

             for other processors, X'.vo p' = X.vo p', check_causality succeeds by induction

           check_rfmap_written:
             For all locations other than (location_mem a), rfmap checks succeed by
             induction.
             For (location_mem a), if M p a = SOME (v, SOME e), then by induction, e
               was the last write in vo p, while if it is SOME (v, NONE), then there
               is no write to location_mem a in vo p.
             
           check_rfmap_initial:
             For all locations other than (location_mem a), rfmap checks succeed by
             induction.
             For (location_mem a), if M p a = SOME (v, SOME e), then by induction, e
               was the last write in vo p, and the check succeeds inductively.
               Otherwise, if it is SOME (v, NONE), then there is no write to 
               location_mem a in vo p. By induction, location_mem a contains v in
               initial_state

           check_atomicity:
             vacuous, since no lock events

           for check Rg, Rg is not modified
           
           for check M, M is not modified

           for check G, G and X.write_serialisation does not change, hence by induction

        case deliver-mem-write-1
           X' = X with change in vo p
           E' = E 

           check vos well-formed:
             X'.vo p' (p' <> p) = X.vo p, well-formed by induction
             X'.vo p = X.vo p linearly extended with new write event, which is relevant

           check write_serialisation in candidates:
             no new events were added, check write_serialisation satisfied by induction

           check lock_serialisation in candidates:
             vacuous, no locked events

           check rfmap in candidates:
             no new rfmap edges, check satisfied by induction

           check_causality:
             By induction, acyclic(happens_before E X UNION X.vo q)
             happens_before E X' = happens_before E X
             X'.vo q = X.vo q linearly extended with e, and all 
             happens_before E X predecessors are checked to be in X.vo q. Thus
             we cannot have a cycle in happens_before E X' UNION X'.vo q.

             for other processors, X'.vo p' = X.vo p', check_causality succeeds by induction

           check_rfmap_written:
             rfmap remains the same, check succeeds by induction
             
           check_rfmap_initial:
             rfmap remains the same, check succeeds by induction

           check_atomicity:
             vacuous, since no lock events

           for check Rg, Rg is not modified

           for check M, M is modified for this processor, this write is the last write

           for check G, G and X.write_serialisation does not change, hence by induction

        case deliver-mem-write-2
           X' = X with change in vo p and write_serialisation
           E' = E UNION {(W,location_mem a v)}
 

           check vos well-formed:
             X'.vo p' (p' <> p) = X.vo p, well-formed by induction
             X'.vo p = X.vo p linearly extended with new write event, which is relevant

           check write_serialisation in candidates:
             Since we are in the deliver-mem-write-2 case, G a does not contain this
             event. By induction, write_serialisation does not contain this event either.
             In this rule, the write event was added to both write_serialisation and G a, and the new
             write_serialisation and G must both be proper linearisation of write
             events to the same locations, ie part of write_serialisation_candidates.

           check lock_serialisation in candidates:
             vacuous, no locked events

           check rfmap in candidates:
             no new rfmap edges, check satisfied by induction

           check_causality:
             By induction, acyclic (happens_before E X UNION X.vo p)
             happens_before E' X' can differ from happens_before E X only
             by new write serialisation edge into e. 
             X'.vo p differs from X.vo p only by linear order extension by 
             the event e. Since all happens_before E' X' predecessors of e
             are present in X'.vo p, there cannot be a cycle in 
             (happens_before E' X' UNION X'.vo p). 

             for other processors, X'.vo p' = X.vo p', check_causality succeeds by induction

           check_rfmap_written:
             rfmap remains the same, check succeeds by induction
             
           check_rfmap_initial:
             rfmap remains the same, check succeeds by induction


           check_atomicity:
             vacuous, since no lock events

           for check Rg, Rg is not modified

           for check M, M is modified for this processor, this write is the last write

           for check G. G and X.write_serialisation do not change except at location_mem a
               At location_mem a, both G and X.write_serialisation are linearly extended with
               this write event. In all cases, the two sets are the same.



        case reg-read:
           X' = X with change in vo p and rfmap
           E' = E UNION {(R,location_reg p r,v)}

           check vos well-formed:
             X'.vo p' (p' <> p) = X.vo p, well-formed by induction
             X'.vo p = X.vo p linearly extended with new read event, which is relevant

           check write_serialisation in candidates:
             no new events were added, check write_serialisation satisfied by induction

           check lock_serialisation in candidates:
             vacuous, no locked events

           check rfmap in candidates:
             new rfmap edge relates write event with the same value, by induction

           check_causality:
             By induction, acyclic (happens_before E X UNION X.vo p)
             happens_before E' X' can differ from happens_before E X only
             by new rfmap edge to e and new iico edges to e. 
             X'.vo p differs from X.vo p only by linear order extension by 
             the event e. Since all happens_before E' X' predecessors of e
             are present in X'.vo p, and there are no new successors of e,
             there cannot be a cycle in (happens_before E' X' UNION X'.vo p). 

             happens_before UNION X'.vo p was checked as a premise
             for other processors, X'.vo p' = X.vo p, check_causality succeeds by induction

           check_rfmap_written:
             For all locations other than (location_reg p r), rfmap checks succeed by
             induction.
             For (location_reg p r), if Rg p r = SOME (v, SOME e), then by induction, e
               was the last write in vo p, while if it is SOME (v, NONE), then there
               is no write to location_reg p r in vo p.
             
           check_rfmap_initial:
             For all locations other than (location_reg p r), rfmap checks succeed by
             induction.
             For (location_reg p r), if Rg p r = SOME (v, SOME e), then by induction, e
               was the last write in vo p, while if it is SOME (v, NONE), then there
               is no write to location_reg p r in vo p. By induction, location_reg p r 
               has the same value as in initial_state

           check_atomicity:
             vacuous, since no lock events

           for check Rg, Rg is not modified

           for check M, M is not modified

           for check G, G and X.write_serialisation does not change, hence by induction


        case reg-write:
           X' = X with change in vo p 
           E' = E UNION {(W,location_reg p r,v)}

           check vos well-formed:
             X'.vo p' (p' <> p) = X.vo p, well-formed by induction
             X'.vo p = X.vo p linearly extended with new write event, which is relevant

           check write_serialisation in candidates:
             no new events were added, check write_serialisation satisfied by induction

           check lock_serialisation in candidates:
             vacuous, no locked events

           check rfmap in candidates:
             rfmap is the same, satisfied by induction

           check_causality:
             By induction, acyclic (happens_before E X UNION X.vo p)
             happens_before E' X' can differ from happens_before E X only
             by new iico edges to e. 
             X'.vo p differs from X.vo p only by linear order extension by 
             the event e. Since all happens_before E' X' predecessors of e
             are present in X'.vo p, and there are no new successors of e,
             there cannot be a cycle in (happens_before E' X' UNION X'.vo p). 

             for other processors, X'.vo p' = X.vo p, check_causality succeeds by induction

           check_rfmap_written:
             rfmap remains the same, satisfied by induction

             
           check_rfmap_initial:
             rfmap remains the same, satisfied by induction

           check_atomicity:
             vacuous, since no lock events

           for check Rg, Rg is modified by this write as the last write

           for check M, M is not modified

           for check G, G and X.write_serialisation does not change, hence by induction
        

QED
*)

val hb_machine_progress_thm_def = Define `
hb_machine_progress_thm =
!E mst es path lbl init.
  (({}, (initial_machine_state init)), path) IN 
  traces_of_lts (lts_parallel (lts_po_of_event_structure E) (machine_lts E.procs init)) /\
  final_state path (lbl, (es, mst))
  ==>
  ?mst'.
    (mst, Tau, mst') IN (machine_lts E.procs init).trans \/ 
    (?es' l. 
      (es, l, es') IN (lts_po_of_event_structure E).trans /\
      (mst, l, mst') IN (machine_lts E.procs init).trans) \/
    ((!p q. ((FST (SND (SND mst))) p q = [])) /\ 
     (!es' l. ~((es, l, es') IN (lts_po_of_event_structure E).trans)))`;

(*

Proof: 

Suppose there is a processor p that has an entry in one of F _ p, or
that there is an event on p that lts_po_of_event_structure E can still produce (i.e.
not in es). Suppose for the sake of contradiction that it
is blocked, i.e. there is no step we can take.

If the next po_iico event to be executed is a write, it can always be
enqueued (enqueue-mem-write transition). Thus the next event in
po_iico order is a memory read or a register event. Call this event
Enext.

Suppose all the F _ p buffers are empty. Then the only premises that
can be unsatisfied is the premise that all happens_before predecessors
of the Enext have not yet been seen by processor p. Suppose e is such
an event. Since F _ p are empty, e cannot be a memory write. Then e
only appears in view order of processor p. But if it is not yet seen
by processor p, it cannot be in vo p, and hence cannot be in
happens_before.

Thus there are some pending write events in the {F q p | q}
buffers. Let Ewrites be the set of all events in {F q p | q}. Consider
the happens_before minimal events in Ewrites (there must be at least
one, since happens_before is a partial order). Call this Eminwrites.
For each address a, let Eminwrites_a = {e in Eminwrites |
address-of(e) = a}. Not all these sets can be empty. Pick address a
such that Eminwrites_a be one such nonempty set. Because Eminwrites_a
is happens_before minimal, in particular, all events are
write_serialization minimal. If any Ewrtdel IN Eminwrites_a is in Ga,
pick that one (there can be at most one).  If none of them occur in G
a, pick any write in Eminwrites_a to be Ewrtdel.

We will now argue that we can always perform the transition to deliver
Ewrtdel. Observation: Ewrtdel must be at the head of the F q p
queue for some q. If not, Ewrtdel cannot be happens_before minimal, because F q p
has write events in program order, and write-subsequent-write is in
preserved program order and hence in happens_before.

Case Ewrtdel is not in G a for a = address-of(Ewrtdel): 

Then Ewrtdel has not been delivered to any processor. Then Ewrt does
not appear in any view order, and so not in dom(happens_before). Since
we are in this case, there cannot be any G a write events in {F q p | q}. 
Thus deliver-mem-write-2 transition can be performed.

Case Ewrtdel is in G a:

Then Ewrtdel is happens_before minimal, and is the earliest in G a.
Suppose there is a happens_before predecessor Epred of Ewrtdel that
has not been observed by p. Epred cannot be a memory write, since
Ewrtdel is happens_before minimal among F events (ie unobserved memory
write events). But Epred cannot be a private event (memory read or
register event) either, since Epred is in happens_before, which means
it has to have been observed in vo p (which is the only view order it
appears in). Thus deliver-mem-write-1 transition can be performed.

QED
*)

val _ = export_theory ();

