(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib bossLib Parse;

open HolDoc;

open x86_coretypesTheory;


val _ = new_theory "x86_ast";


(* ---------------------------------------------------------------------------------- *>

  This theory defines the abstract syntax tree (AST) for x86 instructions. It uses 

     Ximm - type of immediate constant
     Xreg - type of register name

  from x86_coretypesTheory.

<* ---------------------------------------------------------------------------------- *)


val _ = Hol_datatype `
  Xrm = Xr of Xreg                                         (* register *) 
      | Xm of (word2 # Xreg) option => Xreg option => Ximm (* mem[2^{scale} * index + base + displacement] *)`;

(* check whether rm requires a lock, i.e. specifies a memory access *)

val rm_is_memory_access_def = Define `
  (rm_is_memory_access (Xm i b d) = T) /\ 
  (rm_is_memory_access (Xr r) = F)`;

val _ = Hol_datatype `
  Xdest_src = Xrm_i of Xrm  => Ximm  (* mnemonic r/m32, imm32 or mnemonic r/m32, imm8 (sign-extended) *)
            | Xrm_r of Xrm  => Xreg  (* mnemonic r/m32, r32 *)
            | Xr_rm of Xreg => Xrm   (* mnemonic r32, r/m32 *)  `;

val _ = Hol_datatype `
  Ximm_rm = Xi_rm of Xrm    (* r/m32 *) 
          | Xi    of Ximm   (* imm32 or imm8 (sign-extended) *) `;

val _ = Hol_datatype `Xbinop_name = Xadd | Xand | Xcmp | Xor | Xshl | Xshr | Xsar | Xsub | Xtest | Xxor `;
val _ = Hol_datatype `Xmonop_name = Xdec | Xinc | Xnot | Xneg `;

val _ = Hol_datatype `Xcond = X_ALWAYS | X_E | X_NE`;   (* this list is by no means complete *)

val _ = Hol_datatype `
  Xinstruction = Xbinop     of Xbinop_name => Xdest_src
               | Xmonop     of Xmonop_name => Xrm
               | Xcmpxchg   of Xrm => Xreg 
               | Xxadd      of Xrm => Xreg 
               | Xxchg      of Xrm => Xreg 
               | Xlea       of Xdest_src
               | Xpop       of Xrm
               | Xpush      of Ximm_rm
               | Xcall      of Ximm_rm
               | Xret       of Ximm
               | Xmov       of Xcond => Xdest_src
               | Xjump      of Xcond => Ximm
               | Xloop      of Xcond => Ximm      (* Here Xcond over approximates possibilities *)
               | Xpushad      
               | Xpopad     `;

val _ = Hol_datatype `Xpre_g1 = Xlock | Xg1_none `;
val _ = Hol_datatype `Xpre_g2 = Xbranch_taken | Xbranch_not_taken | Xg2_none `;

val _ = Hol_datatype `Xinst = Xprefix of Xpre_g1 => Xpre_g2 => Xinstruction`;


val _ = export_theory ();
