(**************************************************************************)
(*         x86 Multiprocessor Machine Code Semantics: HOL sources         *)
(*                                                                        *)
(*                                                                        *)
(*  Susmit Sarkar (1), Peter Sewell (1), Francesco Zappa Nardelli (2),    *)
(*  Scott Owens (1), Tom Ridge (1), Thomas Braibant (2),                  *)
(*  Magnus Myreen (1), Jade Alglave (2)                                   *)
(*                                                                        *)
(*   (1) Computer Laboratory, University of Cambridge                     *)
(*   (2) Moscova project, INRIA Paris-Rocquencourt                        *)
(*                                                                        *)
(*    Copyright 2007-2008                                                 *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*                                                                        *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*     notice, this list of conditions and the following disclaimer.      *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*     notice, this list of conditions and the following disclaimer in    *)
(*     the documentation and/or other materials provided with the         *)
(*     distribution.                                                      *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*     products derived from this software without specific prior         *)
(*     written permission.                                                *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,          *)
(*  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING             *)
(*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS    *)
(*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *)
(*                                                                        *)
(**************************************************************************)

open HolKernel boolLib Parse bossLib pairLib;
open utilTheory open x86_typesTheory;

open x86_axiomatic_modelTheory;
open HolDoc;
val _ = new_theory "x86_sequential_axiomatic_model";


(* ********************** Sequential Executions********************** *)

val sequential_execution_def = Define `
  sequential_execution E so =
       linear_order so E.events /\
       (!(es :: (E.atomicity)) (e1 :: es) (e2 :: es) e.
         (e1, e) IN so /\ (e, e2) IN so ==> e IN es)`; 
    
val so_to_vo_def = Define `
  so_to_vo E so = \p. if p IN E.procs then RRESTRICT so (viewed_events E p) else {}`;

val so_to_write_serialization_def = Define `
  so_to_write_serialization so =
    {(e1, e2) | (e1, e2) IN (strict so) /\ mem_store e1 /\ mem_store e2 /\ (loc e1 = loc e2)}`;
    
val so_to_lock_serialization_def = Define `
  so_to_lock_serialization E so = 
    {(e1, e2) | (e1, e2) IN (strict so) /\ 
                ?es1 es2 :: (E.atomicity). ~(es1 = es2) /\ e1 IN es1 /\ e2 IN es2}`;

val so_to_rfmap_def = Define `
  so_to_rfmap E so =
    {(ew, er) | (ew, er) IN so /\ ew IN (writes E) /\ er IN (reads E) /\ (loc er = loc ew) /\
                (!ew' :: (writes E). ~(ew = ew') /\ (ew, ew') IN so /\ (ew', er) IN so 
                 ==> 
                 ~(loc ew = loc ew'))}`;

val so_to_exec_witness_def = Define `
  so_to_exec_witness E initial_state so =
    <| initial_state := initial_state;
       vo := so_to_vo E so; 
       write_serialization := so_to_write_serialization so; 
       lock_serialization := so_to_lock_serialization E so; 
       rfmap := so_to_rfmap E so |>`;

val valid_sequential_execution_def = Define `
  valid_sequential_execution E initial_state so =
       sequential_execution E so /\
       valid_execution E (so_to_exec_witness E initial_state so)`;

val competes_def = Define `
  competes E X = 
{(e1, e2) |   ~(e1 = e2) /\  (loc e1 = loc e2) /\ 
      ((e1 IN writes E /\ mem_store e1 /\ e2 IN reads E) \/
       (e2 IN writes E /\ mem_store e2 /\ e1 IN reads E))} 
  DIFF (sTC (happens_before E X) UNION sINV(sTC (happens_before E X)))
  `;

(* WAS:  {(e2, e1) | (e1, e2) IN (sTC (happens_before E X))})`; *)

val race_free_def = Define `
  race_free E X = !e1 e2 :: (E.events).
       ~((e1, e2) IN competes E X)`;

val restrictE_def = Define `
  restrictE E es = 
    <|procs := E.procs;
      events := E.events INTER es;
      intra_causality := RRESTRICT E.intra_causality es;
      atomicity := PER_RESTRICT E.atomicity es|>`;

val prefixes_def = Define `
  prefixes E X =  {E' | sub_event_structure E' E /\  !e1 e2. 
        e2 IN E'.events /\ (e1, e2) IN (happens_before E X) ==>
        e1 IN E'.events}`;

val sequential_race_free_def = Define `
  sequential_race_free E X = ! (E' :: (prefixes E X)) so. 
      valid_sequential_execution E' X.initial_state so  ==>
         ! e1 e2. ~((e1, e2) IN competes E' 
                    (so_to_exec_witness E' X.initial_state so))`;

(* WAS    E' IN prefixes E X /\, not :: *)


val _ = export_theory ();
