(* generated by Lem from MachineDefUtils.lem *)
open Nat_num

type 'a set = 'a Pset.set

(*========================================================================*)
(*                                                                        *)
(*                ppcmem executable model                                 *)
(*                                                                        *)
(*          Susmit Sarkar, University of Cambridge                        *)
(*          Peter Sewell, University of Cambridge                         *)
(*          Jade Alglave, Oxford University                               *)
(*          Luc Maranget, INRIA Rocquencourt                              *)
(*                                                                        *)
(*  This file is copyright 2010,2011 Institut National de Recherche en    *)
(*  Informatique et en Automatique (INRIA), and Susmit Sarkar, Peter      *)
(*  Sewell, and Jade Alglave.                                             *)
(*                                                                        *)
(*  All rights reserved.                                                  *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*========================================================================*)

(* Help emacs fontification -*-caml-*- *)

(*: \section{Utility Definitions} :*)

(* type unit = | Unit *)

(*: \subsection{Option types} :*)
(*
type 'a option = 
  | Some of 'a
  | None
*)

let set_option_map f xs =
  let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x x2 -> if (match f x with Some( _) ->
true | None -> false ) then Pset.add (match f x with Some( y) -> y ) x2 else x2) xs x2

let rec opt_map (f:'a -> 'b option) (al : 'a list) : 'b list =
  (match al with
  | [] -> []
  | a :: al' ->
      let fal' = opt_map f al' in
      (match f a with
      | Some( a') -> a' :: fal'
      | None -> fal'
      )
  )

(*: Map-like functions and Sets :*)
let funupd f x y = fun x' -> if x'=x then y else f x'

let set_filter f xs =
  Pset.fold
    (fun x k ->
      if f x then Pset.add x k else k)
    xs (Pset.from_list Pervasives.compare [])

(*: \subsection{Relations} :*)
let domain r = let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun p x2 -> if true then Pset.add (fst p) x2 else x2) r x2
let range  r = let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun p x2 -> if true then Pset.add (snd p) x2 else x2) r x2

let maximal_elements xs r =
    let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x x2 -> if (Pset.for_all (fun x' -> if Pset.mem  (x, x')  r then (x = x') else true) xs) then Pset.add x x2 else x2) xs x2

let minimal_elements xs r =
    let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x x2 -> if (Pset.for_all (fun x' -> if Pset.mem  (x', x)  r then (x = x') else true) xs) then Pset.add x x2 else x2) xs x2


let rec tc r =
  let d = domain r in
  let one_step =
    let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x x2 -> Pset.fold (fun z x2 -> if
        Pset.exists (fun y -> Pset.mem  (x,y)  r && Pset.mem  (y,z)  r) d then Pset.add(x,z) x2 else x2) d x2) d x2 in
  if Pset.subset  one_step  r then r else
  tc ( Pset.union one_step  r)

let rec fix (f : 'a set -> 'a set) (x : 'a set) : 'a set =
   let fx = f x in
   if Pset.subset  fx  x then x
   else fix f ( Pset.union fx  x)

let immediate_predecessors r x =
  let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x' x2 -> if Pset.mem  (x',x)  r then Pset.add x' x2 else x2) (domain r) x2

let down_closure r x =
  fix (fun xs -> 
    let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x' x2 -> if 
    Pset.exists (fun x -> Pset.mem  x'  (immediate_predecessors r x)) xs then Pset.add x' x2 else x2) (domain r) x2)
    (Pset.from_list Pervasives.compare [x])

let is_reflexive r =
  let dr = Pset.union  (domain r)  (range r) in
  Pset.for_all (fun x -> Pset.mem  (x,x)  r) dr

let is_irreflexive r =
  let dr = Pset.union  (domain r)  (range r) in
  Pset.for_all (fun x -> not ( Pset.mem (x,x)  r)) dr

let is_transitive r =
  let dr = Pset.union  (domain r)  (range r) in
  Pset.for_all (fun x -> Pset.for_all (fun y -> Pset.for_all (fun z ->
    if Pset.mem  (x,y)  r && Pset.mem  (y,z)  r 
    then Pset.mem  (x,z)  r
    else true) dr) dr) dr

let is_antisymmetric r =
  let dr = Pset.union  (domain r)  (range r) in
  Pset.for_all (fun x -> Pset.for_all (fun y ->
    if Pset.mem  (x,y)  r && Pset.mem  (y,x)  r
    then x = y
    else true) dr) dr

let is_strict_order r =
  is_transitive r &&
  is_irreflexive r

let is_order r = 
  is_transitive r &&
  (is_antisymmetric r &&
  is_reflexive r)

let is_linear_order r =
  let dr = Pset.union  (domain r)  (range r) in
  (is_order r) && 
  (Pset.for_all (fun x -> Pset.for_all (fun y -> ( Pset.mem (x,y)  r || Pset.mem  (y,x)  r)) dr) dr)

let is_strict_linear_order r =
  let dr = Pset.union  (domain r)  (range r) in
  (is_strict_order r) && 
  (Pset.for_all (fun x -> Pset.for_all (fun y -> ((x = y) || (Pset.mem  (x,y)  r || Pset.mem  (y,x)  r))) dr) dr)

let restrict r xs =
  set_filter (fun (x,y) -> Pset.mem  x  xs && Pset.mem  y  xs) r

let acyclic r =
  let tcr = tc r in
  is_irreflexive tcr

(*: \subsection{Lists as FIFO's} :*)
let add_event l e =
      List.append l [e]

let add_events l es =
      List.append l es

let rec pos_in' l e acc =
       (match l with
       | [] -> None
       | e1::l' -> if e = e1 then Some( acc) else pos_in' l' e (acc+1)
       )

let pos_in l e =
       pos_in' l e 0


let ordered_before_in l e1 e2 =
       (match (pos_in l e1,pos_in l e2) with
       | (Some( n1),Some( n2)) -> n1 < n2
       | _ -> false
       )

(*: \subsection{Comparisons} :*)
type comparison = 
  | Equal
  | Less
  | Greater

let compare_num n1 n2 = 
 if n1 < n2 then Less 
 else if n1 > n2 then Greater
 else Equal

let compare_string (s1 : string) (s2 : string) = 
  (* Warning: not an order, only good for equality testing *)
 if s1 = s2 then Equal else Less

let lexicographic_compare (f : 'a -> 'a -> comparison) (g : 'b -> 'b -> comparison) (x : 'a) (y : 'a) (z : 'b) (w : 'b) : comparison = 
  let c = f x y in
  (match c with
  | Equal -> g z w
  | _ -> c
  )

