(* generated by Lem from MachineDefThreadSubsystem.lem *)
open Nat_num

type 'a set = 'a Pset.set

(*========================================================================*)
(*                                                                        *)
(*                ppcmem executable model                                 *)
(*                                                                        *)
(*          Susmit Sarkar, University of Cambridge                        *)
(*          Peter Sewell, University of Cambridge                         *)
(*          Jade Alglave, Oxford University                               *)
(*          Luc Maranget, INRIA Rocquencourt                              *)
(*                                                                        *)
(*  This file is copyright 2010,2011 Institut National de Recherche en    *)
(*  Informatique et en Automatique (INRIA), and Susmit Sarkar, Peter      *)
(*  Sewell, and Jade Alglave.                                             *)
(*                                                                        *)
(*  All rights reserved.                                                  *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*                                                                        *)
(*========================================================================*)

(* emacs fontification -*-caml-*- *)


(*: \section{Thread Transitions} :*) 

open MachineDefUtils
open MachineDefFreshIds
open MachineDefValue
open MachineDefTypes
open MachineDefInstructionSemantics

(*: \subsection{Auxiliary Definitions} :*) 

let equal_instruction_instance i1 i2 =
  i1.ioid = i2.ioid

let initial_thread_state tid irv iws =
  { thread = tid;
  initial_register_state = irv;
  in_flight_instructions = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [];
  committed_instructions = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [];
  unacknowledged_syncs = Pset.from_list Pervasives.compare []
}

let all_instruction_instances c = Pset.union  c.in_flight_instructions  c.committed_instructions

let program_order_prefix t i =
  let all_instruction_instances = all_instruction_instances t in
  fix (fun x -> let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i' x2 -> if
    Pset.exists (fun i ->
      (match (i.prev) with
      | Some( (ip,r)) -> (ip = i'.ioid)
      | _ -> false
      )) 
    x then Pset.add i' x2 else x2) all_instruction_instances x2)
    (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])

let strict_program_order_prefix t i = Pset.diff 
  (program_order_prefix t i)  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])

let program_order_suffix t i =
  let all_instruction_instances = all_instruction_instances t in
  fix (fun x -> let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i' x2 -> if
    Pset.exists (fun i->
      (match i'.prev with
      | Some( (ip,r)) -> (ip = i.ioid)
      | _ -> false
      ))
    x then Pset.add i' x2 else x2) all_instruction_instances x2)
    (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])
    
let strict_program_order_suffix t i = Pset.diff 
  (program_order_suffix t i)  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])

let dependent_suffix (m:thread_params) (t:thread_state) (i:instruction_instance) : instruction_instance set =
  let all_instruction_instances = all_instruction_instances t in
  fix (fun x -> let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i' x2 -> if
    Pset.exists (fun i ->
      (Pset.exists (fun r ->
       ( Pset.mem i'  (program_order_suffix t i)) && (( Pset.mem r  i'.regs_in) &&
       (not (Pset.exists (fun i'' ->
                              ( Pset.mem r  i''.regs_out)) ( Pset.inter (strict_program_order_suffix t i)  (strict_program_order_prefix t i')))))) i.regs_out) ||
      ((match m.thread_restart_forwarded with
      | Restart_forwarded_reads -> (Pset.exists (fun w -> write_possibly_done_by t.thread i.behaviour w) i'.writes_read_from)
      | Dont_restart_forwarded_reads -> false
      ))) x then Pset.add i' x2 else x2) all_instruction_instances x2)
    (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])

let strict_dependent_suffix m t i = Pset.diff 
  (dependent_suffix m t i)  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i])
    
let starting_inst_instance new_ioid inst loc prev_inst ist =
       let (isem,ist') = sem_of_instruction inst ist in
       let r_in = regs_in_of_sem isem in
       let r_out = regs_out_of_sem isem in
       ({ioid = new_ioid;
         behaviour = isem;
         regs_in = r_in;
         regs_out = r_out;
(*          is_memory_read = will_mem_read isem (\*|| will_mem_load_reserve isem *\); *)
(*          is_memory_write = will_mem_write isem (\* || will_mem_store_conditional isem *\); *)
         is_load = will_mem_read isem (*|| will_mem_load_reserve isem *);
         is_store = will_mem_write isem (* || will_mem_store_conditional isem *);
         is_load_reserve = will_mem_read_reserve isem;
         is_store_conditional = will_mem_write_conditional isem;
         is_load_acquire = will_mem_read_acquire isem;
         is_store_release = will_mem_write_release isem;
         is_branch = will_branch isem;
         is_isync = will_isync isem;
         is_sync = will_sync isem ;
         is_lwsync = will_lwsync isem;
         is_eieio = will_eieio isem;
         read_responses = Pset.from_list Pervasives.compare [];
         writes_read_from = Pset.from_list Pervasives.compare [];
         program_loc = loc;
         instruction = inst;
         prev = prev_inst;
       },ist')

let abort_subtree t i =
       let all_is = program_order_suffix t i in
       { t with in_flight_instructions = Pset.diff  t.in_flight_instructions  all_is }

let abort_subtrees t is =
       let all_is = let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i x2 -> Pset.fold (fun i' x2 -> if true then Pset.add i' x2 else x2) (program_order_suffix t i) x2) is x2 in
       { t with in_flight_instructions = Pset.diff  t.in_flight_instructions  all_is }
     
let restart_dependent_subtree m t i ist =
       let all_is = dependent_suffix m t i in
       let (new_is,ist') = 
	 Pset.fold
	   (fun i (isk,istk) ->
	     let (isnew,istk') = 
	       starting_inst_instance i.ioid i.instruction i.program_loc i.prev istk in
	     (Pset.add isnew isk,istk'))
	   all_is (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [],ist) in
       ({ t with in_flight_instructions = Pset.union  ( Pset.diff t.in_flight_instructions  all_is)  new_is },
	 ist')


let restart_dependent_subtrees m t is ist =
       let all_is = let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i x2 -> Pset.fold (fun i' x2 -> if true then Pset.add i' x2 else x2) (dependent_suffix m t i) x2) is x2 in
       let (new_is,ist') = 
	 Pset.fold
	   (fun i (isk,istk) ->
	     let (isnew,istk') = 
	       starting_inst_instance i.ioid i.instruction i.program_loc i.prev istk in
	     (Pset.add isnew isk,istk'))
	   all_is (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [],ist) in
       ({ t with in_flight_instructions = Pset.union  ( Pset.diff t.in_flight_instructions  all_is)  new_is },ist')

let is_memory_access_instruction i = 
  i.is_load || (i.is_store ||
  (i.is_load_reserve || (i.is_store_conditional ||
  (i.is_load_acquire || i.is_store_release))))

let is_memory_barrier i =
  i.is_sync || (i.is_lwsync || i.is_eieio)

let previous_writes_for_write_conditional t i wc = 
   let po_preds = strict_program_order_prefix t i in
   let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun il x2 -> Pset.fold (fun w x2 -> if 
           il.is_load_reserve && 
           (not (Pset.exists (fun iother -> 
                    (iother.is_load_reserve || iother.is_store_conditional) && Pset.mem 
                    iother  (strict_program_order_suffix t il)) po_preds)) then Pset.add w x2 else x2) il.writes_read_from x2) po_preds x2 
   

(* TODO: uncomment Fetch rule *)
(*: \subsection{Thread Transition Preconditions and Actions} :*) 

(*: \subsubsection{Fetch instruction} :*) 

let fetch_cand program t iprevopt a inst =
  (match iprevopt with
  | Some( iprev) ->
       let next_fetch_addresses = 
         let addr_next = succeeding_instruction_address iprev.program_loc in
          (match next_fetch_addr iprev.behaviour with
          | Next -> Pset.from_list Pervasives.compare [addr_next]
          | Jump_to( c) -> Pset.from_list Pervasives.compare [Rigid( c)]
          | Cond_branch_to( v, c) -> Pset.from_list Pervasives.compare [addr_next; Rigid( c)] 
          ) in
       ( Pset.mem iprev (Pset.union   t.committed_instructions  t.in_flight_instructions)) &&
       (( Pset.mem a  next_fetch_addresses) &&
       (program a = Some( inst)))
  | None ->
       (a = initial_instruction_address t) &&
       (program a = Some( inst))
   )

let fetched_instruction_instance next_ioid iprevopt inst a ist =
       let prev =		 
         (match iprevopt with
         | Some( iprev) -> 
             let prev_reaches_by		=
               (match next_fetch_addr iprev.behaviour with
               | Next -> Always
               | Jump_to( c) -> Always
               | Cond_branch_to( v, c) -> if a = (Rigid( c)) then (IfNonZero( v)) else (IfZero( v))
               )
             in Some( (iprev.ioid,prev_reaches_by))
          | None -> None
          ) 
       in
       starting_inst_instance next_ioid inst a prev ist 

let fetch_action t i ist' = 
       ({ t with in_flight_instructions = Pset.union 
          t.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]) },ist')

(*: \subsubsection{Commit in-flight instruction} :*) 

let commit_cand_loose t i =
       ( Pset.mem i  t.in_flight_instructions) &&
       (* commitPend *)
       ((not (can_transition i.behaviour)) &&
       (* commitDataflow *)
       ((Pset.for_all (fun r ->
         Pset.for_all (fun ideps -> 
           if Pset.mem  r  ideps.regs_out && 
              (not (Pset.exists (fun ideps' ->
                          ( Pset.mem r  ideps'.regs_out)) ( Pset.inter (strict_program_order_suffix t ideps)  (strict_program_order_prefix t i)))) 
           then Pset.mem  ideps  t.committed_instructions else true) (strict_program_order_prefix t i)) i.regs_in) &&
       (* commitControlflow *)
       ((Pset.for_all (fun iprev -> 
	  if iprev.is_branch
	  then Pset.mem  iprev  t.committed_instructions
	  else true) (strict_program_order_prefix t i)) &&
       (* commitPrevMightSameAddress *)
       ((if is_memory_access_instruction i then
	 let i_addresses = Pset.union  
	   (let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun w x2 -> if true then Pset.add w.w_addr x2 else x2) i.writes_read_from x2)  ( Pset.union (mem_all_read_addresses i.behaviour)  (mem_all_write_addresses i.behaviour)) in
         Pset.for_all (fun iprev -> 
           if (is_memory_access_instruction iprev) &&
             (Pset.exists (fun a -> possibly_reads_from_address iprev.behaviour a || (possibly_writes_to_address iprev.behaviour a || (Pset.exists (fun w -> w.w_addr = a) iprev.writes_read_from))) i_addresses)
           then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
       else true) &&
       (* commitPrevMightSameAddressII *)
       (* Any previous memory instruction has dependency-to-address committed (will not change) *)
       ((if is_memory_access_instruction i then
         Pset.for_all (fun iprev ->
           if (is_memory_access_instruction iprev) 
           then Pset.for_all (fun r ->
                  Pset.for_all (fun ideps -> 
                    if Pset.mem  r  ideps.regs_out && 
                      (not (Pset.exists (fun ideps' ->
                              ( Pset.mem r  ideps'.regs_out)) ( Pset.inter (strict_program_order_suffix t ideps)  (strict_program_order_prefix t iprev)))) 
                    then Pset.mem  ideps  t.committed_instructions else true) (strict_program_order_prefix t iprev)) (regs_feeding_addresses (fst (sem_of_instruction iprev.instruction initial_id_state)))                        
           else true) (strict_program_order_prefix t i)
        else true) &&
       (* commitPrevBarrLS *)
       ((if is_memory_access_instruction i then
          (Pset.for_all (fun iprev -> 
             if (iprev.is_sync || (iprev.is_lwsync || iprev.is_isync))
             then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) &&
          (Pset.is_empty t.unacknowledged_syncs) else true) &&
       (* commitPrevBarrSEIEIO *)
       ((if i.is_store || (i.is_store_conditional || i.is_store_release) then
          (Pset.for_all (fun iprev -> 
             if (iprev.is_eieio)
             then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) else true) &&
       (* commitPrevBarrB *)
       ((if is_memory_barrier i || i.is_isync then
          (Pset.for_all (fun iprev -> 
             if (is_memory_barrier iprev || iprev.is_isync)
             then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) &&
          (Pset.is_empty t.unacknowledged_syncs) else true) &&
       (* commitMemoryAccessBeforeBarrier *)
       ((if i.is_sync || i.is_lwsync
       then 
         Pset.for_all (fun iprev ->
           if is_memory_access_instruction iprev
           then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
       else true) &&
       (* commitMemoryAccessBeforeBarrierEIEIO *)
       ((if i.is_eieio
       then 
         Pset.for_all (fun iprev ->
           if iprev.is_store || (iprev.is_store_conditional || iprev.is_store_release)
           then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
       else true) &&
       (* commitAddressesBeforeIsyncDetermined *)
       ((if i.is_isync
       then 
	 Pset.for_all (fun iprev ->
	   known_memory_addresses i.behaviour) (strict_program_order_prefix t i)
       else true) &&
       (* commitPrevLoadAcquire *)
       ((if i.is_store || (i.is_store_conditional || i.is_store_release)
       then 
	 Pset.for_all (fun iprev ->
	   if iprev.is_load_acquire 
	   then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
       else true) &&
       (* commitStoreRelease *)
       ((if i.is_store_release
       then 
	 Pset.for_all (fun iprev ->
	   if is_memory_access_instruction iprev
	   then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
       else true) &&
       (* commitLRSC *)
       (if i.is_load_reserve || i.is_store_conditional 
       then 
         Pset.for_all (fun iprev ->
           if iprev.is_load_reserve || iprev.is_store_conditional 
           then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)
           else true)))))))))))))) 


let commit_action_loose m t i wreqs breqs wcreqs wcsuccs ist =
       let irestarts = 
         (* commitWriteRestarts *)
	 if i.is_store || (i.is_store_conditional || i.is_store_release)
	 then 
	   let addrs = mem_all_write_addresses i.behaviour in
	   let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun ir x2 -> if 
	   Pset.exists (fun w' -> 
             Pset.exists (fun a -> 
             (w'.w_addr = a) && 
(* TODO: The conjunct below is somewhat opaque, and not in clear correspondence to the text.  Wouldn't it be clearer to require w' <> the_write_of_i and have an explicit "unless there is a program-order-intervening write to the same address" (the below and wite_possibly_done_by doesn't check that the other write i' is program-order-before the read). *)
           (not (Pset.exists (fun i' -> 
                   write_possibly_done_by t.thread i'.behaviour w') t.in_flight_instructions))) addrs) ir.writes_read_from then Pset.add ir x2 else x2) t.in_flight_instructions x2        
         (* commitReadRestarts *)
	 else if Pset.cardinal i.writes_read_from > 0 then
           let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun isucc x2 -> if (( Pset.mem isucc  (program_order_suffix t i)) && 
                      ((not (equal_instruction_instance isucc i)) &&
            (Pset.exists (fun w' -> Pset.exists (fun w -> 
              (((w'.w_addr = w.w_addr) && (not (w' = w) &&
                (not (Pset.exists (fun i' ->
(* TODO: again, correspondence between text (which here doesn't say "(where the read was not forwarded)" and the use of write_possibly_done_by below isn't terribly clear *)
                        write_possibly_done_by t.thread i'.behaviour w') t.in_flight_instructions)))) || 
              (Pset.exists (fun ibar ->
                 is_memory_barrier ibar && (Pset.mem  ibar  (program_order_prefix t isucc) && Pset.mem  ibar  (program_order_suffix t i))) t.in_flight_instructions))) i.writes_read_from) isucc.writes_read_from 
                     ))) then Pset.add isucc x2 else x2) t.in_flight_instructions x2
	 else Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] 
       in
       let (t',ist') = restart_dependent_subtrees m t irestarts ist in
       (* commitBranchAborts *)
       let iaborts = 
         if i.is_branch
         then
           let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i_others x2 -> if
             (match i_others.prev with 
             | Some( (iioid,r)) -> (iioid = i.ioid)  &&
             (not (possible_target i.behaviour i_others.program_loc r))
             | None -> false
             ) then Pset.add i_others x2 else x2) t'.in_flight_instructions x2
         else Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in
       let t'' = abort_subtrees t' iaborts in
       (* commitSendBarriersAndWrites - this code just calculates the resulting state; the actual sending is elsewhere*)
       let new_barriers = set_option_map ((function | Breq( b) -> if b.b_barrier_type = Sync then Some( b) else None | _ -> None )) breqs in
       (* TODO: The below is not quite right for multiple write_conditional in one instruction. Forbid that case? *)
       let wcsucc_bools =
         Pset.fold (fun m k -> 
           (match m with
           | WCresp( b) -> Pset.add b k )) wcsuccs (Pset.from_list Pervasives.compare []) in
       let i' = 
         { i with 
                behaviour =
                 Pset.fold
                   (fun succ k ->
                       mem_accept_wcond_action k succ)
                   wcsucc_bools i.behaviour } in
       ({ t'' with in_flight_instructions = Pset.diff  t''.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]);
          committed_instructions = Pset.union  t''.committed_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i']) ;
           unacknowledged_syncs = Pset.union  new_barriers  t''.unacknowledged_syncs},
	 ist')

let commit_cand_tight t i =
       ( Pset.mem i  t.in_flight_instructions) &&
       ((not (can_transition i.behaviour)) &&
       ((Pset.for_all (fun iprev -> Pset.mem  
          iprev  t.committed_instructions) (strict_program_order_prefix t i)) &&
       (Pset.is_empty t.unacknowledged_syncs)))

let commit_action_tight m t i wreqs breqs wcreqs wcsuccs ist =
       let irestarts = 
	 if i.is_store || (i.is_store_conditional || i.is_store_release)
	 then 
	   let addrs = mem_all_write_addresses i.behaviour in
	   let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun ir x2 -> if 
	   Pset.exists (fun w' -> 
             Pset.exists (fun a -> 
             (w'.w_addr = a) && 
           (not (Pset.exists (fun i' -> 
                   write_possibly_done_by t.thread i'.behaviour w') t.in_flight_instructions))) addrs) ir.writes_read_from then Pset.add ir x2 else x2) t.in_flight_instructions x2        
	 else if Pset.cardinal i.writes_read_from > 0 then
           let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun isucc x2 -> if (Pset.exists (fun w' -> Pset.exists (fun w -> 
              (((w'.w_addr = w.w_addr) && (not (w' = w) &&
                (not (Pset.exists (fun i' ->
                        write_possibly_done_by t.thread i'.behaviour w') t.in_flight_instructions)))) || 
              (Pset.exists (fun ibar ->
                 ibar.is_lwsync && (Pset.mem  ibar  (strict_program_order_prefix t isucc) && Pset.mem  ibar  (strict_program_order_suffix t i))) t.in_flight_instructions)) && 
            ( Pset.mem isucc  (strict_program_order_suffix t i))) i.writes_read_from) isucc.writes_read_from) then Pset.add isucc x2 else x2) t.in_flight_instructions x2
	 else Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] 
       in
       let (t',ist') = restart_dependent_subtrees m t irestarts ist in
       let iaborts = 
         if i.is_branch 
         then
           let x2 = Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in Pset.fold (fun i_others x2 -> if
             (match i_others.prev with 
             | Some( (iioid,r)) -> (iioid = i.ioid)  &&
             (not (possible_target i.behaviour i_others.program_loc r))
             | None -> false
             ) then Pset.add i_others x2 else x2) t'.in_flight_instructions x2
         else Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [] in
       let t'' = abort_subtrees t' iaborts in
       let new_barriers = set_option_map ((function | Breq( b) -> if b.b_barrier_type = Sync then Some( b) else None | _ -> None )) breqs in
       (* TODO: The below is not quite right for multiple write_conditional in one instruction. Forbid that case? *)
       let wcsucc_bools =
         Pset.fold (fun m k -> 
           (match m with
           | WCresp( b) -> Pset.add b k )) wcsuccs (Pset.from_list Pervasives.compare []) in
       let i' = 
         { i with 
                behaviour =
                 Pset.fold
                   (fun succ k ->
                       mem_accept_wcond_action k succ)
                   wcsucc_bools i.behaviour } in
       ({ t'' with in_flight_instructions = Pset.diff  t''.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]);
          committed_instructions = Pset.union  t''.committed_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i']) ;
          unacknowledged_syncs = Pset.union  new_barriers  t''.unacknowledged_syncs},
	 ist')

let commit_cand m t i =
  (match m.thread_loose_tight with
  | Thread_loose -> commit_cand_loose t i
  | Thread_tight -> commit_cand_tight t i
  )

let commit_label_of i wreqs breqs wcreqs wcsuccs  =
  if Pset.cardinal wreqs > 0 then T_Commit_write( i, let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x1 x2 -> (match x1 with Wreq( w) -> if true then Pset.add w x2 else x2 | _ -> x2)) wreqs x2)
  else if Pset.cardinal breqs > 0 then T_Commit_barrier( i, let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x1 x2 -> (match x1 with Breq( b) -> if true then Pset.add b x2 else x2 | _ -> x2)) breqs x2)
  else if Pset.cardinal i.writes_read_from > 0 then T_Commit_read( i, i.read_responses)
(* SS: Hacky. Make it clearer elsewhere that there is only one write-cond per instruction *)
  else if Pset.cardinal wcreqs > 0 then T_Commit_write_conditional( i, 
            (Pset.choose (let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x1 x2 -> (match x1 with WCreq( w) -> if true then Pset.add w x2 else x2 | _ -> x2)) wcreqs x2)), 
            (Pset.choose (let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun x1 x2 -> (match x1 with WCresp( b) -> if true then Pset.add b x2 else x2 | _ -> x2)) wcsuccs x2)))
  else T_Commit_reg_or_branch( i)

let commit_action m t i wreqs breqs wcreqs wcsuccs ist =
  (match m.thread_loose_tight with
  | Thread_loose -> commit_action_loose m t i wreqs breqs wcreqs wcsuccs ist
  | Thread_tight -> commit_action_tight m t i wreqs breqs wcreqs wcsuccs ist
  )

(*: \subsection{Accept sync barrier acknowledgement} :*) 

let accept_sync_barrier_ack_cand t br = true

let accept_sync_barrier_ack_action m t br ist =
  let b = Pset.choose (let x2 = Pset.from_list Pervasives.compare [] in Pset.fold (fun b x2 -> if (b.b_eiid = br.br_eiid) then Pset.add b x2 else x2) t.unacknowledged_syncs x2) in
  ({ t with unacknowledged_syncs = Pset.diff  t.unacknowledged_syncs  (Pset.from_list Pervasives.compare [b]) },ist)

(*: \subsection{Satisfy memory read from write received from storage subsystem} :*) 

let memory_read_storage_cand m t i a = 
  ( Pset.mem i  t.in_flight_instructions) &&
  ((mem_read_cand i.behaviour) &&
  ((is_determined (mem_loc_to_read i.behaviour)) &&
  ((a = mem_loc_to_read i.behaviour) &&
  ((Pset.for_all (fun iprev -> 
    if iprev.is_sync || (iprev.is_isync || ((match m.thread_lwsync with Lwsync_read_block -> iprev.is_lwsync | Lwsync_read_restart -> false )))
    then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) &&
  (Pset.is_empty t.unacknowledged_syncs)))))

(*: \subsection{Satisfy memory read reserve from write received from storage subsystem} :*) 

let memory_read_reserve_storage_cand m t i a = 
  ( Pset.mem i  t.in_flight_instructions) &&
  ((mem_read_reserve_cand i.behaviour) &&
  ((is_determined (mem_loc_to_read i.behaviour)) &&
  ((a = mem_loc_to_read i.behaviour) &&
  ((Pset.for_all (fun iprev -> 
    if iprev.is_sync || (iprev.is_isync || ((match m.thread_lwsync with Lwsync_read_block -> iprev.is_lwsync | Lwsync_read_restart -> false ))) (* || iprev.is_load_reserve || iprev.is_store_conditional *)
    then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) &&
  (Pset.is_empty t.unacknowledged_syncs)))))

(*: \subsubsection{Memory read action} :*) 

let memory_read_action t i r w =
       let isem = i.behaviour in
       let isem' = mem_read_action isem w.w_value in
       let i' = { i with behaviour = isem'; read_responses = Pset.union  i.read_responses  (Pset.from_list Pervasives.compare [{ rr_thread = r.r_thread; rr_ioid = r.r_ioid; rr_eiid = r.r_eiid; rr_write = w }]); writes_read_from = Pset.union  i.writes_read_from  (Pset.from_list Pervasives.compare [w]) } in
       let t' = { t with in_flight_instructions = Pset.diff  ( Pset.union t.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i']))  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]) } in
       t'

(*: \subsection{Satisfy memory read by forwarding in-flight write directly to reading instruction} :*) 

let memory_read_forward_cand m t i w iprev =
  ( Pset.mem i  t.in_flight_instructions) &&
  ((mem_read_cand i.behaviour) &&  (* note that that does not cover mem_read_reserve_cand *)
  ((is_determined (mem_loc_to_read i.behaviour)) &&
  ((w.w_addr = (mem_loc_to_read i.behaviour)) &&
  ((is_determined w.w_value) &&
  (( Pset.mem iprev  (strict_program_order_prefix t i)) &&
  (( Pset.mem iprev  t.in_flight_instructions) &&
  ((write_possibly_done_by t.thread iprev.behaviour w) &&
  ((not iprev.is_store_conditional) &&
  ((not iprev.is_store_release) &&
  ((Pset.for_all (fun iprev' ->
   if possibly_writes_to_address iprev'.behaviour (mem_loc_to_read i.behaviour)
   then (equal_instruction_instance iprev iprev') || Pset.mem  iprev'  (program_order_prefix t iprev) 
   else true) (strict_program_order_prefix t i)) &&
  ((Pset.for_all (fun iprev -> 
   if iprev.is_sync || iprev.is_isync
   then Pset.mem  iprev  t.committed_instructions else true) (strict_program_order_prefix t i)) &&
  (Pset.is_empty t.unacknowledged_syncs))))))))))))



(*: \subsection{Register read from previous register write} :*) 

let register_read_prev_cand t i r iread =
       ( Pset.mem i  t.in_flight_instructions) &&
       ((reg_read_cand i.behaviour) &&
       ((r = reg_to_read i.behaviour) &&
       (( Pset.mem iread  (strict_program_order_prefix t i)) &&
       (( Pset.mem r  iread.regs_out) &&
       ((is_determined (val_written_to_register iread.behaviour r)) &&
       (Pset.for_all (fun iprev' ->
         if Pset.mem  r  iprev'.regs_out 
         then (equal_instruction_instance iread iprev') || Pset.mem  iprev'  (program_order_prefix t iread) 
         else true) (strict_program_order_prefix t i)))))))

let register_read_action t i w =
       let isem = i.behaviour in
       let isem' = reg_read_action isem w in
       let i' = { i with behaviour = isem' } in
       { t with in_flight_instructions = Pset.diff  ( Pset.union t.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i']))  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]) }

(*: \subsection{Register read from initial register state} :*) 

let initial_register_read_cand t i r =
       ( Pset.mem i  t.in_flight_instructions) &&
       ((reg_read_cand i.behaviour) &&
       ((r = reg_to_read i.behaviour) &&
       (Pset.for_all (fun iprev ->
         not ( Pset.mem r  iprev.regs_out)) (strict_program_order_prefix t i))))

(*: \subsection{Partially evaluate an instruction} :*) 

let partial_evaluate_cand t i =
       let isem = i.behaviour in
       ( Pset.mem i  t.in_flight_instructions) &&
       (internal_transition_cand isem) 
   
let partial_evaluate_action t i =
       let isem = i.behaviour in
       let isem' = internal_transition_action isem in
       let i' = { i with behaviour = isem' } in
       { t with in_flight_instructions = Pset.diff 
                    ( Pset.union t.in_flight_instructions  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i']))  (Pset.from_list (fun i1 i2 -> Pervasives.compare i1.ioid i2.ioid) [i]) }

(*: \subsection{Restart in-flight instruction} :*) 

let restart_cand t i = 
       ( Pset.mem i  t.in_flight_instructions)

let restart_action t i =
       restart_dependent_subtree t i

(*: \subsection{Abort in-flight instruction} :*) 

let abort_cand t i =
       ( Pset.mem i  t.in_flight_instructions) &&
       (Pset.for_all (fun i' -> not ( Pset.mem i  t.committed_instructions)) (program_order_suffix t i))

let abort_action t i =
       abort_subtree t i


(*: \subsubsection{The Collected Core Transitions} :*) 

(*indreln
(*: \textbf{Fetch instruction} :*)
forall m program t ist ist' ioid a iprevopt inst i.
    ((ioid,ist') = gen_ioid ist) &&
    (fetch_cand program t iprevopt a inst) &&
    ((i,ist') = fetched_instruction_instance ioid iprevopt inst a ist)
    ==>
    thread_trans m program (t,ist) {} {} (T_Fetch i) (fetch_action t i ist')
and
(*: \textbf{Commit in-flight instruction} :*)
forall m program t i wreqs breqs wcreqs sswcsuccs wcsuccs ist.
    (commit_cand m t i) &&
    (wreqs = Set.fold (fun w k -> Set.add (Wreq w) k) (mem_writes_of t.thread i.ioid i.behaviour) {}) &&
    (breqs = Set.fold (fun b k -> Set.add (Breq b) k) (barriers_of t.thread i.ioid i.behaviour) {}) &&
    (let (wcrs,imm_fail) = 
        Set.fold 
         (fun wcr (k,imm_fail) -> 
             let wprev_set = previous_writes_for_write_conditional t i wcr in
             if (Set.cardinal wprev_set = 1) then 
               ((Set.add (WCreq (<|wc_w=wcr;wc_wprev=Some (Set.choose wprev_set)|>)) k),imm_fail)
             else (k,true))
         (mem_write_conditionals_of t.thread i.ioid i.behaviour) ({},false)
      in 
      if imm_fail then wcreqs = {} && wcsuccs = {(WCresp false)}
      else wcreqs = wcrs && wcsuccs = sswcsuccs) 
    ==>
    thread_trans m program (t,ist) (wreqs union breqs union wcreqs) sswcsuccs (commit_label_of i wreqs breqs wcreqs wcsuccs) (commit_action m t i wreqs breqs wcreqs wcsuccs ist)
and
(*: \textbf{Accept sync barrier acknowledgement} :*)
forall m program t br ist.
       (accept_sync_barrier_ack_cand t br)
       ==>
       thread_trans m program (t,ist) {} {Back br} (T_Accept_sync_ack br) (accept_sync_barrier_ack_action m t br ist)
and
(*: \textbf{Satisfy memory read from writes received from storage subsystem} :*)
forall m program t i r rr ist.
       ((r = read_request_of t.thread i.ioid i.behaviour) &&
       (memory_read_storage_cand m t i r.r_addr))
        ==>
        thread_trans m program (t,ist) {Rreq r} {Rresp rr} (T_Satisfy_read_from_storage i r rr.rr_write) (memory_read_action t i r rr.rr_write,ist)
and
(*: \textbf{Satisfy memory read by forwarding in-flight write directly to reading instruction} :*)
forall m program t i w iprev ist.
        (memory_read_forward_cand m t i w iprev)
        ==>
        thread_trans m program (t,ist) {} {} (T_Satisfy_read_from_forwarded_write i w iprev) (memory_read_action t i (read_request_of t.thread i.ioid i.behaviour) w,ist)
and
(*: \textbf{Satisfy memory read reserve from writes received from storage subsystem} :*)
forall m program t i r rr ist.
       ((r = read_reserve_request_of t.thread i.ioid i.behaviour) &&
       (memory_read_reserve_storage_cand m t i r.r_addr))
        ==>
        thread_trans m program (t,ist) {Rreq r} {Rresp rr} (T_Satisfy_read_from_storage (*T_Satisfy_read_reserve*) i r rr.rr_write) (memory_read_action t i r rr.rr_write,ist)
and
(*: \textbf{Register read from previous register write} :*)
forall m program t i r iprev v ist.
       (register_read_prev_cand t i r iprev) &&
       (v = val_written_to_register iprev.behaviour r)
       ==>
       thread_trans m program (t,ist) {} {} (T_Register_read_from_previous_write i r v iprev) (register_read_action t i v,ist)
and
(*: \textbf{Register read from initial state} :*)
forall m program t i r v ist.
       (initial_register_read_cand t i r) &&
       (v = t.initial_register_state r)
       ==>
       thread_trans m program (t,ist) {} {} (T_Register_read_from_initial i r v) (register_read_action t i v,ist)
and
(*: \textbf{Partially evaluate an instruction} :*)
forall m program t i ist.
       (partial_evaluate_cand t i)
       ==>
       thread_trans m program (t,ist) {} {} (T_Partial_evaluate i) (partial_evaluate_action t i,ist)
and
(*: \textbf{Restart in-flight instruction} :*)
forall m program t i ist.
       (restart_cand t i)
       ==>
       thread_trans m program (t,ist) {} {} (T_Restart i) (restart_action m t i ist)
and
(*: \textbf{Abort in-flight instruction} :*)
forall m program t i ist.
       (abort_cand t i)
       ==>
       thread_trans m program (t,ist) {} {} (T_Abort i) (abort_action t i,ist)*)
