(** tpat_any
 * DOC   Dependence upon top-level values (int)
 * FAM   pat
 * GROUP tpat_any1 tpat_any2 tpat_any3
 *)

(** tpat_any1
 * DOC A top-level value
 * RET
 *)
let _ = 13

(** tpat_any2
 * DOC A different top-level value
 * RET
 *)
let _ = 42

(** tpat_any3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_any1.cmo tpat_any2.cmo
 *)
print_string (string_of_bool (Tpat_any1.myname <> Tpat_any2.myname))





(** pat_any
 * DOC   Dependence upon sub-level values (int)
 * FAM   pat
 * GROUP pat_any1 pat_any2 pat_any3
 *)

(** pat_any1
 * DOC A sub-level value
 * RET
 *)
let _ = let _ = 13 in ()

(** pat_any2
 * DOC A different sub-level value
 * RET
 *)
let _ = let _ = 42 in ()

(** pat_any3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS pat_any1.cmo pat_any2.cmo
 *)
print_string (string_of_bool (Pat_any1.myname <> Pat_any2.myname))





(** tpat_var
 * DOC   Dependence upon top-level variable names
 * FAM   pat
 * GROUP tpat_var1 tpat_var2 tpat_var3
 *)

(** tpat_var1
 * DOC A top-level variable definition
 * RET
 *)
let x = 42

(** tpat_var2
 * DOC A top-level variable with same definition but different name
 * RET
 *)
let y = 42

(** tpat_var3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_var1.cmo tpat_var2.cmo
 *)
print_string (string_of_bool (Tpat_var1.myname <> Tpat_var2.myname))





(** pat_var
 * DOC   Independence upon sub-level variable names
 * FAM   pat
 * GROUP pat_var1 pat_var2 pat_var3
 *)

(** pat_var1
 * DOC A sub-level variable definition
 * RET
 *)
let _ = let x = 42 in ()

(** pat_var2
 * DOC A sub-level variable with same definition but different name
 * RET
 *)
let _ = let y = 42 in ()

(** pat_var3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_var1.cmo pat_var2.cmo
 *)
print_string (string_of_bool (Pat_var1.myname = Pat_var2.myname))





(** tpat_alias
 * DOC   Dependence upon names of top-level variable aliases
 * FAM   pat
 * GROUP tpat_alias1 tpat_alias2 tpat_alias3
 *)

(** tpat_alias1
 * DOC A top-level variable with an alias
 * RET
 *)
let x as y = 42

(** tpat_alias2
 * DOC Same, but with a different alias
 * RET
 *)
let x as z = 42

(** tpat_alias3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_alias1.cmo tpat_alias2.cmo
 *)
print_string (string_of_bool (Tpat_alias1.myname <> Tpat_alias2.myname))





(** pat_alias
 * DOC   Independence opon names of sub-level variable aliases
 * FAM   pat
 * GROUP pat_alias1 pat_alias2 pat_alias3
 *)

(** pat_alias1
 * DOC A sub-level variable with an alias
 * RET
 *)
let _ = let x as y = 42 in ()

(** pat_alias2
 * DOC Same, but with a different alias
 * RET
 *)
let _ = let x as z = 42 in ()

(** pat_alias3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_alias1.cmo pat_alias2.cmo
 *)
print_string (string_of_bool (Pat_alias1.myname = Pat_alias2.myname))





(** tpat_constant
 * DOC   Dependence upon LHS of top-level definitions of constants
 * FAM   pat
 * GROUP tpat_constant1 tpat_constant2 tpat_constant3
 *)

(** tpat_constant1
 * DOC A top-level definition of a constant
 * RET
 *)
let (false|true) = (1 = 1)

(** tpat_constant2
 * DOC A top-level definition of a different constant
 * RET
 *)
let (true|false) = (1 = 1)

(** tpat_constant3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_constant1.cmo tpat_constant2.cmo
 *)
print_string (string_of_bool (Tpat_constant1.myname <> Tpat_constant2.myname))





(** pat_constant
 * DOC   Independence upon LHS of sub-level definitions of constants
 * FAM   pat
 * GROUP pat_constant1 pat_constant2 pat_constant3
 *)

(** pat_constant1
 * DOC A sub-level definition of a constant
 * RET
 *)
let _ = let (false|true) = (1 = 1) in ()

(** pat_constant2
 * DOC A sub-level definition of a different constant
 * RET
 *)
let _ = let (false|true) = (1 = 1) in ()

(** pat_constant3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_constant1.cmo pat_constant2.cmo
 *)
print_string (string_of_bool (Pat_constant1.myname = Pat_constant2.myname))





(** tpat_tuple
 * DOC   Dependence upon LHS of top-level definitions of tuples
 * FAM   pat
 * GROUP tpat_tuple1 tpat_tuple2 tpat_tuple3
 *)

(** tpat_tuple1
 * DOC A top-level definition of a tuple
 * RET
 *)
let (x, y) = (42, 17)

(** tpat_tuple2
 * DOC Same, but with a different LHS
 * RET
 *)
let (y, x) = (42, 17)

(** tpat_tuple3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_tuple1.cmo tpat_tuple2.cmo
 *)
print_string (string_of_bool (Tpat_tuple1.myname <> Tpat_tuple2.myname))





(** pat_tuple
 * DOC   Independence upon LHS of sub-level definitions of tuples
 * FAM   pat
 * GROUP pat_tuple1 pat_tuple2 pat_tuple3
 *)

(** pat_tuple1
 * DOC A sub-level definition of a tuple
 * RET
 *)
let _ = let (x, y) = (42, 17) in ()

(** pat_tuple2
 * DOC Same, but with a different LHS
 * RET
 *)
let _ = let (y, x) = (42, 17) in ()

(** pat_tuple3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_tuple1.cmo pat_tuple2.cmo
 *)
print_string (string_of_bool (Pat_tuple1.myname = Pat_tuple2.myname))





(** tpat_construct
 * DOC   Dependence upon LHS of top-level definitions of constructs
 * FAM   pat
 * GROUP tpat_construct1 tpat_construct2 tpat_construct3
 *)

(** tpat_construct1
 * DOC A top-level definition of a construct
 * RET
 *)
let (x, y) = (17, 42)

(** tpat_construct2
 * DOC Same, but with a different LHS
 * RET
 *)
let (x, z) = (17, 42)

(** tpat_construct3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_construct1.cmo tpat_construct2.cmo
 *)
print_string (string_of_bool (Tpat_construct1.myname <> Tpat_construct2.myname))





(** pat_construct
 * DOC   Independence upon LHS of sub-level definitions of constructs
 * FAM   pat
 * GROUP pat_construct1 pat_construct2 pat_construct3
 *)

(** pat_construct1
 * DOC A sub-level definition of a construct
 * RET
 *)
let _ = let (x, y) = (17, 42) in ()

(** pat_construct2
 * DOC Same, but with a different LHS
 * RET
 *)
let _ = let (x, z) = (17, 42) in ()

(** pat_construct3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_construct1.cmo pat_construct2.cmo
 *)
print_string (string_of_bool (Pat_construct1.myname = Pat_construct2.myname))





(** tpat_variant
 * DOC   Dependence of top-level definitions of variants
 * FAM   pat
 * GROUP tpat_variant1 tpat_variant2 tpat_variant3
 *)

(** tpat_variant1
 * DOC A top-level definition of a variant
 * RET
 *)
let `On = `On

(** tpat_variant2
 * DOC A different top-level definition of a variant
 * RET
 *)
let `Off = `Off

(** tpat_variant3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_variant1.cmo tpat_variant2.cmo
 *)
print_string (string_of_bool (Tpat_variant1.myname <> Tpat_variant2.myname))





(** pat_variant
 * DOC   Independence of sub-level definitions of variants
 * FAM   pat
 * GROUP pat_variant1 pat_variant2 pat_variant3
 *)

(** pat_variant1
 * DOC A sub-level definition of a variant
 * RET
 *)
let _ = let `On = `On in ()

(** pat_variant2
 * DOC A different sub-level definition of a variant
 * RET
 *)
let _ = let `On = `On in ()

(** pat_variant3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_variant1.cmo pat_variant2.cmo
 *)
print_string (string_of_bool (Pat_variant1.myname = Pat_variant2.myname))





(** tpat_record
 * DOC   Dependence upon top-level record definitions (values)
 * FAM   pat
 * GROUP tpat_record1 tpat_record2 tpat_record3
 *)

(** tpat_record1
 * DOC A top-level record definition
 * RET
 *)
type ratio = {num : int; denum : int}
let pi = {num = 22; denum = 7}

(** tpat_record2
 * DOC Same, but with different record values
 * RET
 *)
type ratio = {num : int; denum : int}
let pi = {num = 44; denum = 14}

(** tpat_record3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_record1.cmo tpat_record2.cmo
 *)
print_string (string_of_bool (Tpat_record1.myname <> Tpat_record2.myname))





(** pat_record
 * DOC   Dependence of sub-level record definitions (values)
 * FAM   pat
 * GROUP pat_record1 pat_record2 pat_record3
 *)

(** pat_record1
 * DOC A sub-level record definition
 * RET
 *)
type ratio = {num : int; denum : int}
let _ = let pi = {num = 22; denum = 7} in ()

(** pat_record2
 * DOC Same, but with different record values
 * RET
 *)
type ratio = {num : int; denum : int}
let _ = let pi = {num = 22; denum = 14} in ()

(** pat_record3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_record1.cmo pat_record2.cmo
 *)
print_string (string_of_bool (Pat_record1.myname <> Pat_record2.myname))





(** tpat_array
 * DOC   Dependence upon top-level array definitions (values)
 * FAM   pat
 * GROUP tpat_array1 tpat_array2 tpat_array3
 *)

(** tpat_array1
 * DOC A top-level array definition
 * RET
 *)
let fib = [| 1; 1; 2; 3; 5 |]

(** tpat_array2
 * DOC Same, but with a different definition
 * RET
 *)
let fib = [| 1; 1; 2; 3; 5; 8 |]

(** tpat_array3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_array1.cmo tpat_array2.cmo
 *)
print_string (string_of_bool (Tpat_array1.myname <> Tpat_array2.myname))





(** pat_array
 * DOC   Dependence upon sub-level array definition (values)
 * FAM   pat
 * GROUP pat_array1 pat_array2 pat_array3
 *)

(** pat_array1
 * DOC A sub-level array definition
 * RET
 *)
let _ = let fib = [| 1; 1; 2; 3; 5 |] in ()

(** pat_array2
 * DOC Same, but with a different definition
 * RET
 *)
let _ = let fib = [| 1; 1; 2; 3; 5 |] in ()

(** pat_array3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_array1.cmo pat_array2.cmo
 *)
print_string (string_of_bool (Pat_array1.myname = Pat_array2.myname))





(** tpat_or
 * DOC   Dependence upon LHS of top-level 'or' definitions
 * FAM   pat
 * GROUP tpat_or1 tpat_or2 tpat_or3
 *)

(** tpat_or1
 * DOC A top-level 'or' definition
 * RET
 *)
module M = struct
  let (x|x) = 42
end

(** tpat_or2
 * DOC Same, but with a diffenret LHS
 * RET
 *)
module N = struct
  let (y|y) = 42
end

(** tpat_or3
 * DOC  The two modules have different mynames
 * RET  true
 * OPTS tpat_or1.cmo tpat_or2.cmo
 *)
print_string (string_of_bool (Tpat_or1.myname <> Tpat_or2.myname))





(** pat_or
 * DOC   Independence upon LHS of sub-level 'or' definitions
 * FAM   pat
 * GROUP pat_or1 pat_or2 pat_or3
 *)

(** pat_or1
 * DOC A sub-level 'or' definition
 * RET
 *)
let _ = let (x|x) = 42 in ()

(** pat_or2
 * DOC Same, but with a different LHS
 * RET
 *)
let _ = let (y|y) = 42 in ()

(** pat_or3
 * DOC  The two modules have same mynames
 * RET  true
 * OPTS pat_or1.cmo pat_or2.cmo
 *)
print_string (string_of_bool (Pat_or1.myname = Pat_or2.myname))
