(** mod_name_top
 * DOC   Irrelevence of module names
 * FAM   mod
 * GROUP mod_name_top1 mod_name_top2 mod_name_top3
 *)

(** mod_name_top1
 * DOC A module
 * RET
 *)

;;

(** mod_name_top2
 * DOC Same module with a different name
 * RET
 *)

;;

(** mod_name_top3
 * DOC  The modules have the same myname
 * RET  true
 * OPTS mod_name_top1.cmo mod_name_top2.cmo
 *)

print_string (string_of_bool (Mod_name_top1.myname = Mod_name_top2.myname))


(** mod_name_sub
 * DOC   Dependence upon names of sub-modules
 * FAM   mod
 * GROUP mod_name_sub1 mod_name_sub2 mod_name_sub3
 *)

(** mod_name_sub1
 * DOC A module containing a sub-module
 * RET
 *)

module M = struct end

(** mod_name_sub2
 * DOC Another module containing a sub-module with a different name
 * RET
 *)

module N = struct end

(** mod_name_sub3
 * DOC  The modules have different mynames
 * RET  true
 * OPTS mod_name_sub1.cmo mod_name_sub2.cmo
 *)

print_string (string_of_bool (Mod_name_sub1.myname <> Mod_name_sub2.myname))


(** mod_ctx_dep
 * DOC   Dependence upon super-module if accessed
 * FAM   mod
 * GROUP mod_ctx_dep1 mod_ctx_dep2 mod_ctx_dep3
 *)

(** mod_ctx_dep1
 * DOC A sub-module accessing a value in its super-module
 * RET
 *)

module M = struct
  let x = true 
  module N = struct
    let a = x
  end
end

(** mod_ctx_dep2
 * DOC Same, except the super-module's value differs
 * RET
 *)

module M = struct
  let x = false
  module N = struct
    let a = x
  end
end

(** mod_ctx_dep3
 * DOC  The two sub-modules have different mynames
 * RET  true
 * OPTS mod_ctx_dep1.cmo mod_ctx_dep2.cmo
 *)

print_string (string_of_bool (Mod_ctx_dep1.M.myname <> Mod_ctx_dep2.M.myname))


(** mod_ctx_indep
 * DOC   Independence upon super-module if not accessed
 * FAM   mod
 * GROUP mod_ctx_indep1 mod_ctx_indep2 mod_ctx_indep3
 *)

(** mod_ctx_indep1
 * DOC A sub-module does not access a value in its super-module
 * RET
 *)

module M = struct
  let x = true 
  module N = struct end
end

(** mod_ctx_indep2
 * DOC Same, except the super-module's value differs
 * RET
 *)

module M = struct
  let x = false
  module N = struct end
end

(** mod_ctx_indep3
 * DOC  The two sub-modules have the same mynames
 * RET  true
 * OPTS mod_ctx_indep1.cmo mod_ctx_indep2.cmo
 *)

print_string (string_of_bool
  (Mod_ctx_indep1.M.N.myname = Mod_ctx_indep2.M.N.myname))
