(** marsh_all
 * DOC Trying to marshal to the same and any different type
 * FAM marsh
 * RET y+n+
 *)
let m x y =
  try
    let _ = (y = Marshal.from_string (Marshal.to_string x []) 0) in
    print_char 'y'
  with Invalid_argument _ -> print_char 'n'
(* something -> something *)
let _ = m 1 1
let _ = m 1.0 1.0
let _ = m true true
let _ = m 'a' 'a'
let _ = m "a" "a"
let _ = m (1,2) (1,2)
let _ = m {contents = 1} {contents = 1}
let _ = m [| 1; 2|] [| 1; 2|]
let _ = m (Some 1) (Some 1)
(* int -> something else *)
let _ = m 1 1.0
let _ = m 1 true
let _ = m 1 'a'
let _ = m 1 "a"
let _ = m 1 (1,2)
let _ = m 1 {contents = 1}
let _ = m 1 [| 1; 2|]
let _ = m 1 (Some 1)
(* float -> something else *)
let _ = m 1.0 1
let _ = m 1.0 true
let _ = m 1.0 'a'
let _ = m 1.0 "a"
let _ = m 1.0 (1,2)
let _ = m 1.0 {contents = 1}
let _ = m 1.0 [| 1; 2|]
let _ = m 1.0 (Some 1)
(* bool -> something else *)
let _ = m true 1
let _ = m true 1.0
let _ = m true 'a'
let _ = m true "a"
let _ = m true (1,2)
let _ = m true {contents = 1}
let _ = m true [| 1; 2|]
let _ = m true (Some 1)
(* char -> something else *)
let _ = m 'a' 1
let _ = m 'a' 1.0
let _ = m 'a' true
let _ = m 'a' "a"
let _ = m 'a' (1,2)
let _ = m 'a' {contents = 1}
let _ = m 'a' [| 1; 2|]
let _ = m 'a' (Some 1)
(* string -> something else *)
let _ = m "a" 1
let _ = m "a" 1.0
let _ = m "a" true
let _ = m "a" 'a'
let _ = m "a" (1,2)
let _ = m "a" {contents = 1}
let _ = m "a" [| 1; 2|]
let _ = m "a" (Some 1)
(* tuple -> something else *)
let _ = m (1,2) 1
let _ = m (1,2) 1.0
let _ = m (1,2) true
let _ = m (1,2) 'a'
let _ = m (1,2) "a"
let _ = m (1,2) {contents = 1}
let _ = m (1,2) [| 1; 2|]
let _ = m (1,2) (Some 1)
(* record -> something else *)
let _ = m {contents = 1} 1
let _ = m {contents = 1} 1.0
let _ = m {contents = 1} true
let _ = m {contents = 1} 'a'
let _ = m {contents = 1} "a"
let _ = m {contents = 1} (1,2)
let _ = m {contents = 1} [| 1; 2|]
let _ = m {contents = 1} (Some 1)
(* array -> something else *)
let _ = m [| 1; 2|] 1
let _ = m [| 1; 2|] 1.0
let _ = m [| 1; 2|] true
let _ = m [| 1; 2|] 'a'
let _ = m [| 1; 2|] "a"
let _ = m [| 1; 2|] (1,2)
let _ = m [| 1; 2|] {contents = 1}
let _ = m [| 1; 2|] (Some 1)
(* array -> something else *)
let _ = m (Some 1) 1
let _ = m (Some 1) 1.0
let _ = m (Some 1) true
let _ = m (Some 1) 'a'
let _ = m (Some 1) "a"
let _ = m (Some 1) (1,2)
let _ = m (Some 1) {contents = 1}
let _ = m (Some 1) [| 1; 2 |]
