#!/usr/bin/perl

#*** Copyright 2002-2004 The Acute Team
#
#  Allen-Williams, Mair
#  Bishop, Steven
#  Fairbairn, Matthew
#  Habouzit, Pierre [*]
#  Leifer, James [*]
#  Sewell, Peter
#  Sjberg, Vilhelm
#  Steinruecken, Christian
#  Vafeiadis, Viktor
#  Wansbrough, Keith
#  Zappa Nardelli, Francesco [*]
#  Institut National de Recherche en Informatique et en Automatique (INRIA)
#
#  Contributions of authors marked [*] are copyright INRIA.
#
#All rights reserved.
#
#This file is distributed under the terms of the GNU Lesser General
#Public License, with the special exception on linking described in
#file NEW-LICENSE.
#
#***

use Getopt::Std;
use IO::Handle;

# options are:
# -c : args to pass through
# -s : stylesheet name
# -f : run only for one family
# -i : genereate only index.html
# -d : output directory
# -k : kill delay

my %args;
getopts('ir:c:d:f:s:k:', \%args);

sub opt($$) {
    my($idx,$default) = @_;
    if(defined($args{$idx})) {
        return $args{$idx};
    } else {
        return $default;
    }
}

###
# global settings
#
my $runtestargs = opt('r', "");
my $argstring = opt('c',"");
my $stylesheet = opt('s','acute.css');
my $o_dir = opt('d', "out");
my $kill_time = opt('k', 10);

my $fams = `perl ./list_tests.pl -f | grep -v FAMS\:`;
chomp $fams;
$fams =~ s/\n//m;
my @fams = split /, /, $fams;
@fams = grep (!/^xxx_.*_xxx$/,@fams);

###
# copy css file into dest dir
#
`mkdir $o_dir 2>&1 >/dev/null`;
!(system ("cp acute.css $o_dir")) or die "cannot copy acute.css to $o_dir";

###
# run test for one fam
#
sub runfamily($) {

    my $fam = shift;
    local *FILE;
    select *FILE;
    $|=1;

    $date = gmtime();
    open FILE,">$o_dir/$fam.html" || die "cannot open $o_dir/$fam.html";
    print FILE <<EOF
<html>
<head>
  <title>Family $fam</title>
  <link rel="stylesheet" type="text/css" href="$stylesheet">
</head>
<body>
  <p>[<a href="index.html">index</a>]</p>
  <h1>$fam</h1>
  <p><strong>started : $date</p>
  <table cellspacing="0" cellpadding="0">
EOF
;
    close FILE;

    print "YYY\n";

    `./runtest $runtestargs -v -D "$o_dir" -T html -c "$argstring" -k $kill_delay -f $fam >> "$o_dir/$fam.html"`;
    `echo '</table>' >> "$o_dir/$fam.html"`;
    $date = gmtime();
    `echo '<p><strong>ended : $date</strong></table>' >> "$o_dir/$fam.html"`;
    `echo '</body>' >> "$o_dir/$fam.html"`;
    `echo '</html>' >> "$o_dir/$fam.html"`;
}

###
# make index
#

sub makeidx() {
    local *FILE;
    open FILE,">$o_dir/index.html" || die "cannot open $o_dir/index.html";
    $date = gmtime();
    print FILE <<EOF
<html>
  <head>
    <title>HashCaml tests</title>
    <link rel="stylesheet" type="text/css" href="$stylesheet">
  </head>
  <body>
    <h1>HashCaml tests</h1>
    <table id="index" cellspacing="0" cellpadding="0">
      <tr>
        <th>Family</th>
        <td class="test_ok">ok</th>
        <td class="test_bad">bad</th>
        <td class="test_killed">killed</th>
      </tr>
EOF
    ;
    foreach $fam (@fams) {

        $nb_ok = `grep 'class="test_ok"'     "$o_dir/$fam.html" | wc -l`;
        $nb_ok = "&nbsp;" if($nb_ok==0);

        $nb_bad = `grep 'class="test_bad"'    "$o_dir/$fam.html" | wc -l`;
        $nb_bad = "&nbsp;" if($nb_bad==0);

        $nb_kil = `grep 'class="test_killed"' "$o_dir/$fam.html" | wc -l`;
        $nb_kil = "&nbsp;" if($nb_kil==0);

        print FILE <<EOF
      <tr>
        <td><a href="$fam.html">$fam</a></td>
        <td>$nb_ok</td>
        <td>$nb_bad</td>
        <td>$nb_kil</td>
      </li>
EOF
        ;
    }
    print FILE <<EOF
    </table>
    <p><strong>$date (GMT)</strong></p>
  </body>
</html>
EOF
    ;
    close FILE;
}

###
# main
#
if(defined($args{i})) {
    makeidx();
} elsif(defined($args{f})) {
    runfamily($args{f})
} else {
    foreach(@fams) {
        runfamily($_);
    }
    makeidx();
}

