#!/usr/bin/perl

use warnings;
use strict;

use Getopt::Std;

# options are:
# -f : print families
# -t : print tests

# default: print help

my %args;
getopts('tf', \%args);

my $t = (defined($args{t}));
my $f = (defined($args{f}));

if (!$t && !$f)
{
    print "OPTIONS: -t lists all (ungrouped) tests, -f lists families\n";

    exit;
}


my @tests;
my @fams;
my %groups;


my $tests_db="tests_db";

opendir(DIR, $tests_db) || die "Could not open directory ($tests_db):$!\n";

while (my $f = readdir(DIR))
{
    if ($f =~ /\.ml$/)
    {
	open(TEST_FILE, "$tests_db/$f");

	while (<TEST_FILE>)
	{
	    if ($_ =~ /\(\*\* (.*)$/)
	    {
		# need to deal with groups.
		if ($groups{$1}) {}
		else {
		    my $t=$1;
		    $t =~ s/ //g;
		    push @tests, $t;}
	    }

	    elsif ($_ =~ /\* GROUP (.*)/)
	    {
		foreach(split / +/, $1)
		{
		    $groups{$_} = 1;
		}
	    }

	    elsif ($_ =~  /\* FAM (.*)$/)
	    {
		my @f = split(" ", $1);
		foreach (@f){
		push @fams, $_};
	    }
	}

	close (TEST_FILE);
    }
}


#shouldn't be any duplicate tests anyway
#sort into alpha at the same time
my @tests_sorted=();
foreach (sort @tests){
    unless ("@tests_sorted" =~ /$_/)
    { push @tests_sorted, $_}
}
my @fams_sorted=();
foreach (sort @fams){
    unless ("@fams_sorted" =~ /$_/)
    { push @fams_sorted, $_}
}



if ($t ) {print "TESTS:\n"; foreach(@tests_sorted){ print "$_, ";}}
if ($f) {print "\nFAMS:\n";foreach(@fams_sorted){ print "$_, ";}}
print "\n";
