let send (s : string) : unit =
  let fd = open_out "store" in
  output_string fd s;
  close_out fd

let recv () : string =
  let fd = open_in "store" in
  let len = in_channel_length fd in
  let s = String.create len in
  really_input fd s 0 len;
  close_in fd;
  s
