open Types
open Typedtree

(* Create new myname structure item. *)
let new_sig_value () : signature_item =
  assert (!Clflags.hashing);
  Tsig_value (Ident.create "myname",
              { val_type = Ctype.instance Predef.type_string;
                val_kind = Val_reg })

(* Only adds myname to given signature. *)
let tr_sig (s : signature) : signature =
  assert (!Clflags.hashing);
  s @ [new_sig_value ()]

(* Recursively adds mynames to signatures. *)
let rec tr_sig_rec (s : signature) : signature =
  assert (!Clflags.hashing);
  (List.map tr_sig_item s) @ [new_sig_value ()]

and tr_sig_item (si : signature_item) : signature_item =
  match si with
  | Tsig_module (id, mt, rs) -> Tsig_module (id, tr_mod_type mt, rs)
  | Tsig_modtype (id, mtd) -> Tsig_modtype (id, tr_mod_type_decl mtd)
  | _ -> si

and tr_mod_type (mt : module_type) : module_type =
  match mt with
  | Tmty_signature s -> Tmty_signature (tr_sig_rec s)
  | Tmty_functor (id, mt1, mt2) ->
      Tmty_functor (id, tr_mod_type mt1, tr_mod_type mt2)
  | _ -> mt

and tr_mod_type_decl (mtd : modtype_declaration) : modtype_declaration =
  match mtd with
  | Tmodtype_manifest mt -> Tmodtype_manifest (tr_mod_type mt)
  | _ -> mtd
