header{*Generated by Lem from set_extra.lem.*}

theory "Lem_set_extra" 

imports 
 	 Main
	 "Lem_bool" 
	 "Lem_basic_classes" 
	 "Lem_maybe" 
	 "Lem_function" 
	 "Lem_num" 
	 "Lem_list" 
	 "Lem_sorting" 
	 "Lem_set" 

begin 

(******************************************************************************)
(* A library for sets                                                         *)
(*                                                                            *)
(* It mainly follows the Haskell Set-library                                  *)
(******************************************************************************)

(* ========================================================================== *)
(* Header                                                                     *)
(* ========================================================================== *)

(*open import Bool Basic_classes Maybe Function Num List Sorting Set*)


(* ----------------------------*)
(* set choose (be careful !)   *)
(* --------------------------- *)

(*val choose : forall 'a. SetType 'a => set 'a -> 'a*)


(* ----------------------------*)
(* universal set               *)
(* --------------------------- *)

(*val universal : forall 'a. SetType 'a => set 'a*)
definition universal  :: " 'a set "  where 
     " universal = ( { x   . True })"



(* ----------------------------*)
(* toList                      *)
(* --------------------------- *)

(*val toList        : forall 'a. SetType 'a => set 'a -> list 'a*)


(* ----------------------------*)
(* toOrderedList               *)
(* --------------------------- *)

(* toOrderedList returns a sorted list. Therefore the result is (given a suitable order) deterministic.
   Therefore, it is much preferred to toList. However, it still is only defined for finite sets. So, please
   use carefully and consider using set-operations instead of translating sets to lists, performing list manipulations
   and then transforming back to sets. *)

(*val toOrderedListBy : forall 'a. ('a -> 'a -> bool) -> set 'a -> list 'a*)

(*val toOrderedList : forall 'a. SetType 'a, Ord 'a => set 'a -> list 'a*)

(* ----------------------------*)
(* unbounded fixed point       *)
(* --------------------------- *)

(* Is NOT supported by the coq backend! *)
(*val leastFixedPointUnbounded : forall 'a. SetType 'a => (set 'a -> set 'a) -> set 'a -> set 'a*)
function (sequential,domintros)  leastFixedPointUnbounded  :: "('a set \<Rightarrow> 'a set)\<Rightarrow> 'a set \<Rightarrow> 'a set "  where 
     " leastFixedPointUnbounded f x = (
   (let fx = (f x) in
   if fx \<subseteq> x then x
   else leastFixedPointUnbounded f (fx \<union> x)))" 
by pat_completeness auto

end
