header{*Generated by Lem from cmm_csem.lem.*}

theory "Cmm_csem" 

imports 
 	 Main
	 "Lem_show" 
	 "Lem_show_extra" 
	 "Lem_pervasives" 
	 "Lem_relation" 
	 "Lem_set" 
	 "Cmm_aux" 

begin 

(*========================================================================*)
(*                                                                        *)
(*             cppmem model exploration tool                              *)
(*                                                                        *)
(*                    Mark Batty                                          *)
(*                    Scott Owens                                         *)
(*                    Jean Pichon                                         *)
(*                    Susmit Sarkar                                       *)
(*                    Peter Sewell                                        *)
(*                                                                        *)
(*  This file is copyright 2011, 2012 by the above authors.               *)
(*                                                                        *)
(*  Redistribution and use in source and binary forms, with or without    *)
(*  modification, are permitted provided that the following conditions    *)
(*  are met:                                                              *)
(*  1. Redistributions of source code must retain the above copyright     *)
(*  notice, this list of conditions and the following disclaimer.         *)
(*  2. Redistributions in binary form must reproduce the above copyright  *)
(*  notice, this list of conditions and the following disclaimer in the   *)
(*  documentation and/or other materials provided with the distribution.  *)
(*  3. The names of the authors may not be used to endorse or promote     *)
(*  products derived from this software without specific prior written    *)
(*  permission.                                                           *)
(*                                                                        *)
(*  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS    *)
(*  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED     *)
(*  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE    *)
(*  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY       *)
(*  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL    *)
(*  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE     *)
(*  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS         *)
(*  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHE   *)
(*  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR       *)
(*  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN   *)
(*  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                         *)
(*========================================================================*)

(* emacs fontification -*-caml-*- *)

(*

Log:

20/03/13 - a savage and hasty tidy, following r10282

--- Introduction ---

This file contains a mathematical version of the relaxed memory model
of C11 and C++11, written in the specification language of Lem. Lem
can compile it to Ocaml, HOL, Isabelle or Latex. The basic model is
faithful to the intent of the 2011 standard and included here in
full. In addition, there are several simplified models that either remove
redundant concepts or provide simplifications for programs that
restrict the input language of programs.

There are lots of definitions that make up the models. To help you
navigate them, the following table of contents (with unique key
phrases) can be used to search the document. Where appropriate, there
are comments describing or explaining the definitions. These are
especially important for the top-level definitions of the simplified models.

--- Contents ---


1 - Relational definitions

2 - Type definitions and projections

  - 2.1 - Action and location types

  - 2.2 - Execution records

  - 2.3 - Projection functions 

  - 2.4 - Location kinds

  - 2.5  - Well formed action

  - 2.6  - Well formed threads

3 - Memory_Model simplified, single thread, no atomics

4 - Memory_Model simplified, multi-thread, no atomics, yes locks

5 - relaxed - memory_model simplified for programs without sc,
consumes, release or acquire

6 - release acquire - memory_model simplified for programs without sc,
consumes or relaxed

7 - release_acquire_relaxed - memory_model simplified for programs without sc,
consumes or relaxed

8 - release_acquire_fenced

9 - sc, no sc fences

10 - sc_fences, no consume

11 - with consume

12 - the standard model

13 - release acquire SC - for programs without consumes or relaxed

14 - SC - for programs without release, acquire, consumes or relaxed

15 - tot - sequential consistency

16 - Meta-theory

17 - release acquire, no locks - memory_model simplified for programs without sc,
consumes, relaxed or locks

18 - (not much there)

19 - overlap

*)

(*open import Show Show_extra*)
(*open import Pervasives Relation Set*)

(* for reference, this actually uses the following parts of Pervasives *)
(*
open import Basic_classes
open import Bool
(*open import Tuple*)
open import Maybe
(*open import Either*)
(*open import Function*)
open import Num
(*open import Map*)
open import Set
open import List
(*open import String*)
(*open import Word*)
(*open import Sorting*)
open import Relation
*)
(*open import Cmm_aux*)





(*************************************************** *)
(* 1 - Relational definitions *)
(*************************************************** *)

definition relation_over  :: " 'a set \<Rightarrow>('a*'a)set \<Rightarrow> bool "  where 
     " relation_over s rel = ( relOver rel s )"


definition inj_on  :: "('a \<Rightarrow> 'b)\<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " inj_on f A = ( ((\<forall> x \<in> A.  ((\<forall> y \<in> A.  (f x = f y) \<longrightarrow> (x = y))))))"


definition strict_total_order_over  :: " 'a set \<Rightarrow>('a*'a)set \<Rightarrow> bool "  where 
     " strict_total_order_over s ord = (
    relation_over s ord \<and> isTotalOrderOn ord s )"


definition adjacent_less_than  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool "  where 
     " adjacent_less_than ord s x y = (    
((x,y) \<in> ord) \<and> \<not> ((\<exists> z \<in> s.  ((x,z) \<in> ord) \<and> ((z,y) \<in> ord))))"

    
definition adjacent_less_than_such_that  :: "('a \<Rightarrow> bool)\<Rightarrow>('a*'a)set \<Rightarrow> 'a set \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool "  where 
     " adjacent_less_than_such_that pred ord s x y = (
    pred x \<and> (((x,y) \<in> ord) \<and> \<not> ((\<exists> z \<in> s.  pred z \<and> (((x,z) \<in> ord) \<and> ((z,y) \<in> ord))))))"


(*val finite_prefixes : forall 'a. SetType 'a, Eq 'a => set ('a * 'a) -> set 'a -> bool*)
definition finite_prefixes  :: "('a*'a)set \<Rightarrow> 'a set \<Rightarrow> bool "  where 
     " finite_prefixes r s = ((
      \<forall> b \<in> s.  finite  
  { a . (a,b) \<in> r}))"



(*val minimal_elements: forall 'a. set 'a -> set ('a * 'a) -> set 'a*)
definition minimal_elements  :: " 'a set \<Rightarrow>('a*'a)set \<Rightarrow> 'a set "  where 
     " minimal_elements s r = ( s )"





(*************************************************** *)
(* 2 - Type definitions and projections *)
(*************************************************** *)


(*************************************************** *)
(* - 2.1 - Action and location types *)
(*************************************************** *)


(**** Cppmem base types ****)

type_synonym aid =" aid_impl "
type_synonym program =" program_impl "
type_synonym tid =" tid_impl "
type_synonym location =" location_impl "
type_synonym cvalue =" cvalue_impl "


datatype memory_order =
    NA
  | Seq_cst
  | Relaxed
  | Release
  | Acquire
  | Consume
  | Acq_rel

definition instance_Show_Show_Cmm_csem_memory_order_dict  :: "(memory_order)Show_class "  where 
     " instance_Show_Show_Cmm_csem_memory_order_dict = ((|

  show_method = (\<lambda> mo1. (case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ))|) )"


datatype lock_outcome =
    Locked
  | Blocked

definition instance_Show_Show_Cmm_csem_lock_outcome_dict  :: "(lock_outcome)Show_class "  where 
     " instance_Show_Show_Cmm_csem_lock_outcome_dict = ((|

  show_method = (\<lambda> lo1. (case  lo1 of
      Locked  => (''Locked'')
    | Blocked => (''Blocked'')
    ))|) )"


datatype action =
    Lock " aid " " tid " " location " " lock_outcome "
  | Unlock " aid " " tid " " location "
  | Load " aid " " tid " " memory_order " " location " " cvalue "
  | Store " aid " " tid " " memory_order " " location " " cvalue "
  | RMW " aid " " tid " " memory_order " " location " " cvalue " " cvalue "
  | Fence " aid " " tid " " memory_order "
  | Blocked_rmw " aid " " tid " " location "
  | Alloc " aid " " tid " " location "   (* CSEM *)
  | Dealloc " aid " " tid " " location " (* CSEM *)

fun aid_of  :: " action \<Rightarrow> string "  where 
     " aid_of (Lock aid _ _ _) = ( aid )"
|" aid_of (Unlock aid _ _) = ( aid )"
|" aid_of (Load aid _ _ _ _) = ( aid )"
|" aid_of (Store aid _ _ _ _) = ( aid )"
|" aid_of (RMW aid _ _ _ _ _) = ( aid )"
|" aid_of (Fence aid _ _) = ( aid )"
|" aid_of (Blocked_rmw aid _ _) = ( aid )"
|" aid_of (Alloc aid _ _) = ( aid )"
|" aid_of (Dealloc aid _ _) = ( aid )" 
declare aid_of.simps [simp del]


(*val action_equality: action -> action -> bool*)                                                              (* CSEM *)



definition instance_Show_Show_Cmm_csem_action_dict  :: "(action)Show_class "  where 
     " instance_Show_Show_Cmm_csem_action_dict = ((|

  show_method = (\<lambda> a. (case  a of
      Lock aid tid loc lock        =>
      (''Lock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', '') @ ((case  lock of
      Locked  => (''Locked'')
    | Blocked => (''Blocked'')
    ) @ ('')''))))))))
    | Unlock aid tid loc           =>
      (''Unlock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Load aid tid mo1 loc val1     =>
      (''Load (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | Store aid tid mo1 loc val1    =>
      (''Store (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | RMW aid tid mo1 loc val1 val2 =>
      (''RMW (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val1: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val2: '') @ ((case  val2 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))))
    | Fence aid tid mo1             =>
      (''Fence (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @ ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ ('')''))))))
    | Blocked_rmw aid tid loc      =>
      (''Blocked_rmw (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Alloc aid tid loc            =>                                                 (* CSEM *)
      (''Alloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))   (* CSEM *)
    | Dealloc aid tid loc          =>                                                 (* CSEM *)
      (''Dealloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')'')))))) (* CSEM *)
    ))|) )"




(*********************************************** *)
(*  - 2.2 - Execution records *)
(*********************************************** *)

datatype location_kind =
    Mutex
  | Non_Atomic
  | Atomic

definition instance_Show_Show_Cmm_csem_location_kind_dict  :: "(location_kind)Show_class "  where 
     " instance_Show_Show_Cmm_csem_location_kind_dict = ((|

  show_method = (\<lambda> loc. (case  loc of
      Mutex      => (''Mutex'')
    | Non_Atomic => (''Non_Atomic'')
    | Atomic     => (''Atomic'')
    ))|) )"


record pre_execution =
  
  actions0 ::" (action) set " 

      threads ::" (tid) set " 

      lk      ::" location \<Rightarrow> location_kind " 

      sb      ::" (action * action) set " 

      asw     ::" (action * action) set " 

      dd      ::" (action * action) set "  
  


(*val action_rel_tostring: set (action * action) -> string*)
definition action_rel_tostring  :: "(action*action)set \<Rightarrow> string "  where 
     " action_rel_tostring rel = (
  (let aid_of_rel = (Set.image (\<lambda> (a, b) .  (aid_of a, aid_of b)) rel) in
  Lem_show_extra.stringFromRelation (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) aid_of_rel))"


(* The name aid_or_rel clashes with something in Isabelle *)
(*val aid_of_rel2: set (action * action) -> set (aid * aid)*)
definition aid_of_rel2  :: "(action*action)set \<Rightarrow>(string*string)set "  where 
     " aid_of_rel2 s = (
  Set.image (\<lambda> (a, b) .  (aid_of a, aid_of b)) s )"


definition instance_Show_Show_Cmm_csem_pre_execution_dict  :: "(pre_execution)Show_class "  where 
     " instance_Show_Show_Cmm_csem_pre_execution_dict = ((|

  show_method = (\<lambda> pre1. (''actions: '') @ (stringFromSet (\<lambda> a. (case  a of
      Lock aid tid loc lock        =>
      (''Lock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', '') @ ((case  lock of
      Locked  => (''Locked'')
    | Blocked => (''Blocked'')
    ) @ ('')''))))))))
    | Unlock aid tid loc           =>
      (''Unlock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Load aid tid mo1 loc val1     =>
      (''Load (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | Store aid tid mo1 loc val1    =>
      (''Store (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | RMW aid tid mo1 loc val1 val2 =>
      (''RMW (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val1: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val2: '') @ ((case  val2 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))))
    | Fence aid tid mo1             =>
      (''Fence (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @ ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ ('')''))))))
    | Blocked_rmw aid tid loc      =>
      (''Blocked_rmw (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Alloc aid tid loc            =>                                                 (* CSEM *)
      (''Alloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))   (* CSEM *)
    | Dealloc aid tid loc          =>                                                 (* CSEM *)
      (''Dealloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')'')))))) (* CSEM *)
    ))(actions0   pre1) @    
 (('', threads: '') @ (stringFromSet (\<lambda> tid. (case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ))(threads   pre1) @    
(('', lk: '') @ ((''?'') @    
(('', sb: '') @ (action_rel_tostring(sb   pre1) @    
(('', asw: '') @ (action_rel_tostring(asw   pre1) @    
 (('', dd: '') @ action_rel_tostring(dd   pre1))))))))))))|) )"


(* this is wrong by design: we can't write a compare function for lk *)
definition pre_execution_setElemCompare  :: "((action)set \<Rightarrow>(action)set \<Rightarrow> ordering)\<Rightarrow>((tid)set \<Rightarrow>(tid)set \<Rightarrow> ordering)\<Rightarrow>((action*action)set \<Rightarrow>(action*action)set \<Rightarrow> ordering)\<Rightarrow> pre_execution \<Rightarrow> pre_execution \<Rightarrow> ordering "  where 
     " pre_execution_setElemCompare cmpa cmpb cmpc x y = (
  pairCompare
    cmpa
    (pairCompare
       cmpb
       (pairCompare
          cmpc
          (pairCompare
             cmpc
             cmpc)))
    ((actions0   x), ((threads   x), ((sb   x), ((asw   x),(dd   x)))))
    ((actions0   y), ((threads   y), ((sb   y), ((asw   y),(dd   y))))))"






(*val pre_execution_equal: pre_execution -> pre_execution -> bool*)                                   (* CSEM *)


datatype order_kind =
     Global_order
   | Per_location_order

record relation_usage_flags =
  
  rf_flag  ::" bool " 

      mo_flag  ::" bool " 

      sc_flag  ::" bool " 

      lo_flag  ::" bool " 

      tot_flag ::" bool "   


record execution_witness =
  
  rf      ::" (action * action) set " 

      mo      ::" (action * action) set " 

      sc      ::" (action * action) set " 

      lo      ::" (action * action) set " 

      tot     ::" (action * action) set " 
 


definition instance_Show_Show_Cmm_csem_execution_witness_dict  :: "(execution_witness)Show_class "  where 
     " instance_Show_Show_Cmm_csem_execution_witness_dict = ((|

  show_method = (\<lambda> wit. (''rf: '')    @ (action_rel_tostring(rf   wit) @    
 (('', mo: '')  @ (action_rel_tostring(mo   wit) @    
 (('', sc: '')  @ (action_rel_tostring(sc   wit) @    
 (('', lo: '')  @ (action_rel_tostring(lo   wit) @    
 (('', tot: '') @ action_rel_tostring(tot   wit))))))))))|) )"


definition execution_witness_setElemCompare  :: "((action*action)set \<Rightarrow>(action*action)set \<Rightarrow> ordering)\<Rightarrow> execution_witness \<Rightarrow> execution_witness \<Rightarrow> ordering "  where 
     " execution_witness_setElemCompare cmp x y = (
  pairCompare
    cmp
    (pairCompare
       cmp
       (pairCompare
          cmp
          (pairCompare
             cmp
             cmp)))
    ((rf   x), ((mo   x), ((sc   x), ((lo   x),(tot   x)))))
    ((rf   y), ((mo   y), ((sc   y), ((lo   y),(tot   y))))))"
                                   (* CSEM *)


(*val execution_witness_equal: execution_witness -> execution_witness -> bool*)                                                   (* CSEM *)


(*val empty_witness: execution_witness*)
definition empty_witness  :: " execution_witness "  where 
     " empty_witness = ( 
  (| rf = {},
     mo = {},
     sc = {},
     lo = {},
     tot = {} 
  |) )"


type_synonym relation_list =" (string * (action * action) set) list "

(* The following instance gives an error, because relation_list is a
type synonym. *)
(* 
instance (Show relation_list)
  let show l = 
end *)

(*val relation_list_tostring: relation_list -> string*)
definition relation_list_tostring  :: "(string*(action*action)set)list \<Rightarrow> string "  where 
     " relation_list_tostring l = ( 
  stringFromList (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) action_rel_tostring) l )"
 

type_synonym candidate_execution =" (pre_execution * execution_witness * relation_list)"

(*val candidate_execution_tostring: candidate_execution -> string*)
fun candidate_execution_tostring  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> string "  where 
     " candidate_execution_tostring (pre1, wit, rel) = ( 
  (''('') @ (((''actions: '') @ (stringFromSet (\<lambda> a. (case  a of
      Lock aid tid loc lock        =>
      (''Lock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', '') @ ((case  lock of
      Locked  => (''Locked'')
    | Blocked => (''Blocked'')
    ) @ ('')''))))))))
    | Unlock aid tid loc           =>
      (''Unlock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Load aid tid mo1 loc val1     =>
      (''Load (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | Store aid tid mo1 loc val1    =>
      (''Store (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | RMW aid tid mo1 loc val1 val2 =>
      (''RMW (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val1: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val2: '') @ ((case  val2 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))))
    | Fence aid tid mo1             =>
      (''Fence (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @ ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ ('')''))))))
    | Blocked_rmw aid tid loc      =>
      (''Blocked_rmw (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Alloc aid tid loc            =>                                                 (* CSEM *)
      (''Alloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))   (* CSEM *)
    | Dealloc aid tid loc          =>                                                 (* CSEM *)
      (''Dealloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')'')))))) (* CSEM *)
    ))(actions0   pre1) @    
 (('', threads: '') @ (stringFromSet (\<lambda> tid. (case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ))(threads   pre1) @    
(('', lk: '') @ ((''?'') @    
(('', sb: '') @ (action_rel_tostring(sb   pre1) @    
(('', asw: '') @ (action_rel_tostring(asw   pre1) @    
 (('', dd: '') @ action_rel_tostring(dd   pre1)))))))))))) @ (('', '') @ (((''rf: '')    @ (action_rel_tostring(rf   wit) @    
 (('', mo: '')  @ (action_rel_tostring(mo   wit) @    
 (('', sc: '')  @ (action_rel_tostring(sc   wit) @    
 (('', lo: '')  @ (action_rel_tostring(lo   wit) @    
 (('', tot: '') @ action_rel_tostring(tot   wit)))))))))) @ (('', '') @ (relation_list_tostring rel @ ('')'')))))))" 
declare candidate_execution_tostring.simps [simp del]


type_synonym observable_execution =" (pre_execution * execution_witness)"

datatype program_behaviours =
    Defined " (observable_execution) set "
  | Undefined

definition program_behaviours_eq  :: " program_behaviours \<Rightarrow> program_behaviours \<Rightarrow> bool "  where 
     " program_behaviours_eq x y = (
  (case  (x, y) of
    (Defined s1, Defined s2) => s1 = s2
  | (Undefined, Undefined) => True
  | _ => False
  ))"
                                       (* CSEM *)



type_synonym rf_observable_execution =" (pre_execution * (action * action) set)"

datatype rf_program_behaviours =
    rf_Defined " (rf_observable_execution) set "
  | rf_Undefined

definition rf_program_behaviours_eq  :: " rf_program_behaviours \<Rightarrow> rf_program_behaviours \<Rightarrow> bool "  where 
     " rf_program_behaviours_eq x y = (
  (case  (x, y) of
    (rf_Defined s1, rf_Defined s2) => s1 = s2
  | (rf_Undefined, rf_Undefined) => True
  | _ => False
  ))"
                                       (* CSEM *)


datatype named_predicate_tree =
    Leaf " (candidate_execution \<Rightarrow> bool)"
  | Node " (string * named_predicate_tree) list "


(*val named_predicate_tree_measure : forall. named_predicate_tree -> nat*)

function (sequential,domintros)  apply_tree  :: " named_predicate_tree \<Rightarrow> pre_execution*execution_witness*relation_list \<Rightarrow> bool "  where 
     " apply_tree (Leaf p) X = ( p X )"
|" apply_tree (Node l) X = ( ((\<forall> x \<in> (set l).  (\<lambda> (name, branch) .  apply_tree branch X) x)))" 
by pat_completeness auto



datatype fault_setgen =
    One " (string * (candidate_execution \<Rightarrow> (action) set))"
  | Two " (string * (candidate_execution \<Rightarrow> (action * action) set))"

(* The above type (fault_setgen) is used for the
   undefinedness-predicates, where the kind of undefinedness is
   denoted by a string. To make it easier to work with, we provide
   alternative definitions of the undefinedness-predicates, that
   return a list of the following type. *)

datatype undefinedness =
    DataRaces " (action * action) set "
  | UnsequencedRaces " (action * action) set "
  | IndeterminateReads " action set "
  | BadMutexes " action set "
  | NotInSublanguage    (* e.g. a fence in the lock-only model *)

definition instance_Show_Show_Cmm_csem_undefinedness_dict  :: "(undefinedness)Show_class "  where 
     " instance_Show_Show_Cmm_csem_undefinedness_dict = ((|

  show_method = (\<lambda> d. (case  d of
      DataRaces s          => (''DataRaces: '') @ stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2 s)
    | UnsequencedRaces s   => (''UnsequencedRaces: '') @ stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2 s)
    | IndeterminateReads s => (''IndeterminateReads: '') @ stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (Set.image aid_of s)
    | BadMutexes s         => (''BadMutexes: '') @ stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (Set.image aid_of s)
    | NotInSublanguage     => (''NotInSublanguage'')
    ))|) )"



type_synonym opsem_t =" program \<Rightarrow> pre_execution \<Rightarrow> bool "

type_synonym condition_t =" candidate_execution set \<Rightarrow> bool "

definition true_condition  :: " 'a \<Rightarrow> bool "  where 
     " true_condition _ = ( True )"




record memory_model =
  
  consistent ::" named_predicate_tree " 

      relation_calculation ::" pre_execution \<Rightarrow> execution_witness \<Rightarrow>
  relation_list " 

      undefined0 ::" (fault_setgen) list " 

      relation_flags ::" relation_usage_flags " 
  






(*************************************************** *)
(*   - 2.3 - Projection functions *)
(*************************************************** *)

(* The unpack functions are not used in the model itself, but are probably 
   needed by every user of the model. *)

definition not_alloc_or_dealloc  :: " action \<Rightarrow> bool "  where 
     " not_alloc_or_dealloc = ( \<lambda>x .  
  (case  x of
      (* CSEM *)
    Lock _ _ _ _ => True (* CSEM *)
    | Unlock _ _ _ => True (* CSEM *)
    | Load _ _ _ _ _ => True (* CSEM *)
    | Store _ _ _ _ _ => True (* CSEM *)
    | RMW _ _ _ _ _ _ => True (* CSEM *)
    | Fence _ _ _ => True (* CSEM *)
    | Blocked_rmw _ _ _ => True (* CSEM *)
    | Alloc _ _ _ => False (* CSEM *)
    | Dealloc _ _ _ => False (* CSEM *)
  ) )"
                                 (* CSEM *)



fun is_fault  :: "(fault_setgen)list \<Rightarrow> pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> action \<Rightarrow> bool "  where 
     " is_fault faults_list (Xo,Xw,rl) a = ( 
  (let is_particular_fault = (\<lambda> f . 
                              (case  f of
                                  One (name0,setgen) => (a \<in>
                                                           (setgen (Xo,Xw,rl)))
                                | Two (name0,setgen) =>(
                                                       \<exists> b \<in>(actions0   Xo).
                                                         ((a,b) \<in>
                                                            (setgen
                                                               (Xo,Xw,rl)))
                                                           \<or>
                                                           ((b,a) \<in>
                                                              (setgen
                                                                 (Xo,Xw,rl))))
                              )) in
  ((\<exists> x \<in> (set faults_list). is_particular_fault x))) )" 
declare is_fault.simps [simp del]


definition each_empty  :: "(fault_setgen)list \<Rightarrow> pre_execution*execution_witness*relation_list \<Rightarrow> bool "  where 
     " each_empty faults_list X = ( 
  (let faults_empty = (\<lambda> f . 
                       (case  f of
                           One (name0,setgen) => ((setgen X) = {})
                         | Two (name0,setgen) => ((setgen X) = {})
                       )) in
  ((\<forall> x \<in> (set faults_list). faults_empty x))) )"



(*val statically_satisfied : forall. condition_t -> opsem_t -> program -> bool*)
definition statically_satisfied  :: "((pre_execution*execution_witness*(string*(action*action)set)list)set \<Rightarrow> bool)\<Rightarrow>(nat \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> bool "  where 
     " statically_satisfied condition opsem (p :: program) = (
  (let Xs = ({(Xo,Xw,rl) . opsem p Xo}) in
  condition Xs))"




(*val observable_filter : forall. set (candidate_execution) -> set (observable_execution)*)
definition observable_filter  :: "(pre_execution*execution_witness*(string*(action*action)set)list)set \<Rightarrow>(pre_execution*execution_witness)set "  where 
     " observable_filter X = ( {(Xo,Xw) .( \<exists> rl.  (Xo,Xw,rl) \<in> X)})"


(*val behaviour : forall. memory_model -> condition_t -> opsem_t -> program -> program_behaviours*)
definition behaviour  :: " memory_model \<Rightarrow>((pre_execution*execution_witness*(string*(action*action)set)list)set \<Rightarrow> bool)\<Rightarrow>(nat \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " behaviour M condition opsem (p :: program) = (
  (let consistent_executions =    
({ (Xo,Xw,rl) .
        opsem p Xo \<and>        
(apply_tree(consistent   M) (Xo,Xw,rl) \<and>        
(rl =(relation_calculation   M) Xo Xw)) }) in
  if condition consistent_executions \<and>     
((\<forall> X \<in> consistent_executions. 
        each_empty(undefined0   M) X))
  then Defined (observable_filter consistent_executions)
  else Undefined))"



(*val rf_observable_filter : forall. set (candidate_execution) -> set (rf_observable_execution)*)
definition rf_observable_filter  :: "(pre_execution*execution_witness*(string*(action*action)set)list)set \<Rightarrow>(pre_execution*(action*action)set)set "  where 
     " rf_observable_filter X = ( {(Xo,(rf   Xw)) |Xo Xw.( \<exists> rl.  (Xo,Xw,rl) \<in> X)})"



(*val rf_behaviour : forall. memory_model -> condition_t -> opsem_t -> program -> rf_program_behaviours*)
definition rf_behaviour  :: " memory_model \<Rightarrow>((pre_execution*execution_witness*(string*(action*action)set)list)set \<Rightarrow> bool)\<Rightarrow>(nat \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> rf_program_behaviours "  where 
     " rf_behaviour M condition opsem (p :: program) = (
  (let consistent_executions =    
({ (Xo,Xw,rl) .
        opsem p Xo \<and>        
(apply_tree(consistent   M) (Xo,Xw,rl) \<and>        
(rl =(relation_calculation   M) Xo Xw)) }) in
  if condition consistent_executions \<and>     
((\<forall> X \<in> consistent_executions. 
        each_empty(undefined0   M) X))
  then rf_Defined (rf_observable_filter consistent_executions)
  else rf_Undefined))"





fun tid_of  :: " action \<Rightarrow> tid_impl "  where 
     " tid_of (Lock _ tid _ _) = ( tid )"
|" tid_of (Unlock _ tid _) = ( tid )"
|" tid_of (Load _ tid _ _ _) = ( tid )"
|" tid_of (Store _ tid _ _ _) = ( tid )"
|" tid_of (RMW _ tid _ _ _ _) = ( tid )"
|" tid_of (Fence _ tid _) = ( tid )"
|" tid_of (Blocked_rmw _ tid _) = ( tid )"
|" tid_of (Alloc _ tid _) = ( tid )"
|" tid_of (Dealloc _ tid _) = ( tid )" 
declare tid_of.simps [simp del]


fun loc_of  :: " action \<Rightarrow>(location_impl)option "  where 
     " loc_of (Lock _ _ l _) = ( Some l )"
|" loc_of (Unlock _ _ l) = ( Some l )"
|" loc_of (Load _ _ _ l _) = ( Some l )"
|" loc_of (Store _ _ _ l _) = ( Some l )"
|" loc_of (RMW _ _ _ l _ _) = ( Some l )"
|" loc_of (Fence _ _ _) = ( None )"
|" loc_of (Blocked_rmw _ _ l) = ( Some l )"
|" loc_of (Alloc _ _ l) = ( Some l )"
|" loc_of (Dealloc _ _ l) = ( Some l )" 
declare loc_of.simps [simp del]


fun value_read_by  :: " action \<Rightarrow>(cvalue_impl)option "  where 
     " value_read_by (Load _ _ _ _ v) = ( Some v )"
|" value_read_by (RMW _ _ _ _ v _) = ( Some v )"
|" value_read_by _ = ( None )" 
declare value_read_by.simps [simp del]


fun value_written_by  :: " action \<Rightarrow>(cvalue_impl)option "  where 
     " value_written_by (Store _ _ _ _ v) = ( Some v )"
|" value_written_by (RMW _ _ _ _ _ v) = ( Some v )"
|" value_written_by _ = ( None )" 
declare value_written_by.simps [simp del]


fun is_lock  :: " action \<Rightarrow> bool "  where 
     " is_lock (Lock _ _ _ _) = ( True )"
|" is_lock _ = ( False )" 
declare is_lock.simps [simp del]


fun is_successful_lock  :: " action \<Rightarrow> bool "  where 
     " is_successful_lock (Lock _ _ _ Locked) = ( True )"
|" is_successful_lock _ = ( False )" 
declare is_successful_lock.simps [simp del]


fun is_blocked_lock  :: " action \<Rightarrow> bool "  where 
     " is_blocked_lock (Lock _ _ _ Blocked) = ( True )"
|" is_blocked_lock _ = ( False )" 
declare is_blocked_lock.simps [simp del]


fun is_unlock  :: " action \<Rightarrow> bool "  where 
     " is_unlock (Unlock _ _ _) = ( True )"
|" is_unlock _ = ( False )" 
declare is_unlock.simps [simp del]


fun is_atomic_load  :: " action \<Rightarrow> bool "  where 
     " is_atomic_load (Load _ _ mo1 _ _) = ( mo1 \<noteq> NA )"
|" is_atomic_load _ = ( False )" 
declare is_atomic_load.simps [simp del]


fun is_atomic_store  :: " action \<Rightarrow> bool "  where 
     " is_atomic_store (Store _ _ mo1 _ _) = ( mo1 \<noteq> NA )"
|" is_atomic_store _ = ( False )" 
declare is_atomic_store.simps [simp del]


fun is_RMW  :: " action \<Rightarrow> bool "  where 
     " is_RMW (RMW _ _ _ _ _ _) = ( True )"
|" is_RMW _ = ( False )" 
declare is_RMW.simps [simp del]


fun is_blocked_rmw  :: " action \<Rightarrow> bool "  where 
     " is_blocked_rmw (Blocked_rmw _ _ _) = ( True )"
|" is_blocked_rmw _ = ( False )" 
declare is_blocked_rmw.simps [simp del]


fun is_NA_load  :: " action \<Rightarrow> bool "  where 
     " is_NA_load (Load _ _ mo1 _ _) = ( mo1 = NA )"
|" is_NA_load _ = ( False )" 
declare is_NA_load.simps [simp del]


fun is_NA_store  :: " action \<Rightarrow> bool "  where 
     " is_NA_store (Store _ _ mo1 _ _) = ( mo1 = NA )"
|" is_NA_store _ = ( False )" 
declare is_NA_store.simps [simp del]


fun is_load  :: " action \<Rightarrow> bool "  where 
     " is_load (Load _ _ _ _ _) = ( True )"
|" is_load _ = ( False )" 
declare is_load.simps [simp del]


fun is_store  :: " action \<Rightarrow> bool "  where 
     " is_store (Store _ _ _ _ _) = ( True )"
|" is_store _ = ( False )" 
declare is_store.simps [simp del]


fun is_fence  :: " action \<Rightarrow> bool "  where 
     " is_fence (Fence _ _ _) = ( True )"
|" is_fence _ = ( False )" 
declare is_fence.simps [simp del]


fun is_alloc  :: " action \<Rightarrow> bool "  where 
     " is_alloc (Alloc _ _ _) = ( True )"
|" is_alloc _ = ( False )" 
declare is_alloc.simps [simp del]
                       (* CSEM *)

fun is_dealloc  :: " action \<Rightarrow> bool "  where 
     " is_dealloc (Dealloc _ _ _) = ( True )"
|" is_dealloc _ = ( False )" 
declare is_dealloc.simps [simp del]
                       (* CSEM *)


fun is_atomic_action  :: " action \<Rightarrow> bool "  where 
     " is_atomic_action (Load _ _ mo1 _ _) = ( mo1 \<noteq> NA )"
|" is_atomic_action (Store _ _ mo1 _ _) = ( mo1 \<noteq> NA )"
|" is_atomic_action (RMW _ _ _ _ _ _) = ( True )"
|" is_atomic_action (Blocked_rmw _ _ _) = ( True )"
|" is_atomic_action _ = ( False )" 
declare is_atomic_action.simps [simp del]


fun is_read  :: " action \<Rightarrow> bool "  where 
     " is_read (Load _ _ _ _ _) = ( True )"
|" is_read (RMW _ _ _ _ _ _) = ( True )"
|" is_read _ = ( False )" 
declare is_read.simps [simp del]


fun is_write  :: " action \<Rightarrow> bool "  where 
     " is_write (Store _ _ _ _ _) = ( True )"
|" is_write (RMW _ _ _ _ _ _) = ( True )"
|" is_write _ = ( False )" 
declare is_write.simps [simp del]



(* It is important to note that seq_cst atomics are both acquires and releases *)


fun is_acquire  :: " action \<Rightarrow> bool "  where 
     " is_acquire (Load _ _ mo1 _ _) = ( mo1 \<in> {Acquire,Seq_cst})"
|" is_acquire (RMW _ _ mo1 _ _ _) = ( mo1 \<in> {Acquire,Acq_rel,Seq_cst})"
|" is_acquire (Fence _ _ mo1) = ( mo1 \<in> {Acquire,Consume,Acq_rel,Seq_cst})"
|" is_acquire _ = ( False )" 
declare is_acquire.simps [simp del]


fun is_release  :: " action \<Rightarrow> bool "  where 
     " is_release (Store _ _ mo1 _ _) = ( mo1 \<in> {Release,Seq_cst})"
|" is_release (RMW _ _ mo1 _ _ _) = ( mo1 \<in> {Release,Acq_rel,Seq_cst})"
|" is_release (Fence _ _ mo1) = ( mo1 \<in> {Release,Acq_rel,Seq_cst})"
|" is_release _ = ( False )" 
declare is_release.simps [simp del]


fun is_consume  :: " action \<Rightarrow> bool "  where 
     " is_consume (Load _ _ mo1 _ _) = ( mo1 = Consume )"
|" is_consume _ = ( False )" 
declare is_consume.simps [simp del]



fun is_seq_cst  :: " action \<Rightarrow> bool "  where 
     " is_seq_cst (Load _ _ mo1 _ _) = ( mo1 = Seq_cst )"
|" is_seq_cst (Store _ _ mo1 _ _) = ( mo1 = Seq_cst )"
|" is_seq_cst (RMW _ _ mo1 _ _ _) = ( mo1 = Seq_cst )"
|" is_seq_cst (Fence _ _ mo1) = ( mo1 = Seq_cst )"
|" is_seq_cst _ = ( False )" 
declare is_seq_cst.simps [simp del]



definition threadwise  :: " 'a \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     " threadwise s rel = (( \<forall> (a,b) \<in> rel.  (tid_of a) = (tid_of b)))"


definition interthread  :: " 'a \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     " interthread s rel = (( \<forall> (a,b) \<in> rel.  \<not> ((tid_of a) = (tid_of b))))"


definition locationwise  :: " 'a \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     " locationwise s rel = (( \<forall> (a,b) \<in> rel.  loc_of a = loc_of b))"


definition per_location_total  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     " per_location_total s rel = ((
    \<forall> a \<in> s. 
    \<forall> b \<in> s.  (loc_of a = loc_of b) \<longrightarrow>
      (((a,b) \<in> rel) \<or> (((b,a) \<in> rel) \<or> ( a = b)))))"


(**************************************** *)
(*   - 2.4 - Location kinds *)
(**************************************** *)

(* The following definition should use
action_respects_location_kind, instead of cloning the function
body. This hasn't been done yet, because it might break existing
proofs. *)

definition actions_respect_location_kinds  :: "(action)set \<Rightarrow>(location_impl \<Rightarrow> location_kind)\<Rightarrow> bool "  where 
     " actions_respect_location_kinds actions2 lk1 = ((
 \<forall> a \<in> actions2.  (case  a of
      Lock _ _ l _            => lk1 l = Mutex
    | Unlock _ _ l            => lk1 l = Mutex
    | Load _ _ mo1 l _         =>
        ((mo1 = NA) \<and> (lk1 l = Non_Atomic)) \<or> ((mo1 \<noteq> NA) \<and> (lk1 l = Atomic))
    | Store _ _ mo1 l _        =>
        ((mo1 = NA) \<and> (lk1 l = Non_Atomic)) \<or> (lk1 l = Atomic)
    | RMW _ _ _ l _ _         => lk1 l = Atomic
    | Fence _ _ _             => True
    | Blocked_rmw _ _ l       => lk1 l = Atomic
    | Alloc _ _ _             => True (* CSEM *)
    | Dealloc _ _ _           => True (* CSEM *)
    )))"


fun action_respects_location_kinds  :: " 'a \<Rightarrow>(location_impl \<Rightarrow> location_kind)\<Rightarrow> action \<Rightarrow> bool "  where 
     " action_respects_location_kinds action lk1 (Lock _ _ l _) = ( lk1 l = Mutex )"
|" action_respects_location_kinds action lk1 (Unlock _ _ l) = ( lk1 l = Mutex )"
|" action_respects_location_kinds action lk1 (Load _ _ mo1 l _) = (
        ((mo1 = NA) \<and> (lk1 l = Non_Atomic)) \<or> ((mo1 \<noteq> NA) \<and> (lk1 l = Atomic)))"
|" action_respects_location_kinds action lk1 (Store _ _ mo1 l _) = (
        ((mo1 = NA) \<and> (lk1 l = Non_Atomic)) \<or> (lk1 l = Atomic))"
|" action_respects_location_kinds action lk1 (RMW _ _ _ l _ _) = ( lk1 l = Atomic )"
|" action_respects_location_kinds action lk1 (Fence _ _ _) = ( True )"
|" action_respects_location_kinds action lk1 (Blocked_rmw _ _ l) = ( lk1 l = Atomic )"
|" action_respects_location_kinds action lk1 (Alloc _ _ _) = ( True )"
|" action_respects_location_kinds action lk1 (Dealloc _ _ _) = ( True )" 
declare action_respects_location_kinds.simps [simp del]



definition is_at_mutex_location  :: "(location_impl \<Rightarrow> location_kind)\<Rightarrow> action \<Rightarrow> bool "  where 
     " is_at_mutex_location lk1 a = (
    (case  loc_of a of
      Some l => (lk1 l = Mutex)
    | None   => False
    ))"


definition is_at_non_atomic_location  :: "(location_impl \<Rightarrow> location_kind)\<Rightarrow> action \<Rightarrow> bool "  where 
     " is_at_non_atomic_location lk1 a = (
    (case  loc_of a of
      Some l => (lk1 l = Non_Atomic)
    | None   => False
    ))"


definition is_at_atomic_location  :: "(location_impl \<Rightarrow> location_kind)\<Rightarrow> action \<Rightarrow> bool "  where 
     " is_at_atomic_location lk1 a = (
    (case  loc_of a of
      Some l => (lk1 l = Atomic)
    | None   => False
    ))"




(**************************************** *)
(*   - 2.5 - Well formed action *)
(**************************************** *)


(* used in cppmem *)
definition locations_of  :: "(action)set \<Rightarrow>(location_impl)set "  where 
     " locations_of actions2 = (
{ l   . (Some l \<in>
    Set.image (\<lambda> a .  (loc_of a))
      (set_filter (\<lambda> a .  True) actions2)) \<and> True})"



fun well_formed_action  :: " action \<Rightarrow> bool "  where 
     " well_formed_action (Load  _ _ mo1 _ _) = ( mo1 \<in> {NA,Relaxed,Acquire,Seq_cst,Consume})"
|" well_formed_action (Store _ _ mo1 _ _) = ( mo1 \<in> {NA,Relaxed,Release,Seq_cst})"
|" well_formed_action (RMW _ _ mo1 _ _ _) = ( mo1 \<in> {Relaxed,Release,Acquire,Acq_rel,Seq_cst})"
|" well_formed_action (Fence _ _ mo1) = ( mo1 \<in> {Relaxed,Release,Acquire,Acq_rel,Consume,Seq_cst})"
|" well_formed_action _ = ( True )" 
declare well_formed_action.simps [simp del]


(*********************************************** *)
(*  - 2.6 - Well formed threads and some assumptions *)
(*********************************************** *)



(*val assumptions: (pre_execution * execution_witness * relation_list) -> bool*)
fun assumptions  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " assumptions (Xo,Xw,_) = (
  finite_prefixes(rf   Xw)(actions0    Xo) \<and>  
(finite_prefixes(mo   Xw)(actions0    Xo) \<and>  
(finite_prefixes(sc   Xw)(actions0    Xo) \<and>
  finite_prefixes(lo   Xw)(actions0    Xo))))" 
declare assumptions.simps [simp del]





definition blocking_observed  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     " blocking_observed actions2 sb1 = (
    ((\<forall> a \<in> actions2.  
       (is_blocked_rmw a \<or> is_blocked_lock a) 
       \<longrightarrow> 
       \<not> ((\<exists> b \<in> actions2.  (a,b) \<in> sb1)))))"


(* Indeterminate sequencing from 1.9p15, noting that all atomic and
lock calls are functions. *)
definition indeterminate_sequencing  :: " pre_execution \<Rightarrow> bool "  where 
     " indeterminate_sequencing Xo = ((
    \<forall> a \<in>(actions0   Xo). 
    \<forall> b \<in>(actions0   Xo).       
(( (tid_of a) = (tid_of b)) \<and> (( ((\<lambda> x y .  \<not> (x = y))a b)) \<and>
      \<not> (is_at_non_atomic_location(lk   Xo) a \<and> is_at_non_atomic_location(lk   Xo) b))) \<longrightarrow>
      (((a,b) \<in>(sb   Xo)) \<or> ((b,a) \<in>(sb   Xo)))))"



definition sbasw  :: " pre_execution \<Rightarrow>(action*action)set "  where 
     " sbasw Xo = ( trancl ((sb   Xo) \<union>(asw   Xo)))"


(* 7.22.3 p1 Each such allocation shall yield a pointer to an object disjoint from any other object.  (* CSEM *)
   When we are going to make a distinction between regions and objects we have to revise this           (* CSEM *)
   (7.22.3 p1 says that the objects do not overlap, so only unused parts of                             (* CSEM *)
   the malloced regions overlap and that might be not-racy. *)                                          (* CSEM *)
definition disjoint_allocs  :: "(action)set \<Rightarrow> bool "  where 
     " disjoint_allocs actions2 = (                                                                          (* CSEM *)
  ((\<forall> a \<in> actions2. \<forall> b \<in> actions2.  (is_alloc a \<and> (is_alloc b \<and> (loc_of a = loc_of b))) \<longrightarrow> a = b)))"
 (* CSEM *)

(*val well_formed_threads: (pre_execution * execution_witness * relation_list) -> bool*)
fun well_formed_threads  :: " pre_execution*execution_witness*relation_list \<Rightarrow> bool "  where 
     " well_formed_threads ((Xo,_,_)::(pre_execution * execution_witness * relation_list)) = (
    ((\<forall> a \<in>(actions0   Xo).  well_formed_action a)) \<and>    
(actions_respect_location_kinds(actions0   Xo)(lk   Xo) \<and>    
(blocking_observed(actions0   Xo)(sb   Xo) \<and>    
(inj_on aid_of(actions0   Xo) \<and>    
(relation_over(actions0   Xo)(sb   Xo) \<and>    
(relation_over(actions0   Xo)(asw   Xo) \<and>    
(threadwise(actions0   Xo)(sb   Xo) \<and>    
(interthread(actions0   Xo)(asw   Xo) \<and>    
(isStrictPartialOrder(sb   Xo) \<and>    
(isStrictPartialOrder(dd   Xo) \<and>
    (((dd   Xo) \<subseteq>(sb   Xo)) \<and>    
(indeterminate_sequencing Xo \<and>    
(irrefl (sbasw Xo) \<and>    
(finite_prefixes (sbasw Xo)(actions0   Xo)
    \<and> disjoint_allocs(actions0   Xo)))))))))))))))" 
declare well_formed_threads.simps [simp del]
 (* CSEM *)

(*
Conjuncts removed from above:


*)


definition pre_execution_mask  :: " pre_execution \<Rightarrow>(action)set \<Rightarrow> pre_execution "  where 
     " pre_execution_mask Xo A = (
  (let B = (A \<inter>(actions0   Xo)) in
  (| actions0 = B,
     threads =(threads   Xo),
     lk      =(lk   Xo),
     sb      = (relRestrict(sb   Xo) B),
     asw     = (relRestrict(asw   Xo) B),
     dd      = (relRestrict(dd   Xo) B)
  |)))"





definition replace_read_value  :: " action \<Rightarrow> cvalue_impl \<Rightarrow> action "  where 
     " replace_read_value a v = (
  (case  a of
    Lock        aid tid     loc out       => Lock aid tid loc Blocked
  | Unlock      aid tid     loc           => a
  | Load        aid tid ord loc rval      => Load aid tid ord loc v
  | Store       aid tid ord loc wval      => a
  | RMW         aid tid ord loc rval wval => RMW  aid tid ord loc v wval
  | Fence       aid tid ord               => a
  | Blocked_rmw aid tid     loc           => a
  ))"


(*val downclosed : forall . set (action) -> set (action * action) -> bool*)
definition
    downclosed  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow> bool "  where 
     "
    downclosed A R = (( \<forall> a.  \<forall> b.  ((b \<in> A) \<and> ((a,b) \<in> R)) \<longrightarrow> (a \<in> A)))"


definition is_prefix  :: "('a \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> 'a \<Rightarrow> pre_execution \<Rightarrow>(action)set \<Rightarrow> bool "  where 
     " is_prefix opsem p Xo A = (
  opsem p Xo \<and> ((A \<subseteq>(actions0   Xo)) \<and> (downclosed A (sbasw Xo) \<and> finite A)))"



definition fringe_set  :: " pre_execution \<Rightarrow>(action)set \<Rightarrow>(action)set "  where 
     " fringe_set Xo A = ( minimal_elements ((actions0   Xo) - A) (sbasw Xo))"




(*val relation_plug : forall. set (action * action) -> action -> action -> set (action * action)*)
definition
    relation_plug  :: "(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow>(action*action)set "  where 
     "
    relation_plug R a a' = (
  { (x,y) . (((x,y) \<in> R) \<and> (( ((\<lambda> x y .  \<not> (x = y))x a)) \<and> ( ((\<lambda> x y .  \<not> (x = y))y a)))) \<or>            
((((a,y) \<in> R) \<and> (( x = a') \<and> ( ((\<lambda> x y .  \<not> (x = y))y a)))) \<or>            
((((x,a) \<in> R) \<and> (( ((\<lambda> x y .  \<not> (x = y))x a)) \<and> ( y = a'))) \<or>
            (((a,a) \<in> R) \<and> (( x = a') \<and> ( y = a')))))
  })"




definition pre_execution_plug  :: " pre_execution \<Rightarrow> action \<Rightarrow> action \<Rightarrow> pre_execution "  where 
     " pre_execution_plug Xo a a' = (
  (| actions0 = (((actions0   Xo) - {a}) \<union> {a'}),
     threads =(threads   Xo),
     lk      =(lk   Xo),
     sb      = (relation_plug(sb   Xo) a a'),
     asw     = (relation_plug(asw   Xo) a a'),
     dd      = (relation_plug(dd   Xo) a a')
  |) )"




definition same_prefix  :: " pre_execution \<Rightarrow> pre_execution \<Rightarrow>(action)set \<Rightarrow> bool "  where 
     " same_prefix Xo1 Xo2 A = (
  (let AF = (A \<union> fringe_set Xo1 A) in
  ( (pre_execution_mask Xo1 AF) = (pre_execution_mask Xo2 AF)) \<and>
  (fringe_set Xo1 A = fringe_set Xo2 A)))"




(* For all subsets of actions in a pre_execution, If there is an sb minimal read, just outside the set, then we can rewrite its value if it is a read, and then find another pre_execution containing the set of actions, with the modified read still minimal and in the same thread. *)
(*val receptiveness : forall. (program -> pre_execution -> bool) -> bool*)
definition
    receptiveness  :: "(nat \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> bool "  where 
     "
    receptiveness opsem = ((
  \<forall> p. 
  \<forall> Xo. 
  \<forall> A. 
  \<forall> a.     
(is_prefix opsem p Xo A \<and>
    ((a \<in> fringe_set Xo A) \<and>
    (is_read a \<or> is_successful_lock a)))
    \<longrightarrow>    
((\<forall> v. 
      (let a' = (replace_read_value a v) in(
      \<exists> Xo'. 
        is_prefix opsem p Xo' A \<and>
        ((a' \<in> fringe_set Xo' A) \<and>
        same_prefix Xo' (pre_execution_plug Xo a a') A)))))))"




(* If some property holds for a chain of prefixes, growing at least by the fringe actions at each step, then it holds for some full Xo.

What about finite executions? Their fringe action sets become empty at some point *)

definition holds_over_prefix  :: "('a \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> 'a \<Rightarrow> pre_execution \<Rightarrow>(action)set \<Rightarrow>(pre_execution \<Rightarrow> bool)\<Rightarrow> bool "  where 
     " holds_over_prefix opsem p Xo A P = (
  is_prefix opsem p Xo A \<and> P (pre_execution_mask Xo A))"




(*val extends_prefix : forall. pre_execution -> set (action) -> set (action) -> bool*)
definition
    extends_prefix  :: " pre_execution \<Rightarrow>(action)set \<Rightarrow>(action)set \<Rightarrow> bool "  where 
     "
    extends_prefix Xo A A' = (
  (let fs = (fringe_set Xo A) in \<not> (fs = {}) \<and>  
((\<exists> fs'. 
    ((\<forall> a.  (a \<in> fs) \<longrightarrow> ((a \<in> fs') \<or> ((\<exists> v.  replace_read_value a v \<in> fs'))))) \<and>    
((A \<union> fs') \<subseteq> A')))))"





(* In proofs of the consistency predicate, I'll extend the total order to the set of fringe actions, value-change all reads accordingly, and then add them all. I can make all locks block by default too.

The above requires the fringe_set to be finite for tot_consistency and for inducting over the fringe. That is something I should make assumptions to satisfy (I will need to justify them). I would be requiring the number of sb unordered actions and the number of thread spawns between actions to be finite.
*)

(*val produce_well_formed_threads : forall. opsem_t -> bool*)
definition
    produce_well_formed_threads  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> bool "  where 
     "
    produce_well_formed_threads (opsem::opsem_t) = ((
    \<forall> Xo. 
    \<forall> p. ( \<exists> Xw.  \<exists> rl.  opsem p Xo \<longrightarrow> well_formed_threads (Xo,Xw,rl))))"





definition opsem_assumptions  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> bool "  where 
     " opsem_assumptions opsem = (
  receptiveness opsem \<and>
  produce_well_formed_threads opsem )"



(*********************************************** *)
(* 3 - Memory_Model simplified, single thread, no atomics *)
(*********************************************** *)


definition visible_side_effect_set  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " visible_side_effect_set actions2 hb = (
  set_filter
    (\<lambda> (a,b) . 
     (is_write a \<and>
        (is_read b \<and>
           ((loc_of a = loc_of b) \<and>
              \<not>
                (( \<exists> c \<in> actions2.
                   \<not> (c \<in> {a,b}) \<and>
                     (is_write c \<and>
                        ((loc_of c = loc_of b) \<and>
                           (((a,c) \<in> hb) \<and> ((c,b) \<in> hb))))))))))
    hb )"


(*val det_read: pre_execution * execution_witness * relation_list -> bool*)
fun det_read  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " det_read (Xo,Xw,([])) = ( undefined )"
|" det_read (Xo,Xw,(_ #([]))) = ( undefined )"
|" det_read (Xo,Xw,(_ #((s,vse)# _))) = ( 
  if(s = (''vse'')) then
    ((\<forall> r \<in>(actions0   Xo).
       is_load r \<longrightarrow>
         (((\<exists> w \<in>(actions0   Xo). (w,r) \<in> vse))
            \<longleftrightarrow>
            ((\<exists> w' \<in>(actions0   Xo). (w',r) \<in> (rf   Xw))))))
  else undefined )" 
declare det_read.simps [simp del]


(* Given consistent_hb, the following definition is equivalent. *)
(*val det_read_alt: pre_execution * execution_witness * relation_list -> bool*)
fun det_read_alt  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " det_read_alt (Xo,Xw,([])) = ( undefined )"
|" det_read_alt (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    ((\<forall> r \<in>(actions0   Xo).
       is_load r \<longrightarrow>
         (((\<exists> w \<in>(actions0   Xo).
             ((w,r) \<in> hb) \<and>
               (is_write w \<and> (loc_of w = loc_of r))))
            \<longleftrightarrow>
            ((\<exists> w' \<in>(actions0   Xo). (w',r) \<in> (rf   Xw))))))
  else undefined )" 
declare det_read_alt.simps [simp del]


(*val consistent_non_atomic_rf: pre_execution * execution_witness * relation_list -> bool*)
fun consistent_non_atomic_rf  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " consistent_non_atomic_rf (Xo,Xw,([])) = ( undefined )"
|" consistent_non_atomic_rf (Xo,Xw,(_ #([]))) = ( undefined )"
|" consistent_non_atomic_rf (Xo,Xw,(_ #((s,vse)# _))) = ( 
  if(s = (''vse'')) then
    ((\<forall> (w,r) \<in>(rf   Xw).
       is_at_non_atomic_location (lk   Xo) r \<longrightarrow>
         ((w,r) \<in> vse))) else undefined )" 
declare consistent_non_atomic_rf.simps [simp del]


(*val well_formed_rf: pre_execution * execution_witness * relation_list -> bool*)
fun well_formed_rf  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " well_formed_rf (Xo,Xw,_) = ((
    \<forall> (a,b) \<in>(rf   Xw).       
(a \<in>(actions0   Xo)) \<and> ((b \<in>(actions0   Xo)) \<and>
      ((loc_of a = loc_of b) \<and>      
(is_write a \<and> (is_read b \<and>
      ((value_read_by b = value_written_by a) \<and>      
((\<forall> a' \<in>(actions0   Xo).  ((a',b) \<in>(rf   Xw)) \<longrightarrow> a = a')))))))))" 
declare well_formed_rf.simps [simp del]


(*val sc_mo_lo_empty: pre_execution * execution_witness * relation_list -> bool*)
fun sc_mo_lo_empty  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_mo_lo_empty (_,Xw,_) = ( ((sc   Xw) = {}) \<and> (((mo   Xw) = {}) \<and> ((lo   Xw) = {})))" 
declare sc_mo_lo_empty.simps [simp del]


(*val sc_mo_empty: pre_execution * execution_witness * relation_list -> bool*)
fun sc_mo_empty  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_mo_empty (_,Xw,_) = ( ((sc   Xw) = {}) \<and> ((mo   Xw) = {}))" 
declare sc_mo_empty.simps [simp del]


(*val sc_empty: pre_execution * execution_witness * relation_list -> bool*)
fun sc_empty  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_empty (_,Xw,_) = ( (((sc   Xw) = {})))" 
declare sc_empty.simps [simp del]



(*val tot_empty: pre_execution * execution_witness * relation_list -> bool*)
fun tot_empty  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_empty (_,Xw,_) = ( (((tot   Xw) = {})))" 
declare tot_empty.simps [simp del]



definition single_thread_relations  :: " pre_execution \<Rightarrow> 'a \<Rightarrow>(string*(action*action)set)list "  where 
     " single_thread_relations Xo Xw = (
    (let hb    = ((sb   Xo)) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse) ])))"


definition single_thread_consistent_execution  :: " named_predicate_tree "  where 
     " single_thread_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''sc_mo_lo_empty''), Leaf sc_mo_lo_empty),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf) ]) ])"



(*********************************************** *)

(*val indeterminate_reads: candidate_execution -> set action*)
fun indeterminate_reads  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action)set "  where 
     " indeterminate_reads (Xo,Xw,_) = (
  set_filter
    (\<lambda> b .  (is_read b \<and>
                       \<not>
                         ((\<exists> a \<in>(actions0   Xo).
                            (a,b) \<in> (rf   Xw))))) (actions0   Xo) )" 
declare indeterminate_reads.simps [simp del]


(*val unsequenced_races: candidate_execution -> set (action * action)*)
fun unsequenced_races  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action*action)set "  where 
     " unsequenced_races (Xo,_,_) = (
  set_filter
    (\<lambda> (a,b) . 
     (is_at_non_atomic_location (lk   Xo) a \<and>
        (\<not> ( a = b) \<and>
           ((loc_of a = loc_of b) \<and>
              ((is_write a \<or> is_write b) \<and>
                 (( (tid_of a) = (tid_of b)) \<and>
                    \<not>
                      (((a,b) \<in> (sb   Xo)) \<or> ((b,a) \<in> (sb   Xo)))))))))
    ((actions0   Xo) \<times> (actions0   Xo)) )" 
declare unsequenced_races.simps [simp del]



definition single_thread_undefined_behaviour  :: "(fault_setgen)list "  where 
     " single_thread_undefined_behaviour = (
  [ Two ((''unsequenced_races''), unsequenced_races),
    One ((''indeterminate_reads''), indeterminate_reads) ])"


definition no_CK  :: " pre_execution \<Rightarrow> bool "  where 
     " no_CK Xo = ((                                   (* CSEM *)
  \<forall> a \<in>(actions0   Xo).  not_alloc_or_dealloc a))"
 (* CSEM *)


(*val single_thread_condition : forall. condition_t*)
definition single_thread_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " single_thread_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
  \<exists> b \<in>(actions0   Xo). ( \<forall> a \<in>(actions0   Xo). 
    ( (tid_of a) = (tid_of b)) \<and>
    (case  (loc_of a) of
      None   => False
    | Some l => ((lk   Xo) l = Non_Atomic) 
    )))))"


definition single_thread_memory_model  :: " memory_model "  where 
     " single_thread_memory_model = (
  (| consistent = single_thread_consistent_execution,
     relation_calculation = single_thread_relations,
     undefined0 = single_thread_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = False,
           sc_flag  = False,
           lo_flag  = False,
           tot_flag = False |)
  |) )"




(*val single_thread_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition single_thread_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " single_thread_behaviour opsem (p :: program) = (
  behaviour single_thread_memory_model single_thread_condition opsem p )"




(*********************************************** *)
(* 4 - Memory_Model simplified, multi-thread, no atomics, yes locks *)
(*********************************************** *)


definition locks_only_sw  :: " 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " locks_only_sw actions2 asw1 lo1 a b = (
  ( \<not> ((tid_of a) = (tid_of b))) \<and>
  (    
( (* thread sync *)(a,b) \<in> asw1) \<or>
    (* mutex sync *)
    (is_unlock a \<and> (is_lock b \<and> ((a,b) \<in> lo1)))
  ))"


definition locks_only_sw_set  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " locks_only_sw_set actions2 asw1 lo1 = (
  set_filter (\<lambda> (a,b) .  (locks_only_sw actions2 asw1 lo1 a b))
    (actions2 \<times> actions2) )"


(*val locks_only_sw_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition locks_only_sw_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " locks_only_sw_set_alt Xo Xw = (
  locks_only_sw_set(actions0   Xo)(asw   Xo)(lo   Xw))"


definition no_consume_hb  :: "('a*'a)set \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set "  where 
     " no_consume_hb sb1 sw = (
    trancl (sb1 \<union> sw))"


(*val locks_only_hb: pre_execution -> execution_witness -> set (action * action)*)
definition locks_only_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " locks_only_hb Xo Xw = (
  no_consume_hb(sb   Xo) (locks_only_sw_set_alt Xo Xw))"


(*val locks_only_vse: pre_execution -> execution_witness -> set (action * action)*)
definition locks_only_vse  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " locks_only_vse Xo Xw = (
  visible_side_effect_set(actions0   Xo) (locks_only_hb Xo Xw))"


definition locks_only_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " locks_only_relations Xo Xw = (
    (let sw    = (locks_only_sw_set(actions0   Xo)(asw   Xo)(lo   Xw)) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''sw''), sw) ]))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val locks_only_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition locks_only_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " locks_only_relations_alt Xo Xw = (
    [ ((''hb''), locks_only_hb Xo Xw),
      ((''vse''), locks_only_vse Xo Xw),
      ((''sw''), locks_only_sw_set_alt Xo Xw) ])"



fun locks_only_consistent_lo  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " locks_only_consistent_lo (Xo,Xw,([])) = ( undefined )"
|" locks_only_consistent_lo (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (relation_over (actions0   Xo) (lo   Xw) \<and>
       (trans (lo   Xw) \<and>
          (irrefl (lo   Xw) \<and>
             ((\<forall> a \<in>(actions0   Xo). \<forall> b \<in>(actions0   Xo).
                (((a,b) \<in> (lo   Xw)) \<longrightarrow>
                   \<not> ((b,a) \<in> hb)) \<and>
                  ( (((a,b) \<in> (lo   Xw)) \<or> ((b,a) \<in> (lo   Xw)))
                      \<longleftrightarrow>
                      ( (\<not> ( a = b)) \<and>
                          ((is_lock a \<or> is_unlock a) \<and>
                             ((is_lock b \<or> is_unlock b) \<and>
                                ((loc_of a = loc_of b) \<and>
                                   is_at_mutex_location (lk   Xo) a))) ) ))))))
  else undefined )" 
declare locks_only_consistent_lo.simps [simp del]



(*val locks_only_consistent_locks: pre_execution * execution_witness * relation_list -> bool*)
fun locks_only_consistent_locks  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " locks_only_consistent_locks (Xo,Xw,_) = (
    ((\<forall> (a,c) \<in>(lo   Xw).       
 (is_successful_lock a \<and> is_successful_lock c)
      \<longrightarrow> 
      ((\<exists> b \<in>(actions0   Xo).  is_unlock b \<and> (((a,b) \<in>(lo   Xw)) \<and> ((b,c) \<in>(lo   Xw))))))))" 
declare locks_only_consistent_locks.simps [simp del]



(*val consistent_hb: pre_execution * execution_witness * relation_list -> bool*)
fun consistent_hb  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " consistent_hb (Xo,_,([])) = ( undefined )"
|" consistent_hb (Xo,_,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (irrefl (trancl hb) \<and> finite_prefixes hb (actions0   Xo)) else
    undefined )" 
declare consistent_hb.simps [simp del]



definition locks_only_consistent_execution  :: " named_predicate_tree "  where 
     " locks_only_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''sc_mo_empty''), Leaf sc_mo_empty),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf) ]) ])"



(*********************************************** *)

definition locks_only_good_mutex_use  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> bool "  where 
     " locks_only_good_mutex_use actions2 lk1 sb1 lo1 a = (
    (* violated requirement: The calling thread shall own the mutex. *)
    ( is_unlock a
      \<longrightarrow>
      (( \<exists> al \<in> actions2. 
          is_successful_lock al \<and> (((al,a) \<in> sb1) \<and> (((al,a) \<in> lo1) \<and>          
((\<forall> au \<in> actions2. 
            is_unlock au \<longrightarrow> \<not> (((al,au) \<in> lo1) \<and> ((au,a) \<in> lo1)))))))
        )
    ) \<and>
    (* violated requirement: The calling thread does not own the mutex. *)
    ( is_lock a
      \<longrightarrow>      
((\<forall> al \<in> actions2.         
(is_successful_lock al \<and> (((al,a) \<in> sb1) \<and> ((al,a) \<in> lo1)))
        \<longrightarrow>        
((\<exists> au \<in> actions2. 
          is_unlock au \<and> (((al,au) \<in> lo1) \<and> ((au,a) \<in> lo1))))))
    ))"


(*val locks_only_bad_mutexes: candidate_execution -> set action*)
fun locks_only_bad_mutexes  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action)set "  where 
     " locks_only_bad_mutexes (Xo,Xw,_) = (
  set_filter
    (\<lambda> a . 
     (\<not>
        (locks_only_good_mutex_use (actions0   Xo) (lk   Xo) (sb   Xo)
           (lo   Xw) a))) (actions0   Xo) )" 
declare locks_only_bad_mutexes.simps [simp del]



(*val data_races: candidate_execution -> set (action * action)*)
fun data_races  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action*action)set "  where 
     " data_races (Xo,_,([])) = ( undefined )"
|" data_races (Xo,_,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (set_filter
       (\<lambda> (a,b) . 
        (\<not> ( a = b) \<and>
           ((loc_of a = loc_of b) \<and>
              ((is_write a \<or> is_write b) \<and>
                 (( \<not> ((tid_of a) = (tid_of b))) \<and>
                    (\<not> (is_atomic_action a \<and> is_atomic_action b)
                       \<and>
                       \<not> (((a,b) \<in> hb) \<or> ((b,a) \<in> hb))))))))
       ((actions0   Xo) \<times> (actions0   Xo))) else undefined )" 
declare data_races.simps [simp del]



definition locks_only_undefined_behaviour  :: "(fault_setgen)list "  where 
     " locks_only_undefined_behaviour = (
  [ Two ((''unsequenced_races''), unsequenced_races),
    Two ((''data_races''), data_races),
    One ((''indeterminate_reads''), indeterminate_reads),
    One ((''locks_only_bad_mutexes''), locks_only_bad_mutexes) ])"


(*val locks_only_undefined_behaviour_alt: candidate_execution -> list undefinedness*)
definition locks_only_undefined_behaviour_alt  :: " pre_execution*execution_witness*relation_list \<Rightarrow>(undefinedness)list "  where 
     " locks_only_undefined_behaviour_alt ex = (
  (let unseq_races = (unsequenced_races ex) in
  (let data_races1 = (data_races ex) in
  (let indet_reads = (indeterminate_reads ex) in
  (let bad_mutexes = (locks_only_bad_mutexes ex) in
    if \<not> ((unseq_races = {})) then
      [UnsequencedRaces unseq_races]
    else
      []
  @    
(if \<not> ((data_races1 = {})) then
      [DataRaces data_races1]
    else 
      []
  @    
(if \<not> ((indet_reads = {})) then
      [IndeterminateReads indet_reads]
    else
      []
  @    
(if \<not> ((bad_mutexes = {})) then
      [BadMutexes bad_mutexes]
    else
      []))))))))"



(*********************************************** *)


(*val locks_only_condition : forall. condition_t*)
definition locks_only_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " locks_only_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  (loc_of a) of
        None   => False
      | Some l => ((lk   Xo) l \<in> {Mutex,Non_Atomic}) 
      ))))"


definition locks_only_memory_model  :: " memory_model "  where 
     " locks_only_memory_model = (
  (| consistent = locks_only_consistent_execution,
     relation_calculation = locks_only_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = False,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"


(*val locks_only_behaviour : forall . opsem_t -> program -> program_behaviours*)
definition locks_only_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " locks_only_behaviour opsem (p :: program) = (
  behaviour locks_only_memory_model locks_only_condition opsem p )"



(*********************************************** *)
(* 5 - relaxed - memory_model simplified for programs without sc,
consumes, release or acquire *)
(*********************************************** *)


(*val consistent_atomic_rf: pre_execution * execution_witness * relation_list -> bool*)
fun consistent_atomic_rf  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " consistent_atomic_rf (Xo,Xw,([])) = ( undefined )"
|" consistent_atomic_rf (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    ((\<forall> (w,r) \<in>(rf   Xw).
       (is_at_atomic_location (lk   Xo) r \<and> is_load r) \<longrightarrow>
         \<not> ((r,w) \<in> hb))) else undefined )" 
declare consistent_atomic_rf.simps [simp del]


(*val rmw_atomicity: pre_execution * execution_witness * relation_list -> bool*)
fun rmw_atomicity  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " rmw_atomicity (Xo,Xw,_) = ((
    \<forall> b \<in>(actions0   Xo). 
    \<forall> a \<in>(actions0   Xo). 
      is_RMW b \<longrightarrow> (adjacent_less_than(mo   Xw)(actions0   Xo) a b \<longleftrightarrow> ((a,b) \<in>(rf   Xw)))))" 
declare rmw_atomicity.simps [simp del]



(*val coherent_memory_use: pre_execution * execution_witness * relation_list -> bool*)
fun coherent_memory_use  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " coherent_memory_use (Xo,Xw,([])) = ( undefined )"
|" coherent_memory_use (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (( \<not>
         (( \<exists> (a,b) \<in>(rf   Xw). \<exists> (c,d) \<in>(rf   Xw).
            ((b,d) \<in> hb) \<and> ((c,a) \<in> (mo   Xw))) ) ) \<and>
       (
       (* CoWR *) ( \<not>
                      (( \<exists> (a,b) \<in>(rf   Xw). \<exists> c \<in>(actions0   Xo).
                         ((c,b) \<in> hb) \<and> ((a,c) \<in> (mo   Xw))) ) )
         \<and>
         (
         (* CoRW *) ( \<not>
                        (( \<exists> (a,b) \<in>(rf   Xw). \<exists> c \<in>(actions0   Xo).
                           ((b,c) \<in> hb) \<and> ((c,a) \<in> (mo   Xw))) ) )
           \<and>
           (* CoWW *)
           ( \<not> ((\<exists> (a,b) \<in> hb. (b,a) \<in> (mo   Xw))) ))))
  else undefined )" 
declare coherent_memory_use.simps [simp del]



(*val consistent_mo: pre_execution * execution_witness * relation_list -> bool*)
fun consistent_mo  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " consistent_mo (Xo,Xw,_) = (
    relation_over(actions0   Xo)(mo   Xw) \<and>    
(trans(mo   Xw) \<and>    
(irrefl(mo   Xw) \<and>    
((\<forall> a \<in>(actions0   Xo). \<forall> b \<in>(actions0   Xo). 
      (((a,b) \<in>(mo   Xw)) \<or> ((b,a) \<in>(mo   Xw)))
      \<longleftrightarrow> ( (\<not> ( a = b)) \<and>          
(is_write a \<and> (is_write b \<and>          
((loc_of a = loc_of b) \<and>
          is_at_atomic_location(lk   Xo) a))) ))))))" 
declare consistent_mo.simps [simp del]



definition relaxed_only_consistent_execution  :: " named_predicate_tree "  where 
     " relaxed_only_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''sc_empty''), Leaf sc_empty),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity) ]) ])"



(*val relaxed_only_condition : forall. condition_t*)
definition relaxed_only_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " relaxed_only_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => mo1 \<in> {NA,Relaxed}
      | Store _ _ mo1 _ _        => mo1 \<in> {NA,Relaxed}
      | RMW _ _ mo1 _ _ _        => mo1 \<in> {Relaxed}
      | Fence _ _ _             => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



(*********************************************** *)


definition relaxed_only_memory_model  :: " memory_model "  where 
     " relaxed_only_memory_model = (
  (| consistent = relaxed_only_consistent_execution,
     relation_calculation = locks_only_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val relaxed_only_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition relaxed_only_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " relaxed_only_behaviour opsem (p :: program) = (
  behaviour relaxed_only_memory_model relaxed_only_condition opsem p )"




(*********************************************** *)
(* 66 - release acquire - memory_model simplified for programs without sc,
consumes or relaxed *)
(*********************************************** *)

(* Unused in this model currently, causes me to encounter the non-atomic LB writes problem, which can be solved for the simpler model. *)
(*val release_acquire_coherent_memory_use: pre_execution * execution_witness * relation_list -> bool*)
fun release_acquire_coherent_memory_use  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " release_acquire_coherent_memory_use (Xo,Xw,([])) = ( undefined )"
|" release_acquire_coherent_memory_use (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (( \<not>
         (( \<exists> (a,b) \<in>(rf   Xw). \<exists> c \<in>(actions0   Xo).
            ((c,b) \<in> hb) \<and> ((a,c) \<in> (mo   Xw))) ) ) \<and>
       (* CoWW *)
       ( \<not> ((\<exists> (a,b) \<in> hb. (b,a) \<in> (mo   Xw))) )) else
    undefined )" 
declare release_acquire_coherent_memory_use.simps [simp del]



(*val atomic_initialisation_first: pre_execution * execution_witness * relation_list -> bool*)
fun atomic_initialisation_first  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " atomic_initialisation_first (Xo,_,_) = ((
  \<forall> a \<in>(actions0   Xo). 
  \<forall> b \<in>(actions0   Xo).     
(is_at_atomic_location(lk   Xo) a \<and> (is_NA_store a \<and>    
(is_write b \<and> ((loc_of a = loc_of b) \<and> ( ((\<lambda> x y .  \<not> (x = y))a b)))))) \<longrightarrow>    
(((a,b) \<in> trancl ((sb   Xo) \<union>(asw   Xo))) \<and> \<not> (is_NA_store b))))" 
declare atomic_initialisation_first.simps [simp del]



(*val release_acquire_condition : forall. condition_t*)
definition release_acquire_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. 
    atomic_initialisation_first (Xo,Xw,rl) \<and>    
((\<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release})
      | RMW _ _ mo1 _ _ _        => mo1 = Acq_rel
      | Fence _ _ _             => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      )))))"



definition release_acquire_synchronizes_with  :: " 'a \<Rightarrow> 'b \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " release_acquire_synchronizes_with actions2 sb1 asw1 rf1 lo1 a b = (
  ( \<not> ((tid_of a) = (tid_of b))) \<and>
  (    
( (* thread sync *)(a,b) \<in> asw1) \<or>    
(
    (* mutex sync *)(is_unlock a \<and> (is_lock b \<and> ((a,b) \<in> lo1))) \<or>
    (* rel/acq sync *)
    ( is_release a \<and> (is_acquire b \<and> ((a,b) \<in> rf1)) ))
  ))"


definition release_acquire_synchronizes_with_set  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " release_acquire_synchronizes_with_set actions2 sb1 asw1 rf1 lo1 = (
  set_filter
    (\<lambda> (a,b) . 
     (release_acquire_synchronizes_with actions2 sb1 asw1 rf1 lo1 a b))
    (actions2 \<times> actions2) )"


(*val sw_asw: pre_execution -> set (action * action)*)
definition sw_asw  :: " pre_execution \<Rightarrow>(action*action)set "  where 
     " sw_asw Xo = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
((a, b) \<in>(asw   Xo))))})"


(*val sw_lock: pre_execution -> execution_witness -> set (action * action)*)
definition sw_lock  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_lock Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_unlock a \<and> (is_lock b \<and> ((a,b) \<in>(lo   Xw))))))})"


(*val sw_rel_acq: pre_execution -> execution_witness -> set (action * action)*)
definition sw_rel_acq  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_rel_acq Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_release a \<and> (is_acquire b \<and> ((a,b) \<in>(rf   Xw))))))})"


(*val release_acquire_synchronizes_with_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_synchronizes_with_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_synchronizes_with_set_alt Xo Xw = (  
((sw_asw Xo) \<union> (sw_lock Xo Xw)) \<union> (sw_rel_acq Xo Xw))"


(*val release_acquire_hb: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_hb Xo Xw = (
  no_consume_hb(sb   Xo) (release_acquire_synchronizes_with_set_alt Xo Xw))"


(*val release_acquire_vse: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_vse  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_vse Xo Xw = (
  visible_side_effect_set(actions0   Xo) (release_acquire_hb Xo Xw))"


definition release_acquire_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_relations Xo Xw = (
    (let sw    = (release_acquire_synchronizes_with_set(actions0  
                  Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw)) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''sw''), sw) ]))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val release_acquire_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition release_acquire_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_relations_alt Xo Xw = (
    [ ((''hb''), release_acquire_hb Xo Xw),
      ((''vse''), release_acquire_vse Xo Xw),
      ((''sw''), release_acquire_synchronizes_with_set_alt Xo Xw) ])"



(*********************************************** *)


(* Unused currently, see R/A coherence above *)
definition release_acquire_consistent_execution  :: " named_predicate_tree "  where 
     " release_acquire_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''sc_empty''), Leaf sc_empty),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''release_acquire_coherent_memory_use''), Leaf release_acquire_coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity) ]) ])"



definition release_acquire_memory_model  :: " memory_model "  where 
     " release_acquire_memory_model = (
  (| consistent = relaxed_only_consistent_execution,
     relation_calculation = release_acquire_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val release_acquire_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition release_acquire_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " release_acquire_behaviour opsem (p :: program) = (
  behaviour release_acquire_memory_model release_acquire_condition opsem p )"




(*********************************************** *)
(* 7 - release_acquire_relaxed - memory_model simplified for programs without sc or
consumes *)
(*********************************************** *)


(*val release_acquire_relaxed_condition : forall. condition_t*)
definition release_acquire_relaxed_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_relaxed_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire,Relaxed})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release,Relaxed})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Acq_rel,Acquire,Release,Relaxed})
      | Fence _ _ _             => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



definition release_acquire_relaxed_synchronizes_with  :: " 'a set \<Rightarrow> 'b \<Rightarrow>(action*action)set \<Rightarrow>('a*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*'a)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " release_acquire_relaxed_synchronizes_with actions2 sb1 asw1 rf1 lo1 rs a b = (
  ( \<not> ((tid_of a) = (tid_of b))) \<and>
  (    
( (* thread sync *)(a,b) \<in> asw1) \<or>    
(
    (* mutex sync *)(is_unlock a \<and> (is_lock b \<and> ((a,b) \<in> lo1))) \<or>
    (* rel/acq sync *)
    ( is_release a \<and> (is_acquire b \<and>
      ((\<exists> c \<in> actions2.  ((a,c) \<in> rs) \<and> ((c,b) \<in> rf1)))) ))
  ))"


definition release_acquire_relaxed_synchronizes_with_set  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " release_acquire_relaxed_synchronizes_with_set actions2 sb1 asw1 rf1 lo1 rs = (
  set_filter
    (\<lambda> (a,b) . 
     (release_acquire_relaxed_synchronizes_with actions2 sb1 asw1 rf1 
      lo1 rs a b)) (actions2 \<times> actions2) )"


definition rs_element  :: " action \<Rightarrow> action \<Rightarrow> bool "  where 
     " rs_element head a = (
    ( (tid_of a) = (tid_of head)) \<or> is_RMW a )"


definition release_sequence_set  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " release_sequence_set actions2 lk1 mo1 = (
  set_filter
    (\<lambda> (rel,b) . 
     (is_release rel \<and>
        ( ( b = rel) \<or>
            ( ((rel,b) \<in> mo1) \<and>
                (rs_element rel b \<and>
                   ((\<forall> c \<in> actions2.
                      (((rel,c) \<in> mo1) \<and> ((c,b) \<in> mo1))
                        \<longrightarrow> rs_element rel c))) ) )))
    (actions2 \<times> actions2) )"


(*val release_sequence_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition release_sequence_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_sequence_set_alt Xo Xw = (
  release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw))"


(*val sw_rel_acq_rs: pre_execution -> execution_witness -> set (action * action)*)
definition sw_rel_acq_rs  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_rel_acq_rs Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_release a \<and> (is_acquire b \<and> 
                         ((\<exists> c \<in>(actions0   Xo).  ((a,c) \<in> release_sequence_set_alt Xo Xw) \<and>                                                    
 ((c,b) \<in>(rf   Xw))))))))})"


(*val release_acquire_relaxed_synchronizes_with_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_relaxed_synchronizes_with_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_relaxed_synchronizes_with_set_alt Xo Xw = (  
((sw_asw Xo) \<union> (sw_lock Xo Xw)) \<union> (sw_rel_acq_rs Xo Xw))"


(*val release_acquire_relaxed_hb: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_relaxed_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_relaxed_hb Xo Xw = (
  no_consume_hb(sb   Xo) (release_acquire_relaxed_synchronizes_with_set_alt Xo Xw))"


(*val release_acquire_relaxed_vse: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_relaxed_vse  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_relaxed_vse Xo Xw = (
  visible_side_effect_set(actions0   Xo) (release_acquire_relaxed_hb Xo Xw))"


definition release_acquire_relaxed_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_relaxed_relations Xo Xw = (
    (let rs    = (release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let sw    = (release_acquire_relaxed_synchronizes_with_set(actions0   Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw) rs) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''sw''), sw),
      ((''rs''), rs) ])))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val release_acquire_relaxed_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition release_acquire_relaxed_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_relaxed_relations_alt Xo Xw = (
    [ ((''hb''), release_acquire_relaxed_hb Xo Xw),
      ((''vse''), release_acquire_relaxed_vse Xo Xw),
      ((''sw''), release_acquire_relaxed_synchronizes_with_set_alt Xo Xw),
      ((''rs''), release_sequence_set_alt Xo Xw) ])"



(*********************************************** *)


definition release_acquire_relaxed_memory_model  :: " memory_model "  where 
     " release_acquire_relaxed_memory_model = (
  (| consistent = relaxed_only_consistent_execution,
     relation_calculation = release_acquire_relaxed_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val release_acquire_relaxed_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition release_acquire_relaxed_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " release_acquire_relaxed_behaviour opsem (p :: program) = (
  behaviour release_acquire_relaxed_memory_model release_acquire_relaxed_condition opsem p )"





(*********************************************** *)
(* 8 - release_acquire_fenced *)
(*********************************************** *)


(*val release_acquire_fenced_condition : forall. condition_t*)
definition release_acquire_fenced_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_fenced_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire,Relaxed})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release,Relaxed})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Acq_rel,Acquire,Release,Relaxed})
      | Fence _ _ mo1            => (mo1 \<in> {Release,Acquire,Relaxed})
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



definition release_acquire_fenced_synchronizes_with  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " release_acquire_fenced_synchronizes_with actions2 sb1 asw1 rf1 lo1 rs hrs a b = (
  ( \<not> ((tid_of a) = (tid_of b))) \<and>
  (    
( (* thread sync *)(a,b) \<in> asw1) \<or>    
(
    (* mutex sync *)(is_unlock a \<and> (is_lock b \<and> ((a,b) \<in> lo1))) \<or>    
(
    (* rel/acq sync *)( is_release a \<and> (is_acquire b \<and>
      ((\<exists> c \<in> actions2.  ((a,c) \<in> rs) \<and> ((c,b) \<in> rf1)))) ) \<or>    
(
    (* fence synchronisation *)( is_fence a \<and> (is_release a \<and> (is_fence b \<and> (is_acquire b \<and>      
((\<exists> x \<in> actions2. \<exists> z \<in> actions2. \<exists> y \<in> actions2.         
((a,x) \<in> sb1) \<and> (((x,z) \<in> hrs) \<and> (((z,y) \<in> rf1) \<and> ((y,b) \<in> sb1))))))))) \<or>    
(( is_fence a \<and> (is_release a \<and> (is_acquire b \<and>      
((\<exists> x \<in> actions2. \<exists> y \<in> actions2.           
((a,x) \<in> sb1) \<and> (((x,y) \<in> hrs) \<and> ((y,b) \<in> rf1)))))) ) \<or>
    ( is_release a \<and> (is_fence b \<and> (is_acquire b \<and>      
((\<exists> y \<in> actions2. \<exists> x \<in> actions2.         
((a,y) \<in> rs) \<and> (((y,x) \<in> rf1) \<and> ((x,b) \<in> sb1))))))))))) ))"


definition release_acquire_fenced_synchronizes_with_set  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " release_acquire_fenced_synchronizes_with_set actions2 sb1 asw1 rf1 lo1 rs hrs = (
  set_filter
    (\<lambda> (a,b) . 
     (release_acquire_fenced_synchronizes_with actions2 sb1 asw1 rf1 
      lo1 rs hrs a b)) (actions2 \<times> actions2) )"


definition hypothetical_release_sequence_set  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " hypothetical_release_sequence_set actions2 lk1 mo1 = (
  set_filter
    (\<lambda> (a,b) . 
     (is_atomic_action a \<and>
        (is_write a \<and>
           ( ( b = a) \<or>
               ( ((a,b) \<in> mo1) \<and>
                   (rs_element a b \<and>
                      ((\<forall> c \<in> actions2.
                         (((a,c) \<in> mo1) \<and> ((c,b) \<in> mo1))
                           \<longrightarrow> rs_element a c))) ) ))))
    (actions2 \<times> actions2) )"


(*val hypothetical_release_sequence_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition hypothetical_release_sequence_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " hypothetical_release_sequence_set_alt Xo Xw = (
  hypothetical_release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw))"


(*val sw_fence_sb_hrs_rf_sb: pre_execution -> execution_witness -> set (action * action)*)
definition sw_fence_sb_hrs_rf_sb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_fence_sb_hrs_rf_sb Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_fence a \<and> (is_release a \<and> (is_fence b \<and> (is_acquire b \<and>
                         ((\<exists> x \<in>(actions0   Xo). \<exists> y \<in>(actions0   Xo). \<exists> z \<in>(actions0   Xo).                            
((a,x) \<in>(sb   Xo)) \<and> 
                           (((x,y) \<in> hypothetical_release_sequence_set_alt Xo Xw) \<and> 
                           (((y,z) \<in>(rf   Xw)) \<and>                           
 ((z,b) \<in>(sb   Xo))))))))))))})"


(*val sw_fence_sb_hrs_rf: pre_execution -> execution_witness -> set (action * action)*)
definition sw_fence_sb_hrs_rf  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_fence_sb_hrs_rf Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_fence a \<and> (is_release a \<and> (is_acquire b \<and>
                         ((\<exists> x \<in>(actions0   Xo). \<exists> y \<in>(actions0   Xo).                            
((a,x) \<in>(sb   Xo)) \<and> 
                           (((x,y) \<in> hypothetical_release_sequence_set_alt Xo Xw) \<and>                           
 ((y,b) \<in>(rf   Xw))))))))))})"


(*val sw_fence_rs_rf_sb: pre_execution -> execution_witness -> set (action * action)*)
definition sw_fence_rs_rf_sb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sw_fence_rs_rf_sb Xo Xw = (
  {(a, b)   . (a \<in>(actions0   Xo)) \<and> 
                         ((b \<in>(actions0   Xo)) \<and> (\<not> ((tid_of a) = (tid_of b)) \<and>                         
(is_release a \<and> (is_fence b \<and> (is_acquire b \<and>
                         ((\<exists> x \<in>(actions0   Xo). \<exists> y \<in>(actions0   Xo).                            
((a,x) \<in> release_sequence_set_alt Xo Xw) \<and> 
                           (((x,y) \<in>(rf   Xw)) \<and>                           
 ((y,b) \<in>(sb   Xo))))))))))})"


(*val release_acquire_fenced_synchronizes_with_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_fenced_synchronizes_with_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_fenced_synchronizes_with_set_alt Xo Xw = (
  (((((sw_asw Xo) \<union> (sw_lock Xo Xw)) \<union> (sw_rel_acq_rs Xo Xw)) \<union>
  (sw_fence_sb_hrs_rf_sb Xo Xw)) \<union> (sw_fence_sb_hrs_rf Xo Xw)) \<union> (sw_fence_rs_rf_sb Xo Xw))"


(*val release_acquire_fenced_hb: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_fenced_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_fenced_hb Xo Xw = (
  no_consume_hb(sb   Xo) (release_acquire_fenced_synchronizes_with_set_alt Xo Xw))"


(*val release_acquire_fenced_vse: pre_execution -> execution_witness -> set (action * action)*)
definition release_acquire_fenced_vse  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " release_acquire_fenced_vse Xo Xw = (
  visible_side_effect_set(actions0   Xo) (release_acquire_fenced_hb Xo Xw))"


(*val release_acquire_fenced_relations: pre_execution -> execution_witness -> relation_list*)
definition release_acquire_fenced_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_fenced_relations Xo Xw = (
    (let hrs   = (hypothetical_release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let rs    = (release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let sw    = (release_acquire_fenced_synchronizes_with_set(actions0   Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw) rs hrs) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''sw''), sw),
      ((''rs''), rs),
      ((''hrs''), hrs) ]))))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val release_acquire_fenced_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition release_acquire_fenced_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_fenced_relations_alt Xo Xw = (
    [ ((''hb''), release_acquire_fenced_hb Xo Xw),
      ((''vse''), release_acquire_fenced_vse Xo Xw),
      ((''sw''), release_acquire_fenced_synchronizes_with_set_alt Xo Xw),
      ((''rs''), release_sequence_set_alt Xo Xw),
      ((''hrs''), hypothetical_release_sequence_set_alt Xo Xw) ])"



(*********************************************** *)


definition release_acquire_fenced_memory_model  :: " memory_model "  where 
     " release_acquire_fenced_memory_model = (
  (| consistent = relaxed_only_consistent_execution,
     relation_calculation = release_acquire_fenced_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val release_acquire_fenced_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition release_acquire_fenced_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " release_acquire_fenced_behaviour opsem (p :: program) = (
  behaviour release_acquire_fenced_memory_model release_acquire_fenced_condition opsem p )"




(*********************************************** *)
(* 9 - sc, no sc fences *)
(*********************************************** *)


(*val sc_accesses_condition : forall. condition_t*)
definition sc_accesses_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " sc_accesses_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire,Relaxed,Seq_cst})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release,Relaxed,Seq_cst})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Acq_rel,Acquire,Release,Relaxed,Seq_cst})
      | Fence _ _ mo1            => (mo1 \<in> {Release,Acquire,Relaxed})
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



(*val sc_accesses_consistent_sc: pre_execution * execution_witness * relation_list -> bool*)
fun sc_accesses_consistent_sc  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_accesses_consistent_sc (Xo,Xw,([])) = ( undefined )"
|" sc_accesses_consistent_sc (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (relation_over (actions0   Xo) (sc   Xw) \<and>
       (trans (sc   Xw) \<and>
          (irrefl (sc   Xw) \<and>
             ((\<forall> a \<in>(actions0   Xo). \<forall> b \<in>(actions0   Xo).
                (((a,b) \<in> (sc   Xw)) \<longrightarrow>
                   \<not> ((b,a) \<in> (hb \<union> (mo   Xw)))) \<and>
                  ( (((a,b) \<in> (sc   Xw)) \<or> ((b,a) \<in> (sc   Xw)))
                      \<longleftrightarrow>
                      ( (\<not> ( a = b)) \<and>
                          (is_seq_cst a \<and> is_seq_cst b)) )))))) else
    undefined )" 
declare sc_accesses_consistent_sc.simps [simp del]



(*val sc_accesses_sc_reads_restricted: pre_execution * execution_witness * relation_list -> bool*)
fun sc_accesses_sc_reads_restricted  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_accesses_sc_reads_restricted (Xo,Xw,([])) = ( undefined )"
|" sc_accesses_sc_reads_restricted (Xo,Xw,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    ((\<forall> (w,r) \<in>(rf   Xw).
       is_seq_cst r \<longrightarrow>
         (( is_seq_cst w \<and>
              (((w,r) \<in> (sc   Xw)) \<and>
                 \<not>
                   ((\<exists> w' \<in>(actions0   Xo).
                      is_write w' \<and>
                        ((loc_of w = loc_of w') \<and>
                           (((w,w') \<in> (sc   Xw)) \<and>
                              ((w',r) \<in> (sc   Xw))))) )) ) \<or>
            ( \<not> (is_seq_cst w) \<and>
                \<not>
                  ((\<exists> w' \<in>(actions0   Xo).
                     is_write w' \<and>
                       ((loc_of w = loc_of w') \<and>
                          (((w,w') \<in> hb) \<and> ((w',r) \<in> (sc   Xw))))) ) ))))
  else undefined )" 
declare sc_accesses_sc_reads_restricted.simps [simp del]



definition sc_accesses_consistent_execution  :: " named_predicate_tree "  where 
     " sc_accesses_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''sc_accesses_consistent_sc''), Leaf sc_accesses_consistent_sc),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity),
                  ((''sc_accesses_sc_reads_restricted''), Leaf sc_accesses_sc_reads_restricted) ]) ])"



(*********************************************** *)


definition sc_accesses_memory_model  :: " memory_model "  where 
     " sc_accesses_memory_model = (
  (| consistent = sc_accesses_consistent_execution,
     relation_calculation = release_acquire_fenced_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val sc_accesses_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition sc_accesses_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " sc_accesses_behaviour opsem (p :: program) = (
  behaviour sc_accesses_memory_model sc_accesses_condition opsem p )"




(*********************************************** *)
(* 10 - sc_fences, no consume *)
(*********************************************** *)


(*val sc_fenced_condition : forall. condition_t*)
definition sc_fenced_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " sc_fenced_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire,Relaxed,Seq_cst})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release,Relaxed,Seq_cst})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Acq_rel,Acquire,Release,Relaxed,Seq_cst})
      | Fence _ _ mo1            => (mo1 \<in> {Release,Acquire,Relaxed,Seq_cst})
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



(*val sc_fenced_sc_fences_heeded: pre_execution * execution_witness * relation_list -> bool*)
fun sc_fenced_sc_fences_heeded  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " sc_fenced_sc_fences_heeded (Xo,Xw,_) = ((
    \<forall> f \<in>(actions0   Xo). 
    \<forall> f' \<in>(actions0   Xo). 
    \<forall> 
           r \<in>(actions0   Xo). 
    \<forall>
           w \<in>(actions0   Xo). 
    \<forall> w' \<in>(actions0   Xo). 
      \<not> ( is_fence f \<and> (is_fence f' \<and>
            ( (* fence restriction N3291 29.3p4 *)
              ( ((w,w') \<in>(mo   Xw)) \<and>
                (((w',f) \<in>(sc   Xw)) \<and>
                (((f,r)  \<in>(sb   Xo)) \<and>                
((w,r)  \<in>(rf   Xw)))) ) \<or>              
(
              (* fence restriction N3291 29.3p5 *)( ((w,w') \<in>(mo   Xw)) \<and>
                (((w',f) \<in>(sb   Xo)) \<and>
                (((f,r)  \<in>(sc   Xw)) \<and>                
((w,r)  \<in>(rf   Xw)))) ) \<or>              
(
              (* fence restriction N3291 29.3p6 *)( ((w,w') \<in>(mo   Xw)) \<and>
                (((w',f) \<in>(sb   Xo)) \<and>
                (((f,f') \<in>(sc   Xw)) \<and>
                (((f',r) \<in>(sb   Xo)) \<and>                
((w,r)  \<in>(rf   Xw))))) ) \<or>              
(
              (* SC fences impose mo N3291 29.3p7 *)( ((w',f) \<in>(sb   Xo)) \<and>
                (((f,f') \<in>(sc   Xw)) \<and>
                (((f',w) \<in>(sb   Xo)) \<and>                
((w,w') \<in>(mo   Xw)))) ) \<or>              
(
              (* N3291 29.3p7, w collapsed first write*)( ((w',f) \<in>(sc   Xw)) \<and>
                (((f,w)  \<in>(sb   Xo)) \<and>                
((w,w') \<in>(mo   Xw))) ) \<or>
              (* N3291 29.3p7, w collapsed second write*)
              ( ((w',f) \<in>(sb   Xo)) \<and>
                (((f,w)  \<in>(sc   Xw)) \<and>                
((w,w') \<in>(mo   Xw))) ))))) )) )))" 
declare sc_fenced_sc_fences_heeded.simps [simp del]


definition sc_fenced_consistent_execution  :: " named_predicate_tree "  where 
     " sc_fenced_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''sc_accesses_consistent_sc''), Leaf sc_accesses_consistent_sc),
         ((''sc_fenced_sc_fences_heeded''), Leaf sc_fenced_sc_fences_heeded),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity),
                  ((''sc_accesses_sc_reads_restricted''), Leaf sc_accesses_sc_reads_restricted) ]) ])"



(*********************************************** *)

definition sc_fenced_memory_model  :: " memory_model "  where 
     " sc_fenced_memory_model = (
  (| consistent = sc_fenced_consistent_execution,
     relation_calculation = release_acquire_fenced_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val sc_fenced_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition sc_fenced_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " sc_fenced_behaviour opsem (p :: program) = (
  behaviour sc_fenced_memory_model sc_fenced_condition opsem p )"





(*********************************************** *)
(* 11 - with consume *)
(*********************************************** *)

(*val with_consume_condition : forall. condition_t*)

(* For backward compatibility we inline true_condition for non-csem
   users. *)

definition with_consume_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " with_consume_condition (Xs:: candidate_execution set) = (( (* CSEM *)
  \<forall> (Xo,Xw,rl) \<in> Xs. (                              (* CSEM *)
    \<forall> a \<in>(actions0   Xo).                              (* CSEM *)
      (case  a of                                        (* CSEM *)
        Lock _ _ _ _            => True                   (* CSEM *)
      | Unlock _ _ _            => True                   (* CSEM *)
      | Load _ _ mo1 _ _         => True                   (* CSEM *)
      | Store _ _ mo1 _ _        => True                   (* CSEM *)
      | RMW _ _ mo1 _ _ _        => True                   (* CSEM *)
      | Fence _ _ mo1            => True                   (* CSEM *)
      | Blocked_rmw _ _ _       => True                   (* CSEM *)
      | Alloc _ _ _             => False                  (* CSEM *)
      | Dealloc _ _ _           => False                  (* CSEM *)
      ))))"
                                                 (* CSEM *)

definition with_consume_cad_set  :: " 'b \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set "  where 
     " with_consume_cad_set actions2 sb1 dd1 rf1 = ( trancl ( (rf1 \<inter> sb1) \<union> dd1 ))"


(*val with_consume_cad_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition with_consume_cad_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " with_consume_cad_set_alt Xo Xw = (
  with_consume_cad_set(actions0   Xo)(sb   Xo)(dd   Xo)(rf   Xw))"


definition with_consume_dob  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " with_consume_dob actions2 rf1 rs cad w a = ( \<not> ((tid_of w) = (tid_of a)) \<and>    
((\<exists> w' \<in> actions2. \<exists> r \<in> actions2. 
      is_consume r \<and>
      (((w,w') \<in> rs) \<and> (((w',r) \<in> rf1) \<and>
      ( ((r,a) \<in> cad) \<or> ( r = a) ))))))"



definition dependency_ordered_before  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " dependency_ordered_before actions2 rf1 rs cad a d = (     
(a \<in> actions2) \<and> ((d \<in> actions2) \<and>
     (( \<exists> b \<in> actions2.  is_release a \<and> (is_consume b \<and>       
(((\<exists> e \<in> actions2.  ((a,e) \<in> rs) \<and> ((e,b) \<in> rf1))) \<and>
       ( ((b,d) \<in> cad) \<or> ( b = d) )))) )))"



definition with_consume_dob_set  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " with_consume_dob_set actions2 rf1 rs cad = (
  set_filter
    (\<lambda> (a,b) .  (dependency_ordered_before actions2 rf1 rs cad a b))
    (actions2 \<times> actions2) )"


(*val with_consume_dob_set_alt: pre_execution -> execution_witness -> set (action * action)*)
definition with_consume_dob_set_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " with_consume_dob_set_alt Xo Xw = (
  with_consume_dob_set(actions0   Xo)(rf   
                       Xw) 
                       (release_sequence_set_alt Xo Xw) 
                       (with_consume_cad_set_alt Xo Xw))"



definition compose0  :: "('b*'a)set \<Rightarrow>('a*'c)set \<Rightarrow>('b*'c)set "  where 
     " compose0 R1 R2 = (
  Set.image (\<lambda> ((w,x),(y,z)) .  (w,z))
    (set_filter (\<lambda> ((w,x),(y,z)) .  (x = y)) (R1 \<times> R2)) )"



definition inter_thread_happens_before  :: " 'b \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set \<Rightarrow>('a*'a)set "  where 
     " inter_thread_happens_before actions2 sb1 sw dob = (
    (let r = ((sw \<union> dob) \<union> (compose0 sw sb1)) in
      trancl (r \<union> (compose0 sb1 r))))"


(*val inter_thread_happens_before_r: pre_execution -> execution_witness -> set (action * action)*)
definition inter_thread_happens_before_r  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " inter_thread_happens_before_r Xo Xw = (        
((release_acquire_fenced_synchronizes_with_set_alt Xo Xw) 
  \<union> (with_consume_dob_set_alt Xo Xw))
  \<union> (compose0 (release_acquire_fenced_synchronizes_with_set_alt Xo Xw) ((sb   Xo))))"


(*val inter_thread_happens_before_step: pre_execution -> execution_witness -> set (action * action)*)
definition inter_thread_happens_before_step  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " inter_thread_happens_before_step Xo Xw = (
  (inter_thread_happens_before_r Xo Xw) \<union> (compose0(sb   Xo) (inter_thread_happens_before_r Xo Xw)))"


(*val inter_thread_happens_before_alt: pre_execution -> execution_witness -> set (action * action)*)
definition inter_thread_happens_before_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " inter_thread_happens_before_alt Xo Xw = (
  trancl (inter_thread_happens_before_step Xo Xw))"


definition happens_before  :: " 'b \<Rightarrow> 'a set \<Rightarrow> 'a set \<Rightarrow> 'a set "  where 
     " happens_before actions2 sb1 ithb = (
    sb1 \<union> ithb )"


(*val with_consume_hb: pre_execution -> execution_witness -> set (action * action)*)
definition with_consume_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " with_consume_hb Xo Xw = (
  happens_before(actions0   Xo)(sb   Xo) (inter_thread_happens_before_alt Xo Xw))"


(*val with_consume_vse: pre_execution -> execution_witness -> set (action * action)*)
definition with_consume_vse  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " with_consume_vse Xo Xw = (
  visible_side_effect_set(actions0   Xo) (with_consume_hb Xo Xw))"


(*val with_consume_relations: pre_execution -> execution_witness -> relation_list*)
definition with_consume_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " with_consume_relations Xo Xw = (
    (let hrs   = (hypothetical_release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let rs    = (release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let sw    = (release_acquire_fenced_synchronizes_with_set(actions0   Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw) rs hrs) in
    (let cad   = (with_consume_cad_set(actions0   Xo)(sb   Xo)(dd   Xo)(rf   Xw)) in
    (let dob   = (with_consume_dob_set(actions0   Xo)(rf   Xw) rs cad) in
    (let ithb  = (inter_thread_happens_before(actions0   Xo)(sb   Xo) sw dob) in
    (let hb    = (happens_before(actions0   Xo)(sb   Xo) ithb) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''ithb''), ithb),
      ((''sw''), sw),
      ((''rs''), rs),
      ((''hrs''), hrs),
      ((''dob''), dob),
      ((''cad''), cad) ])))))))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val with_consume_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition with_consume_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " with_consume_relations_alt Xo Xw = (
    [ ((''hb''), with_consume_hb Xo Xw),
      ((''vse''), with_consume_vse Xo Xw),
      ((''ithb''), inter_thread_happens_before_alt Xo Xw),
      ((''sw''), release_acquire_fenced_synchronizes_with_set_alt Xo Xw),
      ((''rs''), release_sequence_set_alt Xo Xw),
      ((''hrs''), hypothetical_release_sequence_set_alt Xo Xw),
      ((''dob''), with_consume_dob_set_alt Xo Xw),
      ((''cad''), with_consume_cad_set_alt Xo Xw) ])"


definition with_consume_consistent_execution  :: " named_predicate_tree "  where 
     " with_consume_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''sc_accesses_consistent_sc''), Leaf sc_accesses_consistent_sc),
         ((''sc_fenced_sc_fences_heeded''), Leaf sc_fenced_sc_fences_heeded),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity),
                  ((''sc_accesses_sc_reads_restricted''), Leaf sc_accesses_sc_reads_restricted) ]) ])"



(*********************************************** *)


definition with_consume_memory_model  :: " memory_model "  where 
     " with_consume_memory_model = (
  (| consistent = with_consume_consistent_execution,
     relation_calculation = with_consume_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val with_consume_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition with_consume_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " with_consume_behaviour opsem (p :: program) = (
  behaviour with_consume_memory_model with_consume_condition opsem p )"




(*********************************************** *)
(* 12 - the standard model *)
(*********************************************** *)

definition dummy12  :: " bool "  where 
     " dummy12 = ( True )"


definition standard_vsses  :: "(action)set \<Rightarrow>(location_impl \<Rightarrow> location_kind)\<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " standard_vsses actions2 lk1 mo1 hb vse = (
  set_filter
    (\<lambda> (v,r) . ((\<exists> head \<in> actions2.
                          is_at_atomic_location lk1 r \<and>
                            (((head,r) \<in> vse) \<and>
                               (\<not>
                                  ((\<exists> v' \<in> actions2.
                                     ((v',r) \<in> vse) \<and>
                                       ((head,v') \<in> mo1))) \<and>
                                  ( v = head \<or>
                                      ( ((head,v) \<in> mo1) \<and>
                                          (\<not> ((r,v) \<in> hb) \<and>
                                             ((\<forall> w \<in> actions2.
                                                (((head,w) \<in> mo1) \<and>
                                                   ((w,v) \<in> mo1))
                                                  \<longrightarrow>
                                                  \<not> ((r,w) \<in> hb)))) )
                                    )))))) (actions2 \<times> actions2) )"


(*val standard_vsses_alt: pre_execution -> execution_witness -> set (action * action)*)
definition standard_vsses_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " standard_vsses_alt Xo Xw = (
  standard_vsses(actions0   Xo)(lk   
                 Xo)(mo   
                 Xw) 
                 (with_consume_hb Xo Xw) 
                 (with_consume_vse Xo Xw))"


definition standard_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " standard_relations Xo Xw = (
    (let hrs   = (hypothetical_release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let rs    = (release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let sw    = (release_acquire_fenced_synchronizes_with_set(actions0   Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw) rs hrs) in
    (let cad   = (with_consume_cad_set(actions0   Xo)(sb   Xo)(dd   Xo)(rf   Xw)) in
    (let dob   = (with_consume_dob_set(actions0   Xo)(rf   Xw) rs cad) in
    (let ithb  = (inter_thread_happens_before(actions0   Xo)(sb   Xo) sw dob) in
    (let hb    = (happens_before(actions0   Xo)(sb   Xo) ithb) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    (let vsses = (standard_vsses(actions0   Xo)(lk   Xo)(mo   Xw) hb vse) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''ithb''), ithb),
      ((''vsses''), vsses),
      ((''sw''), sw),
      ((''rs''), rs),
      ((''hrs''), hrs),
      ((''dob''), dob),
      ((''cad''), cad) ]))))))))))"


(* The following equivalent version of the relations calculation is
   less efficient to compute, but easier to work with in proofs. *)

(*val standard_relations_alt: pre_execution -> execution_witness -> relation_list*)
definition standard_relations_alt  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " standard_relations_alt Xo Xw = (
    [ ((''hb''), with_consume_hb Xo Xw),
      ((''vse''), with_consume_vse Xo Xw),
      ((''ithb''), inter_thread_happens_before_alt Xo Xw),
      ((''vsses''), standard_vsses_alt Xo Xw),
      ((''sw''), release_acquire_fenced_synchronizes_with_set_alt Xo Xw),
      ((''rs''), release_sequence_set_alt Xo Xw),
      ((''hrs''), hypothetical_release_sequence_set_alt Xo Xw),
      ((''dob''), with_consume_dob_set_alt Xo Xw),
      ((''cad''), with_consume_cad_set_alt Xo Xw) ])"



(*val standard_consistent_atomic_rf: pre_execution * execution_witness * relation_list -> bool*)
fun standard_consistent_atomic_rf  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " standard_consistent_atomic_rf (Xo,Xw,([])) = ( undefined )"
|" standard_consistent_atomic_rf (Xo,Xw,(_ #([]))) = ( undefined )"
|" standard_consistent_atomic_rf (Xo,Xw,(_ #(_ #([])))) = ( undefined )"
|" standard_consistent_atomic_rf (Xo,Xw,(_ #(_ #(_ #([]))))) = ( undefined )"
|" standard_consistent_atomic_rf (Xo,Xw,(_ #(_ #(_ #((s,vsses)# _))))) = ( 
  if(s = (''vsses'')) then
    ((\<forall> (w,r) \<in>(rf   Xw).
       (is_at_atomic_location (lk   Xo) r \<and> is_load r) \<longrightarrow>
         ((w,r) \<in> vsses))) else undefined )" 
declare standard_consistent_atomic_rf.simps [simp del]



definition standard_consistent_execution  :: " named_predicate_tree "  where 
     " standard_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''locks_only_consistent_locks''), Leaf locks_only_consistent_locks),
         ((''locks_only_consistent_lo''), Leaf locks_only_consistent_lo),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''sc_accesses_consistent_sc''), Leaf sc_accesses_consistent_sc),
         ((''sc_fenced_sc_fences_heeded''), Leaf sc_fenced_sc_fences_heeded),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''standard_consistent_atomic_rf''),
                     Leaf standard_consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity),
                  ((''sc_accesses_sc_reads_restricted''),
                     Leaf sc_accesses_sc_reads_restricted) ]) ])"



(*********************************************** *)


definition standard_memory_model  :: " memory_model "  where 
     " standard_memory_model = (
  (| consistent = standard_consistent_execution,
     relation_calculation = standard_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"


(*val standard_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition standard_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " standard_behaviour opsem (p :: program) = (
  behaviour standard_memory_model with_consume_condition opsem p )"






(*********************************************** *)
(* 13 - release acquire SC - memory_model simplified for programs without
consumes or relaxed *)
(*********************************************** *)

(* Hypothetical Fortran model note (No longer applicable): If Nick was going to use this model, I would want to strengthen SC fences, and think some more about the SC fence absorbsion mismatch. I would also need to cut down hb to the SC portion that Nick discussed. *)

(*val release_acquire_SC_condition : forall. condition_t*)
definition release_acquire_SC_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_SC_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. 
    atomic_initialisation_first (Xo,Xw,rl) \<and>    
((\<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire,Seq_cst})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release,Seq_cst})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Acq_rel,Seq_cst})
      | Fence _ _ mo1            => (mo1 \<in> {Seq_cst})
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      )))))"


(*********************************************** *)



definition release_acquire_SC_memory_model  :: " memory_model "  where 
     " release_acquire_SC_memory_model = (
  (| consistent = sc_fenced_consistent_execution,
     relation_calculation = release_acquire_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val release_acquire_SC_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition release_acquire_SC_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " release_acquire_SC_behaviour opsem (p :: program) = (
  behaviour release_acquire_SC_memory_model release_acquire_SC_condition opsem p )"



(*val release_acquire_SC_rf_behaviour : forall. opsem_t -> program -> rf_program_behaviours*)
definition release_acquire_SC_rf_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> rf_program_behaviours "  where 
     " release_acquire_SC_rf_behaviour opsem (p :: program) = (
  rf_behaviour release_acquire_SC_memory_model release_acquire_SC_condition opsem p )"



(*********************************************** *)
(* 14 - SC - memory_model simplified for programs without release, acquire,
consumes or relaxed *)
(*********************************************** *)


(*val SC_condition : forall. condition_t*)
definition SC_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " SC_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. 
    atomic_initialisation_first (Xo,Xw,rl) \<and>    
((\<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Seq_cst})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Seq_cst})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Seq_cst})
      | Fence _ _ mo1            => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      )))))"


(*********************************************** *)



definition SC_memory_model  :: " memory_model "  where 
     " SC_memory_model = (
  (| consistent = sc_accesses_consistent_execution,
     relation_calculation = release_acquire_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val SC_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition SC_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " SC_behaviour opsem (p :: program) = (
  behaviour SC_memory_model SC_condition opsem p )"



(*********************************************** *)
(* 15 - tot - sequential consistency *)
(*********************************************** *)

(*val atomic_initialisation_before_all: pre_execution * execution_witness * relation_list -> bool*)
fun atomic_initialisation_before_all  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " atomic_initialisation_before_all (Xo,_,_) = ((
  \<forall> a \<in>(actions0   Xo). 
  \<forall> b \<in>(actions0   Xo).     
(is_at_atomic_location(lk   Xo) a \<and> (is_NA_store a \<and>    
((loc_of a = loc_of b) \<and> ( ((\<lambda> x y .  \<not> (x = y))a b))))) \<longrightarrow>    
(((a,b) \<in> trancl ((sb   Xo) \<union>(asw   Xo))) \<and> \<not> (is_NA_store b))))" 
declare atomic_initialisation_before_all.simps [simp del]



(*val bounded_executions : forall. set candidate_execution -> bool*)
definition bounded_executions  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " bounded_executions (Xs:: candidate_execution set) = ((
  \<exists> N. ( \<forall> (Xo,Xw,rl) \<in> Xs. 
    finite(actions0   Xo) \<and>    
(card(actions0   Xo) < N))))"



(*val tot_condition : forall. condition_t*)
definition tot_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " tot_condition (Xs:: candidate_execution set) = (
  bounded_executions Xs \<and>  
((\<forall> (Xo,Xw,rl) \<in> Xs. 
    atomic_initialisation_before_all (Xo,Xw,rl) \<and>    
((\<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => True
      | Unlock _ _ _            => True
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Seq_cst})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Seq_cst})
      | RMW _ _ mo1 _ _ _        => (mo1 \<in> {Seq_cst})
      | Fence _ _ mo1            => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))))"




definition tot_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " tot_relations Xo Xw = (
    (let vse   = (visible_side_effect_set(actions0   Xo)(tot   Xw)) in
    [ ((''empty''), {}),
      ((''vse''), vse) 
    ]))"


(*val tot_det_read: pre_execution * execution_witness * relation_list -> bool*)
fun tot_det_read  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_det_read (Xo,Xw,([])) = ( undefined )"
|" tot_det_read (Xo,Xw,(_ #([]))) = ( undefined )"
|" tot_det_read (Xo,Xw,(_ #((s,vse)# _))) = ( 
  if(s = (''vse'')) then
    ((\<forall> r \<in>(actions0   Xo).
       ((\<exists> w \<in>(actions0   Xo). (w,r) \<in> vse))
         \<longleftrightarrow>
         ((\<exists> w' \<in>(actions0   Xo). (w',r) \<in> (rf   Xw))))) else
    undefined )" 
declare tot_det_read.simps [simp del]


(*val tot_consistent_rf: pre_execution * execution_witness * relation_list -> bool*)
fun tot_consistent_rf  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_consistent_rf (_,Xw,([])) = ( undefined )"
|" tot_consistent_rf (_,Xw,(_ #([]))) = ( undefined )"
|" tot_consistent_rf (_,Xw,(_ #((s,vse)# _))) = ( 
  if(s = (''vse'')) then ((\<forall> (w,r) \<in>(rf   Xw). (w,r) \<in> vse))
  else undefined )" 
declare tot_consistent_rf.simps [simp del]


(*val tot_consistent_locks: pre_execution * execution_witness * relation_list -> bool*)
fun tot_consistent_locks  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_consistent_locks (Xo,Xw,_) = (
    ((\<forall> (a,c) \<in>(tot   Xw).       
 (is_successful_lock a \<and> (is_successful_lock c \<and> (loc_of a = loc_of c)))
      \<longrightarrow> 
      ((\<exists> b \<in>(actions0   Xo).  (loc_of a = loc_of b) \<and> (is_unlock b \<and> (((a,b) \<in>(tot   Xw)) \<and> ((b,c) \<in>(tot   Xw)))))))))" 
declare tot_consistent_locks.simps [simp del]



(*val tot_consistent_tot: pre_execution * execution_witness * relation_list -> bool*)
fun tot_consistent_tot  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_consistent_tot (Xo,Xw,_) = (
    relation_over(actions0   Xo)(tot   Xw) \<and>    
(trans(tot   Xw) \<and>    
(irrefl(tot   Xw) \<and>    
(isTrichotomousOn(tot    Xw)(actions0    Xo) \<and>
    (((sb   Xo) \<subseteq>(tot   Xw)) \<and>
    (((asw   Xo) \<subseteq>(tot   Xw)) \<and>
    finite_prefixes(tot   Xw)(actions0   Xo)))))))" 
declare tot_consistent_tot.simps [simp del]



(*val tot_assumptions: pre_execution * execution_witness * relation_list -> bool*)
fun tot_assumptions  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " tot_assumptions (Xo,Xw,_) = (
  finite_prefixes(rf   Xw)(actions0   Xo))" 
declare tot_assumptions.simps [simp del]




definition tot_consistent_execution  :: " named_predicate_tree "  where 
     " tot_consistent_execution = (
  Node [ ((''tot_assumptions''), Leaf tot_assumptions),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''tot_conistent_tot''), Leaf tot_consistent_tot),
         ((''tot_consistent_locks''), Leaf tot_consistent_locks),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf tot_det_read),
                  ((''tot_consistent_rf''), Leaf tot_consistent_rf)
                ]
         )
       ])"




fun tot_bad_mutexes  :: " pre_execution*execution_witness*'a \<Rightarrow>(action)set "  where 
     " tot_bad_mutexes (Xo,Xw,_) = (
  set_filter
    (\<lambda> a . 
     ((let lo1 =(set_filter
                   (\<lambda> (a,b) . 
                    (((a,b) \<in> (tot   Xw)) \<and>
                       ((loc_of a = loc_of b) \<and>
                          is_at_mutex_location (lk   Xo) a)))
                   ((actions0   Xo) \<times> (actions0   Xo))) in
      \<not>
        (locks_only_good_mutex_use (actions0   Xo) (lk   Xo) (sb   Xo) lo1 a))))
    (actions0   Xo) )" 
declare tot_bad_mutexes.simps [simp del]



fun tot_data_races  :: " pre_execution*execution_witness*'a \<Rightarrow>(action*action)set "  where 
     " tot_data_races (Xo,Xw,_) = (
  set_filter
    (\<lambda> (a,b) . 
     (\<not> ( a = b) \<and>
        ((loc_of a = loc_of b) \<and>
           ((is_write a \<or> is_write b) \<and>
              (( \<not> ((tid_of a) = (tid_of b))) \<and>
                 (\<not> (is_atomic_action a \<and> is_atomic_action b)
                    \<and>
                    (\<not> ((a,b) \<in> (asw   Xo)) \<and>
                       (((a,b) \<in> (tot   Xw)) \<and>
                          \<not>
                            ((\<exists> c \<in>(actions0   Xo).
                               ((a,c) \<in> (tot   Xw)) \<and>
                                 ((c,b) \<in> (tot   Xw))))))))))))
    ((actions0   Xo) \<times> (actions0   Xo)) )" 
declare tot_data_races.simps [simp del]




definition tot_undefined_behaviour  :: "(fault_setgen)list "  where 
     " tot_undefined_behaviour = (
  [ Two ((''unsequenced_races''), unsequenced_races),
    Two ((''data_races''), tot_data_races),
    One ((''indeterminate_reads''), indeterminate_reads),
    One ((''tot_bad_mutexes''), tot_bad_mutexes) ])"




(*********************************************** *)




definition tot_memory_model  :: " memory_model "  where 
     " tot_memory_model = (
  (| consistent = tot_consistent_execution,
     relation_calculation = tot_relations,
     undefined0 = tot_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = False,
           sc_flag  = False,
           lo_flag  = False,
           tot_flag = True  |)
  |) )"



(*val tot_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition tot_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " tot_behaviour opsem (p :: program) = (
  behaviour tot_memory_model tot_condition opsem p )"


(*val tot_rf_behaviour : forall. opsem_t -> program -> rf_program_behaviours*)
definition tot_rf_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> rf_program_behaviours "  where 
     " tot_rf_behaviour opsem (p :: program) = (
  rf_behaviour tot_memory_model tot_condition opsem p )"



(***********************)
(* - 16 - Meta-theory  *)
(***********************)

(*val cond : forall. (program -> pre_execution -> bool) -> program -> bool*)
definition 
cond  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> bool "  where 
     " 
cond opsem p = ( statically_satisfied sc_fenced_condition opsem p )"


definition M1  :: " memory_model "  where 
     " M1 = ( tot_memory_model )"

definition M2  :: " memory_model "  where 
     " M2 = ( tot_memory_model )"

definition P1  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " P1 = ( tot_condition )"

definition P2  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " P2 = ( tot_condition )"



(* val genthm : bool *)
(* let {hol; isabelle; tex} genthm = forall opsem p. *)
(*   cond opsem p --> *)
(*   (rf_behaviour M1 P1 opsem p = rf_behaviour M2 P2 opsem p) *)



(* val thm0 : bool *)
(* let {hol; isabelle; tex} thm0 = forall opsem p. *)
(*   ( with_consume_behaviour opsem p = standard_behaviour opsem p) *)

(* (* The theorem syntax: *)
(* theorem {hol; isabelle; tex} thm0:  *)
(*   (forall opsem p. *)
(*     ( with_consume_behaviour opsem p = standard_behaviour opsem p)) *)
(* *) *)

(* val thm1 : bool *)
(* let {hol; isabelle; tex} thm1 = forall opsem p. *)
(*   statically_satisfied sc_fenced_condition opsem p --> *)
(*   (sc_fenced_behaviour opsem p = with_consume_behaviour opsem p) *)

(* val thm2 : bool *)
(* let {hol; isabelle; tex} thm2 = forall opsem p. *)
(*   statically_satisfied sc_accesses_condition opsem p --> *)
(*   (sc_accesses_behaviour opsem p = sc_fenced_behaviour opsem p) *)

(* val thm3 : bool *)
(* let {hol; isabelle; tex} thm3 = forall opsem p. *)
(*   statically_satisfied release_acquire_fenced_condition opsem p --> *)
(*   (release_acquire_fenced_behaviour opsem p = sc_accesses_behaviour opsem p) *)

(* val thm4 : bool *)
(* let {hol; isabelle; tex} thm4 = forall opsem p. *)
(*   statically_satisfied release_acquire_relaxed_condition opsem p --> *)
(*   (release_acquire_relaxed_behaviour opsem p = release_acquire_fenced_behaviour opsem p) *)

(* val thm6 : bool *)
(* let {hol; isabelle; tex} thm6 = forall opsem p. *)
(*   statically_satisfied relaxed_only_condition opsem p --> *)
(*   (relaxed_only_behaviour opsem p = release_acquire_relaxed_behaviour opsem p) *)

(* val thm7 : bool *)
(* let {hol; isabelle; tex} thm7 = forall opsem p. *)
(*   statically_satisfied locks_only_condition opsem p --> *)
(*   (locks_only_behaviour opsem p = release_acquire_behaviour opsem p) *)

(* val thm8 : bool *)
(* let {hol; isabelle; tex} thm8 = forall opsem p. *)
(*   statically_satisfied locks_only_condition opsem p --> *)
(*   (locks_only_behaviour opsem p = relaxed_only_behaviour opsem p) *)

(* val thm9 : bool *)
(* let {hol; isabelle; tex} thm9 = forall opsem p. *)
(*   statically_satisfied single_thread_condition opsem p --> *)
(*   (single_thread_behaviour opsem p = locks_only_behaviour opsem p) *)

(* val thm10 : bool *)
(* let {hol; isabelle; tex} thm10 = forall opsem p. *)
(*   statically_satisfied release_acquire_SC_condition opsem p --> *)
(*   (sc_fenced_behaviour opsem p = release_acquire_SC_behaviour opsem p) *)

(* val thm5 : bool *)
(* let {hol; isabelle; tex} thm5 = forall opsem p. *)
(*   statically_satisfied release_acquire_condition opsem p --> *)
(*   (release_acquire_behaviour opsem p = release_acquire_SC_behaviour opsem p) *)

(* val thm11 : bool *)
(* let {hol; isabelle; tex} thm11 = forall opsem p. *)
(*   statically_satisfied SC_condition opsem p --> *)
(*   (SC_behaviour opsem p = release_acquire_SC_behaviour opsem p) *)

(* val thm12 : bool *)
(* let {hol; isabelle; tex} thm12 = forall opsem p. *)
(*   statically_satisfied locks_only_condition opsem p --> *)
(*   (SC_behaviour opsem p = locks_only_behaviour opsem p) *)

(* val bigthm : bool *)
(* let {hol; isabelle; tex} bigthm = forall opsem p. *)
(*   opsem_assumptions opsem && *)
(*   statically_satisfied tot_condition opsem p --> *)
(*   (release_acquire_SC_rf_behaviour opsem p = tot_rf_behaviour opsem p) *)



(*********************************************** *)
(* 17 - release acquire, no locks - memory_model simplified for programs without sc,
consumes, relaxed or locks *)
(*********************************************** *)



(*val release_acquire_no_locks_condition : forall. condition_t*)
definition release_acquire_no_locks_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_no_locks_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => False
      | Unlock _ _ _            => False
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release})
      | RMW _ _ mo1 _ _ _        => mo1 = Acq_rel
      | Fence _ _ _             => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"



definition release_acquire_no_locks_synchronizes_with  :: " 'a \<Rightarrow> 'b \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow> bool "  where 
     " release_acquire_no_locks_synchronizes_with actions2 sb1 asw1 rf1 a b = (
  ( \<not> ((tid_of a) = (tid_of b))) \<and>
  (    
( (* thread sync *)(a,b) \<in> asw1) \<or>
    (* rel/acq sync *)
    ( is_release a \<and> (is_acquire b \<and> ((a,b) \<in> rf1)) )
  ))"


definition release_acquire_no_locks_synchronizes_with_set  :: "(action)set \<Rightarrow> 'a \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*action)set "  where 
     " release_acquire_no_locks_synchronizes_with_set actions2 sb1 asw1 rf1 = (
  set_filter
    (\<lambda> (a,b) . 
     (release_acquire_no_locks_synchronizes_with actions2 sb1 asw1 rf1 a b))
    (actions2 \<times> actions2) )"


definition release_acquire_no_locks_relations  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(string*(action*action)set)list "  where 
     " release_acquire_no_locks_relations Xo Xw = (
    (let sw    = (release_acquire_no_locks_synchronizes_with_set(actions0  
                  Xo)(sb   Xo)(asw   Xo)(rf   Xw)) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set(actions0   Xo) hb) in
    [ ((''hb''), hb),
      ((''vse''), vse),
      ((''sw''), sw) ]))))"



fun sc_lo_empty  :: " 'b*execution_witness*'a \<Rightarrow> bool "  where 
     " sc_lo_empty (_,Xw,_) = ( ((sc   Xw) = {}) \<and> ((lo   Xw) = {}))" 
declare sc_lo_empty.simps [simp del]



definition release_acquire_no_locks_consistent_execution  :: " named_predicate_tree "  where 
     " release_acquire_no_locks_consistent_execution = (
  Node [ ((''assumptions''), Leaf assumptions),
         ((''sc_lo_empty''), Leaf sc_empty),
         ((''tot_empty''), Leaf tot_empty),
         ((''well_formed_threads''), Leaf well_formed_threads),
         ((''well_formed_rf''), Leaf well_formed_rf),
         ((''consistent_mo''), Leaf consistent_mo),
         ((''consistent_hb''), Leaf consistent_hb),
         ((''consistent_rf''),
           Node [ ((''det_read''), Leaf det_read),
                  ((''consistent_non_atomic_rf''), Leaf consistent_non_atomic_rf),
                  ((''consistent_atomic_rf''), Leaf consistent_atomic_rf),
                  ((''coherent_memory_use''), Leaf coherent_memory_use),
                  ((''rmw_atomicity''), Leaf rmw_atomicity) ]) ])"



(*********************************************** *)

definition release_acquire_no_locks_undefined_behaviour  :: "(fault_setgen)list "  where 
     " release_acquire_no_locks_undefined_behaviour = (
  [ Two ((''unsequenced_races''), unsequenced_races),
    Two ((''data_races''), data_races),
    One ((''indeterminate_reads''), indeterminate_reads)  ])"




definition release_acquire_no_locks_memory_model  :: " memory_model "  where 
     " release_acquire_no_locks_memory_model = (
  (| consistent = release_acquire_no_locks_consistent_execution,
     relation_calculation = release_acquire_no_locks_relations,
     undefined0 = release_acquire_no_locks_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = False,
           lo_flag  = True,
           tot_flag = False |)
  |) )"



(*val release_acquire_no_locks_behaviour : forall. opsem_t -> program -> program_behaviours*)
definition release_acquire_no_locks_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " release_acquire_no_locks_behaviour opsem (p :: program) = (
  behaviour release_acquire_no_locks_memory_model release_acquire_no_locks_condition opsem p )"




(*********************************************** *)
(* 18 - release acquire lifetime, no locks - memory_model with explicit creation and killing of objects,
but without sc, consumes, relaxed or locks *)
(*********************************************** *)

(*val release_acquire_lifetime_no_locks_condition : forall. condition_t*)
definition release_acquire_lifetime_no_locks_condition  :: "(candidate_execution)set \<Rightarrow> bool "  where 
     " release_acquire_lifetime_no_locks_condition (Xs:: candidate_execution set) = ((
  \<forall> (Xo,Xw,rl) \<in> Xs. (
    \<forall> a \<in>(actions0   Xo). 
      (case  a of
        Lock _ _ _ _            => False
      | Unlock _ _ _            => False
      | Load _ _ mo1 _ _         => (mo1 \<in> {NA,Acquire})
      | Store _ _ mo1 _ _        => (mo1 \<in> {NA,Release})
      | RMW _ _ mo1 _ _ _        => mo1 = Acq_rel
      | Fence _ _ _             => False
      | Blocked_rmw _ _ _       => True
      | Alloc _ _ _             => False (* CSEM *)
      | Dealloc _ _ _           => False (* CSEM *)
      ))))"


(*********************************************** *)     

(*
(* 6.2.4 p2: If an object is referred to outside of its lifetime, the behavior is undefined. 
   together with 7.22.3 p1 The lifetime of an allocated object extends from the allocation until the deallocation. *)
let reads_outside_lifetime (Xo,Xw,(hb,hb)::_) =
    { a | forall (a IN Xo.actions) |
     not (exists (b IN Xo.actions). is_alloc b && (loc_of a = loc_of b) && (b, a) IN hb) ||
     (exists (b IN Xo.actions). is_dealloc b && (loc_of a = loc_of b) && not ((a, b) IN hb))}

(* 7.22.3.3 p2 (similar to C++ 18.6.1.3) says that Deallocs without a 
  happens before Alloc are undefined and that a Dealloc that happens after 
  another Dealloc is undefined. The standard does not say anything about Deallocs that 
  are hb-unrelated. We have decided to treat that as undefined behaviour. *)
let bad_deallocs (Xo,Xw,(hb,hb)::_) =
    { a | forall (a IN Xo.actions) |
      is_dealloc a && ((not (exists (b IN Xo.actions). is_alloc b && (b, a) IN hb)) || 
                    (exists (c IN Xo.actions). is_dealloc c && a <> c))}
      
let release_acquire_lifetime_no_locks_undefined_behaviour =
  [ Two (unsequenced_races, unsequenced_races);
    Two (data_races, data_races);
    One (indeterminate_reads, indeterminate_reads);
    One (reads_outside_lifetime, reads_outside_lifetime);
    One (bad_deallocs, bad_deallocs); ]

let release_acquire_lifetime_no_locks_memory_model =
  <| consistent = release_acquire_no_locks_consistent_execution;
     relation_calculation = release_acquire_no_locks_relations;
     undefined = release_acquire_lifetime_no_locks_undefined_behaviour;
     relation_flags =
       <|  rf_flag  = true;
           mo_flag  = true;
           sc_flag  = false;
           lo_flag  = true;
           tot_flag = false |>
  |>

val release_acquire_lifetime_no_locks_behaviour : forall. opsem_t -> program -> program_behaviours
let {hol; isabelle; tex}release_acquire_lifetime_no_locks_behaviour  opsem (p : program) =
  behaviour release_acquire_lifetime_no_locks_memory_model release_acquire_lifetime_no_locks_condition opsem p

*)


(*********************************************** *)
(* 19 - overlap - memory_model where writes and reads can have
   distinct but overlapping footprints. *)
(*********************************************** *)

(* Footprints *)

type_synonym footprint =" footprint_impl "

(* Instead of changing the type of actions to include a footprint, we
   use a projection function from locations (see
   csem/notes/notes39). *)

(*val footprint_of_loc: location -> footprint*)
definition footprint_of_loc  :: " location_impl \<Rightarrow> footprint_impl "  where 
     " footprint_of_loc = ( footprint_of_loc_impl )"


(* We use the following functions to manipulate footprints. *)

(*val footprint_leq: footprint -> footprint -> bool*)
definition footprint_leq  :: " footprint_impl \<Rightarrow> footprint_impl \<Rightarrow> bool "  where 
     " footprint_leq = ( footprint_leq_impl )"


(*val footprint_empty: footprint*)
definition footprint_empty  :: "(location_impl)set "  where 
     " footprint_empty = ( footprint_empty_impl )"


(*val footprint_is_empty: footprint -> bool*)
definition footprint_is_empty  :: " footprint_impl \<Rightarrow> bool "  where 
     " footprint_is_empty = ( footprint_is_empty_impl )"


(*val footprint_difference: footprint -> footprint -> footprint*)
definition footprint_difference  :: " footprint_impl \<Rightarrow> footprint_impl \<Rightarrow> footprint_impl "  where 
     " footprint_difference = ( footprint_difference_impl )"


(*val footprint_intersection: footprint -> footprint -> footprint*)
definition footprint_intersection  :: " footprint_impl \<Rightarrow> footprint_impl \<Rightarrow> footprint_impl "  where 
     " footprint_intersection = ( footprint_intersection_impl )"


(*val footprint_bigunion: set footprint -> footprint*)
definition footprint_bigunion  :: "(footprint_impl)set \<Rightarrow> footprint_impl "  where 
     " footprint_bigunion = ( footprint_bigunion_impl )"


(*val footprint_of: action -> footprint*)
definition footprint_of  :: " action \<Rightarrow>(location_impl)set "  where 
     " footprint_of a = (
  (case  loc_of a of
    None => footprint_empty
  | Some l  => footprint_of_loc l
  ))"


(* We combine the values of the writes where a read reads from with
   the following function. *)

(*val combine_cvalues: set (cvalue * footprint * footprint) -> maybe cvalue*)
definition combine_cvalues  :: "(cvalue_impl*footprint_impl*footprint_impl)set \<Rightarrow>(cvalue_impl)option "  where 
     " combine_cvalues = ( combine_cvalues_impl )"




(* ********************************************** *)

(* We model the readsfrom relation as follows, see csem/notes/notes40
   and notes39 for a discussion of the alternatives. *)

record execution_witness_fp =
  
  rf_fp   ::" (action * footprint * action) set " 

      mo_fp   ::" (action * action) set " 

      sc_fp   ::" (action * action) set " 

      lo_fp   ::" (action * action) set " 

      tot_fp  ::" (action * action) set " 
 


(*val aid_of_rel2_fp: set (action * footprint * action) -> set (aid * footprint)*)
definition aid_of_rel2_fp  :: "(action*(location_impl)set*action)set \<Rightarrow>(string*(location_impl)set)set "  where 
     " aid_of_rel2_fp s = ( Set.image (\<lambda> (w,f,r) .  (aid_of w, f)) s )"


definition instance_Show_Show_Cmm_csem_execution_witness_fp_dict  :: "(execution_witness_fp)Show_class "  where 
     " instance_Show_Show_Cmm_csem_execution_witness_fp_dict = ((|

  show_method = (\<lambda> wit. (''rf: '')    @ (stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> xs. stringFromSet (\<lambda> location. (case  location of
      Loc_hol n => Lem_string_extra.stringFromNat n
    )) xs)) (aid_of_rel2_fp(rf_fp   wit)) @    
 (('', mo: '')  @ (stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2(mo_fp   wit)) @    
 (('', sc: '')  @ (stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2(sc_fp   wit)) @    
 (('', lo: '')  @ (stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2(lo_fp   wit)) @    
 (('', tot: '') @ stringFromSet (stringFromPair (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))) (aid_of_rel2(tot_fp   wit)))))))))))|) )"


definition execution_witness_fp_setElemCompare  :: "((action*footprint*action)set \<Rightarrow>(action*footprint*action)set \<Rightarrow> ordering)\<Rightarrow>((action*action)set \<Rightarrow>(action*action)set \<Rightarrow> ordering)\<Rightarrow> execution_witness_fp \<Rightarrow> execution_witness_fp \<Rightarrow> ordering "  where 
     " execution_witness_fp_setElemCompare cmpa cmpb x y = (
  pairCompare
    cmpa
    (pairCompare
       cmpb
       (pairCompare
          cmpb
          (pairCompare
             cmpb
             cmpb)))
    ((rf_fp   x), ((mo_fp   x), ((sc_fp   x), ((lo_fp   x),(tot_fp   x)))))
    ((rf_fp   y), ((mo_fp   y), ((sc_fp   y), ((lo_fp   y),(tot_fp   y))))))"


(*val project_witness_fp: execution_witness_fp -> execution_witness*)
definition project_witness_fp  :: " execution_witness_fp \<Rightarrow> execution_witness "  where 
     " project_witness_fp wit = (
  (| rf = (Set.image (\<lambda> (w, f, r) .  (w, r))(rf_fp   wit)),
     mo =(mo_fp   wit),
     sc =(sc_fp   wit),
     lo =(lo_fp   wit),
     tot =(tot_fp   wit) 
  |) )"


record relation_list_fp =
(* The name hb clashes with variable names hb in Isabelle (same for
   vse). *)
  
 hb_fp ::" (action * action) set " 
 
     vse_fp ::" (action * footprint * action) set " 

     rest ::" relation_list "  
  


definition relation_list_fp_eq  :: " relation_list_fp \<Rightarrow> relation_list_fp \<Rightarrow> bool "  where 
     " relation_list_fp_eq x y = (
  ((hb_fp   x), ((vse_fp   x),(rest   x))) = ((hb_fp   y), ((vse_fp   y),(rest   y))))"


definition relation_list_fp_setElemCompare  :: "((action*action)set*((action*footprint*action)set*(string*(action*action)set)list) \<Rightarrow>(action*action)set*((action*footprint*action)set*(string*(action*action)set)list) \<Rightarrow> 'a)\<Rightarrow> relation_list_fp \<Rightarrow> relation_list_fp \<Rightarrow> 'a "  where 
     " relation_list_fp_setElemCompare cmp x y = (
  cmp ((hb_fp   x), ((vse_fp   x),(rest   x))) ((hb_fp   y), ((vse_fp   y),(rest   y))))"


(*val project_relation_list_fp: relation_list_fp -> relation_list*)
definition project_relation_list_fp  :: " relation_list_fp \<Rightarrow>(string*(action*action)set)list "  where 
     " project_relation_list_fp l = (
  (let new_vse = (Set.image (\<lambda> (w, f, r) .  (w, r))(vse_fp   l)) in
  ((''hb''),(hb_fp   l))#(((''vse''), new_vse)#(rest   l))))"


type_synonym candidate_execution_fp =" 
  (pre_execution * execution_witness_fp * relation_list_fp)"

(*val project_candidate_execution_fp: candidate_execution_fp -> candidate_execution*)
fun project_candidate_execution_fp  :: " pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> pre_execution*execution_witness*(string*(action*action)set)list "  where 
     " project_candidate_execution_fp (Xo, Xw, rel) = ( 
  (Xo, project_witness_fp Xw, project_relation_list_fp rel))" 
declare project_candidate_execution_fp.simps [simp del]


type_synonym observable_execution_fp =" 
  (pre_execution * execution_witness_fp)"

(* Because the type of candidate execution changed, we need a
   footprint-variant of the rest of the framework as well. *)

datatype named_predicate_tree_fp =
    Leaf_fp " (candidate_execution_fp \<Rightarrow> bool)"
  | Leaf_non_fp " (candidate_execution \<Rightarrow> bool)"
  | Node_fp " (string * named_predicate_tree_fp) list "

(*val apply_tree_fp_aux: named_predicate_tree_fp -> candidate_execution_fp -> candidate_execution -> bool*)
function (sequential,domintros)  apply_tree_fp_aux  :: " named_predicate_tree_fp \<Rightarrow> pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> pre_execution*execution_witness*relation_list \<Rightarrow> bool "  where 
     " apply_tree_fp_aux (Leaf_fp p) ex_fp ex = ( p ex_fp )"
|" apply_tree_fp_aux (Leaf_non_fp p) ex_fp ex = ( p ex )"
|" apply_tree_fp_aux (Node_fp l) ex_fp ex = ( ((\<forall> x \<in> (set l).  (\<lambda> (_, branch) .  apply_tree_fp_aux branch ex_fp ex) x)))" 
by pat_completeness auto


(*val apply_tree_fp: named_predicate_tree_fp -> candidate_execution_fp -> bool*)
definition apply_tree_fp  :: " named_predicate_tree_fp \<Rightarrow> pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> bool "  where 
     " apply_tree_fp tree ex_fp = (
  apply_tree_fp_aux tree ex_fp (project_candidate_execution_fp ex_fp))"


record memory_model_fp =
  
  consistent_fp ::"           named_predicate_tree_fp " 

      relation_calculation_fp ::" pre_execution \<Rightarrow> execution_witness_fp \<Rightarrow> relation_list_fp " 

      undefined_fp ::" (fault_setgen)            list " 

      relation_flags_fp ::"       relation_usage_flags " 
  


datatype program_behaviours_fp =
    Defined_fp " (observable_execution_fp) set "
  | Undefined_fp

(*val observable_filter_fp : forall. set (candidate_execution_fp) -> set (observable_execution_fp)*)
definition observable_filter_fp  :: "(pre_execution*execution_witness_fp*relation_list_fp)set \<Rightarrow>(pre_execution*execution_witness_fp)set "  where 
     " observable_filter_fp X = ( {(Xo,Xw) .( \<exists> rl.  (Xo,Xw,rl) \<in> X)})"


(*val behaviour_fp : forall. memory_model_fp -> condition_t -> opsem_t -> program -> program_behaviours_fp*)
definition behaviour_fp  :: " memory_model_fp \<Rightarrow>((pre_execution*execution_witness*relation_list)set \<Rightarrow> bool)\<Rightarrow>(nat \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours_fp "  where 
     " behaviour_fp M condition opsem (p :: program) = (
  (let consistent_executions_fp =    
({ (Xo,Xw,rl) .
        opsem p Xo \<and>        
(apply_tree_fp(consistent_fp   M) (Xo,Xw,rl) \<and> relation_list_fp_eq rl ((relation_calculation_fp   M) Xo Xw)) }) in
  (let consistent_executions =    
 (Set.image project_candidate_execution_fp consistent_executions_fp) in
  if condition consistent_executions \<and>     
((\<forall> X \<in> consistent_executions. 
        each_empty(undefined_fp   M) X))
  then Defined_fp (observable_filter_fp consistent_executions_fp)
  else Undefined_fp)))"




(* ********************************************** *)

(* The overlap consistency predicates *)

(*val well_formed_rf_fp: candidate_execution_fp -> bool*)
fun well_formed_rf_fp  :: " pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> bool "  where 
     " well_formed_rf_fp (Xo,Xw,_) = (    

    ((\<forall> (w,f,r) \<in>(rf_fp   Xw).        
(w \<in>(actions0   Xo)) \<and> ((r \<in>(actions0   Xo)) \<and>       
(is_write w \<and> (is_read r \<and>       
 (\<not> (footprint_is_empty f) \<and>       
((is_at_non_atomic_location(lk   Xo) r \<longrightarrow> 
          ((\<forall> (w',f',r') \<in>(rf_fp   Xw).  (r = r' \<and> w = w') \<longrightarrow> (f = f')))) \<and>
       (is_at_atomic_location(lk   Xo) r \<longrightarrow> 
          ((\<forall> (w',f',r') \<in>(rf_fp   Xw).  r = r' \<longrightarrow> (w = w' \<and> (f = f')))))))))))) \<and>

    ((\<forall> r \<in>(actions0   Xo).  
       (let writes_of_r =
  (Set.image (\<lambda> (w, f, r') . (w, f))
     (set_filter (\<lambda> (w, f, r') .  ( r = r')) (rf_fp   Xw))) in
       (\<not> ((writes_of_r = {}))) \<longrightarrow>       
(footprint_leq 
         (footprint_bigunion 
  (Set.image (\<lambda> (w, f) . f)
     (set_filter (\<lambda> (w, f) .  True) writes_of_r)))
         (footprint_of r) \<and>       
 (value_read_by r = 
          combine_cvalues (Lem_set.setMapMaybe (\<lambda> (w, f) .  (case  value_written_by w of
                                                         Some v  => Some (v, footprint_of w, f)
                                                       | None => None
                                                       )) 
                                        writes_of_r)))))))" 
declare well_formed_rf_fp.simps [simp del]


(*val consistent_non_atomic_rf_fp: candidate_execution_fp -> bool*)
fun consistent_non_atomic_rf_fp  :: " pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> bool "  where 
     " consistent_non_atomic_rf_fp (Xo,Xw,rel) = ((
    \<forall> (w,f,r) \<in>(rf_fp   Xw).  is_at_non_atomic_location(lk   Xo) r \<longrightarrow>      
((\<exists> (w',f',r') \<in>(vse_fp   rel).  w = w' \<and> (r = r' \<and> footprint_leq f f')))))" 
declare consistent_non_atomic_rf_fp.simps [simp del]


(*val det_read_fp: candidate_execution_fp -> bool*)
fun det_read_fp  :: " pre_execution*execution_witness_fp*relation_list_fp \<Rightarrow> bool "  where 
     " det_read_fp (Xo,Xw,rel) = ((
    \<forall> r \<in>(actions0   Xo). 
      is_load r \<longrightarrow>      
(footprint_bigunion (Set.image (\<lambda> (w,f,r') . f)
   (set_filter (\<lambda> (w,f,r') .  ( r = r')) (vse_fp   rel))) =
      footprint_bigunion 
  (Set.image (\<lambda> (w,f,r') . f)
     (set_filter (\<lambda> (w,f,r') .  ( r = r')) (rf_fp   Xw))))))" 
declare det_read_fp.simps [simp del]


(*val overlap_consistent_execution: named_predicate_tree_fp*)
definition overlap_consistent_execution  :: " named_predicate_tree_fp "  where 
     " overlap_consistent_execution = (
  Node_fp [ ((''assumptions''), Leaf_non_fp assumptions),
            ((''tot_empty''), Leaf_non_fp tot_empty),
            ((''well_formed_threads''), Leaf_non_fp well_formed_threads),
            ((''well_formed_rf_fp''), Leaf_fp well_formed_rf_fp),
            ((''locks_only_consistent_locks''), Leaf_non_fp locks_only_consistent_locks),
            ((''locks_only_consistent_lo''), Leaf_non_fp locks_only_consistent_lo),
            ((''consistent_mo''), Leaf_non_fp consistent_mo),
            ((''sc_accesses_consistent_sc''), Leaf_non_fp sc_accesses_consistent_sc),
            ((''sc_fenced_sc_fences_heeded''), Leaf_non_fp sc_fenced_sc_fences_heeded),
            ((''consistent_hb''), Leaf_non_fp consistent_hb),
            ((''consistent_rf''),
              Node_fp [ ((''det_read_fp''), Leaf_fp det_read_fp),
                        ((''consistent_non_atomic_rf_fp''), Leaf_fp consistent_non_atomic_rf_fp),
                        ((''consistent_atomic_rf''), Leaf_non_fp consistent_atomic_rf),
                        ((''coherent_memory_use''), Leaf_non_fp coherent_memory_use),
                        ((''rmw_atomicity''), Leaf_non_fp rmw_atomicity),
                        ((''sc_accesses_sc_reads_restricted''), Leaf_non_fp sc_accesses_sc_reads_restricted) ]) ])"





(* ********************************************** *)

(* The overlap relation calculation *)

(*val visible_side_effect_set_fp: set action -> set (action * action) -> set (action * footprint * action)*)
definition visible_side_effect_set_fp  :: "(action)set \<Rightarrow>(action*action)set \<Rightarrow>(action*(location_impl)set*action)set "  where 
     " visible_side_effect_set_fp actions2 hb = (
  (let x = (\<lambda> (a,b) .  
      (let overwriting_footprint =        
 (footprint_bigunion (Set.image (\<lambda> c . (footprint_of c))
   (set_filter
      (\<lambda> c .  (\<not> (c \<in> {a,b}) \<and>
                         (is_write c \<and>
                            (((a, c) \<in> hb) \<and> ((c, b) \<in> hb)))))
      actions2))) in
      (let remaining_footprint_of_a =        
(footprint_difference (footprint_of a) overwriting_footprint) in
      (let footprint_between_a_and_b =        
 (footprint_intersection (footprint_of b) remaining_footprint_of_a) in
      (a, footprint_between_a_and_b, b))))) in 
  set_filter
    (\<lambda> (a,f,b) . 
     (is_write a \<and> (is_read b \<and> \<not> (footprint_is_empty f))))
    (Set.image x hb)))"


(*val overlap_relations: pre_execution -> execution_witness_fp -> relation_list_fp*)
definition overlap_relations  :: " pre_execution \<Rightarrow> execution_witness_fp \<Rightarrow> relation_list_fp "  where 
     " overlap_relations Xo Xw_fp = (
    (let Xw    = (project_witness_fp Xw_fp) in
    (let hrs   = (hypothetical_release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let rs    = (release_sequence_set(actions0   Xo)(lk   Xo)(mo   Xw)) in
    (let sw    = (release_acquire_fenced_synchronizes_with_set(actions0   Xo)(sb   Xo)(asw   Xo)(rf   Xw)(lo   Xw) rs hrs) in
    (let hb    = (no_consume_hb(sb   Xo) sw) in
    (let vse   = (visible_side_effect_set_fp(actions0   Xo) hb) in
    (| hb_fp = hb, 
       vse_fp = vse, 
       rest = [ ((''sw''), sw), ((''rs''), rs), ((''hrs''), hrs) ]  
    |))))))))"




(* ********************************************** *)

(* The overlap memory model *)

(*val overlap_memory_model: memory_model_fp*)
definition overlap_memory_model  :: " memory_model_fp "  where 
     " overlap_memory_model = (
  (| consistent_fp = overlap_consistent_execution,
     relation_calculation_fp = overlap_relations,
     undefined_fp = locks_only_undefined_behaviour,
     relation_flags_fp =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"


(*val overlap_behaviour: opsem_t -> program -> program_behaviours_fp*)
definition overlap_behaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours_fp "  where 
     " overlap_behaviour opsem p = (
  behaviour_fp overlap_memory_model sc_fenced_condition opsem p )"

end
