(* (c) Kyndylan Nienhuis, University of Cambridge *)

chapter {* Generated by Lem from nondeterminism.lem. *}

theory "Nondeterminism" 

imports 
 	 Main
	 "lib/Lem_pervasives" 

begin 

(*open import Pervasives*)

datatype 'a t = ND " 'a list "

(*val mzero: forall 'a. t 'a*)
definition mzero  :: " 'a t "  where 
     " mzero = ( ND [])"


(*val return: forall 'a. 'a -> t 'a*)
definition return  :: " 'a \<Rightarrow> 'a t "  where 
     " return a = ( ND [a])"


(*val pick: forall 'a. string -> list 'a -> t 'a*)
definition pick  :: " string \<Rightarrow> 'a list \<Rightarrow> 'a t "  where 
     " pick _ l = ( ND l )"


(* Forget is not part of the interface, but is used internally *)
(*val forget: forall 'a. t 'a -> list 'a*)
fun forget  :: " 'a t \<Rightarrow> 'a list "  where 
     " forget (ND l) = ( l )" 
declare forget.simps [simp del]


datatype kill_reason =
  (* Undef is not used by the opsem *)
  (* | Undef of list Undefined.undefined_behaviour *)
    Error " string "
  | Other " string "

(* The function kill (and the types of its arguments) are part of the
   interface, but they are not used in this implementation. *)
(*val kill: forall 'a. kill_reason -> t 'a*)
definition kill0  :: " kill_reason \<Rightarrow> 'a t "  where 
     " kill0 _ = ( mzero )"


(* The reason contains the message in the case the guard is FALSE. *)
(*val guard: bool -> kill_reason -> t unit*)
definition guard  :: " bool \<Rightarrow> kill_reason \<Rightarrow>(unit)t "  where 
     " guard b reason = (
  if b then return ()  else kill0 reason )"


(*val mplus: forall 'a. t 'a -> t 'a -> t 'a*)
fun mplus  :: " 'a t \<Rightarrow> 'a t \<Rightarrow> 'a t "  where 
     " mplus (ND l1) (ND l2) = ( ND (l1 @ l2))" 
declare mplus.simps [simp del]


(*val msum: forall 'a. list (t 'a) -> t 'a*)
definition msum  :: "('a t)list \<Rightarrow> 'a t "  where 
     " msum = ( (\<lambda> l. List.foldr mplus l mzero))"


(*val bindExhaustive: forall 'a 'b. t 'a -> ('a -> t 'b) -> t 'b*)
definition bindExhaustive  :: " 'a t \<Rightarrow>('a \<Rightarrow> 'b t)\<Rightarrow> 'b t "  where 
     " bindExhaustive m f = ( 
  msum (List.map f (forget m)))"


(*val bind: forall 'a 'b. t 'a -> ('a -> t 'b) -> t 'b*)
definition bind  :: " 'a t \<Rightarrow>('a \<Rightarrow> 'b t) \<Rightarrow> 'b t "  where 
     " bind = ( bindExhaustive )"


(*val mem : forall 'a. Eq 'a => 'a -> t 'a -> bool*)
definition mem  :: " 'a \<Rightarrow> 'a t \<Rightarrow> bool "  where 
     " mem x m = ( Set.member x (set (forget m)))"

end
