(* (c) Kyndylan Nienhuis, University of Cambridge *)

chapter {* Generated by Lem from cmm_op.lem. *}

theory "Cmm_op" 

imports 
 	 Main
	 "lib/Lem_pervasives" 
	 "lib/Lem_show" 
	 "lib/Lem_show_extra" 
	 "lib/Cmm_aux" 
	 "lib/Cmm_csem" 
	 "Nondeterminism" 

begin 

(*open import Pervasives Show Show_extra*)
(*open import Cmm_aux Cmm_csem*)



(* The axiomatic model ------------------------------------------------- *)

(* The following parameters denote which model and sublanguage we use
   in the opserational semantics. If the model satisfies certain
   properties (see the Isabelle proofs), the operational semantics
   will be equivalent to the axiomatic model. These properties hold
   for some models (probably rel-acq-rlx-sc, rel-acq-rlx-sc-fences,
   with_consume and the standard model), but not all models. *)

(*val sublanguage: condition_t*)

(*val memory_model: memory_model*)

(*val axBehaviour: opsem_t -> program -> program_behaviours*)

(*val axUndefined: list fault_setgen*)

(*val getRelations: pre_execution -> execution_witness -> relation_list*)

(*val axConsistent: candidate_execution -> bool*)



(* The simplified axiomatic model -------------------------------------- *)

(* We use alternative versions of det_read and consistent_atomic_rf
   that are simpler but equivalent, and we add the requirement that
   executions are finite. The simplified axiomatic model is therefore
   equivalent to the original axiomatic model for finite
   executions. *)

(*val well_formed_threads_opsem: candidate_execution -> bool*)
fun well_formed_threads_opsem  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " well_formed_threads_opsem (pre1, wit, rel) = (
  well_formed_threads (pre1, wit, rel) \<and>
  finite ((actions0   pre1)))" 
declare well_formed_threads_opsem.simps [simp del]


(*val axsimpConsistentExecution: named_predicate_tree*)
definition axsimpConsistentExecution  :: " named_predicate_tree "  where 
     " axsimpConsistentExecution = (
  Node [ 
    ((''assumptions''),                     Leaf assumptions),
    ((''tot_empty''),                       Leaf tot_empty),
    ((''well_formed_threads_opsem''),       Leaf well_formed_threads_opsem),
    ((''well_formed_rf''),                  Leaf well_formed_rf),
    ((''locks_only_consistent_locks''),     Leaf locks_only_consistent_locks),
    ((''locks_only_consistent_lo''),        Leaf locks_only_consistent_lo),
    ((''consistent_mo''),                   Leaf consistent_mo),
    ((''sc_accesses_consistent_sc''),       Leaf sc_accesses_consistent_sc),
    ((''sc_fenced_sc_fences_heeded''),      Leaf sc_fenced_sc_fences_heeded),
    ((''consistent_hb''),                   Leaf consistent_hb),
    ((''det_read_alt''),                    Leaf det_read_alt),
    ((''consistent_non_atomic_rf''),        Leaf consistent_non_atomic_rf),
    ((''consistent_atomic_rf''),            Leaf consistent_atomic_rf),
    ((''coherent_memory_use''),             Leaf coherent_memory_use),
    ((''rmw_atomicity''),                   Leaf rmw_atomicity),
    ((''sc_accesses_sc_reads_restricted''), Leaf sc_accesses_sc_reads_restricted)  
  ])"


(*val axsimpConsistent: candidate_execution -> bool*)

(*val axsimpMemoryModel: memory_model*)
definition axsimpMemoryModel  :: " memory_model "  where 
     " axsimpMemoryModel = ( 
  (| consistent = axsimpConsistentExecution,
     relation_calculation = standard_relations,
     undefined0 = locks_only_undefined_behaviour,
     relation_flags =
       (|  rf_flag  = True,
           mo_flag  = True,
           sc_flag  = True,
           lo_flag  = True,
           tot_flag = False |)
  |) )"


(*val axsimpBehaviour: opsem_t -> program -> program_behaviours*)
definition axsimpBehaviour  :: "(program \<Rightarrow> pre_execution \<Rightarrow> bool)\<Rightarrow> nat \<Rightarrow> program_behaviours "  where 
     " axsimpBehaviour opsem_t p = (
  behaviour axsimpMemoryModel true_condition opsem_t p )"




(* The incremental model ----------------------------------------------- *)

(*val MEM [listMember] : forall 'a. Eq 'a => 'a -> list 'a -> bool*)  

(*val preRestrict: pre_execution -> set action -> pre_execution*)
definition preRestrict  :: " pre_execution \<Rightarrow>(action)set \<Rightarrow> pre_execution "  where 
     " preRestrict pre1 actions2 = ( 
(| actions0 = ((actions0   pre1) \<inter> actions2),
   threads =(threads   pre1),
   lk =(lk   pre1), 
   sb = (Lem_relation.relRestrict(sb   pre1) actions2),
   asw = (Lem_relation.relRestrict(asw   pre1) actions2),
   dd = (Lem_relation.relRestrict(dd   pre1) actions2) 
|) )"


(* incWitRestrict restricts the witness to the set of committed
   actions. *)
(*val incWitRestrict: execution_witness -> set action -> execution_witness*)
definition incWitRestrict  :: " execution_witness \<Rightarrow>(action)set \<Rightarrow> execution_witness "  where 
     " incWitRestrict wit actions2 = ( 
(| rf = (Lem_relation.relRestrict(rf   wit) actions2),
   mo = (Lem_relation.relRestrict(mo   wit) actions2),
   sc = (Lem_relation.relRestrict(sc   wit) actions2),
   lo = (Lem_relation.relRestrict(lo   wit) actions2),
   tot = (Lem_relation.relRestrict(tot   wit) actions2) 
|) )"


(* To show completeness, we will commit the actions of a pre_execution
   in a certain order, which we define here. *)

(*val pre_hb: pre_execution -> set (action * action)*)
definition pre_hb  :: " pre_execution \<Rightarrow>(action*action)set "  where 
     " pre_hb pre1 = ((sb   
  pre1) \<union> (sw_asw pre1))"


(*val wit_hb: pre_execution -> execution_witness -> set (action * action)*)
definition wit_hb  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " wit_hb pre1 wit = (        
 ((((sw_lock pre1 wit)
  \<union> (sw_rel_acq_rs pre1 wit)) 
  \<union> (sw_fence_sb_hrs_rf_sb pre1 wit))
  \<union> (sw_fence_sb_hrs_rf pre1 wit))
  \<union> (sw_fence_rs_rf_sb pre1 wit))"


(*val sb_r_f: pre_execution -> execution_witness -> set (action * action)*)
definition sb_r_f  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sb_r_f pre1 wit = (
  set_filter
    (\<lambda> (a, b) .  (is_at_atomic_location (lk   pre1) a \<and>
                            (is_read a \<and>
                               (is_fence b \<and> is_acquire b))))
    (sb   pre1) )"


(*val sb_f_w: pre_execution -> execution_witness -> set (action * action)*)
definition sb_f_w  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action*action)set "  where 
     " sb_f_w pre1 wit = (
  set_filter
    (\<lambda> (a, b) .  (is_fence a \<and>
                            (is_release a \<and>
                               (is_at_atomic_location (lk   pre1) b \<and>
                                  is_write b)))) (sb   pre1) )"


(*val incCom2_step: candidate_execution -> set (action * action)*)
fun incCom2_step  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action*action)set "  where 
     " incCom2_step (pre1, wit, rel) = (
        (((mo   wit)
  \<union>(rf   wit))
  \<union> (sb_r_f pre1 wit))
  \<union> (sb_f_w pre1 wit))" 
declare incCom2_step.simps [simp del]


(*val incCom2: candidate_execution -> set (action * action)*)
definition incCom2  :: " pre_execution*execution_witness*relation_list \<Rightarrow>(action*action)set "  where 
     " incCom2 ex = (
  trancl (incCom2_step ex))"


(* The old order *)

(*val is_na_or_non_write: pre_execution -> action -> bool*)
definition is_na_or_non_write  :: " pre_execution \<Rightarrow> action \<Rightarrow> bool "  where 
     " is_na_or_non_write pre1 a = ( 
  \<not> (is_write a) \<or> is_at_non_atomic_location(lk   pre1) a )"


(*val hbMinus: candidate_execution -> set (action * action)*)
fun hbMinus  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action*action)set "  where 
     " hbMinus (pre1,_,([])) = ( undefined )"
|" hbMinus (pre1,_,((s,hb)# _)) = ( 
  if(s = (''hb'')) then
    (set_filter (\<lambda> (a, b) .  (is_na_or_non_write pre1 b)) hb) else
    undefined )" 
declare hbMinus.simps [simp del]
 

(* The commitment order *)
(*val incCom: candidate_execution -> set (action * action)*)
fun incCom  :: " pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow>(action*action)set "  where 
     " incCom (pre1, wit, rel) = (
  trancl 
    ((op \<union>) (hbMinus (pre1, wit, rel)) 
                 ((op \<union>) ((rf   wit)) ((mo   wit)))))" 
declare incCom.simps [simp del]


(*val respectsCom: set action -> list action -> set (action * action) -> action -> bool*)
definition respectsCom  :: "(action)set \<Rightarrow>(action)list \<Rightarrow>(action*action)set \<Rightarrow> action \<Rightarrow> bool "  where 
     " respectsCom actions2 committed comOrder a = ( 
  ((\<forall> b \<in> actions2. 
    ( Set.member b (set committed) \<longrightarrow> ((a, b) \<notin> comOrder)) \<and>
    (((b, a) \<in> comOrder) \<longrightarrow> Set.member b (set committed)))))"

  

(* The state of the incremental model *)

record incState = 

 incWit::"       execution_witness " 

   incCommitted::" action list " 



(*val incCommittedSet: incState -> set action*)

(*val incInitialState: pre_execution -> incState*)
definition incInitialState  :: " pre_execution \<Rightarrow> incState "  where 
     " incInitialState _ = ( 
(| incWit       = empty_witness,
   incCommitted = [] 
|) )"


(*val incToEx: pre_execution -> incState -> candidate_execution*)
definition incToEx  :: " pre_execution \<Rightarrow> incState \<Rightarrow> pre_execution*execution_witness*(string*(action*action)set)list "  where 
     " incToEx pre1 s = ( 
  (let pre_res = (preRestrict pre1 (List.set(incCommitted   s))) in
  (let wit     = ((incWit   s)) in
  (let rel     = (standard_relations pre_res wit) in
  (pre_res, wit, rel)))))"


(* The semantics of the incremental model *)

(*val incStep: pre_execution -> incState -> incState -> action -> bool*)
definition incStep  :: " pre_execution \<Rightarrow> incState \<Rightarrow> incState \<Rightarrow> action \<Rightarrow> bool "  where 
     " incStep pre1 s1 s2 a = (

  (let s2_ex = (incToEx pre1 s2) in
  (let com = (incCom (pre1,(incWit   s2), standard_relations pre1(incWit   s2))) in  
(

  (* The action that is committed in this step hasn't already been committed *)a \<in>(actions0   pre1)) \<and>  
(\<not> ( Set.member a (set(incCommitted   s1))) \<and>
  (((incCommitted   s2) = (a #(incCommitted   s1))) \<and>  
(  

  (* Actions are committed in the right order. *)respectsCom(actions0   pre1)(incCommitted   s1) com a \<and> (( 

  (* The new execution_witness extends the previous (only new
  relations are added, and new relations are from or to the committed
  action). *)incWitRestrict(incWit   s2) (List.set(incCommitted   s1)))=(incWit   s1) \<and>

  (* The new execution satisfies the consistency predicates. *)
  apply_tree axsimpConsistentExecution s2_ex)))))))"



(* incTrace is the transitive closure of incStep, except that in the
   reflexive case we require that the consistency predicate hold. This
   is needed for soundness. *)

inductive
  incTrace  :: " pre_execution \<Rightarrow> incState \<Rightarrow> incState \<Rightarrow> bool "  where

"incReflexive": " \<And> pre0 s. 
  well_formed_threads_opsem (pre0, empty_witness, [])
==>
  incTrace pre0 s s "

|
"incStep": " \<And> pre0 x y z a.
  incTrace pre0 x y \<and> 
  incStep pre0 y z a
==>
  incTrace pre0 x z "


(*val consistencyFromTrace: (pre_execution -> incState -> incState -> bool) ->
                          candidate_execution -> bool*)
fun consistencyFromTrace  :: "(pre_execution \<Rightarrow> incState \<Rightarrow> incState \<Rightarrow> bool)\<Rightarrow> pre_execution*execution_witness*(string*(action*action)set)list \<Rightarrow> bool "  where 
     " consistencyFromTrace trace (pre1, wit, rel) = (  
(rel = standard_relations pre1 wit) \<and>  
((\<exists> s.  
  trace pre1 (incInitialState pre1) s \<and> ((incWit   s) = wit \<and>  
(List.set(incCommitted   s) =(actions0   pre1))))))" 
declare consistencyFromTrace.simps [simp del]


(*val incConsistent: candidate_execution -> bool*)
definition incConsistent  :: " candidate_execution \<Rightarrow> bool "  where 
     " incConsistent = (
  consistencyFromTrace incTrace )"



(* The monadic model --------------------------------------------------- *)

(*import Nondeterminism*)

(* Auxiliaries *)

(*val sameLocWrites: list action -> action -> list action*)
definition sameLocWrites  :: "(action)list \<Rightarrow> action \<Rightarrow>(action)list "  where 
     " sameLocWrites actions2 a = (
  (let x2 = ([]) in  List.foldr
   (\<lambda>b x2 . 
    if is_write b \<and> (loc_of b = loc_of a) then b # x2 else x2) actions2
   x2))"


(*val sameLocLocksUnlocks: list action -> action -> list action*)
definition sameLocLocksUnlocks  :: "(action)list \<Rightarrow> action \<Rightarrow>(action)list "  where 
     " sameLocLocksUnlocks actions2 a = (
  (let x2 = ([]) in  List.foldr
   (\<lambda>b x2 . 
    if (is_lock b \<or> is_unlock b) \<and> (loc_of b = loc_of a) then 
    b # x2 else x2) actions2 x2))"


(*val scActions: list action -> list action*)
definition scActions  :: "(action)list \<Rightarrow>(action)list "  where 
     " scActions actions2 = (
  (let x2 = ([]) in  List.foldr (\<lambda>b x2 .  if is_seq_cst b then b # x2 else x2) actions2
   x2))"


(*val checkValuesAreEqual: maybe (cvalue * cvalue) -> Nondeterminism.t unit*)
fun checkValuesAreEqual  :: "(cvalue_impl*cvalue_impl)option \<Rightarrow>(unit)Nondeterminism.t "  where 
     " checkValuesAreEqual (Some (value_w, value_r)) = ( 
         Nondeterminism.guard ( value_w = value_r) 
                              (Nondeterminism.Other ((''The value written ('') @ ((case  value_w of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @                                                     
 (('') and the value read ( '') @ ((case  value_r of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ 
                                                     ('') cannot be matched'')))))))"
|" checkValuesAreEqual _ = ( Nondeterminism.return ()  )" 
declare checkValuesAreEqual.simps [simp del]


(* Methods for updating the execution witness *)

(*val addToTransitiveOrder: list action -> action -> set (action * action) -> 
                          Nondeterminism.t (set (action * action))*)
definition addToTransitiveOrder  :: "(action)list \<Rightarrow> action \<Rightarrow>(action*action)set \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " addToTransitiveOrder domain1 a r = (
  Nondeterminism.mplus
  (* We insert the action before all other actions *)
  (Nondeterminism.return ((op \<union>) r (List.set ((let x2 = 
  ([]) in  List.foldr (\<lambda>b x2 .  if True then (a, b) # x2 else x2) domain1 x2)))))
  (* We choose an action, and insert 'a' directly after it *)
  ( Nondeterminism.bindExhaustive(Nondeterminism.pick (''addToTransitiveOrder'') domain1) (\<lambda> b . 
    (let prev = ((let x2 = 
  ([]) in  List.foldr (\<lambda>c x2 .  if (c, b) \<in> r then (c, a) # x2 else x2)
   domain1 x2)) in
    (let succ = ((let x2 = 
  ([]) in  List.foldr (\<lambda>c x2 .  if (b, c) \<in> r then (a, c) # x2 else x2)
   domain1 x2)) in
    Nondeterminism.return ((op \<union>) r 
                                       (Set.insert (b, a) 
                                                   ((op \<union>) (List.set prev) 
                                                                (List.set succ)))))))))"


(*val exeAddToMo: pre_execution -> action -> incState -> Nondeterminism.t (set (action * action))*)
definition exeAddToMo  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " exeAddToMo pre1 a s = (
  (let prev = ((let x2 = 
  ([]) in  List.foldr (\<lambda>b x2 .  if True then (b, a) # x2 else x2)
   (sameLocWrites (incCommitted   s) a) x2)) in
  Nondeterminism.return ((op \<union>) ((mo  (incWit   s))) (List.set prev))))"


(*val auxAddPairToRf: set (action * action) -> action -> action -> 
                    Nondeterminism.t (set (action * action) * cvalue * cvalue)*)
definition auxAddPairToRf  :: "(action*action)set \<Rightarrow> action \<Rightarrow> action \<Rightarrow>((action*action)set*cvalue_impl*cvalue_impl)Nondeterminism.t "  where 
     " auxAddPairToRf old_rf w r = (
  (case  (value_written_by w, value_read_by r) of
    (Some value_w, Some value_r) => 
      Nondeterminism.return ((Set.insert (w, r) old_rf), value_w, value_r)
  | _ => 
      Nondeterminism.kill0 (Nondeterminism.Error ([(CHR ''A''), (CHR '' ''), (CHR ''w''), (CHR ''r''), (CHR ''i''), (CHR ''t''), (CHR ''e''), (CHR ''-''), (CHR ''r''), (CHR ''e''), (CHR ''a''), (CHR ''d''), (CHR '' ''), (CHR ''p''), (CHR ''a''), (CHR ''i''), (CHR ''r''), (CHR '' ''), (CHR ''d''), (CHR ''o''), (CHR ''e''), (CHR ''s''), (CHR ''n''), (Char Nibble2 Nibble7), (CHR ''t''), (CHR '' ''), (CHR ''c''), (CHR ''o''), (CHR ''n''), (CHR ''t''), (CHR ''a''), (CHR ''i''), (CHR ''n''), (CHR '' ''), (CHR ''t''), (CHR ''h''), (CHR ''e''), (CHR '' ''), (CHR ''v''), (CHR ''a''), (CHR ''l''), (CHR ''u''), (CHR ''e''), (CHR ''s''), (CHR '' ''), (CHR ''w''), (CHR ''r''), (CHR ''i''), (CHR ''t''), (CHR ''t''), (CHR ''e''), (CHR ''n''), (CHR '' ''), (CHR ''a''), (CHR ''n''), (CHR ''d''), (CHR '' ''), (CHR ''r''), (CHR ''e''), (CHR ''a''), (CHR ''d'')]))
  ))"
  

(* NOTE: this function is only sound when the resulting execution is
   checked for det_read. Because the resulting state is not visible at 
   this point, we can't check that here. The top-level semantics is sound, 
   because in all calling fuctions we do check det_read *)
(* The return type is the new rf-relation, and Nothing if no new edge
   has been added, and otherwise Just a b with a b the values of the
   read and write of the new rf-edge. *)
(*val auxAddToRfLoad: pre_execution -> action -> incState -> 
                    Nondeterminism.t (set (action * action) * maybe (cvalue * cvalue))*)
definition auxAddToRfLoad  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set*(cvalue_impl*cvalue_impl)option)Nondeterminism.t "  where 
     " auxAddToRfLoad pre1 a s = (
  Nondeterminism.mplus
  (* We do not add an rf-edge. This should happen when there is no vse-edge in the resulting state. *)
  (Nondeterminism.return ((rf  (incWit   s)), None))
  (* We add an rf-edge. *)
  ( 
   Nondeterminism.bindExhaustive(Nondeterminism.pick (''auxAddToRfLoad'') (sameLocWrites(incCommitted   s) a)) (\<lambda> w . 
   Nondeterminism.bindExhaustive   
(auxAddPairToRf(rf  (incWit   s)) w a) (\<lambda> (new_rf, value_w, value_r) . 
   Nondeterminism.return (new_rf, Some (value_w, value_r))))))"


(*val exeAddToRfLoad: pre_execution -> action -> incState -> 
                    Nondeterminism.t (set (action * action))*)
definition exeAddToRfLoad  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " exeAddToRfLoad pre1 a s = ( Nondeterminism.bindExhaustive  
(auxAddToRfLoad pre1 a s) (\<lambda> (new_rf, v) .   Nondeterminism.bindExhaustive (checkValuesAreEqual v) (\<lambda> _ .  Nondeterminism.return new_rf)))"


(* The parameter eq is used to compare cvalues. *)
(* The return type is the new rf-relation, and Nothing if no new edge
   has been added, and otherwise Just a b with a b the values of the
   read and write of the new rf-edge. *)
(*val auxAddToRfRmw: pre_execution -> action -> incState -> 
                   Nondeterminism.t (set (action * action) * maybe (cvalue * cvalue))*)
definition auxAddToRfRmw  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set*(cvalue_impl*cvalue_impl)option)Nondeterminism.t "  where 
     " auxAddToRfRmw pre1 a s = (
  (let mo_actions = (sameLocWrites(incCommitted   s) a) in
  if (mo_actions = []) then
    Nondeterminism.return ((rf  (incWit   s)), None)
  else
    Nondeterminism.bindExhaustive    
(Nondeterminism.pick (''auxAddToRfRmw'')        
 ((let x2 = ([]) in  List.foldr
   (\<lambda>w x2 . 
    if( \<forall> c \<in> List.set mo_actions.
        (w, c) \<notin> (mo  (incWit   s))) then w # x2 else x2) mo_actions
   x2))) (\<lambda> w .   
    Nondeterminism.bindExhaustive    
(auxAddPairToRf(rf  (incWit   s)) w a) (\<lambda> (new_rf, value_w, value_r) . 
    Nondeterminism.return (new_rf, Some (value_w, value_r))))))"
   

(*val exeAddToRfRmw: pre_execution -> action -> incState -> 
                   Nondeterminism.t (set (action * action))*)
definition exeAddToRfRmw  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " exeAddToRfRmw pre1 a s = ( Nondeterminism.bindExhaustive  
(auxAddToRfRmw pre1 a s) (\<lambda> (new_rf, v) .  Nondeterminism.bindExhaustive (checkValuesAreEqual v) (\<lambda> _ .  Nondeterminism.return new_rf)))"


(*val exeAddToLo: pre_execution -> action -> incState -> Nondeterminism.t (set (action * action))*)
definition exeAddToLo  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " exeAddToLo pre1 a s = ( 
  addToTransitiveOrder (sameLocLocksUnlocks(incCommitted   s) a) a(lo  (incWit   s)))"


(*val exeAddToSc: pre_execution -> action -> incState -> Nondeterminism.t (set (action * action))*)
definition exeAddToSc  :: " pre_execution \<Rightarrow> action \<Rightarrow> incState \<Rightarrow>((action*action)set)Nondeterminism.t "  where 
     " exeAddToSc pre1 a s = ( 
  addToTransitiveOrder (scActions(incCommitted   s)) a(sc  (incWit   s)))"


(* Checking consistency in monadic style *)

(*val exeCheckConsistency: candidate_execution -> Nondeterminism.t unit*)
definition exeCheckConsistency  :: " pre_execution*execution_witness*relation_list \<Rightarrow>(unit)Nondeterminism.t "  where 
     " exeCheckConsistency ex = ( Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.guard (assumptions ex) (Nondeterminism.Other (''Inconsistent''))) (\<lambda> _ .  Nondeterminism.guard (locks_only_consistent_locks ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (locks_only_consistent_lo ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (sc_accesses_consistent_sc ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (sc_fenced_sc_fences_heeded ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (consistent_hb ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (det_read_alt ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (consistent_non_atomic_rf ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (consistent_atomic_rf ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (coherent_memory_use ex) (Nondeterminism.Other (''Inconsistent'')))) (\<lambda> _ .  Nondeterminism.guard (sc_accesses_sc_reads_restricted ex) (Nondeterminism.Other (''Inconsistent''))))"


(*val exeCheckWitRestrict: execution_witness -> set action -> execution_witness -> Nondeterminism.t unit*)
definition exeCheckWitRestrict  :: " execution_witness \<Rightarrow>(action)set \<Rightarrow> execution_witness \<Rightarrow>(unit)Nondeterminism.t "  where 
     " exeCheckWitRestrict new_wit committed old_wit = (
  Nondeterminism.guard ( (incWitRestrict new_wit committed) = old_wit) 
           (Nondeterminism.Error ([(Char Nibble2 Nibble2), (CHR ''w''), (CHR ''i''), (CHR ''t''), (CHR ''n''), (CHR ''e''), (CHR ''s''), (CHR ''s''), (CHR ''R''), (CHR ''e''), (CHR ''s''), (CHR ''t''), (CHR ''r''), (CHR ''i''), (CHR ''c''), (CHR ''t''), (CHR '' ''), (CHR ''n''), (CHR ''e''), (CHR ''w''), (CHR '' ''), (CHR ''c''), (CHR ''o''), (CHR ''m''), (CHR ''m''), (CHR ''i''), (CHR ''t''), (CHR ''t''), (CHR ''e''), (CHR ''d''), (CHR '' ''), (CHR ''=''), (CHR '' ''), (CHR ''o''), (CHR ''l''), (CHR ''d''), (Char Nibble2 Nibble2), (CHR '' ''), (CHR ''s''), (CHR ''h''), (CHR ''o''), (CHR ''u''), (CHR ''l''), (CHR ''d''), (CHR '' ''), (CHR ''h''), (CHR ''o''), (CHR ''l''), (CHR ''d''), (CHR '' ''), (CHR ''b''), (CHR ''y''), (CHR '' ''), (CHR ''c''), (CHR ''o''), (CHR ''n''), (CHR ''s''), (CHR ''t''), (CHR ''r''), (CHR ''u''), (CHR ''c''), (CHR ''t''), (CHR ''i''), (CHR ''o''), (CHR ''n''), (CHR ''.'')])))"


(*val exeCheckCommitmentOrder: pre_execution -> execution_witness -> list action 
                             -> action -> Nondeterminism.t unit*)
definition exeCheckCommitmentOrder  :: " pre_execution \<Rightarrow> execution_witness \<Rightarrow>(action)list \<Rightarrow> action \<Rightarrow>(unit)Nondeterminism.t "  where 
     " exeCheckCommitmentOrder pre1 wit committed a = ( 
  (let rel = (standard_relations pre1 wit) in
  (let order = (incCom (pre1, wit, rel)) in
  Nondeterminism.guard 
    (respectsCom(actions0   pre1) committed order a)
    (Nondeterminism.Other ((''Committing action '') @ ((([(Char Nibble2 Nibble2)]) @ ((aid_of a) @ ([(Char Nibble2 Nibble2)]))) @ 
                           ('' does not respect the commitment order.'')))))))"


(* The semantics of performing an action *)

(*val exePerformLoad: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformLoad  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformLoad pre1 s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc pre1 a s
   else
     Nondeterminism.return(sc  (incWit   s))) (\<lambda> new_sc .        Nondeterminism.bindExhaustive  
(exeAddToRfLoad pre1 a s) (\<lambda> new_rf . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| sc := new_sc, rf := new_rf  |)))))"


(*val exePerformStore: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformStore  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformStore pre1 s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc pre1 a s
   else
     Nondeterminism.return(sc  (incWit   s))) (\<lambda> new_sc .     Nondeterminism.bindExhaustive
  (if is_at_atomic_location(lk   pre1) a then
     exeAddToMo pre1 a s
   else
     Nondeterminism.return(mo  (incWit   s))) (\<lambda> new_mo . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| sc := new_sc, mo := new_mo  |)))))"


(*val exePerformRmw: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformRmw  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformRmw pre1 s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc pre1 a s
   else
     Nondeterminism.return(sc  (incWit   s))) (\<lambda> new_sc .         Nondeterminism.bindExhaustive  
(exeAddToRfRmw pre1 a s) (\<lambda> new_rf .            Nondeterminism.bindExhaustive  
(exeAddToMo pre1 a s) (\<lambda> new_mo . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| sc := new_sc, rf := new_rf, mo := new_mo  |))))))"


(*val exePerformLock: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformLock  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformLock pre1 s a = (          Nondeterminism.bindExhaustive  
(exeAddToLo pre1 a s) (\<lambda> new_lo . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| lo := new_lo  |))))"


(*val exePerformUnlock: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformUnlock  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformUnlock pre1 s a = (          Nondeterminism.bindExhaustive  
(exeAddToLo pre1 a s) (\<lambda> new_lo . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| lo := new_lo  |))))"


(*val exePerformFence: pre_execution -> incState -> action -> Nondeterminism.t execution_witness*)
definition exePerformFence  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformFence pre1 s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc pre1 a s
   else
     Nondeterminism.return(sc  (incWit   s))) (\<lambda> new_sc . 
  (* Without the extra brackets the generated isabelle code is invalid. *)
  Nondeterminism.return ((incWit   s) (| sc := new_sc  |))))"


(*val exePerformAction: pre_execution -> incState -> action  -> Nondeterminism.t execution_witness*)
definition exePerformAction  :: " pre_execution \<Rightarrow> incState \<Rightarrow> action \<Rightarrow>(execution_witness)Nondeterminism.t "  where 
     " exePerformAction pre1 s a = (
  (case  a of
    Lock _ _ _ _      => exePerformLock pre1 s a
  | Unlock _ _ _      => exePerformUnlock pre1 s a
  | Load _ _ _ _ _    => exePerformLoad pre1 s a
  | Store _ _ _ _ _   => exePerformStore pre1 s a
  | RMW _ _ _ _ _ _   => exePerformRmw pre1 s a
  | Fence _ _ _       => exePerformFence pre1 s a
  | Blocked_rmw _ _ _ => Nondeterminism.return(incWit   s)
  | Alloc _ _ _       => Nondeterminism.return(incWit   s)
  | Dealloc _ _ _     => Nondeterminism.return(incWit   s)
  ))"


(*val exeStep: pre_execution -> incState -> Nondeterminism.t (action * incState)*)
definition exeStep  :: " pre_execution \<Rightarrow> incState \<Rightarrow>(action*incState)Nondeterminism.t "  where 
     " exeStep pre1 s = (
  (let uncommitted_actions =    
 ((let x2 = ([]) in  List.foldr
   (\<lambda>a x2 . 
    if \<not> ( Set.member a (set (incCommitted   s))) then a # x2 else x2)
   (list_of_set (actions0   pre1)) x2)) in Nondeterminism.bindExhaustive  
(Nondeterminism.pick (''exeStep'') uncommitted_actions) (\<lambda> a .  Nondeterminism.bindExhaustive  

(exePerformAction pre1 s a) (\<lambda> new_wit . 

  (let new_committed = (a #(incCommitted   s)) in
  (let new_pre = (preRestrict pre1 (List.set new_committed)) in
  (let new_ex = (new_pre, new_wit, standard_relations new_pre new_wit) in     Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (exeCheckConsistency new_ex) (\<lambda> _ .  exeCheckWitRestrict new_wit (List.set(incCommitted   s))(incWit   s))) (\<lambda> _ .  exeCheckCommitmentOrder pre1 new_wit(incCommitted   s) a)) (\<lambda> _ .  (let new_state = ((| incWit       = new_wit, 
                     incCommitted = new_committed  |)) in
  Nondeterminism.return (a, new_state))))))))))"



(* exeTrace is the transitive closure of exeStep, except that in the
   reflexive case we require that the consistency predicate hold. This
   is needed for soundness. *)

inductive
  exeTrace  :: " pre_execution \<Rightarrow> incState \<Rightarrow> incState \<Rightarrow> bool "  where

"exeReflexive": " \<And> pre0 s. 
  well_formed_threads_opsem (pre0, empty_witness, [])
==>
  exeTrace pre0 s s "

|
"exeStep": " \<And> pre0 x y z a.
  exeTrace pre0 x y \<and> 
  Nondeterminism.mem (a, z) (exeStep pre0 y)
==>
  exeTrace pre0 x z "

(*val exeConsistent: candidate_execution -> bool*)
definition exeConsistent  :: " candidate_execution \<Rightarrow> bool "  where 
     " exeConsistent = (
  consistencyFromTrace exeTrace )"




(* The symbolic model -------------------------------------------------- *)

(* We have a different type of state, because pre-executions and the
   equality over cvalues can be updated. *)

record symState =

 symPre::"            pre_execution " 
 
   symWit::"            execution_witness " 

   symCommitted::" action      list " 

   symUndefinedness::" undefinedness  list " 



(*val symCommittedSet: symState -> set action*)

definition instance_Show_Show_Cmm_op_symState_dict  :: "(symState)Show_class "  where 
     " instance_Show_Show_Cmm_op_symState_dict = ((|

  show_method = (\<lambda> state. (''(pre_ex: '') @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (Set.image aid_of(actions0  (symPre   state))) @    
  (('', wit: '') @ (((''rf: '')    @ (action_rel_tostring(rf  (symWit   state)) @    
 (('', mo: '')  @ (action_rel_tostring(mo  (symWit   state)) @    
 (('', sc: '')  @ (action_rel_tostring(sc  (symWit   state)) @    
 (('', lo: '')  @ (action_rel_tostring(lo  (symWit   state)) @    
 (('', tot: '') @ action_rel_tostring(tot  (symWit   state))))))))))) @    
(('', committed: '') @ (stringFromList (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (List.map aid_of(symCommitted   state)) @ ('')'')))))))|) )"


(*val defaultLk: location_kind*)
definition defaultLk  :: " location_kind "  where 
     " defaultLk = ( Non_Atomic )"


(*val symInitialPre: pre_execution*)
definition symInitialPre  :: " pre_execution "  where 
     " symInitialPre = ( 
  (| actions0 = {}, 
     threads = {},
     lk = (\<lambda> _ .  defaultLk),
     sb = {},
     asw = {},
     dd = {}  
  |) )"


(*val symInitialState: pre_execution -> symState*)
definition symInitialState  :: " pre_execution \<Rightarrow> symState "  where 
     " symInitialState pre1 = ( 
  (| symPre = pre1,
     symWit = empty_witness,
     symCommitted = [],
     symUndefinedness = [] 
  |) )"


(* The symbolic model allows the threadwise local semantics to build
   the pre-execution step by step, as opposed to generate full
   pre-executions. *)

record preExStep = 
  
 newAction    ::" action " 

     sbBefore     ::" aid set " 

     ddBefore     ::" aid set " 

     aswBefore    ::" aid set " 

     locationKind ::"  location_kind option " 
  


definition instance_Show_Show_Cmm_op_preExStep_dict  :: "(preExStep)Show_class "  where 
     " instance_Show_Show_Cmm_op_preExStep_dict = ((|

  show_method = (\<lambda> step. (''(Action: '')     @ ((case (newAction   step) of
      Lock aid tid loc lock        =>
      (''Lock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', '') @ ((case  lock of
      Locked  => (''Locked'')
    | Blocked => (''Blocked'')
    ) @ ('')''))))))))
    | Unlock aid tid loc           =>
      (''Unlock (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @      
 ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Load aid tid mo1 loc val1     =>
      (''Load (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | Store aid tid mo1 loc val1    =>
      (''Store (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))
    | RMW aid tid mo1 loc val1 val2 =>
      (''RMW (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @      
 ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val1: '') @ ((case  val1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', val2: '') @ ((case  val2 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))))))))
    | Fence aid tid mo1             =>
      (''Fence (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', mo: '') @ ((case  mo1 of
      NA      => (''NA'')
    | Seq_cst => (''Seq_cst'')
    | Relaxed => (''Relaxed'')
    | Release => (''Release'')
    | Acquire => (''Acquire'')
    | Consume => (''Consume'')
    | Acq_rel => (''Acq_rel'')
    ) @ ('')''))))))
    | Blocked_rmw aid tid loc      =>
      (''Blocked_rmw (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))
    | Alloc aid tid loc            =>                                                 (* CSEM *)
      (''Alloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')''))))))   (* CSEM *)
    | Dealloc aid tid loc          =>                                                 (* CSEM *)
      (''Dealloc (aid: '') @ ((([(Char Nibble2 Nibble2)]) @ (aid @ ([(Char Nibble2 Nibble2)]))) @ (('', tid: '') @ ((case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', loc: '') @ ((case  loc of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ) @ ('')'')))))) (* CSEM *)
    ) @    
(('', sbBefore: '')  @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))(sbBefore   step) @    
(('', ddBefore: '')  @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))(ddBefore   step) @    
(('', aswBefore: '') @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)])))(aswBefore   step) @    
(('', locKind: '')   @ (stringFromMaybe (\<lambda> loc. (case  loc of
      Mutex      => (''Mutex'')
    | Non_Atomic => (''Non_Atomic'')
    | Atomic     => (''Atomic'')
    ))(locationKind   step) @ ('')'')))))))))))|) )"


(*val symUpdatePreEx: symState -> preExStep -> symState*)
definition symUpdatePreEx  :: " symState \<Rightarrow> preExStep \<Rightarrow> symState "  where 
     " symUpdatePreEx s step = ( 
  (let pre1 = ((symPre   s)) in
  (let new_lk = ((case  ((locationKind   step), loc_of(newAction   step)) of
                 (Some loc_kind, Some loc) => (\<lambda> x .  if x = loc then loc_kind else(lk   pre1) x)
               | _                         =>(lk   pre1)
               )) in
  (let extra_sb  = ((set_filter (\<lambda> a .  (aid_of a \<in> (sbBefore   step)))
   (actions0   pre1)) \<times>  {(newAction   step)}) in
  (let extra_dd  = ((set_filter (\<lambda> a .  (aid_of a \<in> (ddBefore   step)))
   (actions0   pre1)) \<times>  {(newAction   step)}) in
  (let extra_asw = ((set_filter (\<lambda> a .  (aid_of a \<in> (aswBefore   step)))
   (actions0   pre1)) \<times> {(newAction   step)}) in
  (let new_pre = ((| actions0 = (Set.insert(newAction   step)(actions0   pre1)),
                   threads = (Set.insert (tid_of(newAction   step))(threads   pre1)),
                   lk      = new_lk,
                   sb      = ((sb   pre1) \<union> extra_sb),
                   asw     = ((asw   pre1) \<union> extra_asw),
                   dd      = ((dd   pre1) \<union> extra_dd) 
                |)) in
   s (| symPre := new_pre  |))))))))"




(* The return type of the step function. The threadwise model wants to
   know which values are being considered equal when a new rf-edge is
   formed. *)

datatype symStep = 
    ConcurrencyTau " action " " symState "

  (* The first cvalue is the value written, the second the value read. *)
  | ReadsFrom      " cvalue " " cvalue " " action " " symState " 

definition instance_Show_Show_Cmm_op_symStep_dict  :: "(symStep)Show_class "  where 
     " instance_Show_Show_Cmm_op_symStep_dict = ((|

  show_method = (\<lambda> step. (case  step of
      ConcurrencyTau a state  => 
        (''Tau ('') @ ((([(Char Nibble2 Nibble2)]) @ ((aid_of a) @ ([(Char Nibble2 Nibble2)]))) @ (('', '') @ (((''(pre_ex: '') @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (Set.image aid_of(actions0  (symPre   state))) @    
  (('', wit: '') @ (((''rf: '')    @ (action_rel_tostring(rf  (symWit   state)) @    
 (('', mo: '')  @ (action_rel_tostring(mo  (symWit   state)) @    
 (('', sc: '')  @ (action_rel_tostring(sc  (symWit   state)) @    
 (('', lo: '')  @ (action_rel_tostring(lo  (symWit   state)) @    
 (('', tot: '') @ action_rel_tostring(tot  (symWit   state))))))))))) @    
(('', committed: '') @ (stringFromList (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (List.map aid_of(symCommitted   state)) @ ('')''))))))) @ ('')''))))
    | ReadsFrom v1 v2 a state => 
        (''ReadsFrom ('') @ ((([(Char Nibble2 Nibble2)]) @ ((aid_of a) @ ([(Char Nibble2 Nibble2)]))) @ (('', '') @ ((case  v2 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('' <- '') @ ((case  v1 of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ) @ (('', '') @ (((''(pre_ex: '') @ (stringFromSet (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (Set.image aid_of(actions0  (symPre   state))) @    
  (('', wit: '') @ (((''rf: '')    @ (action_rel_tostring(rf  (symWit   state)) @    
 (('', mo: '')  @ (action_rel_tostring(mo  (symWit   state)) @    
 (('', sc: '')  @ (action_rel_tostring(sc  (symWit   state)) @    
 (('', lo: '')  @ (action_rel_tostring(lo  (symWit   state)) @    
 (('', tot: '') @ action_rel_tostring(tot  (symWit   state))))))))))) @    
(('', committed: '') @ (stringFromList (\<lambda> s. ([(Char Nibble2 Nibble2)]) @ (s @ ([(Char Nibble2 Nibble2)]))) (List.map aid_of(symCommitted   state)) @ ('')''))))))) @ ('')''))))))))
    ))|) )"


(*val stateOf: symStep -> symState*)
fun stateOf  :: " symStep \<Rightarrow> symState "  where 
     " stateOf (ConcurrencyTau _ s) = ( s )"
|" stateOf (ReadsFrom _ _ _ s) = ( s )" 
declare stateOf.simps [simp del]


(*val actionOf: symStep -> action*)
fun actionOf  :: " symStep \<Rightarrow> action "  where 
     " actionOf (ConcurrencyTau a _) = ( a )"
|" actionOf (ReadsFrom _ _ a _) = ( a )" 
declare actionOf.simps [simp del]


(* Methods for updating the execution witness *)

(*val symToIncState: symState -> incState*)
definition symToIncState  :: " symState \<Rightarrow> incState "  where 
     " symToIncState s = (
  (| incWit =(symWit   s), 
     incCommitted =(symCommitted   s)  |) )"


(*val symAddToRfLoad: symState -> action ->  
                    Nondeterminism.t (set (action * action) * maybe (cvalue * cvalue))*)
definition symAddToRfLoad  :: " symState \<Rightarrow> action \<Rightarrow>((action*action)set*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symAddToRfLoad s a = ( 
  auxAddToRfLoad(symPre   s) a (symToIncState s))"


(*val symAddToRfRmw: symState -> action ->  
                   Nondeterminism.t (set (action * action) * maybe (cvalue * cvalue))*)
definition symAddToRfRmw  :: " symState \<Rightarrow> action \<Rightarrow>((action*action)set*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symAddToRfRmw s a = ( 
  auxAddToRfRmw(symPre   s) a (symToIncState s))"


(* The semantics of performing an action *)

(*val symPerformLoad: symState -> action ->  
                    Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformLoad  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformLoad s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc(symPre   s) a (symToIncState s)
   else
     Nondeterminism.return(sc  (symWit   s))) (\<lambda> new_sc .                        Nondeterminism.bindExhaustive  
(symAddToRfLoad s a) (\<lambda> (new_rf, values1) . 
  Nondeterminism.return ((symWit   s) (| sc := new_sc, rf := new_rf  |), values1))))"


(*val symPerformStore: symState -> action -> 
                     Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformStore  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformStore s a = ( Nondeterminism.bindExhaustive  
(exePerformStore(symPre   s) (symToIncState s) a) (\<lambda> wit .  
  Nondeterminism.return (wit, None)))"


(*val symPerformRmw: symState -> action -> 
                   Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformRmw  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformRmw s a = (    Nondeterminism.bindExhaustive
  (if is_seq_cst a then
     exeAddToSc(symPre   s) a (symToIncState s)
   else
     Nondeterminism.return(sc  (symWit   s))) (\<lambda> new_sc .                         Nondeterminism.bindExhaustive  
(symAddToRfRmw s a) (\<lambda> (new_rf, values1) .   Nondeterminism.bindExhaustive  
(exeAddToMo(symPre   s) a (symToIncState s)) (\<lambda> new_mo . 
  Nondeterminism.return ((symWit   s) (| sc := new_sc, rf := new_rf, mo := new_mo  |), values1)))))"


(*val symPerformLock: symState -> action -> 
                    Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformLock  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformLock s a = ( Nondeterminism.bindExhaustive  
(exePerformLock(symPre   s) (symToIncState s) a) (\<lambda> wit .  
  Nondeterminism.return (wit, None)))"


(*val symPerformUnlock: symState -> action -> 
                      Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformUnlock  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformUnlock s a = ( Nondeterminism.bindExhaustive  
(exePerformUnlock(symPre   s) (symToIncState s) a) (\<lambda> wit .  
  Nondeterminism.return (wit, None)))"


(*val symPerformFence: symState -> action -> 
                     Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformFence  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformFence s a = ( Nondeterminism.bindExhaustive  
(exePerformFence(symPre   s) (symToIncState s) a) (\<lambda> wit .  
  Nondeterminism.return (wit, None)))"


(*val symPerformAction: symState -> action -> 
                      Nondeterminism.t (execution_witness * maybe (cvalue * cvalue))*)
definition symPerformAction  :: " symState \<Rightarrow> action \<Rightarrow>(execution_witness*(cvalue*cvalue)option)Nondeterminism.t "  where 
     " symPerformAction s a = (
  (case  a of
    Lock _ _ _ _      => symPerformLock s a
  | Unlock _ _ _      => symPerformUnlock s a
  | Load _ _ _ _ _    => symPerformLoad s a
  | Store _ _ _ _ _   => symPerformStore s a
  | RMW _ _ _ _ _ _   => symPerformRmw s a
  | Fence _ _ _       => symPerformFence s a
  | Blocked_rmw _ _ _ => Nondeterminism.return ((symWit   s), None)
  | Alloc _ _ _       => Nondeterminism.return ((symWit   s), None)
  | Dealloc _ _ _     => Nondeterminism.return ((symWit   s), None)
  ))"


(*val symStep: symState -> Nondeterminism.t symStep*)
definition symStep  :: " symState \<Rightarrow>(symStep)Nondeterminism.t "  where 
     " symStep s = (

  (let uncommitted_actions =    
 ((let x2 = ([]) in  List.foldr
   (\<lambda>a x2 . 
    if \<not> ( Set.member a (set (symCommitted   s))) then a # x2 else x2)
   (list_of_set (actions0  (symPre   s))) x2)) in Nondeterminism.bindExhaustive  
(Nondeterminism.pick (''symStep'') uncommitted_actions) (\<lambda> a .  Nondeterminism.bindExhaustive  

(symPerformAction s a) (\<lambda> (new_wit, values1) . 

  (let new_committed = (a #(symCommitted   s)) in
  (let new_pre = (preRestrict(symPre   s) (List.set new_committed)) in
  (let new_ex = (new_pre, new_wit, standard_relations new_pre new_wit) in     Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (Nondeterminism.bindExhaustive (exeCheckConsistency new_ex) (\<lambda> _ .  exeCheckWitRestrict new_wit (List.set(symCommitted   s))(symWit   s))) (\<lambda> _ .  exeCheckCommitmentOrder(symPre   s) new_wit(symCommitted   s) a)) (\<lambda> _ .  (let new_state = ( s (|
                     symWit := new_wit,
                     symCommitted := new_committed  |)) in
  (case  values1 of
    Some (v, w) => Nondeterminism.return (ReadsFrom v w a new_state)
  | None     => Nondeterminism.return (ConcurrencyTau a new_state)
  ))))))))))"

end
