header{*Generated by Lem from cmm_aux.lem.*}

theory "Cmm_aux" 

imports 
 	 Main
	 "Lem_pervasives" 
	 "Lem_show" 
	 "Lem_show_extra" 

begin 

(* The types and functions defined in this file are parameters to the
   axiomatic model: users of the axiomatic model can implement them
   however they wish by building the model with their own version of
   cmm_aux.lem. *)

(*open import Pervasives Show Show_extra*)

type_synonym aid_impl =" string "
type_synonym program_impl =" nat "
datatype tid_impl = Tid_hol " nat "
datatype location_impl = Loc_hol " nat "
datatype cvalue_impl = Cvalue_hol " nat "

definition instance_Show_Show_Cmm_aux_tid_impl_dict  :: "(tid_impl)Show_class "  where 
     " instance_Show_Show_Cmm_aux_tid_impl_dict = ((|

  show_method = (\<lambda> tid. (case  tid of
      Tid_hol n => Lem_string_extra.stringFromNat n
    ))|) )"


definition instance_Show_Show_Cmm_aux_location_impl_dict  :: "(location_impl)Show_class "  where 
     " instance_Show_Show_Cmm_aux_location_impl_dict = ((|

  show_method = (\<lambda> location. (case  location of
      Loc_hol n => Lem_string_extra.stringFromNat n
    ))|) )"


definition instance_Show_Show_Cmm_aux_cvalue_impl_dict  :: "(cvalue_impl)Show_class "  where 
     " instance_Show_Show_Cmm_aux_cvalue_impl_dict = ((|

  show_method = (\<lambda> cvalue. (case  cvalue of
      Cvalue_hol n => Lem_string_extra.stringFromNat n
    ))|) )"


type_synonym footprint_impl =" location_impl set "

(*val footprint_of_loc_impl: location_impl -> footprint_impl*)
definition footprint_of_loc_impl  :: " location_impl \<Rightarrow>(location_impl)set "  where 
     " footprint_of_loc_impl loc = ( {loc})"


(*val footprint_empty_impl: footprint_impl*)
(* We also annotate the type in the let to avoid the Ocaml-error
contains type variables that cannot be generalized *)
definition footprint_empty_impl  :: "(location_impl)set "  where 
     " footprint_empty_impl = ( {} )"


(*val footprint_leq_impl: footprint_impl -> footprint_impl -> bool*)
definition footprint_leq_impl  :: "(location_impl)set \<Rightarrow>(location_impl)set \<Rightarrow> bool "  where 
     " footprint_leq_impl = ( (op \<subseteq>))"


(*val footprint_is_empty_impl: footprint_impl -> bool*)
definition footprint_is_empty_impl  :: "(location_impl)set \<Rightarrow> bool "  where 
     " footprint_is_empty_impl f = ( (f = {}))"


(*val footprint_difference_impl: footprint_impl -> footprint_impl -> footprint_impl*)
definition footprint_difference_impl  :: "(location_impl)set \<Rightarrow>(location_impl)set \<Rightarrow>(location_impl)set "  where 
     " footprint_difference_impl = ( (op-))"


(*val footprint_intersection_impl: footprint_impl -> footprint_impl -> footprint_impl*)
definition footprint_intersection_impl  :: "(location_impl)set \<Rightarrow>(location_impl)set \<Rightarrow>(location_impl)set "  where 
     " footprint_intersection_impl = ( (op \<inter>))"


(*val footprint_bigunion_impl: set footprint_impl -> footprint_impl*)
(* We annotate the type in the let to avoid the Ocaml-error contains
   type variables that cannot be generalized. We explicitely give the
   function a parameter s because otherwise the generated
   isabelle-code is invalid (it becomes 
     footprint_bigunion_impl = ( â )
   ) *) 
definition footprint_bigunion_impl  :: "(footprint_impl)set \<Rightarrow>(location_impl)set "  where 
     " footprint_bigunion_impl (s:: footprint_impl set) = ( \<Union> s )"


(* The implementation of combine_cvalues_impl should satisfy 

     combine_cvalues {value_written_by w, footprint_of w, footprint_of w} = value_written_by w

   for all actions w. *)

(* The first footprint is the original footprint of the write that
   wrote the value, the second footprint is the part that we read (and
   that should be combined with the other parts. *)
(*val combine_cvalues_impl: set (cvalue_impl * footprint_impl * footprint_impl) -> maybe cvalue_impl*)
definition combine_cvalues_impl  :: "(cvalue_impl*footprint_impl*footprint_impl)set \<Rightarrow>(cvalue_impl)option "  where 
     " combine_cvalues_impl s = ( (* TODO *) None )"

end
