// charon_run
//
// Copyright (c) 2015, Peter Sewell and Kayvan Memarian.
// All rights reserved. Released under the BSD 3-Clause License in LICENSE.

#include <time.h>
#include <sys/time.h>


// basic types

typedef struct string_s {
  char * buffer;  // with explicit length, not necessarily null-terminated
  int buffer_length;
  int data_length;
} string_st, *string_t;

typedef struct string_list_node_s {
  string_t string;
  struct string_list_node_s * next;
} string_list_node_t;

typedef string_list_node_t* string_list_t;

typedef string_list_node_t* string_list_option_t;


typedef struct string_pair_list_node_s {
  string_t string1;
  string_t string2;
  struct string_pair_list_node_s * next;
} string_pair_list_node_t;

typedef string_pair_list_node_t* string_pair_list_t;

typedef string_pair_list_node_t* string_pair_list_option_t;

// maintain line-by-line in sync with OCaml version from below

// type of test recipes 

typedef struct sources_s {
  string_t src_dir;
  string_t src_main;
  string_list_t src_aux;   // not yet used
} *sources_t;

typedef struct tool_s {
  string_t tool_name;
  string_t tool_args;
  string_t tool_instance_name;
  bool tool_single_phase;
  string_t tool_run_prefix;  // NULL if absent
} *tool_t;

typedef struct recipe_s {
  string_t test_instance_name;
  sources_t sources;
  tool_t tool;
} *recipe_t;

// type of test observations

typedef struct output_s {
  string_t command;
  string_t command_stdout;
  string_t command_stderr;
  int exit_code;
  string_t signals;       // null if none
  string_t start_time;
  struct timeval duration;
} *output_t;

typedef struct host_s {
  string_t host_name;
  string_t host_os;
  string_t host_os_version;
  string_t host_hardware_platform;
  string_t host_cpuinfo;
} *host_t;

typedef struct observation_s {
  recipe_t test_recipe;
  string_t test_name;
  string_t tool_version;
  host_t compile_host;          // NULL for single-phase tool
  output_t compile_output;      // NULL for single-phase tool
  string_t binary_filename;     // NULL for single-phase tool
  host_t execute_host;           // NULL for an intermediate log
  output_t execute_output;       // NULL for an intermediate log
  string_t source_hashes;
  string_t sources;
  //  string_list_t sources;     // not yet used
  // string_list_option_t assembly; // not yet used
  // string_list_option_t binary;   // not yet used
} *observation_t;

// type of tests.charon file contents

typedef struct test_s {
  string_t  src_main;
  string_list_t src_aux;
  string_list_t skip;
  string_pair_list_t expectations;
} *test_t;


// types below not needed in OCaml

// type of read-in intermediate logs
typedef struct int_s {
  string_t int_test_instance_name;
  string_t int_binary_filename;
  string_t int_first_fields;//all those of the obs before the execute_output
  string_t int_last_fields; // all those of the obs after the execute_output
} *int_t;

// type of tools.charon file contents


typedef struct tool_list_node_s {
  struct tool_s tool;
  struct tool_list_node_s * next;
} tool_list_node_t;

typedef tool_list_node_t* tool_list_t;

// misc list types



typedef struct recipe_list_node_s {
  recipe_t recipe;
  struct recipe_list_node_s * next;
} recipe_list_node_t;

typedef recipe_list_node_t* recipe_list_t;

typedef struct int_list_node_s {
  int_t intv;
  struct int_list_node_s * next;
} int_list_node_t;

typedef int_list_node_t* int_list_t;

typedef struct test_list_node_s {
  test_t test;
  struct test_list_node_s * next;
} test_list_node_t;

typedef test_list_node_t* test_list_t;


