(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Acute URI module                                               *
 *                                                                *
 * Version: $Id: uri.mli,v 1.503 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)


exception BadURI of string

type uri = { (* all stored unencoded, e.g., %3d appears as = *)
             scheme    : string;         (* "http" *)
             authority : string option;  (* // "www.cl.cam.ac.uk" *)
             path      : string option;  (* "/~kw217/index.html" *)
             query     : string option;  (* ? "foo" *)
           }

val unescape : string -> string
val escape : string -> string
val path_escape : string -> string

val parse : string -> uri
val build : uri -> string

val open_uri : uri -> in_channel
