(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * Interface: Type checker                                        *
 *                                                                *
 * Version: $Id: typecheck.mli,v 1.512 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

(* no subexpressions may contain a Clos node *)
(* no subexpressions (other than in versions) may contain LitHashes *)

open Ast

(* calculating free type variables (with colours) *)
val freetyvars_expr : eqs -> expr -> (internal_typname * eqs) list
val freetyvars_source_definition : source_definition -> (internal_typname * eqs) list

(* inference *)
val tyinf_expr : typ option -> (internal_typname * eqs) list -> nametypeenv -> eqs -> expr -> typ option -> expr * typ
val tyinf_source_definition : typ option -> (internal_typname * eqs) list -> nametypeenv -> source_definition -> source_definition * typeenv

(* checking *)
val tcheck_expr : language -> nametypeenv -> eqs -> expr -> typ option -> typ
val tcheck_definition : nametypeenv -> definition -> typeenv option -> typeenv
val tcheck_cdefs_eo : nametypeenv -> (definitions * expr option) -> (typeenv * typ option) option -> typeenv * typ option
val tcheck_mb : marshalled_body -> unit
val tcheck_configuration : configuration -> unit

(* this is quiet (whereas the above are noisy) as it's used by eval.ml within resolve methods *)

val tcheck_ssub  : nametypeenv -> eqs -> signature -> signature -> unit

val eqs_of_sign_str : hash -> signature -> structure -> eqs


exception TCFail of string         (* doesn't pass type check *)
   (* P assuming in eval.ml that _all_ type errors raise this *)
