(* -=-- --*- caml -*---------------------------------------- --=- *
 *                                                                *
 * Acute Systematic Tester Process handling primitives            *
 *                                                                *
 * Version: $Id: runtest_shell.ml,v 1.506 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

open Unix

exception Killed
exception Empty_command

(** COMPILE **)

let run = function
  | [] -> raise Empty_command
  | prog :: _ as cmd ->
      let c_out,c_in = pipe () in    (* +r , +w *)
      let args = Array.of_list cmd in
      let pid = create_process prog args stdin c_in stderr in
      close c_in;
      (pid,c_out)

let get_output descl tee =
  let mybuf = String.create 512 in
  let watch = ref (List.map (function (a,b) -> a) descl) in
  while !watch <> [] do
    let (rlist,_,elist) = select !watch [] [] (-1.0) in
    List.iter (function fd ->
      let n = read fd mybuf 0 512 in
      if n = 0 then watch := List.filter (function fd' -> fd' <> fd) !watch;
      let (fd, buf) = (List.assoc fd descl) in
      Buffer.add_substring buf mybuf 0 n;
      if tee then let _ = write fd mybuf 0 n in ();
    ) rlist;
  done

let run_compile opts test tee =
  let obuf = Buffer.create 1024 in
  let dbuf = Buffer.create 1024 in

  let (pid,out,err) = Runtest_acute.fork test opts in

  let th_buf = Thread.create (fun () -> get_output [(out,(stdout,obuf)); (err,(stderr,dbuf))] tee) () in
  let th_watch = Thread.create (
    function () -> match test.Runtest_db.expect with
    | Runtest_db.Killed i -> Thread.delay (float i); kill pid 1
    | _ -> ()
  ) () in

  let (_,st) = waitpid [] pid in
  (try Thread.kill th_watch with _ -> ());
  Thread.join th_buf;
  close out;
  close err;
  let o = Buffer.contents obuf
  and d = Buffer.contents dbuf in
  Buffer.reset obuf;
  Buffer.reset dbuf;
  match st with
  | WEXITED i -> (o,d,i)
  | _ -> raise Killed

