(* -=-- ---------------------------------------------------- --=- *
 *                                                                *
 * parsetools.ml                                                  *
 *                                                                *
 * Version: $Id: parsetools.ml,v 1.504 2004/12/22 12:23:32 zappa Exp $
 *                                                                *
*** Copyright 2002-2004 The Acute Team

  Allen-Williams, Mair
  Bishop, Steven
  Fairbairn, Matthew
  Habouzit, Pierre [*]
  Leifer, James [*]
  Sewell, Peter
  Sjberg, Vilhelm
  Steinruecken, Christian
  Vafeiadis, Viktor
  Wansbrough, Keith
  Zappa Nardelli, Francesco [*]
  Institut National de Recherche en Informatique et en Automatique (INRIA)

  Contributions of authors marked [*] are copyright INRIA.

All rights reserved.

This file is distributed under the terms of the GNU Lesser General
Public License, with the special exception on linking described in
file NEW-LICENSE.

***
 * -=-- ---------------------------------------------------- --=- *)

exception Wrapped_parse_error of string

type filename = string

let wrapped_parser_entry parser_entry envp tokenvl lexbuf =
  try
    parser_entry envp tokenvl lexbuf
  with
    Myparsing.Parse_error as e ->
      let curr_loc = Location.curr lexbuf in
      raise (Wrapped_parse_error
               ("Parse error at character "
                ^ string_of_int(Mylexing.lexeme_start lexbuf)
                ^ ".\n"
                ^ (Location.print () curr_loc)
               ))
 | Misc.Syntax_error(s) as e -> raise (Wrapped_parse_error  ("Syntax error: " ^ s ^ " at character "
                                                ^ string_of_int(Mylexing.lexeme_start lexbuf)^".\n"))

let parse_chan parser_entry lexer_new_lexenv lexer_token filename ch =
  try
    let lexbuf = Mylexing.from_channel ch in
    Location.init lexbuf filename;
    let envp = Myparsing.new_envp () in
    let envl = lexer_new_lexenv () in
    let result
      = try wrapped_parser_entry parser_entry
              envp (lexer_token envl) lexbuf
        with
          Wrapped_parse_error(s) as e -> raise e
     in
    close_in ch;
    result
  with e -> close_in ch; raise e

let parse_file parser_entry lexer_new_lexenv lexer_token filename =
  let ch = open_in filename in
  parse_chan parser_entry lexer_new_lexenv lexer_token filename ch

let parse_uri parser_entry lexer_new_lexenv lexer_token uri =
  let ch = Uri.open_uri uri in
  parse_chan parser_entry lexer_new_lexenv lexer_token (Uri.build uri) ch

let parse_string parser_entry lexer_new_lexenv lexer_token string =
  let lexbuf = Mylexing.from_string string in
  Location.init lexbuf "" (* no filename*);
  let envp = Myparsing.new_envp () in
  let envl = lexer_new_lexenv () in
  wrapped_parser_entry parser_entry envp (lexer_token envl) lexbuf

let parse_compilation_unit_from_filename filename =
  parse_file
    Parser_usersource.compilation_unit
    Lexer_usersource.new_lexenv
    Lexer_usersource.token
    filename

let parse_compilation_unit_from_string str =
  parse_string
    Parser_usersource.compilation_unit
    Lexer_usersource.new_lexenv
    Lexer_usersource.token
    str

let parse_compiled_unit_from_filename filename =
  parse_file
    Parser_compiled.compiled_unit
    Lexer_compiled.new_lexenv
    Lexer_compiled.token
    filename

let parse_compiled_unit_from_uri uri =
  parse_uri
    Parser_compiled.compiled_unit
    Lexer_compiled.new_lexenv
    Lexer_compiled.token
    uri

let parse_compiled_unit_from_string s =
  parse_string
    Parser_compiled.compiled_unit
    Lexer_compiled.new_lexenv
    Lexer_compiled.token
    s

let parse_marshalled_value_from_string string =
  parse_string
    Parser_compiled.marshalled_value
    Lexer_compiled.new_lexenv
    Lexer_compiled.token
    string
