// This file is (c) 2016 Peter Sewell
// It is made available under the Creative Commons
// Attribution-NonCommercial 4.0 International Public License 
// (CC BY-NC 4.0) in the file LICENSE

/* ******************************************************** */
//  pointer_aa_interface.c provides the following cleaner interface
//  to the astronomy code, somewhat disentangled from the 
//  original user interface


extern int objnum;  // object number (planets 0-9, star 88, orbit 99)
extern double JD;   // julian date
extern double azimuth_reference, elevation_reference;

// these functions are provided by pointer_aa_interface.c

// initialise the astronomy code
void initialise_aa();

// if objnum is 0..10, sets the (internal) elements (or 0 for sun or moon) 
//  for the corresponding planet 
void set_elements_planet();

// if objnum is 88, input a star number and set the elements for that
void input_and_set_elements_star();

// if objnum is 99, input orbital elements
void input_and_set_elements_orbit();

// print the object name (and constellation for a star) for objnum
void print_object_name();

// set JD to the current Julian date/time
void set_date_time();

// set (azimuth_reference, elevation_reference) to the topocentric
// coordinates of the object specified by objnum and the internal elements,
// at the Julian date/time in JD
void set_azalt();


// pointer_aa_interface.c uses the following, provided by pointer_aa.c,
// to flag errors and cleanly exit
void my_error_and_reset(const char *s);




