#include <stdbool.h>
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <inttypes.h>
#include <float.h>
#include <math.h>
#include <unistd.h>
#include <sys/select.h>
#include <signal.h>
#include <time.h>
#include <sys/ioctl.h>

void perror_exit(const char *s) {
  perror(s);
  exit(1);
}


// blocking reads of a byte and a number of bytes

uint8_t blocking_read(int fd) {
  uint8_t c;
  while (1) {
    int nread = read(fd,&c,1);
    if (nread == 0) continue;
    if (nread == -1) perror("error in blocking_read");
    // printf("%i\n",c);
    // if (c >=32 && c<127) { printf("%c",c); }
    break;
  }
  return(c);
}

void blocking_readline(int fd, uint8_t * buf, size_t n) {
  size_t offset;
  ssize_t nread;
  offset = 0;
  //memset(buf,23,n);
  while (1) {
    nread = read(fd, buf+offset, 1);
    //printf("%i\n",nread);
    if (nread == 0) continue;
    if (nread == -1) perror("error in blocking_readline");
    if (buf[offset] == '\n') { buf[offset+1]=0; return; }
    if (offset >= n-1) { buf[offset+1]=0; return; }
    offset++;
  }
}


int main () {

  // serial port
  const char *device3 =  "/dev/ttyACM3";
  const char *device4 =  "/dev/ttyACM4";
  const char *device5 =  "/dev/ttyACM5";
  char device[100];

  int fd = open(device3,O_RDWR);
  if (fd != -1) 
    strncpy(device,device3,100);
  else {
    fd = open(device4,O_RDWR);
    if (fd != -1) 
      strncpy(device,device4,100);
    else {
      fd = open(device5,O_RDWR);
      if (fd != -1) 
        strncpy(device,device5,100);
      else {
        printf("devices \"%s\", \"%s\", \"%s\":\n",device3,device4,device5);
        perror_exit("error opening device");
      }
    }
  }
  FILE* fp = fdopen(fd, "rw");
  if (NULL==fp) perror("fdopen error");
  printf("ready\n");

  int bufsize = 1000;
  char buf[bufsize];
  int nread;
  int bytesAv=0;

  while (true) {
    if (ioctl (fd,FIONREAD,&bytesAv) >= 0 && bytesAv >= 1) {
      blocking_readline(fd, buf, bufsize -1 );
      printf("%s",buf);
    }
    if (ioctl (fileno(stdin),FIONREAD,&bytesAv) >= 0  && bytesAv >= 1) {
      fgets(buf, bufsize, stdin);
      fprintf(fp,"%s",buf);
    }
  }
}






