/** \file
 *	\brief	utils.c source file
 *
 *  This file implements some utility functions used in several parts
 *  of the code for this project
 *
 *  These functions are not microcontroller dependent but they are intended
 *  for the AVR 8-bit architecture
 *
 *  Copyright (C) 2010 Omar Choudary (osc22@cam.ac.uk)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include "utils.h"
#include <avr/interrupt.h>

void Write16bitRegister(volatile uint16_t *reg, uint16_t value)
{
	uint8_t sreg;

	sreg = SREG;
	cli();
	*reg = value;
	SREG = sreg;	
}

uint16_t Read16bitRegister(volatile uint16_t *reg)
{
	uint16_t i;
	uint8_t sreg;

	sreg = SREG;
	cli();
	i = *reg;
	SREG = sreg;

	return i;
}
