// types

type option a = None | Some of a
type list a = Nil | Cons of a & list a

// utility functions

val toString : num -> string
val cat    : string & string -> string

// Widget construction 

val mkText   : string -> G(exists a. dom a)
val mkButton : G(exists a. dom a)
val vbox     : G(exists a. dom a)
val hbox     : G(exists a. dom a)

val attach : G(forall a b. dom a * dom b -o dom a)

// Widget modification 

val backgroundColor : string -> G(forall a. dom a -o dom a)
val color           : string -> G(forall a. dom a -o dom a)
val font            : string -> G(forall a. dom a -o dom a)
val fontFamily      : string -> G(forall a. dom a -o dom a)
val width           : string -> G(forall a. dom a -o dom a)
val text            : string -> G(forall a. dom a -o dom a)
val width           : string -> G(forall a. dom a -o dom a)

// Widget dynamics 

val split : G(forall a. dom a -o frame a * next(dom a))
val merge : G(forall a. frame a * next(dom a) -o dom a)

// Event processing

val mouseover    : stream alloc -> G(forall a. dom a -o dom a * F (stream bool))
val clicks       : stream alloc -> G(forall a. dom a -o dom a * F (stream bool))
val keypress     : stream alloc -> G(forall a. dom a -o dom a * F (stream (option string)))

// val doubleclicks : alloc -> G(forall a. dom a -o dom a * F (stream bool))

