%directs=("DCFD", ".double", "DCD", ".word", "DCB", ".byte",
          "AREA", ".section", "MACRO", ".macro", "GET", ".include",
          "EXPORT", ".global", "MEND", ".endm", "IF", ".ifdef",
          "ELSE", ".else", "ELIF", ".elseif", "ENDIF", ".endif",
          "END", ".end");
$fsource=shift(@ARGV);
open(SOURCE, $fsource);
while(<SOURCE>) {
  if(substr($_, 0, 1) eq ";") {
    # If the whole line is a comment
    substr($_, 0, 1)="@";
    print $_;
    next;
  }
  if(/^(\w+)\s*/) {
    # Handle labels at the start of lines
    $label=$1;
    $label.=":\n";
    print $label;
  }
  # Remove any label or leading whitespace
  s/^\$?\w*\s*//;
  # Change comments and a few other special symbols
  tr/;/@/;

  if(/^([a-zA-Z]+)( |$)/) {
    # See if the line is an assembler directive
    $op=$1;
    if($directs{$op} ne "") {
      substr($_, 0, length($op))=$directs{$op};
    }
    # Handle a few special cases, otherwise just print the line
    SWITCH: {
      $op =~ /^AREA/ && do { conv_area($_); last SWITCH; };
      $op =~ /^MACRO/ && do { conv_macro($_); last SWITCH; };
      $op =~ /^GET/ && do { conv_get($_); last SWITCH; };
      $op =~ /^(IF|ELIF)/ && do { conv_if($_); last SWITCH; };
      $op =~ /^END(?!IF)/ && do { conv_end($_); last SWITCH; };
      instrline($_);
    }
    # Go on to the next line
    next;
  }
  if($_ ne "") {
  # The gas assembler does not recognise the post indexed
  # vldr and vstr pseudo instructions
    $_ =~ /^vldr\.64 d(\d+),\[r(\d+)\],#8/ && do { $_=inst_vldr($_) };
    $_ =~ /^vstr\.64 d(\d+),\[r(\d+)\],#8/ && do { $_=inst_vstr($_) };
    instrline($_);
  } else {
    print "\n";
  }
}
close(SOURCE);

sub indent {
  my($line)=@_;

  return sprintf("        %s", $line);
}

sub inst_vldr {
  my($line)=@_;
  my($i, $inst);

  $line =~ /vldr\.64 d(\d+),\[r(\d+)\],#8/;
  $inst=sprintf("vldmia r%s!,\{d%s\}  ", $2, $1);
  if(($i=index($line, "@")) > -1) {
    substr($line, 0, $i)=$inst;
  } else {
    $line=$inst."@ post indexed load\n";
  }
  return $line;
}

sub inst_vstr {
  my($line)=@_;
  my($i, $inst);

  $line =~ /vstr\.64 d(\d+),\[r(\d+)\],#8/;
  $inst=sprintf("vstmia r%s!,\{d%s\}  ", $2, $1);
  if(($i=index($line, "@")) > -1) {
    substr($line, 0, $i)=$inst;
  } else {
    $line=$inst."@ post indexed store\n";
  }
  return $line;
}

sub instrline {
  my ($line)=@_;

  $line =~ s/^\$\w+\s*(.*)/\1/; # labels in macro definitions
  $line =~ tr/$/\\/; # parameters in macros
  $line =~ s/#\&/#0x/; # hex. immediate constants
  $line =~ s/\%FT?(\d+)/\1f/; # forward local labels
  $line =~ s/\%BT?(\d+)/\1b/; # backward local labels
  print indent($line);
}

sub conv_area {
  my ($area)=@_;

  $area =~ /\.section (.*)/;
  $areaname=$1;
  ($name, $type, $attr)=split /,/, $areaname, 3;
  print indent(".section $name\n");
  if($type eq "CODE") {
    print indent(".text\n");
  } elsif($type eq "DATA") {
    print indent(".data\n");
  }
}

sub conv_macro {
  my ($macro)=@_;

  $macro=<SOURCE>;
  $macro =~ s/^\$?\w*\s*//;
  $macro =~ tr/$//d;
  print indent(".macro $macro");
}

sub conv_if {
  my ($cond)=@_;

  if(substr($cond, 0, 7) eq ".elseif") {
    print indent(".endif\n");
    substr($cond, 0, 7)=".ifdef";
  }
  $cond =~ tr/{}//d; # remove braces around boolean symbols
  $cond =~ tr/\0//d; # remove stray nulls?
  print indent($cond);
}

sub conv_end {
  my ($enddir)=@_;
  my $ftype;

  $ftype=substr($fsource, 0, 4);
  if($ftype ne "Hdr." && $ftype ne "hdr.") {
    print $enddir;
  }
}

sub conv_get {
  my ($inc)=@_;

  $inc =~ s/\"(Hdr|hdr).(\w*)\"/\"\2\/s\"/;
  print indent($inc);
}
