;; Tests for f64x2 [ceil, floor, trunc, nearest] operations on major boundary values and all special values.


(module
  (func (export "f64x2.ceil") (param v128) (result v128) (f64x2.ceil (local.get 0)))
  (func (export "f64x2.floor") (param v128) (result v128) (f64x2.floor (local.get 0)))
  (func (export "f64x2.trunc") (param v128) (result v128) (f64x2.trunc (local.get 0)))
  (func (export "f64x2.nearest") (param v128) (result v128) (f64x2.nearest (local.get 0)))
)

(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0p+0 0x0p+0))
                                    (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x1p-1 0x1p-1))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                    (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x1p+0 0x1p+0))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                    (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                    (v128.const f64x2 0x1.c000000000000p+2 0x1.c000000000000p+2))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                    (v128.const f64x2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                    (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                    (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 inf inf))
                                    (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -inf -inf))
                                    (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789 0123456789))
                                    (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789e019 0123456789e019))
                                    (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                    (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                    (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789. 0123456789.))
                                    (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                    (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                    (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                    (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f64x2 123456790.0 123456790.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                    (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                    (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                    (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                    (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                    (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                    (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 nan nan))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -nan -nan))
                                    (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                    (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.ceil" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                    (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0p+0 0x0p+0))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                     (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                     (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x1p-1 0x1p-1))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                     (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x1p+0 0x1p+0))
                                     (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                     (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                     (v128.const f64x2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                     (v128.const f64x2 -0x1.c000000000000p+2 -0x1.c000000000000p+2))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                     (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                     (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 inf inf))
                                     (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -inf -inf))
                                     (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789 0123456789))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789e019 0123456789e019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789. 0123456789.))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                     (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                     (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 nan nan))
                                     (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -nan -nan))
                                     (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                     (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.floor" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                     (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0p+0 0x0p+0))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                     (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                     (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x1p-1 0x1p-1))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                     (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x1p+0 0x1p+0))
                                     (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                     (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                     (v128.const f64x2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                     (v128.const f64x2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                     (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                     (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                     (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 inf inf))
                                     (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -inf -inf))
                                     (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789 0123456789))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789e019 0123456789e019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789. 0123456789.))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                     (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                     (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                     (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                     (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                     (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                     (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                     (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                     (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 nan nan))
                                     (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -nan -nan))
                                     (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                     (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.trunc" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                     (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0p+0 0x0p+0))
                                       (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x0p+0 -0x0p+0))
                                       (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                       (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                       (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x1p-1 0x1p-1))
                                       (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x1p-1 -0x1p-1))
                                       (v128.const f64x2 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x1p+0 0x1p+0))
                                       (v128.const f64x2 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x1p+0 -0x1p+0))
                                       (v128.const f64x2 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x1.921fb54442d18p+2 0x1.921fb54442d18p+2))
                                       (v128.const f64x2 0x1.8000000000000p+2 0x1.8000000000000p+2))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x1.921fb54442d18p+2 -0x1.921fb54442d18p+2))
                                       (v128.const f64x2 -0x1.8000000000000p+2 -0x1.8000000000000p+2))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
                                       (v128.const f64x2 0x1.fffffffffffffp+1023 0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
                                       (v128.const f64x2 -0x1.fffffffffffffp+1023 -0x1.fffffffffffffp+1023))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                       (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                       (v128.const f64x2 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 inf inf))
                                       (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -inf -inf))
                                       (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789 0123456789))
                                       (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789e019 0123456789e019))
                                       (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789e+019 0123456789e+019))
                                       (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789e-019 0123456789e-019))
                                       (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789. 0123456789.))
                                       (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.e019 0123456789.e019))
                                       (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.e+019 0123456789.e+019))
                                       (v128.const f64x2 1.23456789e+27 1.23456789e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.e-019 0123456789.e-019))
                                       (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.0123456789 0123456789.0123456789))
                                       (v128.const f64x2 123456789.0 123456789.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.0123456789e019 0123456789.0123456789e019))
                                       (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                       (v128.const f64x2 1.2345678901234569e+27 1.2345678901234569e+27))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                       (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef))
                                       (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdefp019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdefp+019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdefp-019))
                                       (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef. 0x0123456789ABCDEFabcdef.))
                                       (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.p019 0x0123456789ABCDEFabcdef.p019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.p+019 0x0123456789ABCDEFabcdef.p+019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.p-019 0x0123456789ABCDEFabcdef.p-019))
                                       (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdef))
                                       (v128.const f64x2 1.3754889325393114e+24 1.3754889325393114e+24))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp+019))
                                       (v128.const f64x2 7.211523414631705e+29 7.211523414631705e+29))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019 0x0123456789ABCDEFabcdef.0123456789ABCDEFabcdefp-019))
                                       (v128.const f64x2 2.6235369349275807e+18 2.6235369349275807e+18))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 nan nan))
                                       (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -nan -nan))
                                       (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                       (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.nearest" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                       (v128.const f64x2 nan:arithmetic nan:arithmetic))


;; Unknown operators

(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i8x16.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i16x8.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i32x4.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.ceil (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.floor (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.trunc (v128.const i32x4 0 0 0 0)))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (result v128) (i64x2.nearest (v128.const i32x4 0 0 0 0)))") "unknown operator")

;; type check
(assert_invalid (module (func (result v128) (f64x2.ceil (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.floor (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.trunc (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f64x2.nearest (i32.const 0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f64x2.ceil-arg-empty (result v128)
      (f64x2.ceil)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.floor-arg-empty (result v128)
      (f64x2.floor)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.trunc-arg-empty (result v128)
      (f64x2.trunc)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f64x2.nearest-arg-empty (result v128)
      (f64x2.nearest)
    )
  )
  "type mismatch"
)

