// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/clif.isle
// - src/prelude.isle
// - src/isa/x64/inst.isle
// - src/isa/x64/lower.isle

#![allow(dead_code, unreachable_code, unreachable_patterns)]
#![allow(unused_imports, unused_variables, non_snake_case)]
#![allow(irrefutable_let_patterns)]

use super::*; // Pulls in all external types.

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn value_regs_invalid(&mut self) -> ValueRegs;
    fn output_none(&mut self) -> InstOutput;
    fn output(&mut self, arg0: ValueRegs) -> InstOutput;
    fn output_pair(&mut self, arg0: ValueRegs, arg1: ValueRegs) -> InstOutput;
    fn output_builder_new(&mut self) -> InstOutputBuilder;
    fn output_builder_push(&mut self, arg0: &InstOutputBuilder, arg1: ValueRegs) -> Unit;
    fn output_builder_finish(&mut self, arg0: &InstOutputBuilder) -> InstOutput;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn invalid_reg(&mut self) -> Reg;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn i64_as_u64(&mut self, arg0: i64) -> u64;
    fn u64_add(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sub(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_and(&mut self, arg0: u64, arg1: u64) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bits_u64(&mut self, arg0: Type) -> u64;
    fn ty_mask(&mut self, arg0: Type) -> u64;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_bool_128(&mut self, arg0: Type) -> Option<Type>;
    fn vec128(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn value_slice_empty(&mut self, arg0: ValueSlice) -> Option<()>;
    fn value_slice_unwrap(&mut self, arg0: ValueSlice) -> Option<(Value, ValueSlice)>;
    fn value_slice_len(&mut self, arg0: ValueSlice) -> usize;
    fn value_slice_get(&mut self, arg0: ValueSlice, arg1: usize) -> Value;
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn u64_from_ieee32(&mut self, arg0: Ieee32) -> u64;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u8, u16)>;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn emit_safepoint(&mut self, arg0: &MInst) -> Unit;
    fn trap_code_division_by_zero(&mut self) -> TrapCode;
    fn trap_code_integer_overflow(&mut self) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self) -> TrapCode;
    fn avoid_div_traps(&mut self, arg0: Type) -> Option<()>;
    fn func_ref_data(&mut self, arg0: FuncRef) -> (SigRef, ExternalName, RelocDistance);
    fn symbol_value_data(
        &mut self,
        arg0: GlobalValue,
    ) -> Option<(ExternalName, RelocDistance, i64)>;
    fn reloc_distance_near(&mut self, arg0: RelocDistance) -> Option<()>;
    fn operand_size_of_type_32_64(&mut self, arg0: Type) -> OperandSize;
    fn raw_operand_size_of_type(&mut self, arg0: Type) -> OperandSize;
    fn put_in_reg_mem_imm(&mut self, arg0: Value) -> RegMemImm;
    fn put_in_reg_mem(&mut self, arg0: Value) -> RegMem;
    fn synthetic_amode_to_reg_mem(&mut self, arg0: &SyntheticAmode) -> RegMem;
    fn amode_imm_reg_reg_shift(&mut self, arg0: u32, arg1: Gpr, arg2: Gpr, arg3: u8) -> Amode;
    fn amode_to_synthetic_amode(&mut self, arg0: &Amode) -> SyntheticAmode;
    fn put_masked_in_imm8_gpr(&mut self, arg0: Value, arg1: Type) -> Imm8Gpr;
    fn encode_fcmp_imm(&mut self, arg0: &FcmpImm) -> u8;
    fn imm8_reg_to_imm8_gpr(&mut self, arg0: &Imm8Reg) -> Imm8Gpr;
    fn writable_gpr_to_reg(&mut self, arg0: WritableGpr) -> WritableReg;
    fn writable_xmm_to_reg(&mut self, arg0: WritableXmm) -> WritableReg;
    fn writable_reg_to_xmm(&mut self, arg0: WritableReg) -> WritableXmm;
    fn writable_xmm_to_xmm(&mut self, arg0: WritableXmm) -> Xmm;
    fn writable_gpr_to_gpr(&mut self, arg0: WritableGpr) -> Gpr;
    fn gpr_to_reg(&mut self, arg0: Gpr) -> Reg;
    fn gpr_to_gpr_mem(&mut self, arg0: Gpr) -> GprMem;
    fn gpr_to_gpr_mem_imm(&mut self, arg0: Gpr) -> GprMemImm;
    fn xmm_to_reg(&mut self, arg0: Xmm) -> Reg;
    fn xmm_to_xmm_mem_imm(&mut self, arg0: Xmm) -> XmmMemImm;
    fn temp_writable_gpr(&mut self) -> WritableGpr;
    fn temp_writable_xmm(&mut self) -> WritableXmm;
    fn reg_mem_to_xmm_mem(&mut self, arg0: &RegMem) -> XmmMem;
    fn gpr_mem_imm_new(&mut self, arg0: &RegMemImm) -> GprMemImm;
    fn xmm_mem_imm_new(&mut self, arg0: &RegMemImm) -> XmmMemImm;
    fn xmm_to_xmm_mem(&mut self, arg0: Xmm) -> XmmMem;
    fn xmm_mem_to_reg_mem(&mut self, arg0: &XmmMem) -> RegMem;
    fn gpr_mem_to_reg_mem(&mut self, arg0: &GprMem) -> RegMem;
    fn xmm_new(&mut self, arg0: Reg) -> Xmm;
    fn gpr_new(&mut self, arg0: Reg) -> Gpr;
    fn reg_mem_to_gpr_mem(&mut self, arg0: &RegMem) -> GprMem;
    fn reg_to_gpr_mem(&mut self, arg0: Reg) -> GprMem;
    fn gpr_to_imm8_gpr(&mut self, arg0: Gpr) -> Imm8Gpr;
    fn imm8_to_imm8_gpr(&mut self, arg0: u8) -> Imm8Gpr;
    fn xmm0(&mut self) -> WritableXmm;
    fn is_xmm_type(&mut self, arg0: Type) -> Option<Type>;
    fn is_gpr_type(&mut self, arg0: Type) -> Option<Type>;
    fn is_single_register_type(&mut self, arg0: Type) -> Option<Type>;
    fn avx512vl_enabled(&mut self, arg0: Type) -> Option<()>;
    fn avx512dq_enabled(&mut self, arg0: Type) -> Option<()>;
    fn avx512f_enabled(&mut self, arg0: Type) -> Option<()>;
    fn avx512bitalg_enabled(&mut self, arg0: Type) -> Option<()>;
    fn use_lzcnt(&mut self, arg0: Type) -> Option<()>;
    fn use_bmi1(&mut self, arg0: Type) -> Option<()>;
    fn use_popcnt(&mut self, arg0: Type) -> Option<()>;
    fn imm8_from_value(&mut self, arg0: Value) -> Option<Imm8Reg>;
    fn const_to_type_masked_imm8(&mut self, arg0: u64, arg1: Type) -> Imm8Gpr;
    fn simm32_from_value(&mut self, arg0: Value) -> Option<GprMemImm>;
    fn simm32_from_imm64(&mut self, arg0: Imm64) -> Option<GprMemImm>;
    fn sinkable_load(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sink_load(&mut self, arg0: &SinkableLoad) -> RegMemImm;
    fn ext_mode(&mut self, arg0: u16, arg1: u16) -> ExtMode;
    fn nonzero_u64_fits_in_u32(&mut self, arg0: u64) -> Option<u64>;
    fn ishl_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ishl_i8x16_mask_table(&mut self) -> SyntheticAmode;
    fn ushr_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ushr_i8x16_mask_table(&mut self) -> SyntheticAmode;
    fn sse_insertps_lane_imm(&mut self, arg0: u8) -> u8;
    fn popcount_4bit_table(&mut self) -> VCodeConstant;
    fn popcount_low_mask(&mut self) -> VCodeConstant;
}

/// Internal type SideEffectNoResult: defined at src/prelude.isle line 393.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst { inst: MInst },
}

/// Internal type ProducesFlags: defined at src/prelude.isle line 415.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    ProducesFlagsSideEffect { inst: MInst },
    ProducesFlagsReturnsReg { inst: MInst, result: Reg },
    ProducesFlagsReturnsResultWithConsumer { inst: MInst, result: Reg },
}

/// Internal type ConsumesFlags: defined at src/prelude.isle line 426.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlagsReturnsResultWithProducer {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsTwiceReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        result: ValueRegs,
    },
    ConsumesFlagsFourTimesReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
        inst4: MInst,
        result: ValueRegs,
    },
}

/// Internal type MInst: defined at src/isa/x64/inst.isle line 8.
#[derive(Clone)]
pub enum MInst {
    Nop {
        len: u8,
    },
    AluRmiR {
        size: OperandSize,
        op: AluRmiROpcode,
        src1: Gpr,
        src2: GprMemImm,
        dst: WritableGpr,
    },
    UnaryRmR {
        size: OperandSize,
        op: UnaryRmROpcode,
        src: GprMem,
        dst: WritableGpr,
    },
    Not {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Neg {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Div {
        size: OperandSize,
        signed: bool,
        divisor: GprMem,
        dividend: Gpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
    },
    MulHi {
        size: OperandSize,
        signed: bool,
        src1: Gpr,
        src2: GprMem,
        dst_lo: WritableGpr,
        dst_hi: WritableGpr,
    },
    CheckedDivOrRemSeq {
        kind: DivOrRemKind,
        size: OperandSize,
        dividend: Gpr,
        divisor: WritableGpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
        tmp: OptionWritableGpr,
    },
    SignExtendData {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Imm {
        dst_size: OperandSize,
        simm64: u64,
        dst: WritableGpr,
    },
    MovRR {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    MovzxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    Mov64MR {
        src: SyntheticAmode,
        dst: WritableGpr,
    },
    LoadEffectiveAddress {
        addr: SyntheticAmode,
        dst: WritableGpr,
    },
    MovsxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    MovRM {
        size: OperandSize,
        src: Gpr,
        dst: SyntheticAmode,
    },
    ShiftR {
        size: OperandSize,
        kind: ShiftKind,
        src: Gpr,
        num_bits: Imm8Gpr,
        dst: WritableGpr,
    },
    XmmRmiReg {
        opcode: SseOpcode,
        src1: Xmm,
        src2: XmmMemImm,
        dst: WritableXmm,
    },
    CmpRmiR {
        size: OperandSize,
        opcode: CmpOpcode,
        src: GprMemImm,
        dst: Gpr,
    },
    Setcc {
        cc: CC,
        dst: WritableGpr,
    },
    Cmove {
        size: OperandSize,
        cc: CC,
        consequent: GprMem,
        alternative: Gpr,
        dst: WritableGpr,
    },
    XmmCmove {
        size: OperandSize,
        cc: CC,
        consequent: XmmMem,
        alternative: Xmm,
        dst: WritableXmm,
    },
    Push64 {
        src: GprMemImm,
    },
    Pop64 {
        dst: WritableGpr,
    },
    XmmRmR {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
    },
    XmmRmREvex {
        op: Avx512Opcode,
        src1: XmmMem,
        src2: Xmm,
        dst: WritableXmm,
    },
    XmmUnaryRmR {
        op: SseOpcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmREvex {
        op: Avx512Opcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmMovRM {
        op: SseOpcode,
        src: Reg,
        dst: SyntheticAmode,
    },
    XmmLoadConst {
        src: VCodeConstant,
        dst: WritableReg,
        ty: Type,
    },
    XmmToGpr {
        op: SseOpcode,
        src: Xmm,
        dst: WritableGpr,
        dst_size: OperandSize,
    },
    GprToXmm {
        op: SseOpcode,
        src: GprMem,
        dst: WritableXmm,
        src_size: OperandSize,
    },
    CvtUint64ToFloatSeq {
        dst_size: OperandSize,
        src: WritableGpr,
        dst: WritableXmm,
        tmp_gpr1: WritableGpr,
        tmp_gpr2: WritableGpr,
    },
    CvtFloatToSintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: WritableXmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
    },
    CvtFloatToUintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: WritableXmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
    },
    XmmMinMaxSeq {
        size: OperandSize,
        is_min: bool,
        lhs: Xmm,
        rhs: Xmm,
        dst: WritableXmm,
    },
    XmmCmpRmR {
        op: SseOpcode,
        src: XmmMem,
        dst: Xmm,
    },
    XmmRmRImm {
        op: SseOpcode,
        src1: Reg,
        src2: RegMem,
        dst: WritableReg,
        imm: u8,
        size: OperandSize,
    },
    CallKnown {
        dest: ExternalName,
        uses: VecReg,
        defs: VecWritableReg,
        opcode: Opcode,
    },
    CallUnknown {
        dest: RegMem,
        uses: VecReg,
        defs: VecWritableReg,
        opcode: Opcode,
    },
    Ret,
    EpiloguePlaceholder,
    JmpKnown {
        dst: MachLabel,
    },
    JmpIf {
        cc: CC,
        taken: MachLabel,
    },
    JmpCond {
        cc: CC,
        taken: MachLabel,
        not_taken: MachLabel,
    },
    JmpTableSeq {
        idx: Reg,
        tmp1: WritableReg,
        tmp2: WritableReg,
        default_target: MachLabel,
        targets: VecMachLabel,
        targets_for_term: VecMachLabel,
    },
    JmpUnknown {
        target: RegMem,
    },
    TrapIf {
        cc: CC,
        trap_code: TrapCode,
    },
    Hlt,
    Ud2 {
        trap_code: TrapCode,
    },
    LoadExtName {
        dst: WritableReg,
        name: BoxExternalName,
        offset: i64,
    },
    LockCmpxchg {
        ty: Type,
        replacement: Reg,
        expected: Reg,
        mem: SyntheticAmode,
        dst_old: WritableReg,
    },
    AtomicRmwSeq {
        ty: Type,
        op: AtomicRmwOp,
        address: Reg,
        operand: Reg,
        temp: WritableReg,
        dst_old: WritableReg,
    },
    Fence {
        kind: FenceKind,
    },
    VirtualSPOffsetAdj {
        offset: i64,
    },
    XmmUninitializedValue {
        dst: WritableXmm,
    },
    ElfTlsGetAddr {
        symbol: ExternalName,
    },
    MachOTlsGetAddr {
        symbol: ExternalName,
    },
    ValueLabelMarker {
        reg: Reg,
        label: ValueLabel,
    },
    Unwind {
        inst: UnwindInst,
    },
}

/// Internal type ExtendKind: defined at src/isa/x64/inst.isle line 1120.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ExtendKind {
    Sign,
    Zero,
}

// Generated as internal constructor for term output_reg.
pub fn constructor_output_reg<C: Context>(ctx: &mut C, arg0: Reg) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 86.
    let expr0_0 = C::value_reg(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term output_value.
pub fn constructor_output_value<C: Context>(ctx: &mut C, arg0: Value) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 90.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0 = C::output(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(ctx: &mut C, arg0: Type) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 110.
    let expr0_0 = C::temp_writable_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(ctx: &mut C, arg0: Value) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/prelude.isle line 145.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term side_effect.
pub fn constructor_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 398.
        let expr0_0 = C::emit(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term safepoint.
pub fn constructor_safepoint<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let &SideEffectNoResult::Inst {
        inst: ref pattern1_0,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 404.
        let expr0_0 = C::emit_safepoint(ctx, pattern1_0);
        let expr1_0 = C::output_none(ctx);
        return Some(expr1_0);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_get_reg.
pub fn constructor_produces_flags_get_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if let &ProducesFlags::ProducesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        // Rule at src/prelude.isle line 442.
        return Some(pattern1_1);
    }
    return None;
}

// Generated as internal constructor for term produces_flags_ignore.
pub fn constructor_produces_flags_ignore<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 447.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            // Rule at src/prelude.isle line 449.
            let expr0_0 = ProducesFlags::ProducesFlagsSideEffect {
                inst: pattern1_0.clone(),
            };
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term consumes_flags_concat.
pub fn constructor_consumes_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ConsumesFlags,
    arg1: &ConsumesFlags,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if let &ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: ref pattern1_0,
        result: pattern1_1,
    } = pattern0_0
    {
        let pattern2_0 = arg1;
        if let &ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: ref pattern3_0,
            result: pattern3_1,
        } = pattern2_0
        {
            // Rule at src/prelude.isle line 456.
            let expr0_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
            let expr1_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                inst1: pattern1_0.clone(),
                inst2: pattern3_0.clone(),
                result: expr0_0,
            };
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref pattern1_0,
        } => {
            let pattern2_0 = arg1;
            match pattern2_0 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref pattern3_0,
                    result: pattern3_1,
                } => {
                    // Rule at src/prelude.isle line 481.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::value_reg(ctx, pattern3_1);
                    return Some(expr2_0);
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    result: pattern3_2,
                } => {
                    // Rule at src/prelude.isle line 487.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    return Some(pattern3_2);
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref pattern3_0,
                    inst2: ref pattern3_1,
                    inst3: ref pattern3_2,
                    inst4: ref pattern3_3,
                    result: pattern3_4,
                } => {
                    // Rule at src/prelude.isle line 499.
                    let expr0_0 = C::emit(ctx, pattern1_0);
                    let expr1_0 = C::emit(ctx, pattern3_0);
                    let expr2_0 = C::emit(ctx, pattern3_1);
                    let expr3_0 = C::emit(ctx, pattern3_2);
                    let expr4_0 = C::emit(ctx, pattern3_3);
                    return Some(pattern3_4);
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref pattern1_0,
            result: pattern1_1,
        } => {
            let pattern2_0 = arg1;
            if let &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                inst: ref pattern3_0,
                result: pattern3_1,
            } = pattern2_0
            {
                // Rule at src/prelude.isle line 475.
                let expr0_0 = C::emit(ctx, pattern1_0);
                let expr1_0 = C::emit(ctx, pattern3_0);
                let expr2_0 = C::value_regs(ctx, pattern1_1, pattern3_1);
                return Some(expr2_0);
            }
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term with_flags_reg.
pub fn constructor_with_flags_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/prelude.isle line 516.
    let expr0_0 = constructor_with_flags(ctx, pattern0_0, pattern1_0)?;
    let expr1_0: usize = 0;
    let expr2_0 = C::value_regs_get(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term operand_size_bits.
pub fn constructor_operand_size_bits<C: Context>(ctx: &mut C, arg0: &OperandSize) -> Option<u16> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &OperandSize::Size8 => {
            // Rule at src/isa/x64/inst.isle line 510.
            let expr0_0: u16 = 8;
            return Some(expr0_0);
        }
        &OperandSize::Size16 => {
            // Rule at src/isa/x64/inst.isle line 511.
            let expr0_0: u16 = 16;
            return Some(expr0_0);
        }
        &OperandSize::Size32 => {
            // Rule at src/isa/x64/inst.isle line 512.
            let expr0_0: u16 = 32;
            return Some(expr0_0);
        }
        &OperandSize::Size64 => {
            // Rule at src/isa/x64/inst.isle line 513.
            let expr0_0: u16 = 64;
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term reg_to_gpr_mem_imm.
pub fn constructor_reg_to_gpr_mem_imm<C: Context>(ctx: &mut C, arg0: Reg) -> Option<GprMemImm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 950.
    let expr0_0 = C::gpr_new(ctx, pattern0_0);
    let expr1_0 = C::gpr_to_gpr_mem_imm(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_gpr.
pub fn constructor_put_in_gpr<C: Context>(ctx: &mut C, arg0: Value) -> Option<Gpr> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 957.
    let expr0_0 = C::put_in_reg(ctx, pattern0_0);
    let expr1_0 = C::gpr_new(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_gpr_mem.
pub fn constructor_put_in_gpr_mem<C: Context>(ctx: &mut C, arg0: Value) -> Option<GprMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 964.
    let expr0_0 = C::put_in_reg_mem(ctx, pattern0_0);
    let expr1_0 = C::reg_mem_to_gpr_mem(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_gpr_mem_imm.
pub fn constructor_put_in_gpr_mem_imm<C: Context>(ctx: &mut C, arg0: Value) -> Option<GprMemImm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 971.
    let expr0_0 = C::put_in_reg_mem_imm(ctx, pattern0_0);
    let expr1_0 = C::gpr_mem_imm_new(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_xmm.
pub fn constructor_put_in_xmm<C: Context>(ctx: &mut C, arg0: Value) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 978.
    let expr0_0 = C::put_in_reg(ctx, pattern0_0);
    let expr1_0 = C::xmm_new(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_xmm_mem.
pub fn constructor_put_in_xmm_mem<C: Context>(ctx: &mut C, arg0: Value) -> Option<XmmMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 985.
    let expr0_0 = C::put_in_reg_mem(ctx, pattern0_0);
    let expr1_0 = C::reg_mem_to_xmm_mem(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term put_in_xmm_mem_imm.
pub fn constructor_put_in_xmm_mem_imm<C: Context>(ctx: &mut C, arg0: Value) -> Option<XmmMemImm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 992.
    let expr0_0 = C::put_in_reg_mem_imm(ctx, pattern0_0);
    let expr1_0 = C::xmm_mem_imm_new(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term output_gpr.
pub fn constructor_output_gpr<C: Context>(ctx: &mut C, arg0: Gpr) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 997.
    let expr0_0 = C::gpr_to_reg(ctx, pattern0_0);
    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term value_gprs.
pub fn constructor_value_gprs<C: Context>(ctx: &mut C, arg0: Gpr, arg1: Gpr) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1002.
    let expr0_0 = C::gpr_to_reg(ctx, pattern0_0);
    let expr1_0 = C::gpr_to_reg(ctx, pattern1_0);
    let expr2_0 = C::value_regs(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term output_xmm.
pub fn constructor_output_xmm<C: Context>(ctx: &mut C, arg0: Xmm) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1007.
    let expr0_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term value_regs_get_gpr.
pub fn constructor_value_regs_get_gpr<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: usize,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1014.
    let expr0_0 = C::value_regs_get(ctx, pattern0_0, pattern1_0);
    let expr1_0 = C::gpr_new(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lo_gpr.
pub fn constructor_lo_gpr<C: Context>(ctx: &mut C, arg0: Value) -> Option<Gpr> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1027.
    let expr0_0 = constructor_lo_reg(ctx, pattern0_0)?;
    let expr1_0 = C::gpr_new(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term sink_load_to_gpr_mem_imm.
pub fn constructor_sink_load_to_gpr_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> Option<GprMemImm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1110.
    let expr0_0 = C::sink_load(ctx, pattern0_0);
    let expr1_0 = C::gpr_mem_imm_new(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term extend_to_gpr.
pub fn constructor_extend_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
    arg2: &ExtendKind,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    let pattern2_0 = arg1;
    if pattern2_0 == pattern1_0 {
        let pattern4_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1132.
        let expr0_0 = constructor_put_in_gpr(ctx, pattern0_0)?;
        return Some(expr0_0);
    }
    let pattern3_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1135.
    let expr0_0 = C::ty_bits_u16(ctx, pattern1_0);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern2_0);
    let expr2_0 = constructor_operand_size_bits(ctx, &expr1_0)?;
    let expr3_0 = C::ext_mode(ctx, expr0_0, expr2_0);
    let expr4_0 = constructor_put_in_gpr_mem(ctx, pattern0_0)?;
    let expr5_0 = constructor_extend(ctx, pattern3_0, pattern2_0, &expr3_0, &expr4_0)?;
    return Some(expr5_0);
}

// Generated as internal constructor for term extend.
pub fn constructor_extend<C: Context>(
    ctx: &mut C,
    arg0: &ExtendKind,
    arg1: Type,
    arg2: &ExtMode,
    arg3: &GprMem,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &ExtendKind::Sign => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            let pattern4_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 1155.
            let expr0_0 = constructor_movsx(ctx, pattern2_0, pattern3_0, pattern4_0)?;
            return Some(expr0_0);
        }
        &ExtendKind::Zero => {
            let pattern2_0 = arg1;
            let pattern3_0 = arg2;
            let pattern4_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 1151.
            let expr0_0 = constructor_movzx(ctx, pattern2_0, pattern3_0, pattern4_0)?;
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term sse_xor_op.
pub fn constructor_sse_xor_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 1162.
        let expr0_0 = SseOpcode::Xorps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 1163.
        let expr0_0 = SseOpcode::Xorpd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        // Rule at src/isa/x64/inst.isle line 1164.
        let expr0_0 = SseOpcode::Pxor;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sse_xor.
pub fn constructor_sse_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1168.
    let expr0_0 = constructor_sse_xor_op(ctx, pattern0_0)?;
    let expr1_0 = constructor_xmm_rm_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sse_cmp_op.
pub fn constructor_sse_cmp_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 1177.
        let expr0_0 = SseOpcode::Cmpps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 1178.
        let expr0_0 = SseOpcode::Cmppd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        if pattern1_0 == 8 {
            if pattern1_1 == 16 {
                // Rule at src/isa/x64/inst.isle line 1173.
                let expr0_0 = SseOpcode::Pcmpeqb;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 16 {
            if pattern1_1 == 8 {
                // Rule at src/isa/x64/inst.isle line 1174.
                let expr0_0 = SseOpcode::Pcmpeqw;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 32 {
            if pattern1_1 == 4 {
                // Rule at src/isa/x64/inst.isle line 1175.
                let expr0_0 = SseOpcode::Pcmpeqd;
                return Some(expr0_0);
            }
        }
        if pattern1_0 == 64 {
            if pattern1_1 == 2 {
                // Rule at src/isa/x64/inst.isle line 1176.
                let expr0_0 = SseOpcode::Pcmpeqq;
                return Some(expr0_0);
            }
        }
    }
    return None;
}

// Generated as internal constructor for term vector_all_ones.
pub fn constructor_vector_all_ones<C: Context>(ctx: &mut C, arg0: Type) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1192.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0: Type = I32X4;
    let expr2_0 = constructor_sse_cmp_op(ctx, expr1_0)?;
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    let expr4_0 = constructor_writable_xmm_to_xmm_mem(ctx, expr0_0)?;
    let expr5_0 = MInst::XmmRmR {
        op: expr2_0,
        src1: expr3_0,
        src2: expr4_0,
        dst: expr0_0,
    };
    let expr6_0 = C::emit(ctx, &expr5_0);
    let expr7_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr7_0);
}

// Generated as internal constructor for term make_i64x2_from_lanes.
pub fn constructor_make_i64x2_from_lanes<C: Context>(
    ctx: &mut C,
    arg0: &GprMem,
    arg1: &GprMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1202.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::writable_xmm_to_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmUninitializedValue { dst: expr0_0 };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = SseOpcode::Pinsrd;
    let expr5_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr6_0 = C::gpr_mem_to_reg_mem(ctx, pattern0_0);
    let expr7_0: u8 = 0;
    let expr8_0 = OperandSize::Size64;
    let expr9_0 = MInst::XmmRmRImm {
        op: expr4_0,
        src1: expr5_0,
        src2: expr6_0,
        dst: expr1_0,
        imm: expr7_0,
        size: expr8_0,
    };
    let expr10_0 = C::emit(ctx, &expr9_0);
    let expr11_0 = SseOpcode::Pinsrd;
    let expr12_0 = C::writable_reg_to_reg(ctx, expr1_0);
    let expr13_0 = C::gpr_mem_to_reg_mem(ctx, pattern1_0);
    let expr14_0: u8 = 1;
    let expr15_0 = OperandSize::Size64;
    let expr16_0 = MInst::XmmRmRImm {
        op: expr11_0,
        src1: expr12_0,
        src2: expr13_0,
        dst: expr1_0,
        imm: expr14_0,
        size: expr15_0,
    };
    let expr17_0 = C::emit(ctx, &expr16_0);
    let expr18_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr18_0);
}

// Generated as internal constructor for term mov_rmi_to_xmm.
pub fn constructor_mov_rmi_to_xmm<C: Context>(ctx: &mut C, arg0: &RegMemImm) -> Option<XmmMemImm> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &RegMemImm::Imm { simm32: pattern1_0 } => {
            // Rule at src/isa/x64/inst.isle line 1223.
            let expr0_0 = C::xmm_mem_imm_new(ctx, pattern0_0);
            return Some(expr0_0);
        }
        &RegMemImm::Reg { reg: pattern1_0 } => {
            // Rule at src/isa/x64/inst.isle line 1224.
            let expr0_0 = SseOpcode::Movd;
            let expr1_0 = C::reg_to_gpr_mem(ctx, pattern1_0);
            let expr2_0 = OperandSize::Size32;
            let expr3_0 = constructor_gpr_to_xmm(ctx, &expr0_0, &expr1_0, &expr2_0)?;
            let expr4_0 = C::xmm_to_xmm_mem_imm(ctx, expr3_0);
            return Some(expr4_0);
        }
        &RegMemImm::Mem {
            addr: ref pattern1_0,
        } => {
            // Rule at src/isa/x64/inst.isle line 1222.
            let expr0_0 = C::xmm_mem_imm_new(ctx, pattern0_0);
            return Some(expr0_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term x64_load.
pub fn constructor_x64_load<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: &ExtKind,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1239.
        let expr0_0 = C::temp_writable_gpr(ctx);
        let expr1_0 = MInst::Mov64MR {
            src: pattern2_0.clone(),
            dst: expr0_0,
        };
        let expr2_0 = C::emit(ctx, &expr1_0);
        let expr3_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
        return Some(expr3_0);
    }
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1244.
        let expr0_0 = SseOpcode::Movss;
        let expr1_0 = constructor_synthetic_amode_to_xmm_mem(ctx, pattern2_0)?;
        let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
        let expr3_0 = C::xmm_to_reg(ctx, expr2_0);
        return Some(expr3_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1248.
        let expr0_0 = SseOpcode::Movsd;
        let expr1_0 = constructor_synthetic_amode_to_xmm_mem(ctx, pattern2_0)?;
        let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
        let expr3_0 = C::xmm_to_reg(ctx, expr2_0);
        return Some(expr3_0);
    }
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1252.
        let expr0_0 = SseOpcode::Movups;
        let expr1_0 = constructor_synthetic_amode_to_xmm_mem(ctx, pattern2_0)?;
        let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
        let expr3_0 = C::xmm_to_reg(ctx, expr2_0);
        return Some(expr3_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1256.
        let expr0_0 = SseOpcode::Movupd;
        let expr1_0 = constructor_synthetic_amode_to_xmm_mem(ctx, pattern2_0)?;
        let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
        let expr3_0 = C::xmm_to_reg(ctx, expr2_0);
        return Some(expr3_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/inst.isle line 1260.
        let expr0_0 = SseOpcode::Movdqu;
        let expr1_0 = constructor_synthetic_amode_to_xmm_mem(ctx, pattern2_0)?;
        let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
        let expr3_0 = C::xmm_to_reg(ctx, expr2_0);
        return Some(expr3_0);
    }
    if let Some(pattern1_0) = C::fits_in_32(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let &ExtKind::SignExtend = pattern3_0 {
            // Rule at src/isa/x64/inst.isle line 1234.
            let expr0_0 = C::ty_bytes(ctx, pattern1_0);
            let expr1_0: u16 = 8;
            let expr2_0 = C::ext_mode(ctx, expr0_0, expr1_0);
            let expr3_0 = constructor_synthetic_amode_to_gpr_mem(ctx, pattern2_0)?;
            let expr4_0 = constructor_movsx(ctx, pattern1_0, &expr2_0, &expr3_0)?;
            let expr5_0 = C::gpr_to_reg(ctx, expr4_0);
            return Some(expr5_0);
        }
    }
    return None;
}

// Generated as internal constructor for term xmm_load_const.
pub fn constructor_xmm_load_const<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: VCodeConstant,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1266.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::writable_xmm_to_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmLoadConst {
        src: pattern1_0,
        dst: expr1_0,
        ty: pattern0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term alu_rmi_r.
pub fn constructor_alu_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1279.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::AluRmiR {
        size: expr1_0,
        op: pattern1_0.clone(),
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term add.
pub fn constructor_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1287.
    let expr0_0 = AluRmiROpcode::Add;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term add_with_flags_paired.
pub fn constructor_add_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1295.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Add;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr5_0 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term adc_paired.
pub fn constructor_adc_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1307.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Adc;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr5_0 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term sub.
pub fn constructor_sub<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1319.
    let expr0_0 = AluRmiROpcode::Sub;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sub_with_flags_paired.
pub fn constructor_sub_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1327.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Sub;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr5_0 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term sbb_paired.
pub fn constructor_sbb_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1339.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = AluRmiROpcode::Sbb;
    let expr3_0 = MInst::AluRmiR {
        size: expr1_0,
        op: expr2_0,
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr5_0 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: expr3_0,
        result: expr4_0,
    };
    return Some(expr5_0);
}

// Generated as internal constructor for term mul.
pub fn constructor_mul<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1351.
    let expr0_0 = AluRmiROpcode::Mul;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term x64_and.
pub fn constructor_x64_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1359.
    let expr0_0 = AluRmiROpcode::And;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term or.
pub fn constructor_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1367.
    let expr0_0 = AluRmiROpcode::Or;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xor.
pub fn constructor_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1375.
    let expr0_0 = AluRmiROpcode::Xor;
    let expr1_0 = constructor_alu_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(ctx: &mut C, arg0: Type, arg1: u64) -> Option<Reg> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        if let Some(pattern3_0) = C::nonzero_u64_fits_in_u32(ctx, pattern2_0) {
            // Rule at src/isa/x64/inst.isle line 1415.
            let expr0_0 = C::temp_writable_gpr(ctx);
            let expr1_0 = OperandSize::Size32;
            let expr2_0 = MInst::Imm {
                dst_size: expr1_0,
                simm64: pattern3_0,
                dst: expr0_0,
            };
            let expr3_0 = C::emit(ctx, &expr2_0);
            let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
            return Some(expr4_0);
        }
    }
    if pattern0_0 == F32 {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 1444.
            let expr0_0 = C::temp_writable_xmm(ctx);
            let expr1_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
            let expr2_0 = SseOpcode::Xorps;
            let expr3_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
            let expr4_0 = MInst::XmmRmR {
                op: expr2_0,
                src1: expr1_0,
                src2: expr3_0,
                dst: expr0_0,
            };
            let expr5_0 = C::emit(ctx, &expr4_0);
            let expr6_0 = C::xmm_to_reg(ctx, expr1_0);
            return Some(expr6_0);
        }
        // Rule at src/isa/x64/inst.isle line 1392.
        let expr0_0 = SseOpcode::Movd;
        let expr1_0: Type = I32;
        let expr2_0 = constructor_imm(ctx, expr1_0, pattern2_0)?;
        let expr3_0 = C::reg_to_gpr_mem(ctx, expr2_0);
        let expr4_0 = OperandSize::Size32;
        let expr5_0 = constructor_gpr_to_xmm(ctx, &expr0_0, &expr3_0, &expr4_0)?;
        let expr6_0 = C::xmm_to_reg(ctx, expr5_0);
        return Some(expr6_0);
    }
    if pattern0_0 == F64 {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 1456.
            let expr0_0 = C::temp_writable_xmm(ctx);
            let expr1_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
            let expr2_0 = SseOpcode::Xorpd;
            let expr3_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
            let expr4_0 = MInst::XmmRmR {
                op: expr2_0,
                src1: expr1_0,
                src2: expr3_0,
                dst: expr0_0,
            };
            let expr5_0 = C::emit(ctx, &expr4_0);
            let expr6_0 = C::xmm_to_reg(ctx, expr1_0);
            return Some(expr6_0);
        }
        // Rule at src/isa/x64/inst.isle line 1398.
        let expr0_0 = SseOpcode::Movq;
        let expr1_0: Type = I64;
        let expr2_0 = constructor_imm(ctx, expr1_0, pattern2_0)?;
        let expr3_0 = C::reg_to_gpr_mem(ctx, expr2_0);
        let expr4_0 = OperandSize::Size64;
        let expr5_0 = constructor_gpr_to_xmm(ctx, &expr0_0, &expr3_0, &expr4_0)?;
        let expr6_0 = C::xmm_to_reg(ctx, expr5_0);
        return Some(expr6_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 1434.
            let expr0_0 = C::temp_writable_xmm(ctx);
            let expr1_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
            let expr2_0 = constructor_sse_xor_op(ctx, pattern0_0)?;
            let expr3_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
            let expr4_0 = MInst::XmmRmR {
                op: expr2_0,
                src1: expr1_0,
                src2: expr3_0,
                dst: expr0_0,
            };
            let expr5_0 = C::emit(ctx, &expr4_0);
            let expr6_0 = C::xmm_to_reg(ctx, expr1_0);
            return Some(expr6_0);
        }
    }
    if let Some(pattern1_0) = C::fits_in_64(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        if pattern2_0 == 0 {
            // Rule at src/isa/x64/inst.isle line 1421.
            let expr0_0 = C::temp_writable_gpr(ctx);
            let expr1_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
            let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern1_0);
            let expr3_0 = AluRmiROpcode::Xor;
            let expr4_0 = C::gpr_to_gpr_mem_imm(ctx, expr1_0);
            let expr5_0 = MInst::AluRmiR {
                size: expr2_0,
                op: expr3_0,
                src1: expr1_0,
                src2: expr4_0,
                dst: expr0_0,
            };
            let expr6_0 = C::emit(ctx, &expr5_0);
            let expr7_0 = C::gpr_to_reg(ctx, expr1_0);
            return Some(expr7_0);
        }
        // Rule at src/isa/x64/inst.isle line 1385.
        let expr0_0 = C::temp_writable_gpr(ctx);
        let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern1_0);
        let expr2_0 = MInst::Imm {
            dst_size: expr1_0,
            simm64: pattern2_0,
            dst: expr0_0,
        };
        let expr3_0 = C::emit(ctx, &expr2_0);
        let expr4_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term imm_i64.
pub fn constructor_imm_i64<C: Context>(ctx: &mut C, arg0: Type, arg1: i64) -> Option<Reg> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1407.
    let expr0_0 = C::i64_as_u64(ctx, pattern1_0);
    let expr1_0 = constructor_imm(ctx, pattern0_0, expr0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shift_r.
pub fn constructor_shift_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftKind,
    arg2: Gpr,
    arg3: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1469.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::raw_operand_size_of_type(ctx, pattern0_0);
    let expr2_0 = MInst::ShiftR {
        size: expr1_0,
        kind: pattern1_0.clone(),
        src: pattern2_0,
        num_bits: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term x64_rotl.
pub fn constructor_x64_rotl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1479.
    let expr0_0 = ShiftKind::RotateLeft;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term x64_rotr.
pub fn constructor_x64_rotr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1484.
    let expr0_0 = ShiftKind::RotateRight;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shl.
pub fn constructor_shl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1489.
    let expr0_0 = ShiftKind::ShiftLeft;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term shr.
pub fn constructor_shr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1494.
    let expr0_0 = ShiftKind::ShiftRightLogical;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term sar.
pub fn constructor_sar<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1499.
    let expr0_0 = ShiftKind::ShiftRightArithmetic;
    let expr1_0 = constructor_shift_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_rmi_r.
pub fn constructor_cmp_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &CmpOpcode,
    arg2: &GprMemImm,
    arg3: Gpr,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1504.
    let expr0_0 = MInst::CmpRmiR {
        size: pattern0_0.clone(),
        opcode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: pattern3_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp.
pub fn constructor_cmp<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &GprMemImm,
    arg2: Gpr,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1513.
    let expr0_0 = CmpOpcode::Cmp;
    let expr1_0 = constructor_cmp_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmp_imm.
pub fn constructor_cmp_imm<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: u32,
    arg2: Gpr,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1518.
    let expr0_0 = CmpOpcode::Cmp;
    let expr1_0 = RegMemImm::Imm { simm32: pattern1_0 };
    let expr2_0 = C::gpr_mem_imm_new(ctx, &expr1_0);
    let expr3_0 = constructor_cmp_rmi_r(ctx, pattern0_0, &expr0_0, &expr2_0, pattern2_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term xmm_cmp_rm_r.
pub fn constructor_xmm_cmp_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1523.
    let expr0_0 = MInst::XmmCmpRmR {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: pattern2_0,
    };
    let expr1_0 = ProducesFlags::ProducesFlagsSideEffect { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term fpcmp.
pub fn constructor_fpcmp<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Value,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = C::value_type(ctx, pattern0_0);
    if pattern1_0 == F32 {
        let pattern3_0 = arg1;
        // Rule at src/isa/x64/inst.isle line 1530.
        let expr0_0 = SseOpcode::Ucomiss;
        let expr1_0 = constructor_put_in_xmm(ctx, pattern0_0)?;
        let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
        let expr3_0 = constructor_put_in_xmm(ctx, pattern3_0)?;
        let expr4_0 = constructor_xmm_cmp_rm_r(ctx, &expr0_0, &expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    if pattern1_0 == F64 {
        let pattern3_0 = arg1;
        // Rule at src/isa/x64/inst.isle line 1534.
        let expr0_0 = SseOpcode::Ucomisd;
        let expr1_0 = constructor_put_in_xmm(ctx, pattern0_0)?;
        let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
        let expr3_0 = constructor_put_in_xmm(ctx, pattern3_0)?;
        let expr4_0 = constructor_xmm_cmp_rm_r(ctx, &expr0_0, &expr2_0, expr3_0)?;
        return Some(expr4_0);
    }
    return None;
}

// Generated as internal constructor for term test.
pub fn constructor_test<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &GprMemImm,
    arg2: Gpr,
) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1539.
    let expr0_0 = CmpOpcode::Test;
    let expr1_0 = constructor_cmp_rmi_r(ctx, pattern0_0, &expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term cmove.
pub fn constructor_cmove<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &GprMem,
    arg3: Gpr,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1546.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Cmove {
        size: expr1_0,
        cc: pattern1_0.clone(),
        consequent: pattern2_0.clone(),
        alternative: pattern3_0,
        dst: expr0_0,
    };
    let expr3_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr4_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: expr2_0,
        result: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term cmove_xmm.
pub fn constructor_cmove_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &XmmMem,
    arg3: Xmm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1554.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::XmmCmove {
        size: expr1_0,
        cc: pattern1_0.clone(),
        consequent: pattern2_0.clone(),
        alternative: pattern3_0,
        dst: expr0_0,
    };
    let expr3_0 = constructor_writable_xmm_to_r_reg(ctx, expr0_0)?;
    let expr4_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: expr2_0,
        result: expr3_0,
    };
    return Some(expr4_0);
}

// Generated as internal constructor for term cmove_from_values.
pub fn constructor_cmove_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Value,
    arg3: Value,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == I128 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/inst.isle line 1565.
        let expr0_0 = C::put_in_regs(ctx, pattern3_0);
        let expr1_0 = C::put_in_regs(ctx, pattern4_0);
        let expr2_0 = C::temp_writable_gpr(ctx);
        let expr3_0 = C::temp_writable_gpr(ctx);
        let expr4_0 = OperandSize::Size64;
        let expr5_0: usize = 0;
        let expr6_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr5_0)?;
        let expr7_0 = C::gpr_to_gpr_mem(ctx, expr6_0);
        let expr8_0: usize = 0;
        let expr9_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr8_0)?;
        let expr10_0 = MInst::Cmove {
            size: expr4_0,
            cc: pattern2_0.clone(),
            consequent: expr7_0,
            alternative: expr9_0,
            dst: expr2_0,
        };
        let expr11_0: usize = 1;
        let expr12_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr11_0)?;
        let expr13_0 = C::gpr_to_gpr_mem(ctx, expr12_0);
        let expr14_0: usize = 1;
        let expr15_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr14_0)?;
        let expr16_0 = MInst::Cmove {
            size: expr4_0,
            cc: pattern2_0.clone(),
            consequent: expr13_0,
            alternative: expr15_0,
            dst: expr3_0,
        };
        let expr17_0 = constructor_writable_gpr_to_r_reg(ctx, expr2_0)?;
        let expr18_0 = constructor_writable_gpr_to_r_reg(ctx, expr3_0)?;
        let expr19_0 = C::value_regs(ctx, expr17_0, expr18_0);
        let expr20_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
            inst1: expr10_0,
            inst2: expr16_0,
            result: expr19_0,
        };
        return Some(expr20_0);
    }
    if let Some(pattern1_0) = C::is_xmm_type(ctx, pattern0_0) {
        if let Some(pattern2_0) = C::is_single_register_type(ctx, pattern1_0) {
            let pattern3_0 = arg1;
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 1589.
            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern4_0)?;
            let expr1_0 = constructor_put_in_xmm(ctx, pattern5_0)?;
            let expr2_0 = constructor_cmove_xmm(ctx, pattern2_0, pattern3_0, &expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    if let Some(pattern1_0) = C::is_gpr_type(ctx, pattern0_0) {
        if let Some(pattern2_0) = C::is_single_register_type(ctx, pattern1_0) {
            let pattern3_0 = arg1;
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            // Rule at src/isa/x64/inst.isle line 1586.
            let expr0_0 = constructor_put_in_gpr_mem(ctx, pattern4_0)?;
            let expr1_0 = constructor_put_in_gpr(ctx, pattern5_0)?;
            let expr2_0 = constructor_cmove(ctx, pattern2_0, pattern3_0, &expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term cmove_or.
pub fn constructor_cmove_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: &GprMem,
    arg4: Gpr,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/x64/inst.isle line 1596.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::temp_writable_gpr(ctx);
    let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr3_0 = MInst::Cmove {
        size: expr2_0,
        cc: pattern1_0.clone(),
        consequent: pattern3_0.clone(),
        alternative: pattern4_0,
        dst: expr1_0,
    };
    let expr4_0 = C::writable_gpr_to_gpr(ctx, expr1_0);
    let expr5_0 = MInst::Cmove {
        size: expr2_0,
        cc: pattern2_0.clone(),
        consequent: pattern3_0.clone(),
        alternative: expr4_0,
        dst: expr0_0,
    };
    let expr6_0 = constructor_writable_gpr_to_value_regs(ctx, expr0_0)?;
    let expr7_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: expr3_0,
        inst2: expr5_0,
        result: expr6_0,
    };
    return Some(expr7_0);
}

// Generated as internal constructor for term cmove_or_xmm.
pub fn constructor_cmove_or_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: &XmmMem,
    arg4: Xmm,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/x64/inst.isle line 1608.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::temp_writable_xmm(ctx);
    let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr3_0 = MInst::XmmCmove {
        size: expr2_0,
        cc: pattern1_0.clone(),
        consequent: pattern3_0.clone(),
        alternative: pattern4_0,
        dst: expr1_0,
    };
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr1_0);
    let expr5_0 = MInst::XmmCmove {
        size: expr2_0,
        cc: pattern2_0.clone(),
        consequent: pattern3_0.clone(),
        alternative: expr4_0,
        dst: expr0_0,
    };
    let expr6_0 = constructor_writable_xmm_to_value_regs(ctx, expr0_0)?;
    let expr7_0 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: expr3_0,
        inst2: expr5_0,
        result: expr6_0,
    };
    return Some(expr7_0);
}

// Generated as internal constructor for term cmove_or_from_values.
pub fn constructor_cmove_or_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: Value,
    arg4: Value,
) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    if pattern0_0 == I128 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        let pattern5_0 = arg4;
        // Rule at src/isa/x64/inst.isle line 1623.
        let expr0_0 = C::put_in_regs(ctx, pattern4_0);
        let expr1_0 = C::put_in_regs(ctx, pattern5_0);
        let expr2_0 = C::temp_writable_gpr(ctx);
        let expr3_0 = C::temp_writable_gpr(ctx);
        let expr4_0 = C::temp_writable_gpr(ctx);
        let expr5_0 = C::temp_writable_gpr(ctx);
        let expr6_0 = OperandSize::Size64;
        let expr7_0: usize = 0;
        let expr8_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr7_0)?;
        let expr9_0 = C::gpr_to_gpr_mem(ctx, expr8_0);
        let expr10_0: usize = 0;
        let expr11_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr10_0)?;
        let expr12_0 = MInst::Cmove {
            size: expr6_0,
            cc: pattern2_0.clone(),
            consequent: expr9_0,
            alternative: expr11_0,
            dst: expr4_0,
        };
        let expr13_0: usize = 0;
        let expr14_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr13_0)?;
        let expr15_0 = C::gpr_to_gpr_mem(ctx, expr14_0);
        let expr16_0 = C::writable_gpr_to_gpr(ctx, expr4_0);
        let expr17_0 = MInst::Cmove {
            size: expr6_0,
            cc: pattern2_0.clone(),
            consequent: expr15_0,
            alternative: expr16_0,
            dst: expr2_0,
        };
        let expr18_0: usize = 1;
        let expr19_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr18_0)?;
        let expr20_0 = C::gpr_to_gpr_mem(ctx, expr19_0);
        let expr21_0: usize = 1;
        let expr22_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr21_0)?;
        let expr23_0 = MInst::Cmove {
            size: expr6_0,
            cc: pattern2_0.clone(),
            consequent: expr20_0,
            alternative: expr22_0,
            dst: expr5_0,
        };
        let expr24_0: usize = 1;
        let expr25_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr24_0)?;
        let expr26_0 = C::gpr_to_gpr_mem(ctx, expr25_0);
        let expr27_0 = C::writable_gpr_to_gpr(ctx, expr5_0);
        let expr28_0 = MInst::Cmove {
            size: expr6_0,
            cc: pattern2_0.clone(),
            consequent: expr26_0,
            alternative: expr27_0,
            dst: expr3_0,
        };
        let expr29_0 = constructor_writable_gpr_to_r_reg(ctx, expr2_0)?;
        let expr30_0 = constructor_writable_gpr_to_r_reg(ctx, expr3_0)?;
        let expr31_0 = C::value_regs(ctx, expr29_0, expr30_0);
        let expr32_0 = ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
            inst1: expr12_0,
            inst2: expr17_0,
            inst3: expr23_0,
            inst4: expr28_0,
            result: expr31_0,
        };
        return Some(expr32_0);
    }
    if let Some(pattern1_0) = C::is_xmm_type(ctx, pattern0_0) {
        if let Some(pattern2_0) = C::is_single_register_type(ctx, pattern1_0) {
            let pattern3_0 = arg1;
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/x64/inst.isle line 1645.
            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern5_0)?;
            let expr1_0 = constructor_put_in_xmm(ctx, pattern6_0)?;
            let expr2_0 = constructor_cmove_or_xmm(
                ctx, pattern2_0, pattern3_0, pattern4_0, &expr0_0, expr1_0,
            )?;
            return Some(expr2_0);
        }
    }
    if let Some(pattern1_0) = C::is_gpr_type(ctx, pattern0_0) {
        if let Some(pattern2_0) = C::is_single_register_type(ctx, pattern1_0) {
            let pattern3_0 = arg1;
            let pattern4_0 = arg2;
            let pattern5_0 = arg3;
            let pattern6_0 = arg4;
            // Rule at src/isa/x64/inst.isle line 1642.
            let expr0_0 = constructor_put_in_gpr_mem(ctx, pattern5_0)?;
            let expr1_0 = constructor_put_in_gpr(ctx, pattern6_0)?;
            let expr2_0 =
                constructor_cmove_or(ctx, pattern2_0, pattern3_0, pattern4_0, &expr0_0, expr1_0)?;
            return Some(expr2_0);
        }
    }
    return None;
}

// Generated as internal constructor for term setcc.
pub fn constructor_setcc<C: Context>(ctx: &mut C, arg0: &CC) -> Option<ConsumesFlags> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 1650.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = MInst::Setcc {
        cc: pattern0_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr3_0 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: expr1_0,
        result: expr2_0,
    };
    return Some(expr3_0);
}

// Generated as internal constructor for term movzx.
pub fn constructor_movzx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ExtMode,
    arg2: &GprMem,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1658.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = MInst::MovzxRmR {
        ext_mode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term movsx.
pub fn constructor_movsx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ExtMode,
    arg2: &GprMem,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1665.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = MInst::MovsxRmR {
        ext_mode: pattern1_0.clone(),
        src: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term xmm_rm_r.
pub fn constructor_xmm_rm_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SseOpcode,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1672.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::XmmRmR {
        op: pattern1_0.clone(),
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term paddb.
pub fn constructor_paddb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1679.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddw.
pub fn constructor_paddw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1684.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddd.
pub fn constructor_paddd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1689.
    let expr0_0: Type = I32X4;
    let expr1_0 = SseOpcode::Paddd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddq.
pub fn constructor_paddq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1694.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Paddq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddsb.
pub fn constructor_paddsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1699.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddsw.
pub fn constructor_paddsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1704.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddusb.
pub fn constructor_paddusb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1709.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Paddusb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term paddusw.
pub fn constructor_paddusw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1714.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Paddusw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubb.
pub fn constructor_psubb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1719.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubw.
pub fn constructor_psubw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1724.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubd.
pub fn constructor_psubd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1729.
    let expr0_0: Type = I32X4;
    let expr1_0 = SseOpcode::Psubd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubq.
pub fn constructor_psubq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1734.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Psubq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubsb.
pub fn constructor_psubsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1739.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubsw.
pub fn constructor_psubsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1744.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubusb.
pub fn constructor_psubusb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1749.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Psubusb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term psubusw.
pub fn constructor_psubusw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1754.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Psubusw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pavgb.
pub fn constructor_pavgb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1759.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pavgb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pavgw.
pub fn constructor_pavgw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1764.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pavgw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pand.
pub fn constructor_pand<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1769.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Pand;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andps.
pub fn constructor_andps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1774.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Andps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andpd.
pub fn constructor_andpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1779.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Andpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term por.
pub fn constructor_por<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1784.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Por;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term orps.
pub fn constructor_orps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1789.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Orps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term orpd.
pub fn constructor_orpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1794.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Orpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pxor.
pub fn constructor_pxor<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1799.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pxor;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xorps.
pub fn constructor_xorps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1804.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Xorps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xorpd.
pub fn constructor_xorpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1809.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Xorpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmullw.
pub fn constructor_pmullw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1814.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmullw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulld.
pub fn constructor_pmulld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1819.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulld;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulhw.
pub fn constructor_pmulhw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1824.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulhw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmulhuw.
pub fn constructor_pmulhuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1829.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmulhuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmuldq.
pub fn constructor_pmuldq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1834.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Pmuldq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmuludq.
pub fn constructor_pmuludq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1839.
    let expr0_0: Type = I64X2;
    let expr1_0 = SseOpcode::Pmuludq;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpckhwd.
pub fn constructor_punpckhwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1844.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Punpckhwd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpcklwd.
pub fn constructor_punpcklwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1849.
    let expr0_0: Type = I16X8;
    let expr1_0 = SseOpcode::Punpcklwd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andnps.
pub fn constructor_andnps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1854.
    let expr0_0: Type = F32X4;
    let expr1_0 = SseOpcode::Andnps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term andnpd.
pub fn constructor_andnpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1859.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Andnpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pandn.
pub fn constructor_pandn<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1864.
    let expr0_0: Type = F64X2;
    let expr1_0 = SseOpcode::Pandn;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term addss.
pub fn constructor_addss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1869.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Addss;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term addsd.
pub fn constructor_addsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1874.
    let expr0_0: Type = F64;
    let expr1_0 = SseOpcode::Addsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term addps.
pub fn constructor_addps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1879.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Addps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term addpd.
pub fn constructor_addpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1884.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Addpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term subss.
pub fn constructor_subss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1889.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Subss;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term subsd.
pub fn constructor_subsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1894.
    let expr0_0: Type = F64;
    let expr1_0 = SseOpcode::Subsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term subps.
pub fn constructor_subps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1899.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Subps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term subpd.
pub fn constructor_subpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1904.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Subpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term mulss.
pub fn constructor_mulss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1909.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Mulss;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term mulsd.
pub fn constructor_mulsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1914.
    let expr0_0: Type = F64;
    let expr1_0 = SseOpcode::Mulsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term mulps.
pub fn constructor_mulps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1919.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Mulps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term mulpd.
pub fn constructor_mulpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1924.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Mulpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term divss.
pub fn constructor_divss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1929.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Divss;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term divsd.
pub fn constructor_divsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1934.
    let expr0_0: Type = F64;
    let expr1_0 = SseOpcode::Divsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term divps.
pub fn constructor_divps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1939.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Divps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term divpd.
pub fn constructor_divpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1944.
    let expr0_0: Type = F32;
    let expr1_0 = SseOpcode::Divpd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term sse_blend_op.
pub fn constructor_sse_blend_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 1948.
        let expr0_0 = SseOpcode::Blendvps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 1949.
        let expr0_0 = SseOpcode::Blendvpd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        // Rule at src/isa/x64/inst.isle line 1950.
        let expr0_0 = SseOpcode::Pblendvb;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sse_mov_op.
pub fn constructor_sse_mov_op<C: Context>(ctx: &mut C, arg0: Type) -> Option<SseOpcode> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        // Rule at src/isa/x64/inst.isle line 1953.
        let expr0_0 = SseOpcode::Movaps;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        // Rule at src/isa/x64/inst.isle line 1954.
        let expr0_0 = SseOpcode::Movapd;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        // Rule at src/isa/x64/inst.isle line 1955.
        let expr0_0 = SseOpcode::Movdqa;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sse_blend.
pub fn constructor_sse_blend<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &XmmMem,
    arg2: &XmmMem,
    arg3: Xmm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 1959.
    let expr0_0 = C::xmm0(ctx);
    let expr1_0 = constructor_sse_mov_op(ctx, pattern0_0)?;
    let expr2_0 = MInst::XmmUnaryRmR {
        op: expr1_0,
        src: pattern1_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = constructor_sse_blend_op(ctx, pattern0_0)?;
    let expr5_0 = constructor_xmm_rm_r(ctx, pattern0_0, &expr4_0, pattern3_0, pattern2_0)?;
    return Some(expr5_0);
}

// Generated as internal constructor for term blendvpd.
pub fn constructor_blendvpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 1973.
    let expr0_0 = C::xmm0(ctx);
    let expr1_0 = SseOpcode::Movapd;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern2_0);
    let expr3_0 = MInst::XmmUnaryRmR {
        op: expr1_0,
        src: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0: Type = F64X2;
    let expr6_0 = SseOpcode::Blendvpd;
    let expr7_0 = constructor_xmm_rm_r(ctx, expr5_0, &expr6_0, pattern0_0, pattern1_0)?;
    return Some(expr7_0);
}

// Generated as internal constructor for term movsd.
pub fn constructor_movsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1987.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Movsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term movlhps.
pub fn constructor_movlhps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1992.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Movlhps;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsb.
pub fn constructor_pmaxsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 1997.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsw.
pub fn constructor_pmaxsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2002.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxsd.
pub fn constructor_pmaxsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2007.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsb.
pub fn constructor_pminsb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2012.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsw.
pub fn constructor_pminsw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2017.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminsd.
pub fn constructor_pminsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2022.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminsd;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxub.
pub fn constructor_pmaxub<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2027.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxub;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxuw.
pub fn constructor_pmaxuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2032.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pmaxud.
pub fn constructor_pmaxud<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2037.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pmaxud;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminub.
pub fn constructor_pminub<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2042.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminub;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminuw.
pub fn constructor_pminuw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2047.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminuw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term pminud.
pub fn constructor_pminud<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2052.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Pminud;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpcklbw.
pub fn constructor_punpcklbw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2057.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Punpcklbw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term punpckhbw.
pub fn constructor_punpckhbw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2062.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Punpckhbw;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term packsswb.
pub fn constructor_packsswb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2067.
    let expr0_0: Type = I8X16;
    let expr1_0 = SseOpcode::Packsswb;
    let expr2_0 = constructor_xmm_rm_r(ctx, expr0_0, &expr1_0, pattern0_0, pattern1_0)?;
    return Some(expr2_0);
}

// Generated as internal constructor for term xmm_rm_r_imm.
pub fn constructor_xmm_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Reg,
    arg2: &RegMem,
    arg3: u8,
    arg4: &OperandSize,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    let pattern4_0 = arg4;
    // Rule at src/isa/x64/inst.isle line 2072.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::writable_xmm_to_reg(ctx, expr0_0);
    let expr2_0 = MInst::XmmRmRImm {
        op: pattern0_0.clone(),
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr1_0,
        imm: pattern3_0,
        size: pattern4_0.clone(),
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term palignr.
pub fn constructor_palignr<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
    arg3: &OperandSize,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 2084.
    let expr0_0 = SseOpcode::Palignr;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::xmm_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, pattern2_0, pattern3_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term cmpps.
pub fn constructor_cmpps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2093.
    let expr0_0 = SseOpcode::Cmpps;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::xmm_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 = C::encode_fcmp_imm(ctx, pattern2_0);
    let expr4_0 = OperandSize::Size32;
    let expr5_0 = constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, expr3_0, &expr4_0)?;
    return Some(expr5_0);
}

// Generated as internal constructor for term pinsrb.
pub fn constructor_pinsrb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2102.
    let expr0_0 = SseOpcode::Pinsrb;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::gpr_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 = OperandSize::Size32;
    let expr4_0 = constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, pattern2_0, &expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term pinsrw.
pub fn constructor_pinsrw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2111.
    let expr0_0 = SseOpcode::Pinsrw;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::gpr_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 = OperandSize::Size32;
    let expr4_0 = constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, pattern2_0, &expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term pinsrd.
pub fn constructor_pinsrd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
    arg3: &OperandSize,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 2120.
    let expr0_0 = SseOpcode::Pinsrd;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::gpr_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 =
        constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, pattern2_0, pattern3_0)?;
    return Some(expr3_0);
}

// Generated as internal constructor for term pmaddwd.
pub fn constructor_pmaddwd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2129.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Pmaddwd;
    let expr2_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: pattern1_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term insertps.
pub fn constructor_insertps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2139.
    let expr0_0 = SseOpcode::Insertps;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::xmm_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 = OperandSize::Size32;
    let expr4_0 = constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, pattern2_0, &expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term pshufd.
pub fn constructor_pshufd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: u8,
    arg2: &OperandSize,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2148.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Pshufd;
    let expr2_0 = constructor_writable_xmm_to_r_reg(ctx, expr0_0)?;
    let expr3_0 = C::xmm_mem_to_reg_mem(ctx, pattern0_0);
    let expr4_0 = C::writable_xmm_to_reg(ctx, expr0_0);
    let expr5_0 = MInst::XmmRmRImm {
        op: expr1_0,
        src1: expr2_0,
        src2: expr3_0,
        dst: expr4_0,
        imm: pattern1_0,
        size: pattern2_0.clone(),
    };
    let expr6_0 = C::emit(ctx, &expr5_0);
    let expr7_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr7_0);
}

// Generated as internal constructor for term pshufb.
pub fn constructor_pshufb<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2160.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Pshufb;
    let expr2_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: pattern1_0.clone(),
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term xmm_unary_rm_r.
pub fn constructor_xmm_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2170.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::XmmUnaryRmR {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term pmovsxbw.
pub fn constructor_pmovsxbw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2177.
    let expr0_0 = SseOpcode::Pmovsxbw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pmovzxbw.
pub fn constructor_pmovzxbw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2182.
    let expr0_0 = SseOpcode::Pmovzxbw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsb.
pub fn constructor_pabsb<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2187.
    let expr0_0 = SseOpcode::Pabsb;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsw.
pub fn constructor_pabsw<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2192.
    let expr0_0 = SseOpcode::Pabsw;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pabsd.
pub fn constructor_pabsd<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2197.
    let expr0_0 = SseOpcode::Pabsd;
    let expr1_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_unary_rm_r_evex.
pub fn constructor_xmm_unary_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2202.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::XmmUnaryRmREvex {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term vpabsq.
pub fn constructor_vpabsq<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2209.
    let expr0_0 = Avx512Opcode::Vpabsq;
    let expr1_0 = constructor_xmm_unary_rm_r_evex(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term vpopcntb.
pub fn constructor_vpopcntb<C: Context>(ctx: &mut C, arg0: &XmmMem) -> Option<Xmm> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2214.
    let expr0_0 = Avx512Opcode::Vpopcntb;
    let expr1_0 = constructor_xmm_unary_rm_r_evex(ctx, &expr0_0, pattern0_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_rm_r_evex.
pub fn constructor_xmm_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2219.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::XmmRmREvex {
        op: pattern0_0.clone(),
        src1: pattern1_0.clone(),
        src2: pattern2_0,
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term vpmullq.
pub fn constructor_vpmullq<C: Context>(ctx: &mut C, arg0: &XmmMem, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2231.
    let expr0_0 = Avx512Opcode::Vpmullq;
    let expr1_0 = constructor_xmm_rm_r_evex(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term mul_hi.
pub fn constructor_mul_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Gpr,
    arg3: &GprMem,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 2240.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::temp_writable_gpr(ctx);
    let expr2_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr3_0 = MInst::MulHi {
        size: expr2_0,
        signed: pattern1_0,
        src1: pattern2_0,
        src2: pattern3_0.clone(),
        dst_lo: expr0_0,
        dst_hi: expr1_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    let expr6_0 = C::writable_gpr_to_gpr(ctx, expr1_0);
    let expr7_0 = constructor_value_gprs(ctx, expr5_0, expr6_0)?;
    return Some(expr7_0);
}

// Generated as internal constructor for term mulhi_u.
pub fn constructor_mulhi_u<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2255.
    let expr0_0: bool = false;
    let expr1_0 = constructor_mul_hi(ctx, pattern0_0, expr0_0, pattern1_0, pattern2_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_rmi_xmm.
pub fn constructor_xmm_rmi_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemImm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2260.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::XmmRmiReg {
        opcode: pattern0_0.clone(),
        src1: pattern1_0,
        src2: pattern2_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term psllw.
pub fn constructor_psllw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2270.
    let expr0_0 = SseOpcode::Psllw;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pslld.
pub fn constructor_pslld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2275.
    let expr0_0 = SseOpcode::Pslld;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psllq.
pub fn constructor_psllq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2280.
    let expr0_0 = SseOpcode::Psllq;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrlw.
pub fn constructor_psrlw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2285.
    let expr0_0 = SseOpcode::Psrlw;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrld.
pub fn constructor_psrld<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2290.
    let expr0_0 = SseOpcode::Psrld;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrlq.
pub fn constructor_psrlq<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2295.
    let expr0_0 = SseOpcode::Psrlq;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psraw.
pub fn constructor_psraw<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2300.
    let expr0_0 = SseOpcode::Psraw;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term psrad.
pub fn constructor_psrad<C: Context>(ctx: &mut C, arg0: Xmm, arg1: &XmmMemImm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2305.
    let expr0_0 = SseOpcode::Psrad;
    let expr1_0 = constructor_xmm_rmi_xmm(ctx, &expr0_0, pattern0_0, pattern1_0)?;
    return Some(expr1_0);
}

// Generated as internal constructor for term pextrd.
pub fn constructor_pextrd<C: Context>(ctx: &mut C, arg0: Type, arg1: Xmm, arg2: u8) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2310.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = SseOpcode::Pextrd;
    let expr2_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr3_0 = C::xmm_to_reg(ctx, pattern1_0);
    let expr4_0 = constructor_xmm_to_reg_mem(ctx, expr3_0)?;
    let expr5_0 = C::xmm_mem_to_reg_mem(ctx, &expr4_0);
    let expr6_0 = C::writable_gpr_to_reg(ctx, expr0_0);
    let expr7_0 = C::lane_type(ctx, pattern0_0);
    let expr8_0 = C::operand_size_of_type_32_64(ctx, expr7_0);
    let expr9_0 = MInst::XmmRmRImm {
        op: expr1_0,
        src1: expr2_0,
        src2: expr5_0,
        dst: expr6_0,
        imm: pattern2_0,
        size: expr8_0,
    };
    let expr10_0 = C::emit(ctx, &expr9_0);
    let expr11_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr11_0);
}

// Generated as internal constructor for term cmppd.
pub fn constructor_cmppd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2326.
    let expr0_0 = SseOpcode::Cmppd;
    let expr1_0 = C::xmm_to_reg(ctx, pattern0_0);
    let expr2_0 = C::xmm_mem_to_reg_mem(ctx, pattern1_0);
    let expr3_0 = C::encode_fcmp_imm(ctx, pattern2_0);
    let expr4_0 = OperandSize::Size32;
    let expr5_0 = constructor_xmm_rm_r_imm(ctx, &expr0_0, expr1_0, &expr2_0, expr3_0, &expr4_0)?;
    return Some(expr5_0);
}

// Generated as internal constructor for term gpr_to_xmm.
pub fn constructor_gpr_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2335.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = MInst::GprToXmm {
        op: pattern0_0.clone(),
        src: pattern1_0.clone(),
        dst: expr0_0,
        src_size: pattern2_0.clone(),
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term not.
pub fn constructor_not<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2342.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Not {
        size: expr1_0,
        src: pattern1_0,
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term neg.
pub fn constructor_neg<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2350.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::Neg {
        size: expr1_0,
        src: pattern1_0,
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term lea.
pub fn constructor_lea<C: Context>(ctx: &mut C, arg0: &SyntheticAmode) -> Option<Gpr> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2357.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = MInst::LoadEffectiveAddress {
        addr: pattern0_0.clone(),
        dst: expr0_0,
    };
    let expr2_0 = C::emit(ctx, &expr1_0);
    let expr3_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term ud2.
pub fn constructor_ud2<C: Context>(ctx: &mut C, arg0: &TrapCode) -> Option<SideEffectNoResult> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2364.
    let expr0_0 = MInst::Ud2 {
        trap_code: pattern0_0.clone(),
    };
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term hlt.
pub fn constructor_hlt<C: Context>(ctx: &mut C) -> Option<SideEffectNoResult> {
    // Rule at src/isa/x64/inst.isle line 2369.
    let expr0_0 = MInst::Hlt;
    let expr1_0 = SideEffectNoResult::Inst { inst: expr0_0 };
    return Some(expr1_0);
}

// Generated as internal constructor for term lzcnt.
pub fn constructor_lzcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2374.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = UnaryRmROpcode::Lzcnt;
    let expr3_0 = C::gpr_to_gpr_mem(ctx, pattern1_0);
    let expr4_0 = MInst::UnaryRmR {
        size: expr1_0,
        op: expr2_0,
        src: expr3_0,
        dst: expr0_0,
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr6_0);
}

// Generated as internal constructor for term tzcnt.
pub fn constructor_tzcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2382.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = UnaryRmROpcode::Tzcnt;
    let expr3_0 = C::gpr_to_gpr_mem(ctx, pattern1_0);
    let expr4_0 = MInst::UnaryRmR {
        size: expr1_0,
        op: expr2_0,
        src: expr3_0,
        dst: expr0_0,
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr6_0);
}

// Generated as internal constructor for term bsr.
pub fn constructor_bsr<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2390.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = UnaryRmROpcode::Bsr;
    let expr3_0 = C::gpr_to_gpr_mem(ctx, pattern1_0);
    let expr4_0 = MInst::UnaryRmR {
        size: expr1_0,
        op: expr2_0,
        src: expr3_0,
        dst: expr0_0,
    };
    let expr5_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr6_0 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term bsr_or_else.
pub fn constructor_bsr_or_else<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2399.
    let expr0_0 = constructor_bsr(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_produces_flags_get_reg(ctx, &expr0_0)?;
    let expr2_0 = C::gpr_new(ctx, expr1_0);
    let expr3_0 = CC::Z;
    let expr4_0 = C::gpr_to_gpr_mem(ctx, pattern2_0);
    let expr5_0 = constructor_cmove(ctx, pattern0_0, &expr3_0, &expr4_0, expr2_0)?;
    let expr6_0 = constructor_produces_flags_ignore(ctx, &expr0_0)?;
    let expr7_0 = constructor_with_flags_reg(ctx, &expr6_0, &expr5_0)?;
    let expr8_0 = C::gpr_new(ctx, expr7_0);
    return Some(expr8_0);
}

// Generated as internal constructor for term bsf.
pub fn constructor_bsf<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<ProducesFlags> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2410.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = UnaryRmROpcode::Bsf;
    let expr3_0 = C::gpr_to_gpr_mem(ctx, pattern1_0);
    let expr4_0 = MInst::UnaryRmR {
        size: expr1_0,
        op: expr2_0,
        src: expr3_0,
        dst: expr0_0,
    };
    let expr5_0 = constructor_writable_gpr_to_r_reg(ctx, expr0_0)?;
    let expr6_0 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: expr4_0,
        result: expr5_0,
    };
    return Some(expr6_0);
}

// Generated as internal constructor for term bsf_or_else.
pub fn constructor_bsf_or_else<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/inst.isle line 2419.
    let expr0_0 = constructor_bsf(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = constructor_produces_flags_get_reg(ctx, &expr0_0)?;
    let expr2_0 = C::gpr_new(ctx, expr1_0);
    let expr3_0 = CC::Z;
    let expr4_0 = C::gpr_to_gpr_mem(ctx, pattern2_0);
    let expr5_0 = constructor_cmove(ctx, pattern0_0, &expr3_0, &expr4_0, expr2_0)?;
    let expr6_0 = constructor_produces_flags_ignore(ctx, &expr0_0)?;
    let expr7_0 = constructor_with_flags_reg(ctx, &expr6_0, &expr5_0)?;
    let expr8_0 = C::gpr_new(ctx, expr7_0);
    return Some(expr8_0);
}

// Generated as internal constructor for term x64_popcnt.
pub fn constructor_x64_popcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2430.
    let expr0_0 = C::temp_writable_gpr(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = UnaryRmROpcode::Popcnt;
    let expr3_0 = C::gpr_to_gpr_mem(ctx, pattern1_0);
    let expr4_0 = MInst::UnaryRmR {
        size: expr1_0,
        op: expr2_0,
        src: expr3_0,
        dst: expr0_0,
    };
    let expr5_0 = C::emit(ctx, &expr4_0);
    let expr6_0 = C::writable_gpr_to_gpr(ctx, expr0_0);
    return Some(expr6_0);
}

// Generated as internal constructor for term xmm_min_max_seq.
pub fn constructor_xmm_min_max_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Xmm,
    arg3: Xmm,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    let pattern3_0 = arg3;
    // Rule at src/isa/x64/inst.isle line 2438.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = C::operand_size_of_type_32_64(ctx, pattern0_0);
    let expr2_0 = MInst::XmmMinMaxSeq {
        size: expr1_0,
        is_min: pattern1_0,
        lhs: pattern2_0,
        rhs: pattern3_0,
        dst: expr0_0,
    };
    let expr3_0 = C::emit(ctx, &expr2_0);
    let expr4_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr4_0);
}

// Generated as internal constructor for term minss.
pub fn constructor_minss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2446.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Minss;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term minsd.
pub fn constructor_minsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2453.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Minsd;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term minps.
pub fn constructor_minps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2461.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Minps;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term minpd.
pub fn constructor_minpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2468.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Minpd;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term maxss.
pub fn constructor_maxss<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2475.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Maxss;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term maxsd.
pub fn constructor_maxsd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2482.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Maxsd;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term maxps.
pub fn constructor_maxps<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2489.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Maxps;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term maxpd.
pub fn constructor_maxpd<C: Context>(ctx: &mut C, arg0: Xmm, arg1: Xmm) -> Option<Xmm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/inst.isle line 2496.
    let expr0_0 = C::temp_writable_xmm(ctx);
    let expr1_0 = SseOpcode::Maxpd;
    let expr2_0 = C::xmm_to_xmm_mem(ctx, pattern1_0);
    let expr3_0 = MInst::XmmRmR {
        op: expr1_0,
        src1: pattern0_0,
        src2: expr2_0,
        dst: expr0_0,
    };
    let expr4_0 = C::emit(ctx, &expr3_0);
    let expr5_0 = C::writable_xmm_to_xmm(ctx, expr0_0);
    return Some(expr5_0);
}

// Generated as internal constructor for term reg_to_xmm_mem.
pub fn constructor_reg_to_xmm_mem<C: Context>(ctx: &mut C, arg0: Reg) -> Option<XmmMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2551.
    let expr0_0 = C::xmm_new(ctx, pattern0_0);
    let expr1_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term xmm_to_reg_mem.
pub fn constructor_xmm_to_reg_mem<C: Context>(ctx: &mut C, arg0: Reg) -> Option<XmmMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2554.
    let expr0_0 = C::xmm_new(ctx, pattern0_0);
    let expr1_0 = C::xmm_to_reg(ctx, expr0_0);
    let expr2_0 = RegMem::Reg { reg: expr1_0 };
    let expr3_0 = C::reg_mem_to_xmm_mem(ctx, &expr2_0);
    return Some(expr3_0);
}

// Generated as internal constructor for term writable_gpr_to_r_reg.
pub fn constructor_writable_gpr_to_r_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2558.
    let expr0_0 = C::writable_gpr_to_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term writable_gpr_to_gpr_mem.
pub fn constructor_writable_gpr_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> Option<GprMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2561.
    let expr0_0 = C::writable_gpr_to_gpr(ctx, pattern0_0);
    let expr1_0 = C::gpr_to_gpr_mem(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term writable_gpr_to_value_regs.
pub fn constructor_writable_gpr_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2564.
    let expr0_0 = constructor_writable_gpr_to_r_reg(ctx, pattern0_0)?;
    let expr1_0 = C::value_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term writable_xmm_to_r_reg.
pub fn constructor_writable_xmm_to_r_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> Option<Reg> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2567.
    let expr0_0 = C::writable_xmm_to_reg(ctx, pattern0_0);
    let expr1_0 = C::writable_reg_to_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term writable_xmm_to_xmm_mem.
pub fn constructor_writable_xmm_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> Option<XmmMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2570.
    let expr0_0 = C::writable_xmm_to_xmm(ctx, pattern0_0);
    let expr1_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term writable_xmm_to_value_regs.
pub fn constructor_writable_xmm_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2573.
    let expr0_0 = constructor_writable_xmm_to_r_reg(ctx, pattern0_0)?;
    let expr1_0 = C::value_reg(ctx, expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term synthetic_amode_to_gpr_mem.
pub fn constructor_synthetic_amode_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Option<GprMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2577.
    let expr0_0 = C::synthetic_amode_to_reg_mem(ctx, pattern0_0);
    let expr1_0 = C::reg_mem_to_gpr_mem(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term synthetic_amode_to_xmm_mem.
pub fn constructor_synthetic_amode_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Option<XmmMem> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/inst.isle line 2580.
    let expr0_0 = C::synthetic_amode_to_reg_mem(ctx, pattern0_0);
    let expr1_0 = C::reg_mem_to_xmm_mem(ctx, &expr0_0);
    return Some(expr1_0);
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(ctx: &mut C, arg0: Inst) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == I128 {
            if let Some(()) = C::use_popcnt(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/x64/lower.isle line 1628.
                        let expr0_0: Type = I64;
                        let expr1_0 = C::put_in_regs(ctx, pattern6_1);
                        let expr2_0: usize = 0;
                        let expr3_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr2_0)?;
                        let expr4_0 = constructor_x64_popcnt(ctx, expr0_0, expr3_0)?;
                        let expr5_0: Type = I64;
                        let expr6_0 = C::put_in_regs(ctx, pattern6_1);
                        let expr7_0: usize = 1;
                        let expr8_0 = constructor_value_regs_get_gpr(ctx, expr6_0, expr7_0)?;
                        let expr9_0 = constructor_x64_popcnt(ctx, expr5_0, expr8_0)?;
                        let expr10_0: Type = I64;
                        let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                        let expr12_0 = constructor_add(ctx, expr10_0, expr4_0, &expr11_0)?;
                        let expr13_0 = C::gpr_to_reg(ctx, expr12_0);
                        let expr14_0: Type = I64;
                        let expr15_0: u64 = 0;
                        let expr16_0 = constructor_imm(ctx, expr14_0, expr15_0)?;
                        let expr17_0 = C::value_regs(ctx, expr13_0, expr16_0);
                        let expr18_0 = C::output(ctx, expr17_0);
                        return Some(expr18_0);
                    }
                }
            }
        }
        if pattern2_0 == I8X16 {
            if let Some(()) = C::avx512vl_enabled(ctx, pattern2_0) {
                if let Some(()) = C::avx512bitalg_enabled(ctx, pattern2_0) {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Unary {
                        opcode: ref pattern7_0,
                        arg: pattern7_1,
                    } = &pattern6_0
                    {
                        if let &Opcode::Popcnt = pattern7_0 {
                            // Rule at src/isa/x64/lower.isle line 1720.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr1_0 = constructor_vpopcntb(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_xmm(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
            }
        }
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
            if let Some(()) = C::use_lzcnt(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Clz = pattern6_0 {
                        // Rule at src/isa/x64/lower.isle line 1536.
                        let expr0_0 = constructor_put_in_gpr(ctx, pattern6_1)?;
                        let expr1_0 = constructor_lzcnt(ctx, pattern3_0, expr0_0)?;
                        let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
            if let Some(()) = C::use_bmi1(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Ctz = pattern6_0 {
                        // Rule at src/isa/x64/lower.isle line 1578.
                        let expr0_0 = constructor_put_in_gpr(ctx, pattern6_1)?;
                        let expr1_0 = constructor_tzcnt(ctx, pattern3_0, expr0_0)?;
                        let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
            if let Some(()) = C::use_popcnt(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/x64/lower.isle line 1614.
                        let expr0_0 = constructor_put_in_gpr(ctx, pattern6_1)?;
                        let expr1_0 = constructor_x64_popcnt(ctx, pattern3_0, expr0_0)?;
                        let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                        return Some(expr2_0);
                    }
                }
            }
        }
        if let Some(pattern3_0) = C::ty_8_or_16(ctx, pattern2_0) {
            if let Some(()) = C::use_popcnt(ctx, pattern2_0) {
                let pattern5_0 = C::inst_data(ctx, pattern0_0);
                if let &InstructionData::Unary {
                    opcode: ref pattern6_0,
                    arg: pattern6_1,
                } = &pattern5_0
                {
                    if let &Opcode::Popcnt = pattern6_0 {
                        // Rule at src/isa/x64/lower.isle line 1621.
                        let expr0_0: Type = I32;
                        let expr1_0: Type = I32;
                        let expr2_0 = ExtendKind::Zero;
                        let expr3_0 =
                            constructor_extend_to_gpr(ctx, pattern6_1, expr1_0, &expr2_0)?;
                        let expr4_0 = constructor_x64_popcnt(ctx, expr0_0, expr3_0)?;
                        let expr5_0 = constructor_output_gpr(ctx, expr4_0)?;
                        return Some(expr5_0);
                    }
                }
            }
        }
    }
    let pattern0_0 = arg0;
    let pattern1_0 = C::inst_data(ctx, pattern0_0);
    match &pattern1_0 {
        &InstructionData::NullAry {
            opcode: ref pattern2_0,
        } => {
            if let &Opcode::Debugtrap = pattern2_0 {
                // Rule at src/isa/x64/lower.isle line 2006.
                let expr0_0 = constructor_hlt(ctx)?;
                let expr1_0 = constructor_side_effect(ctx, &expr0_0)?;
                return Some(expr1_0);
            }
        }
        &InstructionData::UnaryIeee32 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F32const = pattern2_0 {
                let pattern4_0 = C::u64_from_ieee32(ctx, pattern2_1);
                // Rule at src/isa/x64/lower.isle line 46.
                let expr0_0: Type = F32;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                return Some(expr2_0);
            }
        }
        &InstructionData::UnaryIeee64 {
            opcode: ref pattern2_0,
            imm: pattern2_1,
        } => {
            if let &Opcode::F64const = pattern2_0 {
                let pattern4_0 = C::u64_from_ieee64(ctx, pattern2_1);
                // Rule at src/isa/x64/lower.isle line 51.
                let expr0_0: Type = F64;
                let expr1_0 = constructor_imm(ctx, expr0_0, pattern4_0)?;
                let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                return Some(expr2_0);
            }
        }
        &InstructionData::Trap {
            opcode: ref pattern2_0,
            code: ref pattern2_1,
        } => {
            match pattern2_0 {
                &Opcode::Trap => {
                    // Rule at src/isa/x64/lower.isle line 1435.
                    let expr0_0 = constructor_ud2(ctx, pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                &Opcode::ResumableTrap => {
                    // Rule at src/isa/x64/lower.isle line 1440.
                    let expr0_0 = constructor_ud2(ctx, pattern2_1)?;
                    let expr1_0 = constructor_safepoint(ctx, &expr0_0)?;
                    return Some(expr1_0);
                }
                _ => {}
            }
        }
        &InstructionData::TernaryImm8 {
            opcode: ref pattern2_0,
            args: ref pattern2_1,
            imm: pattern2_2,
        } => {
            if let &Opcode::Insertlane = pattern2_0 {
                let (pattern4_0, pattern4_1) = C::unpack_value_array_2(ctx, pattern2_1);
                let pattern5_0 = C::value_type(ctx, pattern4_0);
                let pattern6_0 = C::u8_from_uimm8(ctx, pattern2_2);
                // Rule at src/isa/x64/lower.isle line 1302.
                let expr0_0 = constructor_put_in_xmm(ctx, pattern4_0)?;
                let expr1_0 = C::put_in_reg_mem(ctx, pattern4_1);
                let expr2_0 =
                    constructor_vec_insert_lane(ctx, pattern5_0, expr0_0, &expr1_0, pattern6_0)?;
                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                return Some(expr3_0);
            }
        }
        &InstructionData::Unary {
            opcode: ref pattern2_0,
            arg: pattern2_1,
        } => {
            match pattern2_0 {
                &Opcode::IsNull => {
                    let pattern4_0 = C::value_type(ctx, pattern2_1);
                    if pattern4_0 == R64 {
                        // Rule at src/isa/x64/lower.isle line 1849.
                        let expr0_0 = OperandSize::Size64;
                        let expr1_0: u32 = 0;
                        let expr2_0 = constructor_put_in_gpr(ctx, pattern2_1)?;
                        let expr3_0 = constructor_cmp_imm(ctx, &expr0_0, expr1_0, expr2_0)?;
                        let expr4_0 = CC::Z;
                        let expr5_0 = constructor_setcc(ctx, &expr4_0)?;
                        let expr6_0 = constructor_with_flags(ctx, &expr3_0, &expr5_0)?;
                        let expr7_0 = C::output(ctx, expr6_0);
                        return Some(expr7_0);
                    }
                }
                &Opcode::IsInvalid => {
                    let pattern4_0 = C::value_type(ctx, pattern2_1);
                    if pattern4_0 == R64 {
                        // Rule at src/isa/x64/lower.isle line 1857.
                        let expr0_0 = OperandSize::Size64;
                        let expr1_0: u32 = 4294967295;
                        let expr2_0 = constructor_put_in_gpr(ctx, pattern2_1)?;
                        let expr3_0 = constructor_cmp_imm(ctx, &expr0_0, expr1_0, expr2_0)?;
                        let expr4_0 = CC::Z;
                        let expr5_0 = constructor_setcc(ctx, &expr4_0)?;
                        let expr6_0 = constructor_with_flags(ctx, &expr3_0, &expr5_0)?;
                        let expr7_0 = C::output(ctx, expr6_0);
                        return Some(expr7_0);
                    }
                }
                _ => {}
            }
        }
        _ => {}
    }
    if let Some(pattern1_0) = C::first_result(ctx, pattern0_0) {
        let pattern2_0 = C::value_type(ctx, pattern1_0);
        if pattern2_0 == B128 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryBool {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Bconst = pattern5_0 {
                        if pattern5_1 == true {
                            // Rule at src/isa/x64/lower.isle line 39.
                            let expr0_0: Type = B64;
                            let expr1_0: u64 = 1;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = B64;
                            let expr4_0: u64 = 0;
                            let expr5_0 = constructor_imm(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_regs(ctx, expr2_0, expr5_0);
                            let expr7_0 = C::output(ctx, expr6_0);
                            return Some(expr7_0);
                        }
                        if pattern5_1 == false {
                            // Rule at src/isa/x64/lower.isle line 34.
                            let expr0_0: Type = B64;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = B64;
                            let expr4_0: u64 = 0;
                            let expr5_0 = constructor_imm(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::value_regs(ctx, expr2_0, expr5_0);
                            let expr7_0 = C::output(ctx, expr6_0);
                            return Some(expr7_0);
                        }
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 344.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
                            let expr8_0 = constructor_x64_and(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = constructor_value_gprs(ctx, expr8_0, expr4_0)?;
                            let expr10_0 = C::output(ctx, expr9_0);
                            return Some(expr10_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 410.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
                            let expr8_0 = constructor_or(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = constructor_value_gprs(ctx, expr8_0, expr4_0)?;
                            let expr10_0 = C::output(ctx, expr9_0);
                            return Some(expr10_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 468.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr6_0: Type = I64;
                            let expr7_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
                            let expr8_0 = constructor_xor(ctx, expr6_0, expr2_0, &expr7_0)?;
                            let expr9_0 = constructor_value_gprs(ctx, expr8_0, expr4_0)?;
                            let expr10_0 = C::output(ctx, expr9_0);
                            return Some(expr10_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1269.
                        let expr0_0 = constructor_i128_not(ctx, pattern5_1)?;
                        let expr1_0 = C::output(ctx, expr0_0);
                        return Some(expr1_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bitrev = pattern5_0 {
                    // Rule at src/isa/x64/lower.isle line 1771.
                    let expr0_0: Type = I32;
                    let expr1_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                    let expr2_0 = constructor_do_bitrev8(ctx, expr0_0, expr1_0)?;
                    let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
        }
        if pattern2_0 == I16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bitrev = pattern5_0 {
                    // Rule at src/isa/x64/lower.isle line 1774.
                    let expr0_0: Type = I32;
                    let expr1_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                    let expr2_0 = constructor_do_bitrev16(ctx, expr0_0, expr1_0)?;
                    let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
        }
        if pattern2_0 == I32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Bitrev = pattern5_0 {
                    // Rule at src/isa/x64/lower.isle line 1777.
                    let expr0_0: Type = I32;
                    let expr1_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                    let expr2_0 = constructor_do_bitrev32(ctx, expr0_0, expr1_0)?;
                    let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
        }
        if pattern2_0 == I64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Bitrev => {
                        // Rule at src/isa/x64/lower.isle line 1780.
                        let expr0_0: Type = I64;
                        let expr1_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                        let expr2_0 = constructor_do_bitrev64(ctx, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Uextend => {
                        if let Some(pattern7_0) = C::def_inst(ctx, pattern5_1) {
                            if let Some(pattern8_0) = C::first_result(ctx, pattern7_0) {
                                let pattern9_0 = C::value_type(ctx, pattern8_0);
                                if pattern9_0 == I32 {
                                    let pattern11_0 = C::inst_data(ctx, pattern7_0);
                                    match &pattern11_0 {
                                        &InstructionData::Binary {
                                            opcode: ref pattern12_0,
                                            args: ref pattern12_1,
                                        } => {
                                            match pattern12_0 {
                                                &Opcode::Iadd => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1896.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Isub => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1902.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Imul => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1905.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::IaddIfcout => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1899.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Band => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1908.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Bor => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1911.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Bxor => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1914.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Ishl => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1917.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                &Opcode::Ushr => {
                                                    let (pattern14_0, pattern14_1) =
                                                        C::unpack_value_array_2(ctx, pattern12_1);
                                                    // Rule at src/isa/x64/lower.isle line 1920.
                                                    let expr0_0 =
                                                        constructor_output_value(ctx, pattern5_1)?;
                                                    return Some(expr0_0);
                                                }
                                                _ => {}
                                            }
                                        }
                                        &InstructionData::Load {
                                            opcode: ref pattern12_0,
                                            arg: pattern12_1,
                                            flags: pattern12_2,
                                            offset: pattern12_3,
                                        } => {
                                            if let &Opcode::Uload32 = pattern12_0 {
                                                // Rule at src/isa/x64/lower.isle line 1923.
                                                let expr0_0 =
                                                    constructor_output_value(ctx, pattern5_1)?;
                                                return Some(expr0_0);
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                        }
                        let pattern7_0 = C::value_type(ctx, pattern5_1);
                        if let Some(pattern8_0) = C::fits_in_32(ctx, pattern7_0) {
                            // Rule at src/isa/x64/lower.isle line 1878.
                            let expr0_0: Type = I64;
                            let expr1_0 = ExtendKind::Zero;
                            let expr2_0 =
                                constructor_extend_to_gpr(ctx, pattern5_1, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I128 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryImm {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Iconst = pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 15.
                        let expr0_0: Type = I64;
                        let expr1_0 = constructor_imm(ctx, expr0_0, pattern7_0)?;
                        let expr2_0: Type = I64;
                        let expr3_0: u64 = 0;
                        let expr4_0 = constructor_imm(ctx, expr2_0, expr3_0)?;
                        let expr5_0 = C::value_regs(ctx, expr1_0, expr4_0);
                        let expr6_0 = C::output(ctx, expr5_0);
                        return Some(expr6_0);
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 111.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr6_0)?;
                            let expr8_0: usize = 1;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                            let expr12_0 = constructor_add_with_flags_paired(
                                ctx, expr10_0, expr2_0, &expr11_0,
                            )?;
                            let expr13_0: Type = I64;
                            let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr15_0 =
                                constructor_adc_paired(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_with_flags(ctx, &expr12_0, &expr15_0)?;
                            let expr17_0 = C::output(ctx, expr16_0);
                            return Some(expr17_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 257.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr6_0)?;
                            let expr8_0: usize = 1;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                            let expr12_0 = constructor_sub_with_flags_paired(
                                ctx, expr10_0, expr2_0, &expr11_0,
                            )?;
                            let expr13_0: Type = I64;
                            let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr15_0 =
                                constructor_sbb_paired(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_with_flags(ctx, &expr12_0, &expr15_0)?;
                            let expr17_0 = C::output(ctx, expr16_0);
                            return Some(expr17_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 957.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr6_0)?;
                            let expr8_0: usize = 1;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr12_0 = constructor_mul(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                            let expr15_0 = constructor_mul(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0: Type = I64;
                            let expr17_0 = C::gpr_to_gpr_mem_imm(ctx, expr15_0);
                            let expr18_0 = constructor_add(ctx, expr16_0, expr12_0, &expr17_0)?;
                            let expr19_0: Type = I64;
                            let expr20_0 = C::gpr_to_gpr_mem(ctx, expr7_0);
                            let expr21_0 = constructor_mulhi_u(ctx, expr19_0, expr2_0, &expr20_0)?;
                            let expr22_0: usize = 0;
                            let expr23_0 = constructor_value_regs_get_gpr(ctx, expr21_0, expr22_0)?;
                            let expr24_0: usize = 1;
                            let expr25_0 = constructor_value_regs_get_gpr(ctx, expr21_0, expr24_0)?;
                            let expr26_0: Type = I64;
                            let expr27_0 = C::gpr_to_gpr_mem_imm(ctx, expr25_0);
                            let expr28_0 = constructor_add(ctx, expr26_0, expr18_0, &expr27_0)?;
                            let expr29_0 = constructor_value_gprs(ctx, expr23_0, expr28_0)?;
                            let expr30_0 = C::output(ctx, expr29_0);
                            return Some(expr30_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 334.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr6_0)?;
                            let expr8_0: usize = 1;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                            let expr12_0 = constructor_x64_and(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr15_0 = constructor_x64_and(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_value_gprs(ctx, expr12_0, expr15_0)?;
                            let expr17_0 = C::output(ctx, expr16_0);
                            return Some(expr17_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 407.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr2_0 = constructor_or_i128(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 458.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::put_in_regs(ctx, pattern7_1);
                            let expr6_0: usize = 0;
                            let expr7_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr6_0)?;
                            let expr8_0: usize = 1;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                            let expr12_0 = constructor_xor(ctx, expr10_0, expr2_0, &expr11_0)?;
                            let expr13_0: Type = I64;
                            let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr15_0 = constructor_xor(ctx, expr13_0, expr4_0, &expr14_0)?;
                            let expr16_0 = constructor_value_gprs(ctx, expr12_0, expr15_0)?;
                            let expr17_0 = C::output(ctx, expr16_0);
                            return Some(expr17_0);
                        }
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 830.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr2_0 = constructor_shl_i128(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0: Type = I64;
                            let expr5_0: u64 = 128;
                            let expr6_0 = constructor_imm(ctx, expr4_0, expr5_0)?;
                            let expr7_0 = C::gpr_new(ctx, expr6_0);
                            let expr8_0 = C::gpr_to_gpr_mem_imm(ctx, expr1_0);
                            let expr9_0 = constructor_sub(ctx, expr3_0, expr7_0, &expr8_0)?;
                            let expr10_0 = constructor_shr_i128(ctx, expr0_0, expr9_0)?;
                            let expr11_0 = constructor_or_i128(ctx, expr2_0, expr10_0)?;
                            let expr12_0 = C::output(ctx, expr11_0);
                            return Some(expr12_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 870.
                            let expr0_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr1_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr2_0 = constructor_shr_i128(ctx, expr0_0, expr1_0)?;
                            let expr3_0: Type = I64;
                            let expr4_0: Type = I64;
                            let expr5_0: u64 = 128;
                            let expr6_0 = constructor_imm(ctx, expr4_0, expr5_0)?;
                            let expr7_0 = C::gpr_new(ctx, expr6_0);
                            let expr8_0 = C::gpr_to_gpr_mem_imm(ctx, expr1_0);
                            let expr9_0 = constructor_sub(ctx, expr3_0, expr7_0, &expr8_0)?;
                            let expr10_0 = constructor_shl_i128(ctx, expr0_0, expr9_0)?;
                            let expr11_0 = constructor_or_i128(ctx, expr2_0, expr10_0)?;
                            let expr12_0 = C::output(ctx, expr11_0);
                            return Some(expr12_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 522.
                            let expr0_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr2_0 = constructor_shl_i128(ctx, expr1_0, expr0_0)?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 623.
                            let expr0_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr2_0 = constructor_shr_i128(ctx, expr1_0, expr0_0)?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 728.
                            let expr0_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr1_0 = C::put_in_regs(ctx, pattern7_0);
                            let expr2_0 = constructor_sar_i128(ctx, expr1_0, expr0_0)?;
                            let expr3_0 = C::output(ctx, expr2_0);
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Bnot => {
                            // Rule at src/isa/x64/lower.isle line 1266.
                            let expr0_0 = constructor_i128_not(ctx, pattern5_1)?;
                            let expr1_0 = C::output(ctx, expr0_0);
                            return Some(expr1_0);
                        }
                        &Opcode::Bitrev => {
                            // Rule at src/isa/x64/lower.isle line 1783.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr2_0: usize = 1;
                            let expr3_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_do_bitrev64(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = C::gpr_to_reg(ctx, expr4_0);
                            let expr6_0: Type = I64;
                            let expr7_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr8_0: usize = 0;
                            let expr9_0 = constructor_value_regs_get_gpr(ctx, expr7_0, expr8_0)?;
                            let expr10_0 = constructor_do_bitrev64(ctx, expr6_0, expr9_0)?;
                            let expr11_0 = C::gpr_to_reg(ctx, expr10_0);
                            let expr12_0 = C::value_regs(ctx, expr5_0, expr11_0);
                            let expr13_0 = C::output(ctx, expr12_0);
                            return Some(expr13_0);
                        }
                        &Opcode::Clz => {
                            // Rule at src/isa/x64/lower.isle line 1553.
                            let expr0_0: Type = I64;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr3_0: usize = 1;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_do_clz(ctx, expr0_0, expr1_0, expr4_0)?;
                            let expr6_0: Type = I64;
                            let expr7_0: Type = I64;
                            let expr8_0: Type = I64;
                            let expr9_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr10_0: usize = 0;
                            let expr11_0 = constructor_value_regs_get_gpr(ctx, expr9_0, expr10_0)?;
                            let expr12_0 = constructor_do_clz(ctx, expr7_0, expr8_0, expr11_0)?;
                            let expr13_0: u32 = 64;
                            let expr14_0 = RegMemImm::Imm { simm32: expr13_0 };
                            let expr15_0 = C::gpr_mem_imm_new(ctx, &expr14_0);
                            let expr16_0 = constructor_add(ctx, expr6_0, expr12_0, &expr15_0)?;
                            let expr17_0 = OperandSize::Size64;
                            let expr18_0: u32 = 64;
                            let expr19_0 = constructor_cmp_imm(ctx, &expr17_0, expr18_0, expr5_0)?;
                            let expr20_0: Type = I64;
                            let expr21_0 = CC::NZ;
                            let expr22_0 = C::gpr_to_gpr_mem(ctx, expr5_0);
                            let expr23_0 =
                                constructor_cmove(ctx, expr20_0, &expr21_0, &expr22_0, expr16_0)?;
                            let expr24_0 = constructor_with_flags_reg(ctx, &expr19_0, &expr23_0)?;
                            let expr25_0 = C::gpr_new(ctx, expr24_0);
                            let expr26_0 = C::gpr_to_reg(ctx, expr25_0);
                            let expr27_0: Type = I64;
                            let expr28_0: u64 = 0;
                            let expr29_0 = constructor_imm(ctx, expr27_0, expr28_0)?;
                            let expr30_0 = C::value_regs(ctx, expr26_0, expr29_0);
                            let expr31_0 = C::output(ctx, expr30_0);
                            return Some(expr31_0);
                        }
                        &Opcode::Ctz => {
                            // Rule at src/isa/x64/lower.isle line 1595.
                            let expr0_0: Type = I64;
                            let expr1_0: Type = I64;
                            let expr2_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr3_0: usize = 0;
                            let expr4_0 = constructor_value_regs_get_gpr(ctx, expr2_0, expr3_0)?;
                            let expr5_0 = constructor_do_ctz(ctx, expr0_0, expr1_0, expr4_0)?;
                            let expr6_0: Type = I64;
                            let expr7_0: Type = I64;
                            let expr8_0: Type = I64;
                            let expr9_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr10_0: usize = 1;
                            let expr11_0 = constructor_value_regs_get_gpr(ctx, expr9_0, expr10_0)?;
                            let expr12_0 = constructor_do_ctz(ctx, expr7_0, expr8_0, expr11_0)?;
                            let expr13_0: u32 = 64;
                            let expr14_0 = RegMemImm::Imm { simm32: expr13_0 };
                            let expr15_0 = C::gpr_mem_imm_new(ctx, &expr14_0);
                            let expr16_0 = constructor_add(ctx, expr6_0, expr12_0, &expr15_0)?;
                            let expr17_0 = OperandSize::Size64;
                            let expr18_0: u32 = 64;
                            let expr19_0 = constructor_cmp_imm(ctx, &expr17_0, expr18_0, expr5_0)?;
                            let expr20_0: Type = I64;
                            let expr21_0 = CC::Z;
                            let expr22_0 = C::gpr_to_gpr_mem(ctx, expr16_0);
                            let expr23_0 =
                                constructor_cmove(ctx, expr20_0, &expr21_0, &expr22_0, expr5_0)?;
                            let expr24_0 = constructor_with_flags_reg(ctx, &expr19_0, &expr23_0)?;
                            let expr25_0 = C::gpr_new(ctx, expr24_0);
                            let expr26_0 = C::gpr_to_reg(ctx, expr25_0);
                            let expr27_0: Type = I64;
                            let expr28_0: u64 = 0;
                            let expr29_0 = constructor_imm(ctx, expr27_0, expr28_0)?;
                            let expr30_0 = C::value_regs(ctx, expr26_0, expr29_0);
                            let expr31_0 = C::output(ctx, expr30_0);
                            return Some(expr31_0);
                        }
                        &Opcode::Popcnt => {
                            // Rule at src/isa/x64/lower.isle line 1647.
                            let expr0_0: Type = I64;
                            let expr1_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr2_0: usize = 0;
                            let expr3_0 = constructor_value_regs_get_gpr(ctx, expr1_0, expr2_0)?;
                            let expr4_0 = constructor_do_popcnt(ctx, expr0_0, expr3_0)?;
                            let expr5_0: Type = I64;
                            let expr6_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr7_0: usize = 1;
                            let expr8_0 = constructor_value_regs_get_gpr(ctx, expr6_0, expr7_0)?;
                            let expr9_0 = constructor_do_popcnt(ctx, expr5_0, expr8_0)?;
                            let expr10_0: Type = I64;
                            let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
                            let expr12_0 = constructor_add(ctx, expr10_0, expr4_0, &expr11_0)?;
                            let expr13_0 = C::gpr_to_reg(ctx, expr12_0);
                            let expr14_0: Type = I64;
                            let expr15_0: u64 = 0;
                            let expr16_0 = constructor_imm(ctx, expr14_0, expr15_0)?;
                            let expr17_0 = C::value_regs(ctx, expr13_0, expr16_0);
                            let expr18_0 = C::output(ctx, expr17_0);
                            return Some(expr18_0);
                        }
                        &Opcode::Bint => {
                            // Rule at src/isa/x64/lower.isle line 1998.
                            let expr0_0: Type = I64;
                            let expr1_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr2_0: u32 = 1;
                            let expr3_0 = RegMemImm::Imm { simm32: expr2_0 };
                            let expr4_0 = C::gpr_mem_imm_new(ctx, &expr3_0);
                            let expr5_0 = constructor_x64_and(ctx, expr0_0, expr1_0, &expr4_0)?;
                            let expr6_0 = C::gpr_to_reg(ctx, expr5_0);
                            let expr7_0: Type = I64;
                            let expr8_0: u64 = 0;
                            let expr9_0 = constructor_imm(ctx, expr7_0, expr8_0)?;
                            let expr10_0 = C::value_regs(ctx, expr6_0, expr9_0);
                            let expr11_0 = C::output(ctx, expr10_0);
                            return Some(expr11_0);
                        }
                        &Opcode::Uextend => {
                            let pattern7_0 = C::value_type(ctx, pattern5_1);
                            if pattern7_0 == I64 {
                                // Rule at src/isa/x64/lower.isle line 1870.
                                let expr0_0 = C::put_in_reg(ctx, pattern5_1);
                                let expr1_0: Type = I64;
                                let expr2_0: u64 = 0;
                                let expr3_0 = constructor_imm(ctx, expr1_0, expr2_0)?;
                                let expr4_0 = C::value_regs(ctx, expr0_0, expr3_0);
                                let expr5_0 = C::output(ctx, expr4_0);
                                return Some(expr5_0);
                            }
                            if let Some(pattern8_0) = C::fits_in_32(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 1874.
                                let expr0_0: Type = I64;
                                let expr1_0 = ExtendKind::Zero;
                                let expr2_0 =
                                    constructor_extend_to_gpr(ctx, pattern5_1, expr0_0, &expr1_0)?;
                                let expr3_0 = C::gpr_to_reg(ctx, expr2_0);
                                let expr4_0: Type = I64;
                                let expr5_0: u64 = 0;
                                let expr6_0 = constructor_imm(ctx, expr4_0, expr5_0)?;
                                let expr7_0 = C::value_regs(ctx, expr3_0, expr6_0);
                                let expr8_0 = C::output(ctx, expr7_0);
                                return Some(expr8_0);
                            }
                        }
                        _ => {}
                    }
                }
                &InstructionData::BinaryImm64 {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    imm: pattern5_2,
                } => {
                    if let &Opcode::IaddImm = pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_2);
                        // Rule at src/isa/x64/lower.isle line 210.
                        let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                        let expr1_0: usize = 0;
                        let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                        let expr3_0: usize = 1;
                        let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
                        let expr5_0: Type = I64;
                        let expr6_0 = constructor_imm(ctx, expr5_0, pattern7_0)?;
                        let expr7_0 = C::gpr_new(ctx, expr6_0);
                        let expr8_0: Type = I64;
                        let expr9_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
                        let expr10_0 =
                            constructor_add_with_flags_paired(ctx, expr8_0, expr2_0, &expr9_0)?;
                        let expr11_0: Type = I64;
                        let expr12_0: u32 = 0;
                        let expr13_0 = RegMemImm::Imm { simm32: expr12_0 };
                        let expr14_0 = C::gpr_mem_imm_new(ctx, &expr13_0);
                        let expr15_0 = constructor_adc_paired(ctx, expr11_0, expr4_0, &expr14_0)?;
                        let expr16_0 = constructor_with_flags(ctx, &expr10_0, &expr15_0)?;
                        let expr17_0 = C::output(ctx, expr16_0);
                        return Some(expr17_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F32 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Fadd => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2021.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_addss(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fsub => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2032.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_subss(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmul => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2043.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_mulss(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fdiv => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2054.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_divss(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmin => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2065.
                        let expr0_0: Type = F32;
                        let expr1_0: bool = true;
                        let expr2_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr4_0 =
                            constructor_xmm_min_max_seq(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                        let expr5_0 = constructor_output_xmm(ctx, expr4_0)?;
                        return Some(expr5_0);
                    }
                    &Opcode::FminPseudo => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2234.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr2_0 = constructor_minss(ctx, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmax => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2137.
                        let expr0_0: Type = F32;
                        let expr1_0: bool = false;
                        let expr2_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr4_0 =
                            constructor_xmm_min_max_seq(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                        let expr5_0 = constructor_output_xmm(ctx, expr4_0)?;
                        return Some(expr5_0);
                    }
                    &Opcode::FmaxPseudo => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2245.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr2_0 = constructor_maxss(ctx, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == F64 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Binary {
                opcode: ref pattern5_0,
                args: ref pattern5_1,
            } = &pattern4_0
            {
                match pattern5_0 {
                    &Opcode::Fadd => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2023.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_addsd(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fsub => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2034.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_subsd(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmul => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2045.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_mulsd(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fdiv => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2056.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                        let expr2_0 = constructor_divsd(ctx, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmin => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2067.
                        let expr0_0: Type = F64;
                        let expr1_0: bool = true;
                        let expr2_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr4_0 =
                            constructor_xmm_min_max_seq(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                        let expr5_0 = constructor_output_xmm(ctx, expr4_0)?;
                        return Some(expr5_0);
                    }
                    &Opcode::FminPseudo => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2236.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr2_0 = constructor_minsd(ctx, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    &Opcode::Fmax => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2139.
                        let expr0_0: Type = F64;
                        let expr1_0: bool = false;
                        let expr2_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr4_0 =
                            constructor_xmm_min_max_seq(ctx, expr0_0, expr1_0, expr2_0, expr3_0)?;
                        let expr5_0 = constructor_output_xmm(ctx, expr4_0)?;
                        return Some(expr5_0);
                    }
                    &Opcode::FmaxPseudo => {
                        let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 2247.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                        let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                        let expr2_0 = constructor_maxsd(ctx, expr0_0, expr1_0)?;
                        let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                    _ => {}
                }
            }
        }
        if pattern2_0 == I8X16 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1402.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminsb(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1424.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminub(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1391.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxsb(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1413.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxub(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 534.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psllw(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr5_0 = constructor_ishl_i8x16_mask(ctx, &expr4_0)?;
                            let expr6_0: Type = I8X16;
                            let expr7_0 = ExtKind::None;
                            let expr8_0 = constructor_x64_load(ctx, expr6_0, &expr5_0, &expr7_0)?;
                            let expr9_0: Type = I8X16;
                            let expr10_0 = RegMem::Reg { reg: expr8_0 };
                            let expr11_0 = C::reg_mem_to_xmm_mem(ctx, &expr10_0);
                            let expr12_0 = constructor_sse_and(ctx, expr9_0, expr3_0, &expr11_0)?;
                            let expr13_0 = constructor_output_xmm(ctx, expr12_0)?;
                            return Some(expr13_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 633.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psrlw(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr5_0 = constructor_ushr_i8x16_mask(ctx, &expr4_0)?;
                            let expr6_0: Type = I8X16;
                            let expr7_0 = ExtKind::None;
                            let expr8_0 = constructor_x64_load(ctx, expr6_0, &expr5_0, &expr7_0)?;
                            let expr9_0: Type = I8X16;
                            let expr10_0 = RegMem::Reg { reg: expr8_0 };
                            let expr11_0 = C::reg_mem_to_xmm_mem(ctx, &expr10_0);
                            let expr12_0 = constructor_sse_and(ctx, expr9_0, expr3_0, &expr11_0)?;
                            let expr13_0 = constructor_output_xmm(ctx, expr12_0)?;
                            return Some(expr13_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            let pattern8_0 = C::value_type(ctx, pattern7_1);
                            // Rule at src/isa/x64/lower.isle line 749.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                            let expr2_0 = constructor_punpcklbw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                            let expr4_0 = constructor_punpckhbw(ctx, expr0_0, &expr3_0)?;
                            let expr5_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr6_0 =
                                constructor_sshr_i8x16_bigger_shift(ctx, pattern8_0, &expr5_0)?;
                            let expr7_0 = constructor_psraw(ctx, expr2_0, &expr6_0)?;
                            let expr8_0 = constructor_psraw(ctx, expr4_0, &expr6_0)?;
                            let expr9_0 = C::xmm_to_xmm_mem(ctx, expr8_0);
                            let expr10_0 = constructor_packsswb(ctx, expr7_0, &expr9_0)?;
                            let expr11_0 = constructor_output_xmm(ctx, expr10_0)?;
                            return Some(expr11_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/x64/lower.isle line 889.
                            let expr0_0: Type = I8X16;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::xmm_new(ctx, expr2_0);
                            let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr5_0 = constructor_psubb(ctx, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Iabs => {
                            // Rule at src/isa/x64/lower.isle line 1210.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr1_0 = constructor_pabsb(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_xmm(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Popcnt => {
                            // Rule at src/isa/x64/lower.isle line 1754.
                            let expr0_0 = C::popcount_4bit_table(ctx);
                            let expr1_0: Type = I8X16;
                            let expr2_0 = C::popcount_low_mask(ctx);
                            let expr3_0 = constructor_xmm_load_const(ctx, expr1_0, expr2_0)?;
                            let expr4_0: Type = I8X16;
                            let expr5_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr3_0);
                            let expr7_0 = constructor_sse_and(ctx, expr4_0, expr5_0, &expr6_0)?;
                            let expr8_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                            let expr9_0: u32 = 4;
                            let expr10_0 = RegMemImm::Imm { simm32: expr9_0 };
                            let expr11_0 = constructor_mov_rmi_to_xmm(ctx, &expr10_0)?;
                            let expr12_0 = constructor_psrlw(ctx, expr8_0, &expr11_0)?;
                            let expr13_0: Type = I8X16;
                            let expr14_0 = C::xmm_to_xmm_mem(ctx, expr3_0);
                            let expr15_0 = constructor_sse_and(ctx, expr13_0, expr12_0, &expr14_0)?;
                            let expr16_0: Type = I8X16;
                            let expr17_0 = C::popcount_4bit_table(ctx);
                            let expr18_0 = constructor_xmm_load_const(ctx, expr16_0, expr17_0)?;
                            let expr19_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                            let expr20_0 = constructor_pshufb(ctx, expr18_0, &expr19_0)?;
                            let expr21_0 = C::xmm_to_xmm_mem(ctx, expr15_0);
                            let expr22_0 = constructor_pshufb(ctx, expr18_0, &expr21_0)?;
                            let expr23_0 = C::xmm_to_xmm_mem(ctx, expr22_0);
                            let expr24_0 = constructor_paddb(ctx, expr20_0, &expr23_0)?;
                            let expr25_0 = constructor_output_xmm(ctx, expr24_0)?;
                            return Some(expr25_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I16X8 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1405.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminsw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1427.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminuw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1394.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxsw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1416.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxuw(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 576.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psllw(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 678.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psrlw(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 776.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psraw(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/x64/lower.isle line 892.
                            let expr0_0: Type = I16X8;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::xmm_new(ctx, expr2_0);
                            let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr5_0 = constructor_psubw(ctx, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Iabs => {
                            // Rule at src/isa/x64/lower.isle line 1213.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr1_0 = constructor_pabsw(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_xmm(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I32X4 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1408.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminsd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1430.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pminud(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1397.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxsd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1419.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaxud(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 579.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_pslld(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 681.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psrld(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 779.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psrad(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::WideningPairwiseDotProductS => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2011.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_pmaddwd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/x64/lower.isle line 895.
                            let expr0_0: Type = I32X4;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::xmm_new(ctx, expr2_0);
                            let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr5_0 = constructor_psubd(ctx, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Iabs => {
                            // Rule at src/isa/x64/lower.isle line 1216.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr1_0 = constructor_pabsd(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_xmm(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == I64X2 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 582.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psllq(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 684.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = C::put_in_reg_mem_imm(ctx, pattern7_1);
                            let expr2_0 = constructor_mov_rmi_to_xmm(ctx, &expr1_0)?;
                            let expr3_0 = constructor_psrlq(ctx, expr0_0, &expr2_0)?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 790.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0: Type = I64;
                            let expr2_0: u8 = 0;
                            let expr3_0 = constructor_pextrd(ctx, expr1_0, expr0_0, expr2_0)?;
                            let expr4_0: Type = I64;
                            let expr5_0: u8 = 1;
                            let expr6_0 = constructor_pextrd(ctx, expr4_0, expr0_0, expr5_0)?;
                            let expr7_0: Type = I64;
                            let expr8_0 = C::put_masked_in_imm8_gpr(ctx, pattern7_1, expr7_0);
                            let expr9_0: Type = I64;
                            let expr10_0 = constructor_sar(ctx, expr9_0, expr3_0, &expr8_0)?;
                            let expr11_0: Type = I64;
                            let expr12_0 = constructor_sar(ctx, expr11_0, expr6_0, &expr8_0)?;
                            let expr13_0 = C::gpr_to_gpr_mem(ctx, expr10_0);
                            let expr14_0 = C::gpr_to_gpr_mem(ctx, expr12_0);
                            let expr15_0 =
                                constructor_make_i64x2_from_lanes(ctx, &expr13_0, &expr14_0)?;
                            let expr16_0 = constructor_output_xmm(ctx, expr15_0)?;
                            return Some(expr16_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/x64/lower.isle line 898.
                            let expr0_0: Type = I64X2;
                            let expr1_0: u64 = 0;
                            let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = C::xmm_new(ctx, expr2_0);
                            let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern5_1)?;
                            let expr5_0 = constructor_psubq(ctx, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Iabs => {
                            // Rule at src/isa/x64/lower.isle line 1230.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                            let expr1_0: Type = I64X2;
                            let expr2_0: u64 = 0;
                            let expr3_0 = constructor_imm(ctx, expr1_0, expr2_0)?;
                            let expr4_0 = C::xmm_new(ctx, expr3_0);
                            let expr5_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                            let expr6_0 = constructor_psubq(ctx, expr4_0, &expr5_0)?;
                            let expr7_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                            let expr8_0 = constructor_blendvpd(ctx, expr6_0, &expr7_0, expr6_0)?;
                            let expr9_0 = constructor_output_xmm(ctx, expr8_0)?;
                            return Some(expr9_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F32X4 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Fadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2025.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_addps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fsub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2036.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_subps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2047.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_mulps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fdiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2058.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_divps(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2082.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_minps(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr4_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr5_0 = constructor_minps(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr7_0 = constructor_orps(ctx, expr2_0, &expr6_0)?;
                            let expr8_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr9_0 = FcmpImm::Unordered;
                            let expr10_0 = constructor_cmpps(ctx, expr7_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = C::xmm_to_xmm_mem(ctx, expr10_0);
                            let expr12_0 = constructor_orps(ctx, expr7_0, &expr11_0)?;
                            let expr13_0: u32 = 10;
                            let expr14_0 = RegMemImm::Imm { simm32: expr13_0 };
                            let expr15_0 = constructor_mov_rmi_to_xmm(ctx, &expr14_0)?;
                            let expr16_0 = constructor_psrld(ctx, expr10_0, &expr15_0)?;
                            let expr17_0 = C::xmm_to_xmm_mem(ctx, expr12_0);
                            let expr18_0 = constructor_andnps(ctx, expr16_0, &expr17_0)?;
                            let expr19_0 = constructor_output_xmm(ctx, expr18_0)?;
                            return Some(expr19_0);
                        }
                        &Opcode::FminPseudo => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2238.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr2_0 = constructor_minps(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2145.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_maxps(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr4_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr5_0 = constructor_maxps(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr7_0 = constructor_xorps(ctx, expr2_0, &expr6_0)?;
                            let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                            let expr9_0 = constructor_orps(ctx, expr2_0, &expr8_0)?;
                            let expr10_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                            let expr11_0 = constructor_subps(ctx, expr9_0, &expr10_0)?;
                            let expr12_0 = C::xmm_to_xmm_mem(ctx, expr9_0);
                            let expr13_0 = FcmpImm::Unordered;
                            let expr14_0 = constructor_cmpps(ctx, expr9_0, &expr12_0, &expr13_0)?;
                            let expr15_0: u32 = 10;
                            let expr16_0 = RegMemImm::Imm { simm32: expr15_0 };
                            let expr17_0 = constructor_mov_rmi_to_xmm(ctx, &expr16_0)?;
                            let expr18_0 = constructor_psrld(ctx, expr14_0, &expr17_0)?;
                            let expr19_0 = C::xmm_to_xmm_mem(ctx, expr11_0);
                            let expr20_0 = constructor_andnps(ctx, expr18_0, &expr19_0)?;
                            let expr21_0 = constructor_output_xmm(ctx, expr20_0)?;
                            return Some(expr21_0);
                        }
                        &Opcode::FmaxPseudo => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2249.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr2_0 = constructor_maxps(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Fabs = pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1238.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                        let expr1_0: Type = F32X4;
                        let expr2_0 = constructor_vector_all_ones(ctx, expr1_0)?;
                        let expr3_0: u32 = 1;
                        let expr4_0 = RegMemImm::Imm { simm32: expr3_0 };
                        let expr5_0 = constructor_mov_rmi_to_xmm(ctx, &expr4_0)?;
                        let expr6_0 = constructor_psrld(ctx, expr2_0, &expr5_0)?;
                        let expr7_0 = C::xmm_to_xmm_mem(ctx, expr6_0);
                        let expr8_0 = constructor_andps(ctx, expr0_0, &expr7_0)?;
                        let expr9_0 = constructor_output_xmm(ctx, expr8_0)?;
                        return Some(expr9_0);
                    }
                }
                _ => {}
            }
        }
        if pattern2_0 == F64X2 {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Fadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2027.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_addpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fsub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2038.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_subpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2049.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_mulpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fdiv => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2060.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_divpd(ctx, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2125.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_minpd(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr4_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr5_0 = constructor_minpd(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr7_0 = constructor_orpd(ctx, expr2_0, &expr6_0)?;
                            let expr8_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr9_0 = FcmpImm::Unordered;
                            let expr10_0 = constructor_cmppd(ctx, expr2_0, &expr8_0, &expr9_0)?;
                            let expr11_0 = C::xmm_to_xmm_mem(ctx, expr10_0);
                            let expr12_0 = constructor_orpd(ctx, expr7_0, &expr11_0)?;
                            let expr13_0: u32 = 13;
                            let expr14_0 = RegMemImm::Imm { simm32: expr13_0 };
                            let expr15_0 = constructor_mov_rmi_to_xmm(ctx, &expr14_0)?;
                            let expr16_0 = constructor_psrlq(ctx, expr10_0, &expr15_0)?;
                            let expr17_0 = C::xmm_to_xmm_mem(ctx, expr12_0);
                            let expr18_0 = constructor_andnpd(ctx, expr16_0, &expr17_0)?;
                            let expr19_0 = constructor_output_xmm(ctx, expr18_0)?;
                            return Some(expr19_0);
                        }
                        &Opcode::FminPseudo => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2240.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr2_0 = constructor_minpd(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Fmax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2188.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_maxpd(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr4_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr5_0 = constructor_maxpd(ctx, expr3_0, expr4_0)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                            let expr7_0 = constructor_xorpd(ctx, expr2_0, &expr6_0)?;
                            let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                            let expr9_0 = constructor_orpd(ctx, expr2_0, &expr8_0)?;
                            let expr10_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                            let expr11_0 = constructor_subpd(ctx, expr9_0, &expr10_0)?;
                            let expr12_0 = C::xmm_to_xmm_mem(ctx, expr9_0);
                            let expr13_0 = FcmpImm::Unordered;
                            let expr14_0 = constructor_cmppd(ctx, expr9_0, &expr12_0, &expr13_0)?;
                            let expr15_0: u32 = 13;
                            let expr16_0 = RegMemImm::Imm { simm32: expr15_0 };
                            let expr17_0 = constructor_mov_rmi_to_xmm(ctx, &expr16_0)?;
                            let expr18_0 = constructor_psrlq(ctx, expr14_0, &expr17_0)?;
                            let expr19_0 = C::xmm_to_xmm_mem(ctx, expr11_0);
                            let expr20_0 = constructor_andnpd(ctx, expr18_0, &expr19_0)?;
                            let expr21_0 = constructor_output_xmm(ctx, expr20_0)?;
                            return Some(expr21_0);
                        }
                        &Opcode::FmaxPseudo => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 2251.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr2_0 = constructor_maxpd(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Fabs = pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1244.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                        let expr1_0: Type = F64X2;
                        let expr2_0 = constructor_vector_all_ones(ctx, expr1_0)?;
                        let expr3_0: u32 = 1;
                        let expr4_0 = RegMemImm::Imm { simm32: expr3_0 };
                        let expr5_0 = constructor_mov_rmi_to_xmm(ctx, &expr4_0)?;
                        let expr6_0 = constructor_psrlq(ctx, expr2_0, &expr5_0)?;
                        let expr7_0 = C::xmm_to_xmm_mem(ctx, expr6_0);
                        let expr8_0 = constructor_andpd(ctx, expr0_0, &expr7_0)?;
                        let expr9_0 = constructor_output_xmm(ctx, expr8_0)?;
                        return Some(expr9_0);
                    }
                }
                _ => {}
            }
        }
        let pattern3_0 = C::inst_data(ctx, pattern0_0);
        match &pattern3_0 {
            &InstructionData::NullAry {
                opcode: ref pattern4_0,
            } => {
                if let &Opcode::Null = pattern4_0 {
                    // Rule at src/isa/x64/lower.isle line 56.
                    let expr0_0: u64 = 0;
                    let expr1_0 = constructor_imm(ctx, pattern2_0, expr0_0)?;
                    let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                    return Some(expr2_0);
                }
            }
            &InstructionData::Binary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                if let &Opcode::BandNot = pattern4_0 {
                    let (pattern6_0, pattern6_1) = C::unpack_value_array_2(ctx, pattern4_1);
                    // Rule at src/isa/x64/lower.isle line 1205.
                    let expr0_0 = constructor_put_in_xmm(ctx, pattern6_1)?;
                    let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern6_0)?;
                    let expr2_0 = constructor_sse_and_not(ctx, pattern2_0, expr0_0, &expr1_0)?;
                    let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                    return Some(expr3_0);
                }
            }
            &InstructionData::Ternary {
                opcode: ref pattern4_0,
                args: ref pattern4_1,
            } => {
                if let &Opcode::Select = pattern4_0 {
                    let (pattern6_0, pattern6_1, pattern6_2) =
                        C::unpack_value_array_3(ctx, pattern4_1);
                    if let Some(pattern7_0) = C::def_inst(ctx, pattern6_0) {
                        let pattern8_0 = C::inst_data(ctx, pattern7_0);
                        if let &InstructionData::FloatCompare {
                            opcode: ref pattern9_0,
                            args: ref pattern9_1,
                            cond: ref pattern9_2,
                        } = &pattern8_0
                        {
                            if let &Opcode::Fcmp = pattern9_0 {
                                let (pattern11_0, pattern11_1) =
                                    C::unpack_value_array_2(ctx, pattern9_1);
                                match pattern9_2 {
                                    &FloatCC::Equal => {
                                        // Rule at src/isa/x64/lower.isle line 1524.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::NZ;
                                        let expr2_0 = CC::P;
                                        let expr3_0 = constructor_cmove_or_from_values(
                                            ctx, pattern2_0, &expr1_0, &expr2_0, pattern6_2,
                                            pattern6_1,
                                        )?;
                                        let expr4_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr3_0)?;
                                        let expr5_0 = C::output(ctx, expr4_0);
                                        return Some(expr5_0);
                                    }
                                    &FloatCC::GreaterThan => {
                                        // Rule at src/isa/x64/lower.isle line 1476.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::NBE;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::GreaterThanOrEqual => {
                                        // Rule at src/isa/x64/lower.isle line 1479.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::NB;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::LessThan => {
                                        // Rule at src/isa/x64/lower.isle line 1499.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::NBE;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::LessThanOrEqual => {
                                        // Rule at src/isa/x64/lower.isle line 1502.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::NB;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::NotEqual => {
                                        // Rule at src/isa/x64/lower.isle line 1527.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::NZ;
                                        let expr2_0 = CC::P;
                                        let expr3_0 = constructor_cmove_or_from_values(
                                            ctx, pattern2_0, &expr1_0, &expr2_0, pattern6_1,
                                            pattern6_2,
                                        )?;
                                        let expr4_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr3_0)?;
                                        let expr5_0 = C::output(ctx, expr4_0);
                                        return Some(expr5_0);
                                    }
                                    &FloatCC::Ordered => {
                                        // Rule at src/isa/x64/lower.isle line 1470.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::NP;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::Unordered => {
                                        // Rule at src/isa/x64/lower.isle line 1473.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::P;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::UnorderedOrGreaterThan => {
                                        // Rule at src/isa/x64/lower.isle line 1505.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::B;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::UnorderedOrGreaterThanOrEqual => {
                                        // Rule at src/isa/x64/lower.isle line 1508.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_0, pattern11_1)?;
                                        let expr1_0 = CC::BE;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::UnorderedOrLessThan => {
                                        // Rule at src/isa/x64/lower.isle line 1482.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::B;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    &FloatCC::UnorderedOrLessThanOrEqual => {
                                        // Rule at src/isa/x64/lower.isle line 1485.
                                        let expr0_0 =
                                            constructor_fpcmp(ctx, pattern11_1, pattern11_0)?;
                                        let expr1_0 = CC::BE;
                                        let expr2_0 = constructor_cmove_from_values(
                                            ctx, pattern2_0, &expr1_0, pattern6_1, pattern6_2,
                                        )?;
                                        let expr3_0 =
                                            constructor_with_flags(ctx, &expr0_0, &expr2_0)?;
                                        let expr4_0 = C::output(ctx, expr3_0);
                                        return Some(expr4_0);
                                    }
                                    _ => {}
                                }
                            }
                        }
                    }
                }
            }
            &InstructionData::Unary {
                opcode: ref pattern4_0,
                arg: pattern4_1,
            } => {
                match pattern4_0 {
                    &Opcode::Breduce => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        if pattern6_0 == pattern2_0 {
                            // Rule at src/isa/x64/lower.isle line 1984.
                            let expr0_0 = constructor_output_value(ctx, pattern4_1)?;
                            return Some(expr0_0);
                        }
                    }
                    &Opcode::Bextend => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/x64/lower.isle line 1965.
                        let expr0_0 =
                            constructor_generic_sextend(ctx, pattern4_1, pattern6_0, pattern2_0)?;
                        return Some(expr0_0);
                    }
                    &Opcode::Ireduce => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        if pattern6_0 == pattern2_0 {
                            // Rule at src/isa/x64/lower.isle line 1973.
                            let expr0_0 = constructor_output_value(ctx, pattern4_1)?;
                            return Some(expr0_0);
                        }
                    }
                    &Opcode::Uextend => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        if pattern6_0 == pattern2_0 {
                            // Rule at src/isa/x64/lower.isle line 1866.
                            let expr0_0 = constructor_output_value(ctx, pattern4_1)?;
                            return Some(expr0_0);
                        }
                    }
                    &Opcode::Sextend => {
                        let pattern6_0 = C::value_type(ctx, pattern4_1);
                        // Rule at src/isa/x64/lower.isle line 1959.
                        let expr0_0 =
                            constructor_generic_sextend(ctx, pattern4_1, pattern6_0, pattern2_0)?;
                        return Some(expr0_0);
                    }
                    _ => {}
                }
            }
            _ => {}
        }
        if let Some(()) = C::avx512vl_enabled(ctx, pattern2_0) {
            if let Some(()) = C::avx512dq_enabled(ctx, pattern2_0) {
                if let Some((pattern5_0, pattern5_1)) = C::multi_lane(ctx, pattern2_0) {
                    if pattern5_0 == 64 {
                        if pattern5_1 == 2 {
                            let pattern8_0 = C::inst_data(ctx, pattern0_0);
                            if let &InstructionData::Binary {
                                opcode: ref pattern9_0,
                                args: ref pattern9_1,
                            } = &pattern8_0
                            {
                                if let &Opcode::Imul = pattern9_0 {
                                    let (pattern11_0, pattern11_1) =
                                        C::unpack_value_array_2(ctx, pattern9_1);
                                    // Rule at src/isa/x64/lower.isle line 992.
                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern11_0)?;
                                    let expr1_0 = constructor_put_in_xmm(ctx, pattern11_1)?;
                                    let expr2_0 = constructor_vpmullq(ctx, &expr0_0, expr1_0)?;
                                    let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                    return Some(expr3_0);
                                }
                            }
                        }
                    }
                }
            }
            if let Some(()) = C::avx512f_enabled(ctx, pattern2_0) {
                if pattern2_0 == I64X2 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Unary {
                        opcode: ref pattern7_0,
                        arg: pattern7_1,
                    } = &pattern6_0
                    {
                        if let &Opcode::Iabs = pattern7_0 {
                            // Rule at src/isa/x64/lower.isle line 1220.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr1_0 = constructor_vpabsq(ctx, &expr0_0)?;
                            let expr2_0 = constructor_output_xmm(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
            }
        }
        if let Some((pattern3_0, pattern3_1)) = C::multi_lane(ctx, pattern2_0) {
            if pattern3_0 == 8 {
                if pattern3_1 == 16 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match pattern7_0 {
                            &Opcode::AvgRound => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 903.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_pavgb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::UaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 136.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddusb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::SaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 126.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddsb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::UsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 282.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubusb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::SsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 272.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubsb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 94.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 240.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubb(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 16 {
                if pattern3_1 == 8 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match pattern7_0 {
                            &Opcode::AvgRound => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 907.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_pavgw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::UaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 140.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddusw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::SaddSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 130.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddsw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::UsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 286.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubusw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::SsubSat => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 276.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubsw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 98.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 244.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1080.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_pmovsxbw(ctx, &expr0_0)?;
                                                                                    let expr2_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr3_0 = constructor_pmovsxbw(ctx, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr3_0);
                                                                                    let expr5_0 = constructor_pmullw(ctx, expr1_0, &expr4_0)?;
                                                                                    let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                                                                                    return Some(
                                                                                        expr6_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1040.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                                                                                    let expr2_0: u8 = 8;
                                                                                    let expr3_0 = OperandSize::Size32;
                                                                                    let expr4_0 = constructor_palignr(ctx, expr0_0, &expr1_0, expr2_0, &expr3_0)?;
                                                                                    let expr5_0 = C::xmm_to_xmm_mem(ctx, expr4_0);
                                                                                    let expr6_0 = constructor_pmovsxbw(ctx, &expr5_0)?;
                                                                                    let expr7_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0: u8 = 8;
                                                                                    let expr10_0 = OperandSize::Size32;
                                                                                    let expr11_0 = constructor_palignr(ctx, expr7_0, &expr8_0, expr9_0, &expr10_0)?;
                                                                                    let expr12_0 = C::xmm_to_xmm_mem(ctx, expr11_0);
                                                                                    let expr13_0 = constructor_pmovsxbw(ctx, &expr12_0)?;
                                                                                    let expr14_0 = C::xmm_to_xmm_mem(ctx, expr13_0);
                                                                                    let expr15_0 = constructor_pmullw(ctx, expr6_0, &expr14_0)?;
                                                                                    let expr16_0 = constructor_output_xmm(ctx, expr15_0)?;
                                                                                    return Some(
                                                                                        expr16_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1156.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_pmovzxbw(ctx, &expr0_0)?;
                                                                                    let expr2_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr3_0 = constructor_pmovzxbw(ctx, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr3_0);
                                                                                    let expr5_0 = constructor_pmullw(ctx, expr1_0, &expr4_0)?;
                                                                                    let expr6_0 = constructor_output_xmm(ctx, expr5_0)?;
                                                                                    return Some(
                                                                                        expr6_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 8 {
                                                        if pattern15_1 == 16 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 8 {
                                                                                if pattern23_1 == 16
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1116.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                                                                                    let expr2_0: u8 = 8;
                                                                                    let expr3_0 = OperandSize::Size32;
                                                                                    let expr4_0 = constructor_palignr(ctx, expr0_0, &expr1_0, expr2_0, &expr3_0)?;
                                                                                    let expr5_0 = C::xmm_to_xmm_mem(ctx, expr4_0);
                                                                                    let expr6_0 = constructor_pmovzxbw(ctx, &expr5_0)?;
                                                                                    let expr7_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0: u8 = 8;
                                                                                    let expr10_0 = OperandSize::Size32;
                                                                                    let expr11_0 = constructor_palignr(ctx, expr7_0, &expr8_0, expr9_0, &expr10_0)?;
                                                                                    let expr12_0 = C::xmm_to_xmm_mem(ctx, expr11_0);
                                                                                    let expr13_0 = constructor_pmovzxbw(ctx, &expr12_0)?;
                                                                                    let expr14_0 = C::xmm_to_xmm_mem(ctx, expr13_0);
                                                                                    let expr15_0 = constructor_pmullw(ctx, expr6_0, &expr14_0)?;
                                                                                    let expr16_0 = constructor_output_xmm(ctx, expr15_0)?;
                                                                                    return Some(
                                                                                        expr16_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 984.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_pmullw(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 32 {
                if pattern3_1 == 4 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match pattern7_0 {
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 102.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddd(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 248.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubd(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1090.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr5_0 = constructor_pmulhw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                                                                                    let expr7_0 = constructor_punpcklwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = constructor_output_xmm(ctx, expr7_0)?;
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1054.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr5_0 = constructor_pmulhw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                                                                                    let expr7_0 = constructor_punpckhwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = constructor_output_xmm(ctx, expr7_0)?;
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1166.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr5_0 = constructor_pmulhuw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                                                                                    let expr7_0 = constructor_punpcklwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = constructor_output_xmm(ctx, expr7_0)?;
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 16 {
                                                        if pattern15_1 == 8 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 16 {
                                                                                if pattern23_1 == 8
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1130.
                                                                                    let expr0_0 = constructor_put_in_xmm(ctx, pattern12_1)?;
                                                                                    let expr1_0 = constructor_put_in_xmm(ctx, pattern20_1)?;
                                                                                    let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr3_0 = constructor_pmullw(ctx, expr0_0, &expr2_0)?;
                                                                                    let expr4_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                                                                    let expr5_0 = constructor_pmulhuw(ctx, expr0_0, &expr4_0)?;
                                                                                    let expr6_0 = C::xmm_to_xmm_mem(ctx, expr5_0);
                                                                                    let expr7_0 = constructor_punpckhwd(ctx, expr3_0, &expr6_0)?;
                                                                                    let expr8_0 = constructor_output_xmm(ctx, expr7_0)?;
                                                                                    return Some(
                                                                                        expr8_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 987.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_pmulld(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            if pattern3_0 == 64 {
                if pattern3_1 == 2 {
                    let pattern6_0 = C::inst_data(ctx, pattern0_0);
                    if let &InstructionData::Binary {
                        opcode: ref pattern7_0,
                        args: ref pattern7_1,
                    } = &pattern6_0
                    {
                        match pattern7_0 {
                            &Opcode::Iadd => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 106.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_paddq(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Isub => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                // Rule at src/isa/x64/lower.isle line 252.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern9_1)?;
                                let expr2_0 = constructor_psubq(ctx, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            &Opcode::Imul => {
                                let (pattern9_0, pattern9_1) =
                                    C::unpack_value_array_2(ctx, pattern7_1);
                                if let Some(pattern10_0) = C::def_inst(ctx, pattern9_0) {
                                    let pattern11_0 = C::inst_data(ctx, pattern10_0);
                                    if let &InstructionData::Unary {
                                        opcode: ref pattern12_0,
                                        arg: pattern12_1,
                                    } = &pattern11_0
                                    {
                                        match pattern12_0 {
                                            &Opcode::SwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1102.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0: u8 = 80;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr5_0: u8 = 80;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0 = constructor_pmuldq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = constructor_output_xmm(ctx, expr9_0)?;
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::SwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::SwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1066.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0: u8 = 250;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr5_0: u8 = 250;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0 = constructor_pmuldq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = constructor_output_xmm(ctx, expr9_0)?;
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenLow => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenLow =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1178.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0: u8 = 80;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr5_0: u8 = 80;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0 = constructor_pmuludq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = constructor_output_xmm(ctx, expr9_0)?;
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::UwidenHigh => {
                                                let pattern14_0 = C::value_type(ctx, pattern12_1);
                                                if let Some((pattern15_0, pattern15_1)) =
                                                    C::multi_lane(ctx, pattern14_0)
                                                {
                                                    if pattern15_0 == 32 {
                                                        if pattern15_1 == 4 {
                                                            if let Some(pattern18_0) =
                                                                C::def_inst(ctx, pattern9_1)
                                                            {
                                                                let pattern19_0 =
                                                                    C::inst_data(ctx, pattern18_0);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref pattern20_0,
                                                                    arg: pattern20_1,
                                                                } = &pattern19_0
                                                                {
                                                                    if let &Opcode::UwidenHigh =
                                                                        pattern20_0
                                                                    {
                                                                        let pattern22_0 =
                                                                            C::value_type(
                                                                                ctx,
                                                                                pattern20_1,
                                                                            );
                                                                        if let Some((
                                                                            pattern23_0,
                                                                            pattern23_1,
                                                                        )) = C::multi_lane(
                                                                            ctx,
                                                                            pattern22_0,
                                                                        ) {
                                                                            if pattern23_0 == 32 {
                                                                                if pattern23_1 == 4
                                                                                {
                                                                                    // Rule at src/isa/x64/lower.isle line 1142.
                                                                                    let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern12_1)?;
                                                                                    let expr1_0: u8 = 250;
                                                                                    let expr2_0 = OperandSize::Size32;
                                                                                    let expr3_0 = constructor_pshufd(ctx, &expr0_0, expr1_0, &expr2_0)?;
                                                                                    let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern20_1)?;
                                                                                    let expr5_0: u8 = 250;
                                                                                    let expr6_0 = OperandSize::Size32;
                                                                                    let expr7_0 = constructor_pshufd(ctx, &expr4_0, expr5_0, &expr6_0)?;
                                                                                    let expr8_0 = C::xmm_to_xmm_mem(ctx, expr7_0);
                                                                                    let expr9_0 = constructor_pmuludq(ctx, expr3_0, &expr8_0)?;
                                                                                    let expr10_0 = constructor_output_xmm(ctx, expr9_0)?;
                                                                                    return Some(
                                                                                        expr10_0,
                                                                                    );
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                // Rule at src/isa/x64/lower.isle line 1018.
                                let expr0_0 = constructor_put_in_xmm(ctx, pattern9_0)?;
                                let expr1_0 = constructor_put_in_xmm(ctx, pattern9_1)?;
                                let expr2_0: u32 = 32;
                                let expr3_0 = RegMemImm::Imm { simm32: expr2_0 };
                                let expr4_0 = constructor_mov_rmi_to_xmm(ctx, &expr3_0)?;
                                let expr5_0 = constructor_psrlq(ctx, expr0_0, &expr4_0)?;
                                let expr6_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                let expr7_0 = constructor_pmuludq(ctx, expr5_0, &expr6_0)?;
                                let expr8_0: u32 = 32;
                                let expr9_0 = RegMemImm::Imm { simm32: expr8_0 };
                                let expr10_0 = constructor_mov_rmi_to_xmm(ctx, &expr9_0)?;
                                let expr11_0 = constructor_psrlq(ctx, expr1_0, &expr10_0)?;
                                let expr12_0 = C::xmm_to_xmm_mem(ctx, expr11_0);
                                let expr13_0 = constructor_pmuludq(ctx, expr0_0, &expr12_0)?;
                                let expr14_0 = C::xmm_to_xmm_mem(ctx, expr13_0);
                                let expr15_0 = constructor_paddq(ctx, expr7_0, &expr14_0)?;
                                let expr16_0: u32 = 32;
                                let expr17_0 = RegMemImm::Imm { simm32: expr16_0 };
                                let expr18_0 = constructor_mov_rmi_to_xmm(ctx, &expr17_0)?;
                                let expr19_0 = constructor_psllq(ctx, expr15_0, &expr18_0)?;
                                let expr20_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                                let expr21_0 = constructor_pmuludq(ctx, expr0_0, &expr20_0)?;
                                let expr22_0 = C::xmm_to_xmm_mem(ctx, expr19_0);
                                let expr23_0 = constructor_paddq(ctx, expr21_0, &expr22_0)?;
                                let expr24_0 = constructor_output_xmm(ctx, expr23_0)?;
                                return Some(expr24_0);
                            }
                            _ => {}
                        }
                    }
                }
            }
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 328.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_sse_and(ctx, pattern2_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 392.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_sse_or(ctx, pattern2_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 453.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_sse_xor(ctx, pattern2_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_xmm(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Ternary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Bitselect => {
                            let (pattern7_0, pattern7_1, pattern7_2) =
                                C::unpack_value_array_3(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1279.
                            let expr0_0 = constructor_put_in_xmm(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm(ctx, pattern7_1)?;
                            let expr2_0 = C::xmm_to_xmm_mem(ctx, expr0_0);
                            let expr3_0 = constructor_sse_and(ctx, pattern2_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_put_in_xmm_mem(ctx, pattern7_2)?;
                            let expr5_0 =
                                constructor_sse_and_not(ctx, pattern2_0, expr0_0, &expr4_0)?;
                            let expr6_0 = C::xmm_to_xmm_mem(ctx, expr3_0);
                            let expr7_0 = constructor_sse_or(ctx, pattern2_0, expr5_0, &expr6_0)?;
                            let expr8_0 = constructor_output_xmm(ctx, expr7_0)?;
                            return Some(expr8_0);
                        }
                        &Opcode::Vselect => {
                            let (pattern7_0, pattern7_1, pattern7_2) =
                                C::unpack_value_array_3(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1293.
                            let expr0_0 = constructor_put_in_xmm_mem(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_xmm_mem(ctx, pattern7_1)?;
                            let expr2_0 = constructor_put_in_xmm(ctx, pattern7_2)?;
                            let expr3_0 = constructor_sse_blend(
                                ctx, pattern2_0, &expr0_0, &expr1_0, expr2_0,
                            )?;
                            let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    if let &Opcode::Bnot = pattern5_0 {
                        // Rule at src/isa/x64/lower.isle line 1274.
                        let expr0_0 = constructor_put_in_xmm(ctx, pattern5_1)?;
                        let expr1_0 = constructor_vector_all_ones(ctx, pattern2_0)?;
                        let expr2_0 = C::xmm_to_xmm_mem(ctx, expr1_0);
                        let expr3_0 = constructor_sse_xor(ctx, pattern2_0, expr0_0, &expr2_0)?;
                        let expr4_0 = constructor_output_xmm(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::fits_in_32(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            if let &InstructionData::Unary {
                opcode: ref pattern5_0,
                arg: pattern5_1,
            } = &pattern4_0
            {
                if let &Opcode::Uextend = pattern5_0 {
                    let pattern7_0 = C::value_type(ctx, pattern5_1);
                    if let Some(pattern8_0) = C::fits_in_32(ctx, pattern7_0) {
                        // Rule at src/isa/x64/lower.isle line 1882.
                        let expr0_0: Type = I32;
                        let expr1_0 = ExtendKind::Zero;
                        let expr2_0 =
                            constructor_extend_to_gpr(ctx, pattern5_1, expr0_0, &expr1_0)?;
                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                        return Some(expr3_0);
                    }
                }
            }
        }
        if let Some(pattern3_0) = C::fits_in_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::UnaryImm {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Iconst = pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_1);
                        // Rule at src/isa/x64/lower.isle line 10.
                        let expr0_0 = constructor_imm(ctx, pattern3_0, pattern7_0)?;
                        let expr1_0 = constructor_output_reg(ctx, expr0_0)?;
                        return Some(expr1_0);
                    }
                }
                &InstructionData::UnaryBool {
                    opcode: ref pattern5_0,
                    imm: pattern5_1,
                } => {
                    if let &Opcode::Bconst = pattern5_0 {
                        if pattern5_1 == true {
                            // Rule at src/isa/x64/lower.isle line 28.
                            let expr0_0: u64 = 1;
                            let expr1_0 = constructor_imm(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        if pattern5_1 == false {
                            // Rule at src/isa/x64/lower.isle line 24.
                            let expr0_0: u64 = 0;
                            let expr1_0 = constructor_imm(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_reg(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                    }
                }
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Imin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1383.
                            let expr0_0 = CC::L;
                            let expr1_0 = constructor_cmp_and_choose(
                                ctx, pattern3_0, &expr0_0, pattern7_0, pattern7_1,
                            )?;
                            let expr2_0 = C::output(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Umin => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1377.
                            let expr0_0 = CC::B;
                            let expr1_0 = constructor_cmp_and_choose(
                                ctx, pattern3_0, &expr0_0, pattern7_0, pattern7_1,
                            )?;
                            let expr2_0 = C::output(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Imax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1386.
                            let expr0_0 = CC::NL;
                            let expr1_0 = constructor_cmp_and_choose(
                                ctx, pattern3_0, &expr0_0, pattern7_0, pattern7_1,
                            )?;
                            let expr2_0 = C::output(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Umax => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 1380.
                            let expr0_0 = CC::NB;
                            let expr1_0 = constructor_cmp_and_choose(
                                ctx, pattern3_0, &expr0_0, pattern7_0, pattern7_1,
                            )?;
                            let expr2_0 = C::output(ctx, expr1_0);
                            return Some(expr2_0);
                        }
                        &Opcode::Iadd => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 74.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 86.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 70.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 80.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 64.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Isub => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 228.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sub(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 233.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_sub(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 223.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_sub(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Imul => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 925.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_mul(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 937.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 921.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_mul(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 931.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 916.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_mul(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::IaddIfcout => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 171.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::gpr_to_reg(ctx, expr1_0);
                                let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 181.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::gpr_to_reg(ctx, expr2_0);
                                let expr4_0 = constructor_output_ifcout(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 167.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_add(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = C::gpr_to_reg(ctx, expr1_0);
                                let expr3_0 = constructor_output_ifcout(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 177.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = C::gpr_to_reg(ctx, expr2_0);
                                let expr4_0 = constructor_output_ifcout(ctx, expr3_0)?;
                                return Some(expr4_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 161.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = C::gpr_to_reg(ctx, expr2_0);
                            let expr4_0 = constructor_output_ifcout(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Band => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 317.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_x64_and(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 305.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 =
                                    constructor_x64_and(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 313.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_x64_and(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 300.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 =
                                    constructor_x64_and(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 295.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_x64_and(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 381.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_or(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 370.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 377.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_or(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 365.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 360.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_or(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bxor => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 447.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_xor(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_0) {
                                // Rule at src/isa/x64/lower.isle line 436.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_1)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            if let Some(pattern8_0) = C::simm32_from_value(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 443.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_xor(ctx, pattern3_0, expr0_0, &pattern8_0)?;
                                let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                                return Some(expr2_0);
                            }
                            if let Some(pattern8_0) = C::sinkable_load(ctx, pattern7_1) {
                                // Rule at src/isa/x64/lower.isle line 431.
                                let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                let expr1_0 =
                                    constructor_sink_load_to_gpr_mem_imm(ctx, &pattern8_0)?;
                                let expr2_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr1_0)?;
                                let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                return Some(expr3_0);
                            }
                            // Rule at src/isa/x64/lower.isle line 426.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = constructor_put_in_gpr_mem_imm(ctx, pattern7_1)?;
                            let expr2_0 = constructor_xor(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ishl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 483.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr1_0 = C::put_masked_in_imm8_gpr(ctx, pattern7_1, pattern3_0);
                            let expr2_0 = constructor_shl(ctx, pattern3_0, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Ushr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 589.
                            let expr0_0 = ExtendKind::Zero;
                            let expr1_0 =
                                constructor_extend_to_gpr(ctx, pattern7_0, pattern3_0, &expr0_0)?;
                            let expr2_0 = C::put_masked_in_imm8_gpr(ctx, pattern7_1, pattern3_0);
                            let expr3_0 = constructor_shr(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_gpr(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Sshr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            // Rule at src/isa/x64/lower.isle line 691.
                            let expr0_0 = ExtendKind::Sign;
                            let expr1_0 =
                                constructor_extend_to_gpr(ctx, pattern7_0, pattern3_0, &expr0_0)?;
                            let expr2_0 = C::put_masked_in_imm8_gpr(ctx, pattern7_1, pattern3_0);
                            let expr3_0 = constructor_sar(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_gpr(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Ineg => {
                            // Rule at src/isa/x64/lower.isle line 884.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0 = constructor_neg(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Bnot => {
                            // Rule at src/isa/x64/lower.isle line 1253.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0 = constructor_not(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Breduce => {
                            // Rule at src/isa/x64/lower.isle line 1987.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        &Opcode::Bint => {
                            // Rule at src/isa/x64/lower.isle line 1995.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0: u32 = 1;
                            let expr2_0 = RegMemImm::Imm { simm32: expr1_0 };
                            let expr3_0 = C::gpr_mem_imm_new(ctx, &expr2_0);
                            let expr4_0 = constructor_x64_and(ctx, pattern3_0, expr0_0, &expr3_0)?;
                            let expr5_0 = constructor_output_gpr(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Ireduce => {
                            // Rule at src/isa/x64/lower.isle line 1979.
                            let expr0_0 = C::put_in_regs(ctx, pattern5_1);
                            let expr1_0: usize = 0;
                            let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
                            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                            return Some(expr3_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::BinaryImm64 {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                    imm: pattern5_2,
                } => {
                    if let &Opcode::IaddImm = pattern5_0 {
                        let pattern7_0 = C::u64_from_imm64(ctx, pattern5_2);
                        // Rule at src/isa/x64/lower.isle line 196.
                        let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                        let expr1_0 = constructor_imm(ctx, pattern3_0, pattern7_0)?;
                        let expr2_0 = constructor_reg_to_gpr_mem_imm(ctx, expr1_0)?;
                        let expr3_0 = constructor_add(ctx, pattern3_0, expr0_0, &expr2_0)?;
                        let expr4_0 = constructor_output_gpr(ctx, expr3_0)?;
                        return Some(expr4_0);
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_32_or_64(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                        // Rule at src/isa/x64/lower.isle line 823.
                                        let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                        let expr1_0 = C::const_to_type_masked_imm8(
                                            ctx,
                                            pattern12_0,
                                            pattern3_0,
                                        );
                                        let expr2_0 = constructor_x64_rotl(
                                            ctx, pattern3_0, expr0_0, &expr1_0,
                                        )?;
                                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                        return Some(expr3_0);
                                    }
                                }
                            }
                            // Rule at src/isa/x64/lower.isle line 817.
                            let expr0_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr2_0 = C::gpr_to_imm8_gpr(ctx, expr0_0);
                            let expr3_0 = constructor_x64_rotl(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_gpr(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                        // Rule at src/isa/x64/lower.isle line 863.
                                        let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                        let expr1_0 = C::const_to_type_masked_imm8(
                                            ctx,
                                            pattern12_0,
                                            pattern3_0,
                                        );
                                        let expr2_0 = constructor_x64_rotr(
                                            ctx, pattern3_0, expr0_0, &expr1_0,
                                        )?;
                                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                        return Some(expr3_0);
                                    }
                                }
                            }
                            // Rule at src/isa/x64/lower.isle line 857.
                            let expr0_0 = constructor_lo_gpr(ctx, pattern7_1)?;
                            let expr1_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr2_0 = C::gpr_to_imm8_gpr(ctx, expr0_0);
                            let expr3_0 = constructor_x64_rotr(ctx, pattern3_0, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_output_gpr(ctx, expr3_0)?;
                            return Some(expr4_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Clz => {
                            // Rule at src/isa/x64/lower.isle line 1543.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0 = constructor_do_clz(ctx, pattern3_0, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Ctz => {
                            // Rule at src/isa/x64/lower.isle line 1585.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0 = constructor_do_ctz(ctx, pattern3_0, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        &Opcode::Popcnt => {
                            // Rule at src/isa/x64/lower.isle line 1637.
                            let expr0_0 = constructor_put_in_gpr(ctx, pattern5_1)?;
                            let expr1_0 = constructor_do_popcnt(ctx, pattern3_0, expr0_0)?;
                            let expr2_0 = constructor_output_gpr(ctx, expr1_0)?;
                            return Some(expr2_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        if let Some(pattern3_0) = C::ty_8_or_16(ctx, pattern2_0) {
            let pattern4_0 = C::inst_data(ctx, pattern0_0);
            match &pattern4_0 {
                &InstructionData::Binary {
                    opcode: ref pattern5_0,
                    args: ref pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Rotl => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                        // Rule at src/isa/x64/lower.isle line 809.
                                        let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                        let expr1_0 = C::const_to_type_masked_imm8(
                                            ctx,
                                            pattern12_0,
                                            pattern3_0,
                                        );
                                        let expr2_0 = constructor_x64_rotl(
                                            ctx, pattern3_0, expr0_0, &expr1_0,
                                        )?;
                                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                        return Some(expr3_0);
                                    }
                                }
                            }
                            // Rule at src/isa/x64/lower.isle line 805.
                            let expr0_0: Type = I32;
                            let expr1_0 = ExtendKind::Zero;
                            let expr2_0 =
                                constructor_extend_to_gpr(ctx, pattern7_1, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr4_0 = C::gpr_to_imm8_gpr(ctx, expr2_0);
                            let expr5_0 = constructor_x64_rotl(ctx, pattern3_0, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_gpr(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        &Opcode::Rotr => {
                            let (pattern7_0, pattern7_1) = C::unpack_value_array_2(ctx, pattern5_1);
                            if let Some(pattern8_0) = C::def_inst(ctx, pattern7_1) {
                                let pattern9_0 = C::inst_data(ctx, pattern8_0);
                                if let &InstructionData::UnaryImm {
                                    opcode: ref pattern10_0,
                                    imm: pattern10_1,
                                } = &pattern9_0
                                {
                                    if let &Opcode::Iconst = pattern10_0 {
                                        let pattern12_0 = C::u64_from_imm64(ctx, pattern10_1);
                                        // Rule at src/isa/x64/lower.isle line 849.
                                        let expr0_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                                        let expr1_0 = C::const_to_type_masked_imm8(
                                            ctx,
                                            pattern12_0,
                                            pattern3_0,
                                        );
                                        let expr2_0 = constructor_x64_rotr(
                                            ctx, pattern3_0, expr0_0, &expr1_0,
                                        )?;
                                        let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
                                        return Some(expr3_0);
                                    }
                                }
                            }
                            // Rule at src/isa/x64/lower.isle line 845.
                            let expr0_0: Type = I32;
                            let expr1_0 = ExtendKind::Zero;
                            let expr2_0 =
                                constructor_extend_to_gpr(ctx, pattern7_1, expr0_0, &expr1_0)?;
                            let expr3_0 = constructor_put_in_gpr(ctx, pattern7_0)?;
                            let expr4_0 = C::gpr_to_imm8_gpr(ctx, expr2_0);
                            let expr5_0 = constructor_x64_rotr(ctx, pattern3_0, expr3_0, &expr4_0)?;
                            let expr6_0 = constructor_output_gpr(ctx, expr5_0)?;
                            return Some(expr6_0);
                        }
                        _ => {}
                    }
                }
                &InstructionData::Unary {
                    opcode: ref pattern5_0,
                    arg: pattern5_1,
                } => {
                    match pattern5_0 {
                        &Opcode::Clz => {
                            // Rule at src/isa/x64/lower.isle line 1548.
                            let expr0_0: Type = I32;
                            let expr1_0: Type = I32;
                            let expr2_0 = ExtendKind::Zero;
                            let expr3_0 =
                                constructor_extend_to_gpr(ctx, pattern5_1, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_do_clz(ctx, expr0_0, pattern3_0, expr3_0)?;
                            let expr5_0 = constructor_output_gpr(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Ctz => {
                            // Rule at src/isa/x64/lower.isle line 1590.
                            let expr0_0: Type = I32;
                            let expr1_0: Type = I32;
                            let expr2_0 = ExtendKind::Zero;
                            let expr3_0 =
                                constructor_extend_to_gpr(ctx, pattern5_1, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_do_ctz(ctx, expr0_0, pattern3_0, expr3_0)?;
                            let expr5_0 = constructor_output_gpr(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        &Opcode::Popcnt => {
                            // Rule at src/isa/x64/lower.isle line 1642.
                            let expr0_0: Type = I32;
                            let expr1_0: Type = I32;
                            let expr2_0 = ExtendKind::Zero;
                            let expr3_0 =
                                constructor_extend_to_gpr(ctx, pattern5_1, expr1_0, &expr2_0)?;
                            let expr4_0 = constructor_do_popcnt(ctx, expr0_0, expr3_0)?;
                            let expr5_0 = constructor_output_gpr(ctx, expr4_0)?;
                            return Some(expr5_0);
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
    }
    return None;
}

// Generated as internal constructor for term output_ifcout.
pub fn constructor_output_ifcout<C: Context>(ctx: &mut C, arg0: Reg) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/lower.isle line 157.
    let expr0_0 = C::value_reg(ctx, pattern0_0);
    let expr1_0 = C::value_regs_invalid(ctx);
    let expr2_0 = C::output_pair(ctx, expr0_0, expr1_0);
    return Some(expr2_0);
}

// Generated as internal constructor for term sse_and.
pub fn constructor_sse_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 324.
        let expr0_0 = constructor_andps(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 325.
        let expr0_0 = constructor_andpd(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 326.
        let expr0_0 = constructor_pand(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term sse_or.
pub fn constructor_sse_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 388.
        let expr0_0 = constructor_orps(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 389.
        let expr0_0 = constructor_orpd(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 390.
        let expr0_0 = constructor_por(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term or_i128.
pub fn constructor_or_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: ValueRegs,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 399.
    let expr0_0: usize = 0;
    let expr1_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr0_0)?;
    let expr2_0: usize = 1;
    let expr3_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr2_0)?;
    let expr4_0: usize = 0;
    let expr5_0 = constructor_value_regs_get_gpr(ctx, pattern1_0, expr4_0)?;
    let expr6_0: usize = 1;
    let expr7_0 = constructor_value_regs_get_gpr(ctx, pattern1_0, expr6_0)?;
    let expr8_0: Type = I64;
    let expr9_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
    let expr10_0 = constructor_or(ctx, expr8_0, expr1_0, &expr9_0)?;
    let expr11_0: Type = I64;
    let expr12_0 = C::gpr_to_gpr_mem_imm(ctx, expr7_0);
    let expr13_0 = constructor_or(ctx, expr11_0, expr3_0, &expr12_0)?;
    let expr14_0 = constructor_value_gprs(ctx, expr10_0, expr13_0)?;
    return Some(expr14_0);
}

// Generated as internal constructor for term shl_i128.
pub fn constructor_shl_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Gpr,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 489.
    let expr0_0: usize = 0;
    let expr1_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr0_0)?;
    let expr2_0: usize = 1;
    let expr3_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr2_0)?;
    let expr4_0: Type = I64;
    let expr5_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr6_0 = constructor_shl(ctx, expr4_0, expr1_0, &expr5_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr9_0 = constructor_shl(ctx, expr7_0, expr3_0, &expr8_0)?;
    let expr10_0: Type = I64;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u64 = 64;
    let expr14_0 = constructor_imm(ctx, expr12_0, expr13_0)?;
    let expr15_0 = C::gpr_new(ctx, expr14_0);
    let expr16_0 = C::gpr_to_gpr_mem_imm(ctx, pattern1_0);
    let expr17_0 = constructor_sub(ctx, expr11_0, expr15_0, &expr16_0)?;
    let expr18_0 = C::gpr_to_imm8_gpr(ctx, expr17_0);
    let expr19_0 = constructor_shr(ctx, expr10_0, expr1_0, &expr18_0)?;
    let expr20_0: Type = I64;
    let expr21_0: u64 = 0;
    let expr22_0 = constructor_imm(ctx, expr20_0, expr21_0)?;
    let expr23_0 = C::gpr_new(ctx, expr22_0);
    let expr24_0 = OperandSize::Size64;
    let expr25_0: u32 = 127;
    let expr26_0 = RegMemImm::Imm { simm32: expr25_0 };
    let expr27_0 = C::gpr_mem_imm_new(ctx, &expr26_0);
    let expr28_0 = constructor_test(ctx, &expr24_0, &expr27_0, pattern1_0)?;
    let expr29_0: Type = I64;
    let expr30_0 = CC::Z;
    let expr31_0 = C::gpr_to_gpr_mem(ctx, expr23_0);
    let expr32_0 = constructor_cmove(ctx, expr29_0, &expr30_0, &expr31_0, expr19_0)?;
    let expr33_0 = constructor_with_flags_reg(ctx, &expr28_0, &expr32_0)?;
    let expr34_0 = C::gpr_new(ctx, expr33_0);
    let expr35_0: Type = I64;
    let expr36_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
    let expr37_0 = constructor_or(ctx, expr35_0, expr34_0, &expr36_0)?;
    let expr38_0 = OperandSize::Size64;
    let expr39_0: u32 = 64;
    let expr40_0 = RegMemImm::Imm { simm32: expr39_0 };
    let expr41_0 = C::gpr_mem_imm_new(ctx, &expr40_0);
    let expr42_0 = constructor_test(ctx, &expr38_0, &expr41_0, pattern1_0)?;
    let expr43_0: Type = I64;
    let expr44_0 = CC::Z;
    let expr45_0 = C::gpr_to_gpr_mem(ctx, expr6_0);
    let expr46_0 = constructor_cmove(ctx, expr43_0, &expr44_0, &expr45_0, expr23_0)?;
    let expr47_0: Type = I64;
    let expr48_0 = CC::Z;
    let expr49_0 = C::gpr_to_gpr_mem(ctx, expr37_0);
    let expr50_0 = constructor_cmove(ctx, expr47_0, &expr48_0, &expr49_0, expr6_0)?;
    let expr51_0 = constructor_consumes_flags_concat(ctx, &expr46_0, &expr50_0)?;
    let expr52_0 = constructor_with_flags(ctx, &expr42_0, &expr51_0)?;
    return Some(expr52_0);
}

// Generated as internal constructor for term ishl_i8x16_mask.
pub fn constructor_ishl_i8x16_mask<C: Context>(
    ctx: &mut C,
    arg0: &RegMemImm,
) -> Option<SyntheticAmode> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &RegMemImm::Imm { simm32: pattern1_0 } => {
            // Rule at src/isa/x64/lower.isle line 552.
            let expr0_0 = C::ishl_i8x16_mask_for_const(ctx, pattern1_0);
            return Some(expr0_0);
        }
        &RegMemImm::Reg { reg: pattern1_0 } => {
            // Rule at src/isa/x64/lower.isle line 561.
            let expr0_0 = C::ishl_i8x16_mask_table(ctx);
            let expr1_0 = constructor_lea(ctx, &expr0_0)?;
            let expr2_0: Type = I64;
            let expr3_0 = C::gpr_new(ctx, pattern1_0);
            let expr4_0: u8 = 4;
            let expr5_0 = C::imm8_to_imm8_gpr(ctx, expr4_0);
            let expr6_0 = constructor_shl(ctx, expr2_0, expr3_0, &expr5_0)?;
            let expr7_0: u32 = 0;
            let expr8_0: u8 = 0;
            let expr9_0 = C::amode_imm_reg_reg_shift(ctx, expr7_0, expr1_0, expr6_0, expr8_0);
            let expr10_0 = C::amode_to_synthetic_amode(ctx, &expr9_0);
            return Some(expr10_0);
        }
        &RegMemImm::Mem {
            addr: ref pattern1_0,
        } => {
            // Rule at src/isa/x64/lower.isle line 571.
            let expr0_0: Type = I64;
            let expr1_0 = ExtKind::None;
            let expr2_0 = constructor_x64_load(ctx, expr0_0, pattern1_0, &expr1_0)?;
            let expr3_0 = RegMemImm::Reg { reg: expr2_0 };
            let expr4_0 = constructor_ishl_i8x16_mask(ctx, &expr3_0)?;
            return Some(expr4_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term shr_i128.
pub fn constructor_shr_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Gpr,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 596.
    let expr0_0: usize = 0;
    let expr1_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr0_0)?;
    let expr2_0: usize = 1;
    let expr3_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr2_0)?;
    let expr4_0: Type = I64;
    let expr5_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr6_0 = constructor_shr(ctx, expr4_0, expr1_0, &expr5_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr9_0 = constructor_shr(ctx, expr7_0, expr3_0, &expr8_0)?;
    let expr10_0: Type = I64;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u64 = 64;
    let expr14_0 = constructor_imm(ctx, expr12_0, expr13_0)?;
    let expr15_0 = C::gpr_new(ctx, expr14_0);
    let expr16_0 = C::gpr_to_gpr_mem_imm(ctx, pattern1_0);
    let expr17_0 = constructor_sub(ctx, expr11_0, expr15_0, &expr16_0)?;
    let expr18_0 = C::gpr_to_imm8_gpr(ctx, expr17_0);
    let expr19_0 = constructor_shl(ctx, expr10_0, expr3_0, &expr18_0)?;
    let expr20_0 = OperandSize::Size64;
    let expr21_0: u32 = 127;
    let expr22_0 = RegMemImm::Imm { simm32: expr21_0 };
    let expr23_0 = C::gpr_mem_imm_new(ctx, &expr22_0);
    let expr24_0 = constructor_test(ctx, &expr20_0, &expr23_0, pattern1_0)?;
    let expr25_0: Type = I64;
    let expr26_0 = CC::Z;
    let expr27_0: Type = I64;
    let expr28_0: u64 = 0;
    let expr29_0 = constructor_imm(ctx, expr27_0, expr28_0)?;
    let expr30_0 = C::reg_to_gpr_mem(ctx, expr29_0);
    let expr31_0 = constructor_cmove(ctx, expr25_0, &expr26_0, &expr30_0, expr19_0)?;
    let expr32_0 = constructor_with_flags_reg(ctx, &expr24_0, &expr31_0)?;
    let expr33_0 = C::gpr_new(ctx, expr32_0);
    let expr34_0: Type = I64;
    let expr35_0 = C::gpr_to_gpr_mem_imm(ctx, expr6_0);
    let expr36_0 = constructor_or(ctx, expr34_0, expr33_0, &expr35_0)?;
    let expr37_0 = OperandSize::Size64;
    let expr38_0: u32 = 64;
    let expr39_0 = RegMemImm::Imm { simm32: expr38_0 };
    let expr40_0 = C::gpr_mem_imm_new(ctx, &expr39_0);
    let expr41_0 = constructor_test(ctx, &expr37_0, &expr40_0, pattern1_0)?;
    let expr42_0: Type = I64;
    let expr43_0 = CC::Z;
    let expr44_0 = C::gpr_to_gpr_mem(ctx, expr36_0);
    let expr45_0 = constructor_cmove(ctx, expr42_0, &expr43_0, &expr44_0, expr9_0)?;
    let expr46_0: Type = I64;
    let expr47_0 = CC::Z;
    let expr48_0 = C::gpr_to_gpr_mem(ctx, expr9_0);
    let expr49_0: Type = I64;
    let expr50_0: u64 = 0;
    let expr51_0 = constructor_imm(ctx, expr49_0, expr50_0)?;
    let expr52_0 = C::gpr_new(ctx, expr51_0);
    let expr53_0 = constructor_cmove(ctx, expr46_0, &expr47_0, &expr48_0, expr52_0)?;
    let expr54_0 = constructor_consumes_flags_concat(ctx, &expr45_0, &expr53_0)?;
    let expr55_0 = constructor_with_flags(ctx, &expr41_0, &expr54_0)?;
    return Some(expr55_0);
}

// Generated as internal constructor for term ushr_i8x16_mask.
pub fn constructor_ushr_i8x16_mask<C: Context>(
    ctx: &mut C,
    arg0: &RegMemImm,
) -> Option<SyntheticAmode> {
    let pattern0_0 = arg0;
    match pattern0_0 {
        &RegMemImm::Imm { simm32: pattern1_0 } => {
            // Rule at src/isa/x64/lower.isle line 653.
            let expr0_0 = C::ushr_i8x16_mask_for_const(ctx, pattern1_0);
            return Some(expr0_0);
        }
        &RegMemImm::Reg { reg: pattern1_0 } => {
            // Rule at src/isa/x64/lower.isle line 662.
            let expr0_0 = C::ushr_i8x16_mask_table(ctx);
            let expr1_0 = constructor_lea(ctx, &expr0_0)?;
            let expr2_0: Type = I64;
            let expr3_0 = C::gpr_new(ctx, pattern1_0);
            let expr4_0: u8 = 4;
            let expr5_0 = C::imm8_to_imm8_gpr(ctx, expr4_0);
            let expr6_0 = constructor_shl(ctx, expr2_0, expr3_0, &expr5_0)?;
            let expr7_0: u32 = 0;
            let expr8_0: u8 = 0;
            let expr9_0 = C::amode_imm_reg_reg_shift(ctx, expr7_0, expr1_0, expr6_0, expr8_0);
            let expr10_0 = C::amode_to_synthetic_amode(ctx, &expr9_0);
            return Some(expr10_0);
        }
        &RegMemImm::Mem {
            addr: ref pattern1_0,
        } => {
            // Rule at src/isa/x64/lower.isle line 673.
            let expr0_0: Type = I64;
            let expr1_0 = ExtKind::None;
            let expr2_0 = constructor_x64_load(ctx, expr0_0, pattern1_0, &expr1_0)?;
            let expr3_0 = RegMemImm::Reg { reg: expr2_0 };
            let expr4_0 = constructor_ushr_i8x16_mask(ctx, &expr3_0)?;
            return Some(expr4_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term sar_i128.
pub fn constructor_sar_i128<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: Gpr,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 698.
    let expr0_0: usize = 0;
    let expr1_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr0_0)?;
    let expr2_0: usize = 1;
    let expr3_0 = constructor_value_regs_get_gpr(ctx, pattern0_0, expr2_0)?;
    let expr4_0: Type = I64;
    let expr5_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr6_0 = constructor_shr(ctx, expr4_0, expr1_0, &expr5_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = C::gpr_to_imm8_gpr(ctx, pattern1_0);
    let expr9_0 = constructor_sar(ctx, expr7_0, expr3_0, &expr8_0)?;
    let expr10_0: Type = I64;
    let expr11_0: Type = I64;
    let expr12_0: Type = I64;
    let expr13_0: u64 = 64;
    let expr14_0 = constructor_imm(ctx, expr12_0, expr13_0)?;
    let expr15_0 = C::gpr_new(ctx, expr14_0);
    let expr16_0 = C::gpr_to_gpr_mem_imm(ctx, pattern1_0);
    let expr17_0 = constructor_sub(ctx, expr11_0, expr15_0, &expr16_0)?;
    let expr18_0 = C::gpr_to_imm8_gpr(ctx, expr17_0);
    let expr19_0 = constructor_shl(ctx, expr10_0, expr3_0, &expr18_0)?;
    let expr20_0 = OperandSize::Size64;
    let expr21_0: u32 = 127;
    let expr22_0 = RegMemImm::Imm { simm32: expr21_0 };
    let expr23_0 = C::gpr_mem_imm_new(ctx, &expr22_0);
    let expr24_0 = constructor_test(ctx, &expr20_0, &expr23_0, pattern1_0)?;
    let expr25_0: Type = I64;
    let expr26_0 = CC::Z;
    let expr27_0: Type = I64;
    let expr28_0: u64 = 0;
    let expr29_0 = constructor_imm(ctx, expr27_0, expr28_0)?;
    let expr30_0 = C::reg_to_gpr_mem(ctx, expr29_0);
    let expr31_0 = constructor_cmove(ctx, expr25_0, &expr26_0, &expr30_0, expr19_0)?;
    let expr32_0 = constructor_with_flags_reg(ctx, &expr24_0, &expr31_0)?;
    let expr33_0 = C::gpr_new(ctx, expr32_0);
    let expr34_0: Type = I64;
    let expr35_0 = C::gpr_to_gpr_mem_imm(ctx, expr33_0);
    let expr36_0 = constructor_or(ctx, expr34_0, expr6_0, &expr35_0)?;
    let expr37_0: Type = I64;
    let expr38_0: u8 = 63;
    let expr39_0 = C::imm8_to_imm8_gpr(ctx, expr38_0);
    let expr40_0 = constructor_sar(ctx, expr37_0, expr3_0, &expr39_0)?;
    let expr41_0 = OperandSize::Size64;
    let expr42_0: u32 = 64;
    let expr43_0 = RegMemImm::Imm { simm32: expr42_0 };
    let expr44_0 = C::gpr_mem_imm_new(ctx, &expr43_0);
    let expr45_0 = constructor_test(ctx, &expr41_0, &expr44_0, pattern1_0)?;
    let expr46_0: Type = I64;
    let expr47_0 = CC::Z;
    let expr48_0 = C::gpr_to_gpr_mem(ctx, expr36_0);
    let expr49_0 = constructor_cmove(ctx, expr46_0, &expr47_0, &expr48_0, expr9_0)?;
    let expr50_0: Type = I64;
    let expr51_0 = CC::Z;
    let expr52_0 = C::gpr_to_gpr_mem(ctx, expr9_0);
    let expr53_0 = constructor_cmove(ctx, expr50_0, &expr51_0, &expr52_0, expr40_0)?;
    let expr54_0 = constructor_consumes_flags_concat(ctx, &expr49_0, &expr53_0)?;
    let expr55_0 = constructor_with_flags(ctx, &expr45_0, &expr54_0)?;
    return Some(expr55_0);
}

// Generated as internal constructor for term sshr_i8x16_bigger_shift.
pub fn constructor_sshr_i8x16_bigger_shift<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &RegMemImm,
) -> Option<XmmMemImm> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    match pattern1_0 {
        &RegMemImm::Imm { simm32: pattern2_0 } => {
            // Rule at src/isa/x64/lower.isle line 762.
            let expr0_0: u32 = 8;
            let expr1_0 = C::u32_add(ctx, pattern2_0, expr0_0);
            let expr2_0 = RegMemImm::Imm { simm32: expr1_0 };
            let expr3_0 = C::xmm_mem_imm_new(ctx, &expr2_0);
            return Some(expr3_0);
        }
        &RegMemImm::Reg { reg: pattern2_0 } => {
            // Rule at src/isa/x64/lower.isle line 764.
            let expr0_0 = C::gpr_new(ctx, pattern2_0);
            let expr1_0: u32 = 8;
            let expr2_0 = RegMemImm::Imm { simm32: expr1_0 };
            let expr3_0 = C::gpr_mem_imm_new(ctx, &expr2_0);
            let expr4_0 = constructor_add(ctx, pattern0_0, expr0_0, &expr3_0)?;
            let expr5_0 = C::gpr_to_reg(ctx, expr4_0);
            let expr6_0 = RegMemImm::Reg { reg: expr5_0 };
            let expr7_0 = constructor_mov_rmi_to_xmm(ctx, &expr6_0)?;
            return Some(expr7_0);
        }
        &RegMemImm::Mem {
            addr: ref pattern2_0,
        } => {
            // Rule at src/isa/x64/lower.isle line 768.
            let expr0_0: u64 = 8;
            let expr1_0 = constructor_imm(ctx, pattern0_0, expr0_0)?;
            let expr2_0 = C::gpr_new(ctx, expr1_0);
            let expr3_0 = C::gpr_mem_imm_new(ctx, pattern1_0);
            let expr4_0 = constructor_add(ctx, pattern0_0, expr2_0, &expr3_0)?;
            let expr5_0 = C::gpr_to_reg(ctx, expr4_0);
            let expr6_0 = RegMemImm::Reg { reg: expr5_0 };
            let expr7_0 = constructor_mov_rmi_to_xmm(ctx, &expr6_0)?;
            return Some(expr7_0);
        }
        _ => {}
    }
    return None;
}

// Generated as internal constructor for term sse_and_not.
pub fn constructor_sse_and_not<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 1194.
        let expr0_0 = constructor_andnps(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 1195.
        let expr0_0 = constructor_andnpd(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    if let Some((pattern1_0, pattern1_1)) = C::multi_lane(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        // Rule at src/isa/x64/lower.isle line 1196.
        let expr0_0 = constructor_pandn(ctx, pattern2_0, pattern3_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term i128_not.
pub fn constructor_i128_not<C: Context>(ctx: &mut C, arg0: Value) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/lower.isle line 1259.
    let expr0_0 = C::put_in_regs(ctx, pattern0_0);
    let expr1_0: usize = 0;
    let expr2_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr1_0)?;
    let expr3_0: usize = 1;
    let expr4_0 = constructor_value_regs_get_gpr(ctx, expr0_0, expr3_0)?;
    let expr5_0: Type = I64;
    let expr6_0 = constructor_not(ctx, expr5_0, expr2_0)?;
    let expr7_0: Type = I64;
    let expr8_0 = constructor_not(ctx, expr7_0, expr4_0)?;
    let expr9_0 = constructor_value_gprs(ctx, expr6_0, expr8_0)?;
    return Some(expr9_0);
}

// Generated as internal constructor for term vec_insert_lane.
pub fn constructor_vec_insert_lane<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &RegMem,
    arg3: u8,
) -> Option<Xmm> {
    let pattern0_0 = arg0;
    if pattern0_0 == I8X16 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1313.
        let expr0_0 = C::reg_mem_to_gpr_mem(ctx, pattern3_0);
        let expr1_0 = constructor_pinsrb(ctx, pattern2_0, &expr0_0, pattern4_0)?;
        return Some(expr1_0);
    }
    if pattern0_0 == I16X8 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1317.
        let expr0_0 = C::reg_mem_to_gpr_mem(ctx, pattern3_0);
        let expr1_0 = constructor_pinsrw(ctx, pattern2_0, &expr0_0, pattern4_0)?;
        return Some(expr1_0);
    }
    if pattern0_0 == I32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1321.
        let expr0_0 = C::reg_mem_to_gpr_mem(ctx, pattern3_0);
        let expr1_0 = OperandSize::Size32;
        let expr2_0 = constructor_pinsrd(ctx, pattern2_0, &expr0_0, pattern4_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == I64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1325.
        let expr0_0 = C::reg_mem_to_gpr_mem(ctx, pattern3_0);
        let expr1_0 = OperandSize::Size64;
        let expr2_0 = constructor_pinsrd(ctx, pattern2_0, &expr0_0, pattern4_0, &expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == F32X4 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1329.
        let expr0_0 = C::reg_mem_to_xmm_mem(ctx, pattern3_0);
        let expr1_0 = C::sse_insertps_lane_imm(ctx, pattern4_0);
        let expr2_0 = constructor_insertps(ctx, pattern2_0, &expr0_0, expr1_0)?;
        return Some(expr2_0);
    }
    if pattern0_0 == F64X2 {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        if let &RegMem::Reg { reg: pattern4_0 } = pattern3_0 {
            let pattern5_0 = arg3;
            if pattern5_0 == 0 {
                // Rule at src/isa/x64/lower.isle line 1351.
                let expr0_0 = constructor_reg_to_xmm_mem(ctx, pattern4_0)?;
                let expr1_0 = constructor_movsd(ctx, pattern2_0, &expr0_0)?;
                return Some(expr1_0);
            }
        }
        let pattern4_0 = arg3;
        if pattern4_0 == 0 {
            // Rule at src/isa/x64/lower.isle line 1353.
            let expr0_0 = SseOpcode::Movsd;
            let expr1_0 = C::reg_mem_to_xmm_mem(ctx, pattern3_0);
            let expr2_0 = constructor_xmm_unary_rm_r(ctx, &expr0_0, &expr1_0)?;
            let expr3_0 = C::xmm_to_xmm_mem(ctx, expr2_0);
            let expr4_0 = constructor_movsd(ctx, pattern2_0, &expr3_0)?;
            return Some(expr4_0);
        }
        if pattern4_0 == 1 {
            // Rule at src/isa/x64/lower.isle line 1362.
            let expr0_0 = C::reg_mem_to_xmm_mem(ctx, pattern3_0);
            let expr1_0 = constructor_movlhps(ctx, pattern2_0, &expr0_0)?;
            return Some(expr1_0);
        }
    }
    return None;
}

// Generated as internal constructor for term cmp_and_choose.
pub fn constructor_cmp_and_choose<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Value,
    arg3: Value,
) -> Option<ValueRegs> {
    let pattern0_0 = arg0;
    if let Some(pattern1_0) = C::fits_in_64(ctx, pattern0_0) {
        let pattern2_0 = arg1;
        let pattern3_0 = arg2;
        let pattern4_0 = arg3;
        // Rule at src/isa/x64/lower.isle line 1370.
        let expr0_0 = constructor_put_in_gpr(ctx, pattern3_0)?;
        let expr1_0 = constructor_put_in_gpr(ctx, pattern4_0)?;
        let expr2_0 = C::raw_operand_size_of_type(ctx, pattern1_0);
        let expr3_0 = C::gpr_to_gpr_mem_imm(ctx, expr0_0);
        let expr4_0 = constructor_cmp(ctx, &expr2_0, &expr3_0, expr1_0)?;
        let expr5_0 = C::gpr_to_gpr_mem(ctx, expr1_0);
        let expr6_0 = constructor_cmove(ctx, pattern1_0, pattern2_0, &expr5_0, expr0_0)?;
        let expr7_0 = constructor_with_flags_reg(ctx, &expr4_0, &expr6_0)?;
        let expr8_0 = C::value_reg(ctx, expr7_0);
        return Some(expr8_0);
    }
    return None;
}

// Generated as internal constructor for term do_clz.
pub fn constructor_do_clz<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/lower.isle line 1568.
    let expr0_0: Type = I64;
    let expr1_0: i64 = -1;
    let expr2_0 = constructor_imm_i64(ctx, expr0_0, expr1_0)?;
    let expr3_0 = C::gpr_new(ctx, expr2_0);
    let expr4_0 = constructor_bsr_or_else(ctx, pattern0_0, pattern2_0, expr3_0)?;
    let expr5_0 = C::gpr_to_reg(ctx, expr4_0);
    let expr6_0 = C::ty_bits_u64(ctx, pattern1_0);
    let expr7_0: u64 = 1;
    let expr8_0 = C::u64_sub(ctx, expr6_0, expr7_0);
    let expr9_0 = constructor_imm(ctx, pattern0_0, expr8_0)?;
    let expr10_0 = C::gpr_new(ctx, expr9_0);
    let expr11_0 = constructor_reg_to_gpr_mem_imm(ctx, expr5_0)?;
    let expr12_0 = constructor_sub(ctx, pattern0_0, expr10_0, &expr11_0)?;
    return Some(expr12_0);
}

// Generated as internal constructor for term do_ctz.
pub fn constructor_do_ctz<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Type,
    arg2: Gpr,
) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    let pattern2_0 = arg2;
    // Rule at src/isa/x64/lower.isle line 1609.
    let expr0_0: Type = I64;
    let expr1_0 = C::ty_bits_u64(ctx, pattern1_0);
    let expr2_0 = constructor_imm(ctx, expr0_0, expr1_0)?;
    let expr3_0 = C::gpr_new(ctx, expr2_0);
    let expr4_0 = constructor_bsf_or_else(ctx, pattern0_0, pattern2_0, expr3_0)?;
    return Some(expr4_0);
}

// Generated as internal constructor for term do_popcnt.
pub fn constructor_do_popcnt<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    if pattern0_0 == I32 {
        let pattern2_0 = arg1;
        // Rule at src/isa/x64/lower.isle line 1700.
        let expr0_0: Type = I32;
        let expr1_0: u8 = 1;
        let expr2_0 = Imm8Reg::Imm8 { imm: expr1_0 };
        let expr3_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr2_0);
        let expr4_0 = constructor_shr(ctx, expr0_0, pattern2_0, &expr3_0)?;
        let expr5_0: Type = I32;
        let expr6_0: u64 = 2004318071;
        let expr7_0 = constructor_imm(ctx, expr5_0, expr6_0)?;
        let expr8_0 = C::gpr_new(ctx, expr7_0);
        let expr9_0: Type = I32;
        let expr10_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr11_0 = constructor_x64_and(ctx, expr9_0, expr4_0, &expr10_0)?;
        let expr12_0: Type = I32;
        let expr13_0 = C::gpr_to_gpr_mem_imm(ctx, expr11_0);
        let expr14_0 = constructor_sub(ctx, expr12_0, pattern2_0, &expr13_0)?;
        let expr15_0: Type = I32;
        let expr16_0: u8 = 1;
        let expr17_0 = Imm8Reg::Imm8 { imm: expr16_0 };
        let expr18_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr17_0);
        let expr19_0 = constructor_shr(ctx, expr15_0, expr11_0, &expr18_0)?;
        let expr20_0: Type = I32;
        let expr21_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr22_0 = constructor_x64_and(ctx, expr20_0, expr19_0, &expr21_0)?;
        let expr23_0: Type = I32;
        let expr24_0 = C::gpr_to_gpr_mem_imm(ctx, expr22_0);
        let expr25_0 = constructor_sub(ctx, expr23_0, expr14_0, &expr24_0)?;
        let expr26_0: Type = I32;
        let expr27_0: u8 = 1;
        let expr28_0 = Imm8Reg::Imm8 { imm: expr27_0 };
        let expr29_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr28_0);
        let expr30_0 = constructor_shr(ctx, expr26_0, expr22_0, &expr29_0)?;
        let expr31_0: Type = I32;
        let expr32_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr33_0 = constructor_x64_and(ctx, expr31_0, expr30_0, &expr32_0)?;
        let expr34_0: Type = I32;
        let expr35_0 = C::gpr_to_gpr_mem_imm(ctx, expr33_0);
        let expr36_0 = constructor_sub(ctx, expr34_0, expr25_0, &expr35_0)?;
        let expr37_0: Type = I32;
        let expr38_0: Type = I32;
        let expr39_0: u8 = 4;
        let expr40_0 = Imm8Reg::Imm8 { imm: expr39_0 };
        let expr41_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr40_0);
        let expr42_0 = constructor_shr(ctx, expr38_0, expr36_0, &expr41_0)?;
        let expr43_0 = C::gpr_to_gpr_mem_imm(ctx, expr36_0);
        let expr44_0 = constructor_add(ctx, expr37_0, expr42_0, &expr43_0)?;
        let expr45_0: Type = I32;
        let expr46_0: u32 = 252645135;
        let expr47_0 = RegMemImm::Imm { simm32: expr46_0 };
        let expr48_0 = C::gpr_mem_imm_new(ctx, &expr47_0);
        let expr49_0 = constructor_x64_and(ctx, expr45_0, expr44_0, &expr48_0)?;
        let expr50_0: Type = I32;
        let expr51_0: u32 = 16843009;
        let expr52_0 = RegMemImm::Imm { simm32: expr51_0 };
        let expr53_0 = C::gpr_mem_imm_new(ctx, &expr52_0);
        let expr54_0 = constructor_mul(ctx, expr50_0, expr49_0, &expr53_0)?;
        let expr55_0: Type = I32;
        let expr56_0: u8 = 24;
        let expr57_0 = Imm8Reg::Imm8 { imm: expr56_0 };
        let expr58_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr57_0);
        let expr59_0 = constructor_shr(ctx, expr55_0, expr54_0, &expr58_0)?;
        return Some(expr59_0);
    }
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/x64/lower.isle line 1657.
        let expr0_0: Type = I64;
        let expr1_0: u8 = 1;
        let expr2_0 = Imm8Reg::Imm8 { imm: expr1_0 };
        let expr3_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr2_0);
        let expr4_0 = constructor_shr(ctx, expr0_0, pattern2_0, &expr3_0)?;
        let expr5_0: Type = I64;
        let expr6_0: u64 = 8608480567731124087;
        let expr7_0 = constructor_imm(ctx, expr5_0, expr6_0)?;
        let expr8_0 = C::gpr_new(ctx, expr7_0);
        let expr9_0: Type = I64;
        let expr10_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr11_0 = constructor_x64_and(ctx, expr9_0, expr4_0, &expr10_0)?;
        let expr12_0: Type = I64;
        let expr13_0 = C::gpr_to_gpr_mem_imm(ctx, expr11_0);
        let expr14_0 = constructor_sub(ctx, expr12_0, pattern2_0, &expr13_0)?;
        let expr15_0: Type = I64;
        let expr16_0: u8 = 1;
        let expr17_0 = Imm8Reg::Imm8 { imm: expr16_0 };
        let expr18_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr17_0);
        let expr19_0 = constructor_shr(ctx, expr15_0, expr11_0, &expr18_0)?;
        let expr20_0: Type = I64;
        let expr21_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr22_0 = constructor_x64_and(ctx, expr20_0, expr19_0, &expr21_0)?;
        let expr23_0: Type = I64;
        let expr24_0 = C::gpr_to_gpr_mem_imm(ctx, expr22_0);
        let expr25_0 = constructor_sub(ctx, expr23_0, expr14_0, &expr24_0)?;
        let expr26_0: Type = I64;
        let expr27_0: u8 = 1;
        let expr28_0 = Imm8Reg::Imm8 { imm: expr27_0 };
        let expr29_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr28_0);
        let expr30_0 = constructor_shr(ctx, expr26_0, expr22_0, &expr29_0)?;
        let expr31_0: Type = I64;
        let expr32_0 = C::gpr_to_gpr_mem_imm(ctx, expr8_0);
        let expr33_0 = constructor_x64_and(ctx, expr31_0, expr30_0, &expr32_0)?;
        let expr34_0: Type = I64;
        let expr35_0 = C::gpr_to_gpr_mem_imm(ctx, expr33_0);
        let expr36_0 = constructor_sub(ctx, expr34_0, expr25_0, &expr35_0)?;
        let expr37_0: Type = I64;
        let expr38_0: Type = I64;
        let expr39_0: u8 = 4;
        let expr40_0 = Imm8Reg::Imm8 { imm: expr39_0 };
        let expr41_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr40_0);
        let expr42_0 = constructor_shr(ctx, expr38_0, expr36_0, &expr41_0)?;
        let expr43_0 = C::gpr_to_gpr_mem_imm(ctx, expr36_0);
        let expr44_0 = constructor_add(ctx, expr37_0, expr42_0, &expr43_0)?;
        let expr45_0: Type = I64;
        let expr46_0: u64 = 1085102592571150095;
        let expr47_0 = constructor_imm(ctx, expr45_0, expr46_0)?;
        let expr48_0 = C::gpr_new(ctx, expr47_0);
        let expr49_0: Type = I64;
        let expr50_0 = C::gpr_to_gpr_mem_imm(ctx, expr48_0);
        let expr51_0 = constructor_x64_and(ctx, expr49_0, expr44_0, &expr50_0)?;
        let expr52_0: Type = I64;
        let expr53_0: u64 = 72340172838076673;
        let expr54_0 = constructor_imm(ctx, expr52_0, expr53_0)?;
        let expr55_0 = C::gpr_new(ctx, expr54_0);
        let expr56_0: Type = I64;
        let expr57_0 = C::gpr_to_gpr_mem_imm(ctx, expr55_0);
        let expr58_0 = constructor_mul(ctx, expr56_0, expr51_0, &expr57_0)?;
        let expr59_0: Type = I64;
        let expr60_0: u8 = 56;
        let expr61_0 = Imm8Reg::Imm8 { imm: expr60_0 };
        let expr62_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr61_0);
        let expr63_0 = constructor_shr(ctx, expr59_0, expr58_0, &expr62_0)?;
        return Some(expr63_0);
    }
    return None;
}

// Generated as internal constructor for term do_bitrev8.
pub fn constructor_do_bitrev8<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 1789.
    let expr0_0 = C::ty_mask(ctx, pattern0_0);
    let expr1_0: u64 = 6148914691236517205;
    let expr2_0 = C::u64_and(ctx, expr0_0, expr1_0);
    let expr3_0 = constructor_imm(ctx, pattern0_0, expr2_0)?;
    let expr4_0 = C::gpr_new(ctx, expr3_0);
    let expr5_0 = C::gpr_to_gpr_mem_imm(ctx, expr4_0);
    let expr6_0 = constructor_x64_and(ctx, pattern0_0, pattern1_0, &expr5_0)?;
    let expr7_0: u8 = 1;
    let expr8_0 = Imm8Reg::Imm8 { imm: expr7_0 };
    let expr9_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr8_0);
    let expr10_0 = constructor_shr(ctx, pattern0_0, pattern1_0, &expr9_0)?;
    let expr11_0 = C::gpr_to_gpr_mem_imm(ctx, expr4_0);
    let expr12_0 = constructor_x64_and(ctx, pattern0_0, expr10_0, &expr11_0)?;
    let expr13_0: u8 = 1;
    let expr14_0 = Imm8Reg::Imm8 { imm: expr13_0 };
    let expr15_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr14_0);
    let expr16_0 = constructor_shl(ctx, pattern0_0, expr6_0, &expr15_0)?;
    let expr17_0 = C::gpr_to_gpr_mem_imm(ctx, expr12_0);
    let expr18_0 = constructor_or(ctx, pattern0_0, expr16_0, &expr17_0)?;
    let expr19_0: u64 = 3689348814741910323;
    let expr20_0 = C::u64_and(ctx, expr0_0, expr19_0);
    let expr21_0 = constructor_imm(ctx, pattern0_0, expr20_0)?;
    let expr22_0 = C::gpr_new(ctx, expr21_0);
    let expr23_0 = C::gpr_to_gpr_mem_imm(ctx, expr22_0);
    let expr24_0 = constructor_x64_and(ctx, pattern0_0, expr18_0, &expr23_0)?;
    let expr25_0: u8 = 2;
    let expr26_0 = Imm8Reg::Imm8 { imm: expr25_0 };
    let expr27_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr26_0);
    let expr28_0 = constructor_shr(ctx, pattern0_0, expr18_0, &expr27_0)?;
    let expr29_0 = C::gpr_to_gpr_mem_imm(ctx, expr22_0);
    let expr30_0 = constructor_x64_and(ctx, pattern0_0, expr28_0, &expr29_0)?;
    let expr31_0: u8 = 2;
    let expr32_0 = Imm8Reg::Imm8 { imm: expr31_0 };
    let expr33_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr32_0);
    let expr34_0 = constructor_shl(ctx, pattern0_0, expr24_0, &expr33_0)?;
    let expr35_0 = C::gpr_to_gpr_mem_imm(ctx, expr30_0);
    let expr36_0 = constructor_or(ctx, pattern0_0, expr34_0, &expr35_0)?;
    let expr37_0: u64 = 1085102592571150095;
    let expr38_0 = C::u64_and(ctx, expr0_0, expr37_0);
    let expr39_0 = constructor_imm(ctx, pattern0_0, expr38_0)?;
    let expr40_0 = C::gpr_new(ctx, expr39_0);
    let expr41_0 = C::gpr_to_gpr_mem_imm(ctx, expr40_0);
    let expr42_0 = constructor_x64_and(ctx, pattern0_0, expr36_0, &expr41_0)?;
    let expr43_0: u8 = 4;
    let expr44_0 = Imm8Reg::Imm8 { imm: expr43_0 };
    let expr45_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr44_0);
    let expr46_0 = constructor_shr(ctx, pattern0_0, expr36_0, &expr45_0)?;
    let expr47_0 = C::gpr_to_gpr_mem_imm(ctx, expr40_0);
    let expr48_0 = constructor_x64_and(ctx, pattern0_0, expr46_0, &expr47_0)?;
    let expr49_0: u8 = 4;
    let expr50_0 = Imm8Reg::Imm8 { imm: expr49_0 };
    let expr51_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr50_0);
    let expr52_0 = constructor_shl(ctx, pattern0_0, expr42_0, &expr51_0)?;
    let expr53_0 = C::gpr_to_gpr_mem_imm(ctx, expr48_0);
    let expr54_0 = constructor_or(ctx, pattern0_0, expr52_0, &expr53_0)?;
    return Some(expr54_0);
}

// Generated as internal constructor for term do_bitrev16.
pub fn constructor_do_bitrev16<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 1812.
    let expr0_0 = constructor_do_bitrev8(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = C::ty_mask(ctx, pattern0_0);
    let expr2_0: u64 = 71777214294589695;
    let expr3_0 = C::u64_and(ctx, expr1_0, expr2_0);
    let expr4_0 = constructor_imm(ctx, pattern0_0, expr3_0)?;
    let expr5_0 = C::gpr_new(ctx, expr4_0);
    let expr6_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
    let expr7_0 = constructor_x64_and(ctx, pattern0_0, expr0_0, &expr6_0)?;
    let expr8_0: u8 = 8;
    let expr9_0 = Imm8Reg::Imm8 { imm: expr8_0 };
    let expr10_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr9_0);
    let expr11_0 = constructor_shr(ctx, pattern0_0, expr0_0, &expr10_0)?;
    let expr12_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
    let expr13_0 = constructor_x64_and(ctx, pattern0_0, expr11_0, &expr12_0)?;
    let expr14_0: u8 = 8;
    let expr15_0 = Imm8Reg::Imm8 { imm: expr14_0 };
    let expr16_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr15_0);
    let expr17_0 = constructor_shl(ctx, pattern0_0, expr7_0, &expr16_0)?;
    let expr18_0 = C::gpr_to_gpr_mem_imm(ctx, expr13_0);
    let expr19_0 = constructor_or(ctx, pattern0_0, expr17_0, &expr18_0)?;
    return Some(expr19_0);
}

// Generated as internal constructor for term do_bitrev32.
pub fn constructor_do_bitrev32<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    // Rule at src/isa/x64/lower.isle line 1824.
    let expr0_0 = constructor_do_bitrev16(ctx, pattern0_0, pattern1_0)?;
    let expr1_0 = C::ty_mask(ctx, pattern0_0);
    let expr2_0: u64 = 281470681808895;
    let expr3_0 = C::u64_and(ctx, expr1_0, expr2_0);
    let expr4_0 = constructor_imm(ctx, pattern0_0, expr3_0)?;
    let expr5_0 = C::gpr_new(ctx, expr4_0);
    let expr6_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
    let expr7_0 = constructor_x64_and(ctx, pattern0_0, expr0_0, &expr6_0)?;
    let expr8_0: u8 = 16;
    let expr9_0 = Imm8Reg::Imm8 { imm: expr8_0 };
    let expr10_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr9_0);
    let expr11_0 = constructor_shr(ctx, pattern0_0, expr0_0, &expr10_0)?;
    let expr12_0 = C::gpr_to_gpr_mem_imm(ctx, expr5_0);
    let expr13_0 = constructor_x64_and(ctx, pattern0_0, expr11_0, &expr12_0)?;
    let expr14_0: u8 = 16;
    let expr15_0 = Imm8Reg::Imm8 { imm: expr14_0 };
    let expr16_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr15_0);
    let expr17_0 = constructor_shl(ctx, pattern0_0, expr7_0, &expr16_0)?;
    let expr18_0 = C::gpr_to_gpr_mem_imm(ctx, expr13_0);
    let expr19_0 = constructor_or(ctx, pattern0_0, expr17_0, &expr18_0)?;
    return Some(expr19_0);
}

// Generated as internal constructor for term do_bitrev64.
pub fn constructor_do_bitrev64<C: Context>(ctx: &mut C, arg0: Type, arg1: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    if pattern0_0 == I64 {
        let pattern2_0 = arg1;
        // Rule at src/isa/x64/lower.isle line 1836.
        let expr0_0 = constructor_do_bitrev32(ctx, pattern0_0, pattern2_0)?;
        let expr1_0: u64 = 4294967295;
        let expr2_0 = constructor_imm(ctx, pattern0_0, expr1_0)?;
        let expr3_0 = C::gpr_new(ctx, expr2_0);
        let expr4_0 = C::gpr_to_gpr_mem_imm(ctx, expr3_0);
        let expr5_0 = constructor_x64_and(ctx, pattern0_0, expr0_0, &expr4_0)?;
        let expr6_0: u8 = 32;
        let expr7_0 = Imm8Reg::Imm8 { imm: expr6_0 };
        let expr8_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr7_0);
        let expr9_0 = constructor_shr(ctx, pattern0_0, expr0_0, &expr8_0)?;
        let expr10_0: u8 = 32;
        let expr11_0 = Imm8Reg::Imm8 { imm: expr10_0 };
        let expr12_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr11_0);
        let expr13_0 = constructor_shl(ctx, pattern0_0, expr5_0, &expr12_0)?;
        let expr14_0 = C::gpr_to_gpr_mem_imm(ctx, expr9_0);
        let expr15_0 = constructor_or(ctx, pattern0_0, expr13_0, &expr14_0)?;
        return Some(expr15_0);
    }
    return None;
}

// Generated as internal constructor for term generic_sextend.
pub fn constructor_generic_sextend<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
    arg2: Type,
) -> Option<InstOutput> {
    let pattern0_0 = arg0;
    let pattern1_0 = arg1;
    if let Some(pattern2_0) = C::fits_in_32(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::fits_in_32(ctx, pattern3_0) {
            // Rule at src/isa/x64/lower.isle line 1956.
            let expr0_0: Type = I32;
            let expr1_0 = ExtendKind::Sign;
            let expr2_0 = constructor_extend_to_gpr(ctx, pattern0_0, expr0_0, &expr1_0)?;
            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
            return Some(expr3_0);
        }
        if let Some(pattern4_0) = C::ty_int_bool_64(ctx, pattern3_0) {
            // Rule at src/isa/x64/lower.isle line 1952.
            let expr0_0: Type = I64;
            let expr1_0 = ExtendKind::Sign;
            let expr2_0 = constructor_extend_to_gpr(ctx, pattern0_0, expr0_0, &expr1_0)?;
            let expr3_0 = constructor_output_gpr(ctx, expr2_0)?;
            return Some(expr3_0);
        }
        if let Some(pattern4_0) = C::ty_int_bool_128(ctx, pattern3_0) {
            // Rule at src/isa/x64/lower.isle line 1946.
            let expr0_0: Type = I64;
            let expr1_0 = ExtendKind::Sign;
            let expr2_0 = constructor_extend_to_gpr(ctx, pattern0_0, expr0_0, &expr1_0)?;
            let expr3_0 = constructor_spread_sign_bit(ctx, expr2_0)?;
            let expr4_0 = C::gpr_to_reg(ctx, expr2_0);
            let expr5_0 = C::gpr_to_reg(ctx, expr3_0);
            let expr6_0 = C::value_regs(ctx, expr4_0, expr5_0);
            let expr7_0 = C::output(ctx, expr6_0);
            return Some(expr7_0);
        }
    }
    if let Some(pattern2_0) = C::ty_int_bool_64(ctx, pattern1_0) {
        let pattern3_0 = arg2;
        if let Some(pattern4_0) = C::ty_int_bool_128(ctx, pattern3_0) {
            // Rule at src/isa/x64/lower.isle line 1942.
            let expr0_0 = C::put_in_reg(ctx, pattern0_0);
            let expr1_0 = constructor_put_in_gpr(ctx, pattern0_0)?;
            let expr2_0 = constructor_spread_sign_bit(ctx, expr1_0)?;
            let expr3_0 = C::gpr_to_reg(ctx, expr2_0);
            let expr4_0 = C::value_regs(ctx, expr0_0, expr3_0);
            let expr5_0 = C::output(ctx, expr4_0);
            return Some(expr5_0);
        }
    }
    let pattern2_0 = arg2;
    if pattern2_0 == pattern1_0 {
        // Rule at src/isa/x64/lower.isle line 1932.
        let expr0_0 = constructor_output_value(ctx, pattern0_0)?;
        return Some(expr0_0);
    }
    return None;
}

// Generated as internal constructor for term spread_sign_bit.
pub fn constructor_spread_sign_bit<C: Context>(ctx: &mut C, arg0: Gpr) -> Option<Gpr> {
    let pattern0_0 = arg0;
    // Rule at src/isa/x64/lower.isle line 1938.
    let expr0_0: Type = I64;
    let expr1_0: u8 = 63;
    let expr2_0 = Imm8Reg::Imm8 { imm: expr1_0 };
    let expr3_0 = C::imm8_reg_to_imm8_gpr(ctx, &expr2_0);
    let expr4_0 = constructor_sar(ctx, expr0_0, pattern0_0, &expr3_0)?;
    return Some(expr4_0);
}
