structure filter=
   struct
    type int = Int.int
    structure UserDeclarations =
      struct
(* this is an -*- sml -*- file, or near enough *)
fun inc r = (r := !r + 1)
fun dec r = (r := !r - 1)

fun bslash_escape s = "\\" ^ Int.toString (Char.ord(String.sub(s,0)))

datatype qfs = QFS of {output_stream : TextIO.outstream,
                       comdepth : int ref,
                       pardepth : int ref,
                       antiquote: bool ref,
                       row      : int ref,
                       rowstart : int ref}

fun ECHO (QFS {output_stream , ...}) s = TextIO.output(output_stream, s)
fun print (QFS {output_stream, ...}) s = TextIO.output(output_stream, s)

fun makesafe c =
    if not (Char.isPrint c) then "\\" ^ Int.toString (Char.ord c)
    else str c

fun safeprint x s = print x (String.translate makesafe s)

fun drop_upto c s = let
  (* returns the substring of s that begins at the first occurrence of c *)
  open Substring
  val ss = full s
  val remainder = dropl (fn c' => c <> c') ss
in
  string remainder
end

(* generate location pragmas inside fragments (not antiquoted ones), for the lex
er *)
(*
val row = ref 0
val rowstart = ref 0
*)
fun nextline (QFS {row, rowstart, ...}) pos = (inc row; rowstart := pos)
fun locpragma (QFS {row, rowstart, ...}) (s,pos) off
  = " (*#loc "^Int.toString((!row) + 1)^" "^
    Int.toString(pos + size s - (!rowstart) - off + 1)^"*)"
    (* NB: the initial space is critical, or else the comment might not be recog
nised
       when prepended by a paren or symbol char.  --KW
       See cvs log comment at rev 1.2 of src/parse/base_tokens.lex *)
fun flushOut (QFS {output_stream,...}) = TextIO.flushOut output_stream

fun newline (arg as QFS q) (yypos,yytext) =
  (print arg "\n";
   flushOut arg;
   nextline arg (yypos + size yytext));

fun qnewline arg (yypos,yytext) =
    (nextline arg (yypos + size yytext);
     print arg "\\n\\\n\\" ;
     flushOut arg)

fun dolocpragma (arg as QFS {output_stream, row, rowstart, ...}) (s,pos)
  = let val ss = Substring.full s
        val sr = Substring.dropl (not o Char.isDigit) ss
        val sc = Substring.dropl (Char.isDigit) sr
    in
      ECHO arg s;
      row := valOf (Int.fromString(Substring.string sr)) - 1;
      rowstart := pos + size s - (valOf (Int.fromString(Substring.string sc)) - 1)
    end

type lexresult = (string * int)

fun eof arg = ("", 0)
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [
 (0,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (1,
"\021\021\021\021\021\021\021\021\021\021\051\021\021\021\021\050\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\049\021\021\021\021\021\034\033\032\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\023\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021"
),
 (3,
"\053\053\053\053\053\053\053\053\053\053\075\053\053\053\053\074\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\073\053\053\053\053\053\058\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\055\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\053\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052"
),
 (5,
"\077\077\077\077\077\077\077\077\077\076\084\077\077\077\077\083\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\076\077\077\077\077\077\081\076\079\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\076\077\076\077\
\\076\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\
\\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076\076"
),
 (7,
"\077\077\077\077\077\077\077\077\077\095\094\077\077\077\077\093\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\092\077\077\077\077\077\081\076\090\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\089\077\087\077\
\\086\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085"
),
 (9,
"\077\077\077\077\077\077\077\077\077\095\094\077\077\077\077\093\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\092\077\077\077\077\077\081\076\098\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\089\077\087\077\
\\096\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085"
),
 (11,
"\077\077\077\077\077\077\077\077\077\095\094\077\077\077\077\093\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\092\077\077\077\077\077\081\076\100\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\089\077\087\077\
\\096\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\077\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\
\\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085\085"
),
 (13,
"\103\103\103\103\103\103\103\103\103\115\119\103\103\103\103\118\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\116\103\115\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\107\103\
\\105\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102"
),
 (15,
"\103\103\103\103\103\103\103\103\103\115\119\103\103\103\103\118\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\121\103\115\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\120\103\
\\105\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102"
),
 (17,
"\103\103\103\103\103\103\103\103\103\115\119\103\103\103\103\118\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\125\103\115\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\124\103\
\\123\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\103\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\
\\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102\102"
),
 (19,
"\127\127\127\127\127\127\127\127\127\134\137\127\127\127\127\136\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\134\128\127\128\128\128\128\127\132\127\128\128\127\128\127\128\
\\127\127\127\127\127\127\127\127\127\127\128\127\128\128\128\128\
\\128\130\130\130\130\130\130\130\130\130\130\130\130\130\130\130\
\\130\130\130\130\130\130\130\130\130\130\130\127\128\127\128\127\
\\127\130\130\130\130\130\130\130\130\130\130\130\130\130\130\130\
\\130\130\130\130\130\130\130\130\130\130\130\127\128\127\128\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\
\\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127\127"
),
 (21,
"\022\022\022\022\022\022\022\022\022\022\000\022\022\022\022\000\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\000\022\022\022\022\022\000\000\000\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022"
),
 (23,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\024\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (24,
"\000\000\000\000\000\000\000\000\000\031\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\025\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (25,
"\000\000\000\000\000\000\000\000\000\027\027\000\000\000\000\030\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\027\000\000\000\000\000\000\027\027\000\000\000\000\000\000\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\029\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\027\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\028\026\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (26,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\027\027\027\027\027\027\027\027\027\027\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (28,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\027\027\027\027\027\027\027\027\027\027\027\027\027\027\027\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (30,
"\000\000\000\000\000\000\000\000\000\000\027\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (34,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\035\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (35,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\036\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (36,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\037\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (37,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\038\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (38,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\039\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (39,
"\000\000\000\000\000\000\000\000\000\040\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (40,
"\000\000\000\000\000\000\000\000\000\047\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\047\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (41,
"\000\000\000\000\000\000\000\000\000\042\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\042\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\041\041\041\041\041\041\041\041\041\041\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (42,
"\000\000\000\000\000\000\000\000\000\042\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\042\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (43,
"\000\000\000\000\000\000\000\000\000\046\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\046\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (44,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\045\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (46,
"\000\000\000\000\000\000\000\000\000\046\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\046\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (47,
"\000\000\000\000\000\000\000\000\000\047\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\047\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\048\048\048\048\048\048\048\048\048\048\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (48,
"\000\000\000\000\000\000\000\000\000\042\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\042\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\
\\048\048\048\048\048\048\048\048\048\048\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (50,
"\000\000\000\000\000\000\000\000\000\000\051\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (53,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (55,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\057\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\056\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (58,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\054\059\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (59,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\060\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (60,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\061\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (61,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\062\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (62,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\063\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (63,
"\054\054\054\054\054\054\054\054\054\064\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\064\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (64,
"\054\054\054\054\054\054\054\054\054\071\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\071\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\065\065\065\065\065\065\065\065\065\065\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (65,
"\054\054\054\054\054\054\054\054\054\066\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\066\054\000\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\065\065\065\065\065\065\065\065\065\065\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (66,
"\054\054\054\054\054\054\054\054\054\066\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\066\054\000\054\054\054\054\054\054\054\068\054\054\054\054\054\
\\067\067\067\067\067\067\067\067\067\067\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (67,
"\054\054\054\054\054\054\054\054\054\070\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\070\054\000\054\054\054\054\054\054\054\068\054\054\054\054\054\
\\067\067\067\067\067\067\067\067\067\067\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (68,
"\054\054\054\054\054\054\054\054\054\054\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\000\054\054\054\054\054\054\069\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (70,
"\054\054\054\054\054\054\054\054\054\070\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\070\054\000\054\054\054\054\054\054\054\068\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (71,
"\054\054\054\054\054\054\054\054\054\071\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\071\054\000\054\054\054\054\054\054\054\068\054\054\054\054\054\
\\072\072\072\072\072\072\072\072\072\072\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (72,
"\054\054\054\054\054\054\054\054\054\066\000\054\054\054\054\000\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\066\054\000\054\054\054\054\054\054\054\068\054\054\054\054\054\
\\072\072\072\072\072\072\072\072\072\072\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\000\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\054\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (74,
"\000\000\000\000\000\000\000\000\000\000\075\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (77,
"\078\078\078\078\078\078\078\078\078\000\000\078\078\078\078\000\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\000\078\078\078\078\078\000\000\000\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\000\078\000\078\
\\000\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (79,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\080\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (81,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\082\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (83,
"\000\000\000\000\000\000\000\000\000\000\084\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (87,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\088\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (90,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\091\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (93,
"\000\000\000\000\000\000\000\000\000\000\094\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (96,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\097\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (98,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\099\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (100,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\101\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (103,
"\104\104\104\104\104\104\104\104\104\000\000\104\104\104\104\000\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\000\104\000\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\000\104\
\\000\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (105,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\106\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (107,
"\000\000\000\000\000\000\000\000\000\112\114\000\000\000\000\113\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\112\108\000\108\108\108\108\000\000\000\108\108\000\108\000\108\
\\000\000\000\000\000\000\000\000\000\000\108\000\108\108\108\108\
\\108\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\108\000\110\000\
\\109\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\108\000\108\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (110,
"\000\000\000\000\000\000\000\000\000\112\114\000\000\000\000\113\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\112\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\111\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (113,
"\000\000\000\000\000\000\000\000\000\000\114\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (116,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\117\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (118,
"\000\000\000\000\000\000\000\000\000\000\119\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (121,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\122\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (125,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\126\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (128,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\129\000\129\129\129\129\000\000\000\129\129\000\129\000\129\
\\000\000\000\000\000\000\000\000\000\000\129\000\129\129\129\129\
\\129\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\129\000\129\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\129\000\129\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (130,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\131\000\000\000\000\000\000\000\000\
\\131\131\131\131\131\131\131\131\131\131\000\000\000\000\000\000\
\\000\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\000\000\000\000\131\
\\000\131\131\131\131\131\131\131\131\131\131\131\131\131\131\131\
\\131\131\131\131\131\131\131\131\131\131\131\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (132,
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\133\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (134,
"\000\000\000\000\000\000\000\000\000\135\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\135\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
 (136,
"\000\000\000\000\000\000\000\000\000\000\137\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
),
(0, "")]
fun f x = x
val s = map f (rev (tl (rev s)))
exception LexHackingError
fun look ((j,x)::r, i) = if i = j then x else look(r, i)
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)}
in Vector.fromList(map g
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [], trans = 7},
{fin = [], trans = 7},
{fin = [], trans = 9},
{fin = [], trans = 9},
{fin = [], trans = 11},
{fin = [], trans = 11},
{fin = [], trans = 13},
{fin = [], trans = 13},
{fin = [], trans = 15},
{fin = [], trans = 15},
{fin = [], trans = 17},
{fin = [], trans = 17},
{fin = [], trans = 19},
{fin = [], trans = 19},
{fin = [(N 58),(N 60)], trans = 21},
{fin = [(N 58)], trans = 21},
{fin = [(N 49),(N 60)], trans = 23},
{fin = [(N 47)], trans = 24},
{fin = [], trans = 25},
{fin = [], trans = 26},
{fin = [(N 38)], trans = 0},
{fin = [], trans = 28},
{fin = [(N 44)], trans = 0},
{fin = [], trans = 30},
{fin = [], trans = 24},
{fin = [(N 60)], trans = 0},
{fin = [(N 22),(N 60)], trans = 0},
{fin = [(N 20),(N 60)], trans = 34},
{fin = [(N 18)], trans = 35},
{fin = [], trans = 36},
{fin = [], trans = 37},
{fin = [], trans = 38},
{fin = [], trans = 39},
{fin = [], trans = 40},
{fin = [], trans = 41},
{fin = [], trans = 42},
{fin = [], trans = 43},
{fin = [], trans = 44},
{fin = [(N 15)], trans = 0},
{fin = [], trans = 46},
{fin = [], trans = 47},
{fin = [], trans = 48},
{fin = [(N 51),(N 60)], trans = 0},
{fin = [(N 60)], trans = 50},
{fin = [(N 55)], trans = 0},
{fin = [(N 74),(N 79)], trans = 0},
{fin = [(N 77),(N 79)], trans = 53},
{fin = [(N 77)], trans = 53},
{fin = [(N 79)], trans = 55},
{fin = [(N 63)], trans = 0},
{fin = [(N 66)], trans = 0},
{fin = [(N 77),(N 79)], trans = 58},
{fin = [(N 77)], trans = 59},
{fin = [(N 77)], trans = 60},
{fin = [(N 77)], trans = 61},
{fin = [(N 77)], trans = 62},
{fin = [(N 77)], trans = 63},
{fin = [(N 77)], trans = 64},
{fin = [(N 77)], trans = 65},
{fin = [(N 77)], trans = 66},
{fin = [(N 77)], trans = 67},
{fin = [(N 77)], trans = 68},
{fin = [(N 15),(N 77)], trans = 53},
{fin = [(N 77)], trans = 70},
{fin = [(N 77)], trans = 71},
{fin = [(N 77)], trans = 72},
{fin = [(N 68),(N 79)], trans = 0},
{fin = [(N 79)], trans = 74},
{fin = [(N 72)], trans = 0},
{fin = [(N 123)], trans = 0},
{fin = [(N 121),(N 123)], trans = 77},
{fin = [(N 121)], trans = 77},
{fin = [(N 123)], trans = 79},
{fin = [(N 85)], trans = 0},
{fin = [(N 123)], trans = 81},
{fin = [(N 82)], trans = 35},
{fin = [(N 123)], trans = 83},
{fin = [(N 98)], trans = 0},
{fin = [(N 118),(N 123)], trans = 0},
{fin = [(N 116),(N 123)], trans = 0},
{fin = [(N 123)], trans = 87},
{fin = [(N 111)], trans = 0},
{fin = [(N 104),(N 123)], trans = 0},
{fin = [(N 123)], trans = 90},
{fin = [(N 94)], trans = 0},
{fin = [(N 106),(N 123)], trans = 0},
{fin = [(N 123)], trans = 93},
{fin = [(N 102)], trans = 0},
{fin = [(N 108),(N 123)], trans = 0},
{fin = [(N 123)], trans = 96},
{fin = [(N 114)], trans = 0},
{fin = [(N 123)], trans = 98},
{fin = [(N 88)], trans = 0},
{fin = [(N 123)], trans = 100},
{fin = [(N 91)], trans = 0},
{fin = [(N 168),(N 173)], trans = 0},
{fin = [(N 171),(N 173)], trans = 103},
{fin = [(N 171)], trans = 103},
{fin = [(N 173)], trans = 105},
{fin = [(N 151)], trans = 0},
{fin = [(N 166),(N 173)], trans = 107},
{fin = [(N 142)], trans = 0},
{fin = [(N 139)], trans = 0},
{fin = [(N 136),(N 142)], trans = 110},
{fin = [], trans = 110},
{fin = [(N 127)], trans = 0},
{fin = [], trans = 113},
{fin = [(N 133)], trans = 0},
{fin = [(N 173)], trans = 0},
{fin = [(N 173)], trans = 116},
{fin = [(N 160)], trans = 35},
{fin = [(N 173)], trans = 118},
{fin = [(N 146)], trans = 0},
{fin = [(N 164),(N 173)], trans = 107},
{fin = [(N 173)], trans = 121},
{fin = [(N 157)], trans = 35},
{fin = [(N 148),(N 173)], trans = 0},
{fin = [(N 162),(N 173)], trans = 107},
{fin = [(N 173)], trans = 125},
{fin = [(N 154)], trans = 35},
{fin = [(N 192)], trans = 0},
{fin = [(N 181),(N 192)], trans = 128},
{fin = [(N 181)], trans = 128},
{fin = [(N 181),(N 192)], trans = 130},
{fin = [(N 181)], trans = 130},
{fin = [(N 183),(N 192)], trans = 132},
{fin = [], trans = 35},
{fin = [(N 186),(N 192)], trans = 134},
{fin = [(N 186)], trans = 134},
{fin = [(N 192)], trans = 136},
{fin = [(N 190)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val ANTIQ = STARTSTATE 19;
val INITIAL = STARTSTATE 1;
val comment = STARTSTATE 5;
val qcomment = STARTSTATE 7;
val quote = STARTSTATE 17;
val string = STARTSTATE 3;
val tmcomment = STARTSTATE 9;
val tmquote = STARTSTATE 15;
val tycomment = STARTSTATE 11;
val tyquote = STARTSTATE 13;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

type int = Int.int
fun makeLexer (yyinput: int -> string) =
let	val yygone0:int=0
	val yyb = ref "\n" 		(* buffer *)
	val yybl: int ref = ref 1		(*buffer length *)
	val yybufpos: int ref = ref 1		(* location of next character to use *)
	val yygone: int ref = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin: int ref = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (UserDeclarations.QFS {output_stream, comdepth, pardepth, antiquote, row, rowstart})) =
let fun continue() : Internal.result =
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0: int) =
	let fun action (i: int,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk =>
			(let fun yymktext() = String.substring(!yyb,i0,i-i0)
			     val yypos: int = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of

			(* Application actions *)

  102 => let val yytext=yymktext() in qnewline yyarg (yypos,yytext); continue() end
| 104 => (ECHO yyarg "\\\\"; continue())
| 106 => (ECHO yyarg "\\\""; continue())
| 108 => (ECHO yyarg "\\t"; continue())
| 111 => (ECHO yyarg "`"; continue())
| 114 => (print yyarg "\"])"; comdepth := 0;
                              YYBEGIN INITIAL; continue())
| 116 => (print yyarg "\"]"; comdepth := 0;
                  YYBEGIN INITIAL; continue())
| 118 => let val yytext=yymktext() in ECHO yyarg (bslash_escape yytext);
                                              continue() end
| 121 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 123 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 127 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 133 => let val yytext=yymktext() in ECHO yyarg (String.substring(yytext,0,size yytext - 1));
    qnewline yyarg (yypos,yytext);
    continue() end
| 136 => (ECHO yyarg "^"; continue())
| 139 => (ECHO yyarg "`"; continue())
| 142 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 146 => let val yytext=yymktext() in qnewline yyarg (yypos,yytext); continue() end
| 148 => (print yyarg "\"]"; YYBEGIN INITIAL; continue())
| 15 => let val yytext=yymktext() in dolocpragma yyarg (yytext, yypos); continue() end
| 151 => (print yyarg "\"])"; YYBEGIN INITIAL; continue())
| 154 => let val yytext=yymktext() in ECHO yyarg yytext; inc comdepth; YYBEGIN qcomment; continue() end
| 157 => let val yytext=yymktext() in ECHO yyarg yytext; inc comdepth; YYBEGIN tmcomment;
                  continue() end
| 160 => let val yytext=yymktext() in ECHO yyarg yytext; inc comdepth; YYBEGIN tycomment;
                  continue() end
| 162 => (print yyarg "\", ANTIQUOTE ("; YYBEGIN ANTIQ; continue();
               YYBEGIN quote; continue())
| 164 => (print yyarg "\", ANTIQUOTE ("; YYBEGIN ANTIQ; continue();
                 YYBEGIN tmquote; continue())
| 166 => (print yyarg "\", ANTIQUOTE ("; YYBEGIN ANTIQ; continue();
                 YYBEGIN tyquote; continue())
| 168 => let val yytext=yymktext() in ECHO yyarg (bslash_escape yytext);
                                       continue() end
| 171 => let val yytext=yymktext() in ECHO yyarg (String.toString yytext); continue() end
| 173 => let val yytext=yymktext() in ECHO yyarg (String.toString yytext); continue() end
| 18 => let val yytext=yymktext() in ECHO yyarg yytext; inc comdepth; YYBEGIN comment; continue() end
| 181 => let val yytext=yymktext() in ECHO yyarg yytext;
                  print yyarg ("),QUOTE \""^locpragma yyarg (yytext,yypos) 0);
                  (yytext,yypos) end
| 183 => let val yytext=yymktext() in let val oldanti = !antiquote
                   in
                     ECHO yyarg yytext;
                     pardepth := 1;
                     antiquote := true;
                     YYBEGIN INITIAL;
                     let val (yytext,yypos) = continue()
                     in
                       print yyarg ("),QUOTE \""^locpragma yyarg (yytext, yypos) 0);
                       antiquote := oldanti;
                       (yytext,yypos)
                     end
               end end
| 186 => (continue())
| 190 => let val yytext=yymktext() in newline yyarg (yypos,yytext); continue() end
| 192 => let val yytext=yymktext() in ECHO yyarg yytext; (yytext,yypos) end
| 20 => let val yytext=yymktext() in ECHO yyarg yytext; inc pardepth; continue() end
| 22 => let val yytext=yymktext() in ECHO yyarg yytext; dec pardepth;
                 if !antiquote andalso !pardepth < 1 then (yytext,yypos)
                 else continue() end
| 38 => let val yytext=yymktext() in print yyarg ("(Parse.Type [QUOTE \""^locpragma yyarg (yytext,yypos) 2);
                 safeprint yyarg (drop_upto #":" yytext);
                 YYBEGIN tyquote;
                 continue() end
| 44 => let val yytext=yymktext() in print yyarg ("(Parse.Type [QUOTE \""^locpragma yyarg (yytext,yypos) 2^
                      ":\", ANTIQUOTE (");
               YYBEGIN ANTIQ;
               continue();
               YYBEGIN tyquote;
               continue() end
| 47 => let val yytext=yymktext() in print yyarg ("(Parse.Term [QUOTE \""^locpragma yyarg (yytext,yypos) 0);
                  YYBEGIN tmquote; continue() end
| 49 => let val yytext=yymktext() in print yyarg ("[QUOTE \""^locpragma yyarg (yytext,yypos) 0); YYBEGIN quote;
                 continue() end
| 51 => let val yytext=yymktext() in ECHO yyarg yytext; YYBEGIN string; continue() end
| 55 => let val yytext=yymktext() in newline yyarg (yypos,yytext); continue() end
| 58 => let val yytext=yymktext() in ECHO yyarg yytext;continue() end
| 60 => let val yytext=yymktext() in ECHO yyarg yytext;continue() end
| 63 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 66 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 68 => let val yytext=yymktext() in ECHO yyarg yytext; YYBEGIN INITIAL; continue() end
| 72 => let val yytext=yymktext() in newline yyarg (yypos,yytext); continue() end
| 74 => let val yytext=yymktext() in ECHO yyarg (bslash_escape yytext); continue() end
| 77 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 79 => let val yytext=yymktext() in ECHO yyarg yytext; continue() end
| 82 => let val yytext=yymktext() in ECHO yyarg yytext; inc comdepth; continue() end
| 85 => let val yytext=yymktext() in ECHO yyarg yytext; dec comdepth;
                  if !comdepth < 1 then YYBEGIN INITIAL else ();
                  continue() end
| 88 => let val yytext=yymktext() in ECHO yyarg yytext; dec comdepth;
                  if !comdepth < 1 then YYBEGIN tmquote else ();
                  continue() end
| 91 => let val yytext=yymktext() in ECHO yyarg yytext; dec comdepth;
                  if !comdepth < 1 then YYBEGIN tyquote else ();
                  continue() end
| 94 => let val yytext=yymktext() in ECHO yyarg yytext; dec comdepth;
                  if !comdepth < 1 then YYBEGIN quote else ();
                  continue() end
| 98 => let val yytext=yymktext() in newline yyarg (yypos,yytext); continue() end
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub (Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (String.size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := String.substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := String.size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord (CharVector.sub (!yyb,l))
		val NewState = Char.ord (CharVector.sub (trans,NewChar))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if String.substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
