/*
########## UNDER DEVEOPMENT ###################################

This program is unlikely to ever be finished, but may be of interest
all the same.

This is a second attempt to write a program to solve the rubik
cube. The first attempt (in rubik1.b) used a strategy that was too
slow to be useful unless the solution has a rather small number of
moves.

This program attempts to solve Rubik Cube problems, given a textual
specification of an initial position, it will hopefully output a
sequence of rotations to solve the cube.

Implemented by Martin Richards (c) January 2015

This program uses a lot of work space so it is a good idea to run
cintsys with a large memory size. You can, for instance, run the
system with 100 million words of Cintcode memory by executing the
following shell command.

cintsys -m 100000000

This program is still too slow to find solutions in general, but
seems to get quite close. For instance, output generated by the command

rubik -s 4

ends as follows:

new bestscore=434 nodecount=4491837
         W W W
         W W W
         W W W
 G G G   R R R   B B B   O O O
 G G G   R R R   B B O   B O O
 G Y G   R O R   B B B   O G O
         Y Y Y
         R Y Y
         Y Y Y
Insufficient space

nodecount = 8259446
space used: 75000002 out of 75000000
360.630> 

So it found that partial solution after visiting fewer than 5 million
nodes. Note that only a few pieces are not in their correct positions.
*/

GET "libhdr"

MANIFEST {
  // This program assumes the cube is always in the same  orientation
  // with upper face being white and the front face red.
  // The other faces are
  //    right  blue
  //    back   orange
  //    left   green
  //    down   yellow

  // Corner piece definitions
  // orientation 0 means W/Y piece face is parallel to up face
  //             1 means the piece was rotated anticlockwise once
  //                     when looking towards its corner.
  //             2 means the piece was rotated anticlockwise twice
  WRB0=0*3+0; WRB1=0*3+1; WRB2=0*3+2 // Corner 0
  WBO0=1*3+0; WBO1=1*3+1; WBO2=1*3+2 // Corner 1
  WOG0=2*3+0; WOG1=2*3+1; WOG2=2*3+2 // Corner 2
  WGR0=3*3+0; WGR1=3*3+1; WGR2=3*3+2 // Corner 3

  YBR0=4*3+0; YBR1=4*3+1; YBR2=4*3+2 // Corner 4
  YOB0=5*3+0; YOB1=5*3+1; YOB2=5*3+2 // Corner 5
  YGO0=6*3+0; YGO1=6*3+1; YGO2=6*3+2 // Corner 6
  YRG0=7*3+0; YRG1=7*3+1; YRG2=7*3+2 // Corner 7

  corncostvupb = YRG2
  corncostvsize = corncostvupb+1 // Number of elements in a row or column
  corncostmupb = corncostvsize*corncostvsize-1 // Upb of the matrix

  // There are 12 Edge pieces
  // The edge directions are
  //   0->1  1->2  2->3  3->0
  //   0->4  1->5  2->6  3->7
  //   4->7  5->4  6->5  7->6
  // orientation 0 means the first colour is on the left when
  //                     looking forward along the edge
  // orientation 1 means the first colour is on the right when
  //                     looking forward along the edge

  // Upper level edges
  WR0= 0*2+0; WR1= 0*2+1  // in edge  0->1
  WB0= 1*2+0; WB1= 1*2+1  // in edge  1->2
  WO0= 2*2+0; WO1= 2*2+1  // in edge  2->3
  WG0= 3*2+0; WG1= 3*2+1  // in edge  3->0

  // Middle layer edges
  BR0= 4*2+0; BR1= 4*2+1  // in edge  0->4
  OB0= 5*2+0; OB1= 5*2+1  // in edge  1->5
  GO0= 6*2+0; GO1= 6*2+1  // in edge  2->6
  RG0= 7*2+0; RG1= 7*2+1  // in edge  3->7

  // Down layer edges
  YR0= 8*2+0; YR1= 8*2+1  // in edge  4->7
  YB0= 9*2+0; YB1= 9*2+1  // in edge  5->4
  YO0=10*2+0; YO1=10*2+1  // in edge  6->5 
  YG0=11*2+0; YG1=11*2+1  // in edge  7->6

  edgecostvupb = YG1
  edgecostvsize = edgecostvupb+1 // Number of elements in a row or column
  edgecostmupb = edgecostvsize*edgecostvsize-1 // Upb of the matrix

  // 8 Corner positions used in the cost function
  cWRB=0; cWBO; cWOG; cWGR // White corners 
  cYBR;   cYOB; cYGO; cYRG // Yellow corners

   // 12 Edge positions used in the cost function
  eWR=0; eWB; eWO; eWG
  eBR;   eOB; eGO; eRG
  eYR;   eYB; eYO; eYG

  // 8 Corner byte position indexes on the cube
  iWRB=0; iWBO; iWOG; iWGR // White corners 
  iYBR;   iYOB; iYGO; iYRG // Yellow corners

  // 12 Edge byte position indexes on the cube
  iWR; iWB; iWO; iWG
  iBR; iOB; iGO; iRG
  iYR; iYB; iYO; iYG

  s_chain= iYG / bytesperword + 1 // Hash chain field
  s_prev                          // Immediate predecessor
  s_move                          // The move from predecessor to this node
  s_maxdepth                      // This node has been or is being searched
                                  // with this setting of maxdepth
  nodeupb = s_maxdepth

  // Moves for Upper, Front, Right, Back, Left and Down
  //   c = clockwise
  //   a = anti clockwise
  // These are used to record the sequence of moves
  mUc='U'; mUa='u'
  mFc='F'; mFa='f'
  mRc='R'; mRa='r'
  mBc='B'; mBa='b'
  mLc='L'; mLa='l'
  mDc='D'; mDa='d'
}

GLOBAL {
  // 8 Corner positions on the p cube as global variables
  pWRB:ug; pWBO; pWOG; pWGR // White corners 
  pYBR;    pYOB; pYGO; pYRG // Yellow corners
  pWR; pWB; pWO; pWG // 12 Edge positions on the p cube
  pBR; pOB; pGO; pRG
  pYR; pYB; pYO; pYG
 
  // 8 Corner positions on the q cube as global variables
  qWRB; qWBO; qWOG; qWGR // White corners 
  qYBR; qYOB; qYGO; qYRG // Yellow corners
  qWR; qWB; qWO; qWG     // 12 Edge positions on the q cube
  qBR; qOB; qGO; qRG
  qYR; qYB; qYO; qYG
 
  corncostm
  corncostv
  // corncostm is a 24x24 matrix giving the cost of moving a
  // piece from one corner of the cube to another changing its
  // orientation at the same time. If i and j are row and
  // column subscripts of corncostm then they have the form
  // corner*3+orientaion where corner is the corner number
  // in the range 0 to 7 and oritation is the orientation
  // number in the range 0 to 2.
  // corncostv!i is a vector corresponding to the ith row
  // of matrix corncostm. So the (i,j)th element of the matrix
  // can be accessed by corncostv!i!j. To see how it is used
  // see the function corncost.

  edgecostm
  edgecostv
  // edgecostm is a 24x24 matrix giving the cost of moving a
  // piece from one edge postion to another possibly flipping
  // its orientation. Its structure is similar to cordcostm.
  // The ((i,j)th element of edgecostm can be accessed by
  // edgecost!i!j. See the function edgecost.

 fin_p; fin_l

 spacev; spacep; spacet
 spacevupb
 hashtabsize
 hashtabupb
 mkvec
 nodecount
 hashtab
 hashfn
 findnode      // Find a node in the hash table, cresting one
               // if necessary.

 cube          // A packed cube -- 20 bytes = 5 words
 colour        // colour!0 .. colour!53
 errors        // =TRUE if an error has occurred
 moves         // Initialising moves supplied by -m argument
 bestnode
 bestscore
 initcostfn
 costfn
 score         // (node) returns the node's score
 scorenode
 exploreroot
 exploretree
 try
 prnode
 tracing
 compact       // =TRUE for compact configuration output
 randomise     // Set by the -r or -s options
 pieces2cube
 cube2pieces
 rotc
 rota
 flip
 rotateUc; rotateUa
 rotateDc; rotateDa
 rotateFc; rotateFa
 rotateBc; rotateBa
 rotateRc; rotateRa
 rotateLc; rotateLa

 movecubep2q;  movecubeq2p
 cornrotate;   edgerotate
 ffloyd
 prcornmat; predgemat
 prmoves
 corncost; edgecost
 prcosts
 prcorncost; predgecost
 prsolution
 wrcornerpiece; wredgepiece
 prpieces
 prnode; prnode
 setface
 corner; edge
 cols2cube; cube2cols
 setcornercols; setedgecols
}

LET hashfn(node) = VALOF
{ // Return a hash value in range 0 to hashtabupb
  LET w = node!0 XOR node!1 XOR node!2 XOR node!3 XOR node!4
  LET h = w MOD hashtabsize
  UNLESS 0 <= h <= hashtabupb DO
  { prnode(node)
    writef("%x8 %x8 %x8 %x8 %x8*n",
           node!0, node!1, node!2, node!3, node!4)
    writef("w = %x8 => hashval = %n*n", w, h)
    abort(999)
  }
  RESULTIS h
}

AND findnode(cube, prev, move) = VALOF
{ // Find the node that matches the configuration in cube
  // prev=0 or is the immediate predecessor
  // move=0 or is the move to reach this node
  // These values are only used if the node has not been seen before.
  // It creates a new node if necessary.
  LET hashval = hashfn(cube)
  LET node    = hashtab!hashval
//writef("hashval=%n node=%n*n", hashval, node)
  WHILE node DO
  { IF cube!0=node!0 &
       cube!1=node!1 &
       cube!2=node!2 &
       cube!3=node!3 &
       cube!4=node!4 DO
    { //writef("node %n has been seen before*n", node)
      RESULTIS node  // The node already exists
    }
    node := s_chain!node
  }
//writef("Matching node not found so create one*n")

  // The matching node has not been found so create one.

  node := mkvec(nodeupb)
  UNLESS node DO
  { writef("Mode space needed*n")
    stop(0, 0) //abort(999)
    RESULTIS 0
  }
  // Fill in all its fields
  node!0 := cube!0 // The corners
  node!1 := cube!1
  node!2 := cube!2 // The edges
  node!3 := cube!3
  node!4 := cube!4

  // Fill in its remaining fields
  s_prev!node := prev
  s_move!node := move
  s_maxdepth!node := 0

  // Insert it into its hash chain
  s_chain!node := hashtab!hashval
  hashtab!hashval := node

  nodecount := nodecount+1

  IF tracing DO
  { writef("New node %n, nodecount=%n*n",
            node, nodecount)
    prnode(node)
  }

  RESULTIS node
}

AND mkvec(upb) = VALOF
{ LET p = spacep
  spacep := spacep+upb+1
  IF spacep>spacet DO
  { writef("Insufficient space*n")
    longjump(fin_p, fin_l) //abort(999)
    RESULTIS 0
  }
  RESULTIS p
}

LET start() = VALOF
{ LET argv = VEC 50
  LET root = 0

  fin_p := level()
  fin_l := fin

  // Allocate 75% of current Cintcode memory as work space.
  // All other space used by this program is taken out of
  // this allocation.
  spacevupb   := rootnode!rtn_memsize*3/4
  hashtabsize := spacevupb/113
  hashtabupb  := hashtabsize-1
  writef("*nAllocating %n words of work space, hashtabupb=%n*n",
          spacevupb, hashtabupb)

  spacev := getvec(spacevupb)

  spacep, spacet := spacev, spacev+spacevupb

  UNLESS spacev DO
  { writef("Insufficient space available, cannot allocate spacev*n")
    GOTO fin
  }

  cube      := mkvec(nodeupb) // Structure representing the current state of the cube
  colour    := mkvec(6*9-1)
  corncostm := mkvec(corncostmupb)
  corncostv := mkvec(corncostvupb)
  edgecostm := mkvec(edgecostmupb)
  edgecostv := mkvec(edgecostvupb)

  UNLESS cube & colour &
         corncostm & edgecostm &
         corncostv & edgecostv DO
  { writef("Insufficient space available*n")
    GOTO fin
  }

  errors := FALSE

  UNLESS rdargs("W,R,B,O,G,Y,-m/K,-s/K/N,-r/S,-t/S,-c/S", argv, 50) DO
  { writef("Bad arguments for Rubik*n")
    GOTO fin
  }

  // Set default colours of the solved cube
  FOR i =  0 TO  8 DO colour!i := 'W'
  FOR i =  9 TO 17 DO colour!i := 'R'
  FOR i = 18 TO 26 DO colour!i := 'B'
  FOR i = 27 TO 35 DO colour!i := 'O'
  FOR i = 36 TO 44 DO colour!i := 'G'
  FOR i = 45 TO 53 DO colour!i := 'Y'

  // Set user specified colours
  IF argv!0 DO setface(0, 'W', argv!0) // W
  IF argv!1 DO setface(1, 'R', argv!1) // R
  IF argv!2 DO setface(2, 'B', argv!2) // B
  IF argv!3 DO setface(3, 'O', argv!3) // O
  IF argv!4 DO setface(4, 'G', argv!4) // G
  IF argv!5 DO setface(5, 'Y', argv!5) // Y

  moves   := argv!6                    // -m/K

  randomise := FALSE

  IF argv!7 DO                         // -s/K/N
  { //writef("calling setseed(%n)*n", !(argv!7))
    setseed(!(argv!7))
    randomise := TRUE
  }
  IF argv!8 DO                         // -r/S
  { LET day, msecs, filler = 0, 0, 0
    datstamp(@day)
    randomise := TRUE
    setseed(msecs) // Set seed based on time of day
  }
  tracing := argv!9                    // -t/S
  compact := argv!10                   // -c/S

  cols2cube(colour, cube)
  cube2pieces(cube, @pWRB)

  // Make initial moves, if any
  IF moves FOR i = 1 TO moves%0 DO
  { SWITCHON moves%i INTO
    { DEFAULT:  writef("Bad initial moves %s*n", moves)
                errors := TRUE
                BREAK

      CASE 'U': rotateUc(); ENDCASE
      CASE 'u': rotateUa(); ENDCASE
      CASE 'F': rotateFc(); ENDCASE
      CASE 'f': rotateFa(); ENDCASE
      CASE 'R': rotateRc(); ENDCASE
      CASE 'r': rotateRa(); ENDCASE
      CASE 'B': rotateBc(); ENDCASE
      CASE 'b': rotateBa(); ENDCASE
      CASE 'L': rotateLc(); ENDCASE
      CASE 'l': rotateLa(); ENDCASE
      CASE 'D': rotateDc(); ENDCASE
      CASE 'd': rotateDa(); ENDCASE
    }
    movecubeq2p()
  }
  
  // Possibly randomise the cube
  IF randomise FOR i = 1 TO 200 DO
  { SWITCHON randno(15) INTO
    { DEFAULT:  LOOP

      CASE  1: rotateUc(); ENDCASE
      CASE  2: rotateUa(); ENDCASE
      CASE  3: rotateFc(); ENDCASE
      CASE  4: rotateFa(); ENDCASE
      CASE  5: rotateRc(); ENDCASE
      CASE  6: rotateRa(); ENDCASE
      CASE  7: rotateBc(); ENDCASE
      CASE  8: rotateBa(); ENDCASE
      CASE  9: rotateLc(); ENDCASE
      CASE 10: rotateLa(); ENDCASE
      CASE 11: rotateDc(); ENDCASE
      CASE 12: rotateDa(); ENDCASE
    }
    movecubeq2p()
  }
  
  IF errors RESULTIS 0

  // Pack the starting position in cube
  pieces2cube(@pWRB, cube)

newline()
newline()
  initcostfn()
  //prcosts()

  //writef("*nThe starting position is:*n*n")
  //prpieces(@pWRB); newline()
  //movecubep2q()
  //writef("score = %n*n", score()+goalscore(cube))
  //prnode(cube)
  //newline()
//abort(1000)

  hashtab := mkvec(hashtabupb)
  FOR i = 0 TO hashtabupb DO hashtab!i := 0

  nodecount := 0

  // The starting node configuration is now in cube

  //writef("Creating the starting position*n")

  // Create a new node with prev=0 and no move
  root := findnode(cube, 0, 0, 0)

  { LET bestsc = bestscore
    root := exploreroot(root, 1)
    IF bestscore=0 | bestsc=bestscore BREAK
  } REPEAT

  writef("*nSolution*n*n")
  prsolution(root)

fin:
  writef("*nnodecount = %n*n", nodecount)
  writef("space used: %n out of %n*n",
         spacep-spacev, spacet-spacev)

  IF spacev DO freevec(spacev)
  RESULTIS 0
}

AND exploreroot(root, maxdepth) = VALOF
{ // root is a new root node from which to start the search
  // to find a nearest node with minimum score no more than
  // maxdepth away. During the search nodes are put into the hash
  // table so that we can easily test whether a node has already
  // been visited.
  // The function returns a node with minimum score.
  // If the best node has the same score as root, exploreroot will
  // have to be called again with a larger maxdepth.

  LET rootscore = scorenode(root)

  // Initialise bestscore and bestnode
  bestscore, bestnode := rootscore, root

  //writef("exploreroot: score=%n  space used = %n*n", rootscore, spacep-spacev)
  //prnode(root)
  IF bestscore=0 RESULTIS root
//abort(5000)

  exploretree(root, maxdepth)

  IF bestscore < rootscore RESULTIS bestnode

  maxdepth := maxdepth + 1
  //writef("bestscore = %n, trying exploreroot with new maxdepth = %n*n",
  //       bestscore, maxdepth)
  //abort(6000)
} REPEAT

AND exploretree(node, maxdepth) BE
{ LET sc = score()+goalscore(node)

  IF sc < bestscore DO
  { bestscore, bestnode := sc, node
    writef("new bestscore=%n nodecount=%n*n", bestscore, nodecount)
    prnode(node)
    //abort(7000)
  }
  //writef("exploretree: maxdepth=%n score=%n bestscore=%n nodecount=%n*n",
  //        maxdepth, sc, bestscore, nodecount)
  //prnode(node)
  //IF sc=0 DO abort(1000)
  IF maxdepth=0 RETURN // We have reached the depth limit

  // Return is this node has already be processed at this maxdepth.
  IF s_maxdepth!node >= maxdepth RETURN

  // Try the 12 possible successors of this node
  // in the list.

  try(rotateUc, node, mUc, maxdepth)
  try(rotateUa, node, mUa, maxdepth)
  try(rotateFc, node, mFc, maxdepth)
  try(rotateFa, node, mFa, maxdepth)
  try(rotateRc, node, mRc, maxdepth)
  try(rotateRa, node, mRa, maxdepth)
  try(rotateBc, node, mBc, maxdepth)
  try(rotateBa, node, mBa, maxdepth)
  try(rotateLc, node, mLc, maxdepth)
  try(rotateLa, node, mLa, maxdepth)
  try(rotateDc, node, mDc, maxdepth)
  try(rotateDa, node, mDa, maxdepth)
}

AND try(rotfn, prev, move, maxdepth) BE IF bestscore DO
{ // Explore an immediate successor of node prev
  LET node = ?
  // First unpack prev in pWRB, etc
  cube2pieces(prev, @pWRB)

  //prpieces(@pWRB)
  rotfn()  // q cube := p cube with one face rotated
  //newline()
  //prpieces(@qWRB)
  //abort(1000)
  pieces2cube(@qWRB, cube)
  node := findnode(cube, prev, move)

  exploretree(node, maxdepth-1) // Explore the successor nodes
}

AND pieces2cube(pieces, cube) BE
{ cube%iWRB := pieces!iWRB
  cube%iWBO := pieces!iWBO
  cube%iWOG := pieces!iWOG
  cube%iWGR := pieces!iWGR
  cube%iYBR := pieces!iYBR
  cube%iYOB := pieces!iYOB
  cube%iYGO := pieces!iYGO
  cube%iYRG := pieces!iYRG

  cube%iWR  := pieces!iWR
  cube%iWB  := pieces!iWB
  cube%iWO  := pieces!iWO
  cube%iWG  := pieces!iWG

  cube%iBR  := pieces!iBR
  cube%iOB  := pieces!iOB
  cube%iGO  := pieces!iGO
  cube%iRG  := pieces!iRG

  cube%iYR  := pieces!iYR
  cube%iYB  := pieces!iYB
  cube%iYO  := pieces!iYO
  cube%iYG  := pieces!iYG
}

AND cube2pieces(cube, pieces) BE
{ pieces!iWRB := cube%iWRB
  pieces!iWBO := cube%iWBO
  pieces!iWOG := cube%iWOG
  pieces!iWGR := cube%iWGR
  pieces!iYBR := cube%iYBR
  pieces!iYOB := cube%iYOB
  pieces!iYGO := cube%iYGO
  pieces!iYRG := cube%iYRG

  pieces!iWR  := cube%iWR
  pieces!iWB  := cube%iWB
  pieces!iWO  := cube%iWO
  pieces!iWG  := cube%iWG

  pieces!iBR  := cube%iBR
  pieces!iOB  := cube%iOB
  pieces!iGO  := cube%iGO
  pieces!iRG  := cube%iRG

  pieces!iYR  := cube%iYR
  pieces!iYB  := cube%iYB
  pieces!iYO  := cube%iYO
  pieces!iYG  := cube%iYG
}

AND rotc(piece) = VALOF SWITCHON piece INTO
{ // Rotate a corner piece one position clockwise
  DEFAULT:  writef("rotc: System error, piece=%n*n", piece)
            abort(999)
            RESULTIS piece

  CASE WRB1: CASE WRB2: CASE WBO1: CASE WBO2:
  CASE WOG1: CASE WOG2: CASE WGR1: CASE WGR2:
  CASE YBR1: CASE YBR2: CASE YOB1: CASE YOB2:
  CASE YGO1: CASE YGO2: CASE YRG1: CASE YRG2:
            RESULTIS piece-1

  CASE WRB0: CASE WBO0: CASE WOG0: CASE WGR0:
  CASE YOB0: CASE YBR0: CASE YGO0: CASE YRG0:
            RESULTIS piece+2
}

AND rota(piece) = VALOF SWITCHON piece INTO
{ // Rotate a corner piece one position anti-clockwise
  DEFAULT:  writef("rot1: System error, piece=%n*n", piece)
            abort(999)
            RESULTIS piece


  CASE WRB0: CASE WRB1: CASE WBO0: CASE WBO1:
  CASE WOG0: CASE WOG1: CASE WGR0: CASE WGR1:
  CASE YBR0: CASE YBR1: CASE YOB0: CASE YOB1:
  CASE YGO0: CASE YGO1: CASE YRG0: CASE YRG1:
            RESULTIS piece+1

  CASE WRB2: CASE WBO2: CASE WOG2: CASE WGR2:
  CASE YOB2: CASE YBR2: CASE YGO2: CASE YRG2:
            RESULTIS piece-2
}

AND flip(piece) = piece XOR 1 // Flip an edge piece

AND rotateUc() BE
{ // Rotate the upper face clockwise by a quarter turn
  qWRB, qWBO, qWOG, qWGR := pWBO, pWOG, pWGR, pWRB // Rotated
  qYBR, qYOB, qYGO, qYRG := pYBR, pYOB, pYGO, pYRG // Not rotated
  qWR, qWB, qWO, qWG := pWB, pWO, pWG, pWR // Rotated
  qBR, qOB, qGO, qRG := pBR, pOB, pGO, pRG // Not rotated
  qYR, qYB, qYO, qYG := pYR, pYB, pYO, pYG // Not rotated
}

AND rotateUa() BE
{ // Rotate the upper face anti-clockwise by a quarter turn
  qWRB, qWBO, qWOG, qWGR := pWGR, pWRB, pWBO, pWOG // Rotated
  qYBR, qYOB, qYGO, qYRG := pYBR, pYOB, pYGO, pYRG // Not rotated
  qWR, qWB, qWO, qWG := pWG, pWR, pWB, pWO // Rotated
  qBR, qOB, qGO, qRG := pBR, pOB, pGO, pRG // Not rotated
  qYR, qYB, qYO, qYG := pYR, pYB, pYO, pYG // Not rotated
}

AND rotateDc() BE
{ // Rotate the down face clockwise by a quarter turn
  qWRB, qWBO, qWOG, qWGR := pWRB, pWBO, pWOG, pWGR // Not rotated
  qYBR, qYOB, qYGO, qYRG := pYRG, pYBR, pYOB, pYGO // Rotated
  qWR, qWB, qWO, qWG := pWR, pWB, pWO, pWG // Not rotated
  qBR, qOB, qGO, qRG := pBR, pOB, pGO, pRG // Not rotated
  qYR, qYB, qYO, qYG := pYG, pYR, pYB, pYO // Rotated
}

AND rotateDa() BE
{ // Rotate the down face anti-clockwise by a quarter turn
  qWRB, qWBO, qWOG, qWGR := pWRB, pWBO, pWOG, pWGR // Not rotated
  qYBR, qYOB, qYGO, qYRG := pYOB, pYGO, pYRG, pYBR // Rotated
  qWR, qWB, qWO, qWG := pWR, pWB, pWO, pWG // Not rotated
  qBR, qOB, qGO, qRG := pBR, pOB, pGO, pRG // Not rotated
  qYR, qYB, qYO, qYG := pYB, pYO, pYG, pYR // Rotated
}

AND rotateFc() BE
{ // Rotate the front face clockwise by a quarter turn
  qWRB, qYBR, qYRG, qWGR := rotc(pWGR), rota(pWRB), rotc(pYBR), rota(pYRG) // Rotated
  qWBO, qYOB, qYGO, qWOG := pWBO, pYOB, pYGO, pWOG // Not rotated
  qWR, qBR, qYR, qRG := flip(pRG), pWR, pBR, flip(pYR) // Rotated
  qWB, qYB, qYG, qWG := pWB, pYB, pYG, pWG // Not rotated
  qWO, qOB, qYO, qGO := pWO, pOB, pYO, pGO // Not rotated
}

AND rotateFa() BE
{ // Rotate the front face anti-clockwise by a quarter turn
  qWRB, qYBR, qYRG, qWGR := rotc(pYBR), rota(pYRG), rotc(pWGR), rota(pWRB) // Rotated
  qWBO, qYOB, qYGO, qWOG := pWBO, pYOB, pYGO, pWOG // Not rotated
  qWR, qBR, qYR, qRG := pBR, pYR, flip(pRG), flip(pWR) // Rotated
  qWB, qYB, qYG, qWG := pWB, pYB, pYG, pWG // Not rotated
  qWO, qOB, qYO, qGO := pWO, pOB, pYO, pGO // Not rotated
}

AND rotateBc() BE
{ // Rotate the back face clockwise by a quarter turn
  qWBO, qWOG, qYGO, qYOB := rota(pYOB), rotc(pWBO), rota(pWOG), rotc(pYGO) // Rotated
  qWRB, qWGR, qYRG, qYBR := pWRB, pWGR, pYRG, pYBR // Not rotated
  qWO, qGO, qYO, qOB := flip(pOB), pWO, pGO, flip(pYO) // Rotated
  qWB, qWG, qYG, qYB := pWB, pWG, pYG, pYB // Not rotated
  qWR, qRG, qYR, qBR := pWR, pRG, pYR, pBR // Not rotated
}

AND rotateBa() BE
{ // Rotate the back face anti-clockwise by a quarter turn
  qWBO, qWOG, qYGO, qYOB := rota(pWOG), rotc(pYGO), rota(pYOB), rotc(pWBO) // Rotated
  qWRB, qWGR, qYRG, qYBR := pWRB, pWGR, pYRG, pYBR // Not rotated
  qWO, qGO, qYO, qOB := pGO, pYO, flip(pOB), flip(pWO) // Rotated
  qWB, qWG, qYG, qYB := pWB, pWG, pYG, pYB // Not rotated
  qWR, qRG, qYR, qBR := pWR, pRG, pYR, pBR // Not rotated
}

AND rotateRc() BE
{ // Rotate the right face clockwise by a quarter turn
  qWRB, qWBO, qYOB, qYBR := rota(pYBR), rotc(pWRB), rota(pWBO), rotc(pYOB) // Rotated
  qWGR, qYRG, qYGO, qWOG := pWGR, pYRG, pYGO, pWOG // Not rotated
  qWB, qOB, qYB, qBR := flip(pBR), pWB, pOB, flip(pYB) // Rotated
  qWR, qWO, qYO, qYR := pWR, pWO, pYO, pYR // Not rotated
  qWG, qRG, qYG, qGO := pWG, pRG, pYG, pGO // Not rotated
}

AND rotateRa() BE
{ // Rotate the right face anti-clockwise by a quarter turn
  qWRB, qWBO, qYOB, qYBR := rota(pWBO), rotc(pYOB), rota(pYBR), rotc(pWRB) // Rotated
  qWGR, qYRG, qYGO, qWOG := pWGR, pYRG, pYGO, pWOG // Not rotated
  qWB, qOB, qYB, qBR := pOB, pYB, flip(pBR), flip(pWB) // Rotated
  qWR, qWO, qYO, qYR := pWR, pWO, pYO, pYR // Not rotated
  qWG, qRG, qYG, qGO := pWG, pRG, pYG, pGO // Not rotated
}

AND rotateLc() BE
{ // Rotate the left face clockwise by a quarter turn
  qWGR, qYRG, qYGO, qWOG := rotc(pWOG), rota(pWGR), rotc(pYRG), rota(pYGO) // Rotated
  qWBO, qYOB, qYBR, qWRB := pWBO, pYOB, pYBR, pWRB // Not rotated
  qWG, qRG, qYG, qGO := flip(pGO), pWG, pRG, flip(pYG) // Rotated
  qWR, qYR, qYO, qWO := pWR, pYR, pYO, pWO // Not rotated
  qWB, qOB, qYB, qBR := pWB, pOB, pYB, pBR // Not rotated
}

AND rotateLa() BE
{ // Rotate the left face anti-clockwise by a quarter turn
  qWGR, qYRG, qYGO, qWOG := rotc(pYRG), rota(pYGO), rotc(pWOG), rota(pWGR) // Rotated
  qWBO, qYOB, qYBR, qWRB := pWBO, pYOB, pYBR, pWRB // Not rotated
  qWG, qRG, qYG, qGO := pRG, pYG, flip(pGO), flip(pWG) // Rotated
  qWR, qYR, qYO, qWO := pWR, pYR, pYO, pWO // Not rotated
  qWB, qOB, qYB, qBR := pWB, pOB, pYB, pBR // Not rotated
}

AND movecubep2q() BE
{ qWRB, qWBO, qWOG, qWGR := pWRB, pWBO, pWOG, pWGR
  qYBR, qYOB, qYGO, qYRG := pYBR, pYOB, pYGO, pYRG
  qWR, qWB, qWO, qWG := pWR, pWB, pWO, pWG
  qBR, qOB, qGO, qRG := pBR, pOB, pGO, pRG
  qYR, qYB, qYO, qYG := pYR, pYB, pYO, pYG
}

AND movecubeq2p() BE
{ pWRB, pWBO, pWOG, pWGR := qWRB, qWBO, qWOG, qWGR
  pYBR, pYOB, pYGO, pYRG := qYBR, qYOB, qYGO, qYRG
  pWR, pWB, pWO, pWG := qWR, qWB, qWO, qWG
  pBR, pOB, pGO, pRG := qBR, qOB, qGO, qRG
  pYR, pYB, pYO, pYG := qYR, qYB, qYO, qYG
}

AND initcostfn() BE
{ // Initialise corncostv
  FOR i = 0 TO corncostvupb DO corncostv!i := corncostm + i*corncostvsize 
  // Set all elements of corncostm to 10
  FOR i = 0 TO corncostmupb DO
    corncostm!i := 10 // No cost will be as large as 10
  // Set all elements on the leading diagonal to 0
  FOR p = 0 TO corncostvupb DO
  { LET rowp = corncostm + corncostvsize*p
    rowp!p := 0
  }
  // Set a cost of one for every single move
  cornrotate(0, 1, 0, mUa) // Corner 0 moves
  cornrotate(0, 3, 0, mUc)
  cornrotate(0, 3, 1, mFa)
  cornrotate(0, 4, 1, mFc)
  cornrotate(0, 4, 2, mRa)
  cornrotate(0, 1, 2, mRc)

  cornrotate(1, 2, 0, mUa) // Corner 1 moves
  cornrotate(1, 0, 0, mUc)
  cornrotate(1, 0, 1, mRa)
  cornrotate(1, 5, 1, mRc)
  cornrotate(1, 5, 2, mBa)
  cornrotate(1, 2, 2, mBc)

  cornrotate(2, 3, 0, mUa) // Corner 2 moves
  cornrotate(2, 1, 0, mUc)
  cornrotate(2, 1, 1, mBa)
  cornrotate(2, 6, 1, mBc)
  cornrotate(2, 6, 2, mLa)
  cornrotate(2, 3, 2, mLc)

  cornrotate(3, 0, 0, mUa) // Corner 3 moves
  cornrotate(3, 2, 0, mUc)
  cornrotate(3, 2, 1, mLa)
  cornrotate(3, 7, 1, mLc)
  cornrotate(3, 7, 2, mFa)
  cornrotate(3, 0, 2, mFc)

  cornrotate(4, 7, 0, mDa) // Corner 4 moves
  cornrotate(4, 5, 0, mDc)
  cornrotate(4, 5, 1, mRa)
  cornrotate(4, 0, 1, mRc)
  cornrotate(4, 0, 2, mFa)
  cornrotate(4, 7, 2, mFc)

  cornrotate(5, 4, 0, mDa) // Corner 5 moves
  cornrotate(5, 6, 0, mDc)
  cornrotate(5, 6, 1, mBa)
  cornrotate(5, 1, 1, mBc)
  cornrotate(5, 1, 2, mRa)
  cornrotate(5, 4, 2, mRc)

  cornrotate(6, 5, 0, mDa) // Corner 6 moves
  cornrotate(6, 7, 0, mDc)
  cornrotate(6, 7, 1, mLa)
  cornrotate(6, 2, 1, mLc)
  cornrotate(6, 2, 2, mBa)
  cornrotate(6, 5, 2, mBc)

  cornrotate(7, 6, 0, mDa) // Corner 7 moves
  cornrotate(7, 4, 0, mDc)
  cornrotate(7, 4, 1, mFa)
  cornrotate(7, 3, 1, mFc)
  cornrotate(7, 3, 2, mLa)
  cornrotate(7, 6, 2, mLc)

  //writef("*ncorner cost matrix before applying Ffloyd's algorithm*n")
  //prcornmat(corncostm, corncostvsize)

  // Apply Ffloyd's algorithm
  ffloyd(corncostm, corncostvsize)

  //writef("*ncorner cost matrix after applying Ffloyd's algorithm*n")
  //prcornmat(corncostm, corncostvsize)
//abort(2000)


  // Initialise edgecostv
  FOR i = 0 TO edgecostvupb DO edgecostv!i := edgecostm + i*edgecostvsize 
  // Set all elements of edgecostm to 10
  FOR i = 0 TO edgecostmupb DO
    edgecostm!i := 10 // No cost will be as large as 10
  // Set all elements on the leading diagonal to 0
  FOR p = 0 TO edgecostvupb DO
  { LET rowp = edgecostm + edgecostvsize*p
    rowp!p := 0
  }
  // Set a cost of one for every single move
  edgerotate( 0,  1, 0, mUa) // Edge 0 moves
  edgerotate( 0,  3, 0, mUc)
  edgerotate( 0,  7, 1, mFa)
  edgerotate( 0,  4, 0, mFc)

  edgerotate( 1,  2, 0, mUa) // Edge 1 moves
  edgerotate( 1,  0, 0, mUc)
  edgerotate( 1,  4, 1, mRa)
  edgerotate( 1,  5, 0, mRc)

  edgerotate( 2,  3, 0, mUa) // Edge 2 moves
  edgerotate( 2,  1, 0, mUc)
  edgerotate( 2,  5, 1, mBa)
  edgerotate( 2,  6, 0, mBc)

  edgerotate( 3,  0, 0, mUa) // Edge 3 moves
  edgerotate( 3,  2, 0, mUc)
  edgerotate( 3,  6, 1, mLa)
  edgerotate( 3,  7, 0, mLc)

  edgerotate( 4,  0, 0, mFa) // Edge 4 moves
  edgerotate( 4,  8, 0, mFc)
  edgerotate( 4,  9, 1, mRa)
  edgerotate( 4,  1, 1, mRc)

  edgerotate( 5,  1, 0, mRa) // Edge 5 moves
  edgerotate( 5,  9, 0, mRc)
  edgerotate( 5, 10, 1, mBa)
  edgerotate( 5,  2, 1, mBc)

  edgerotate( 6,  2, 0, mBa) // Edge 6 moves
  edgerotate( 6, 10, 0, mBc)
  edgerotate( 6, 11, 1, mLa)
  edgerotate( 6,  3, 1, mLc)

  edgerotate( 7,  3, 0, mLa) // Edge 7 moves
  edgerotate( 7, 11, 0, mLc)
  edgerotate( 7,  8, 1, mFa)
  edgerotate( 7,  0, 1, mFc)

  edgerotate( 8, 11, 0, mDa) // Edge 8 moves
  edgerotate( 8,  9, 0, mDc)
  edgerotate( 8,  4, 0, mFa)
  edgerotate( 8,  7, 1, mFc)

  edgerotate( 9,  8, 0, mDa) // Edge 9 moves
  edgerotate( 9, 10, 0, mDc)
  edgerotate( 9,  5, 0, mRa)
  edgerotate( 9,  4, 1, mRc)

  edgerotate(10,  9, 0, mDa) // Edge 10 moves
  edgerotate(10, 11, 0, mDc)
  edgerotate(10,  6, 0, mBa)
  edgerotate(10,  5, 1, mBc)

  edgerotate(11, 10, 0, mDa) // Edge 11 moves
  edgerotate(11,  8, 0, mDc)
  edgerotate(11,  7, 0, mLa)
  edgerotate(11,  6, 1, mLc)

  //writef("*nedge cost matrix before applying Ffloyd's algorithm*n")
  //predgemat(edgecostm, edgecostvsize)

  // Apply Ffloyd's algorithm
  ffloyd(edgecostm, edgecostvsize)

  //writef("*nedge cost matrix after applying Ffloyd's algorithm*n")
  //predgemat(edgecostm, edgecostvsize)
//abort(3000)
}

AND cornrotate(c1, c2, rot, move) BE
{ // rot = 0 no change in orientation,            ie 0->0, 1->1 and 2->2
  // rot = 1 corner piece rotated anti-clockwise, ie 0->1, 1->2 and 2->0
  // rot = 2 corner piece rotated clockwise,      ie 0->2, 1->0 and 2->1
  FOR o1 = 0 TO 2 DO // The three orientations of the piece at corner c1
  { LET o2   = (o1 + rot) MOD 3 // orientation when moved to corner c2
    LET p    = c1*3 + o1 
    LET rowp = corncostv!p
    LET q    = c2*3 + o2
    // A piece at corner c1 with orientation o1 can be moved to
    // corner c2 with orientation o2 by a single move. 
    rowp!q := 1
  }
}

AND edgerotate(e1, e2, flip, move) BE
{ // flip = 0 no change in orientation, ie 0->0 and 1->1
  // flip = 1 edge piece flipped,       ie 0->1 and 1->0
  FOR o1 = 0 TO 1 DO // The two orientations of the piece at edge e1
  { LET o2   = o1 XOR flip // orientation when moved to edge e2
    LET p    = e1*2 + o1 
    LET rowp = edgecostv!p
    LET q    = e2*2 + o2
    // A piece at edge e1 with orientation o1 can be moved to
    // edge e2 with orientation o2 by a single move. 
    rowp!q := 1
  }
}

AND ffloyd(m, n) BE FOR k = 0 TO n-1 DO
{ LET rowk = m + k*n
  FOR i = 0 TO n-1 DO
  { LET rowi = m + i*n
    LET mik = rowi!k
    FOR j = 0 TO n-1 DO
    { LET mkj = rowk!j
      LET d   = mik+mkj
      IF rowi!j > d DO rowi!j := d
    }
  }
}

AND prcornmat(m, n) BE
{ newline()
  FOR i = 0 TO n-1 DO
  { LET rowi = m + i*n
    writef("row %i2:", i)
    FOR j = 0 TO n-1 DO
    { LET d = rowi!j
      TEST d=10 THEN writef(" .")
                ELSE writef(" %n", rowi!j)
      IF j MOD 3 = 2 DO wrch(' ')
    }
    IF i MOD 3 = 2 DO newline()
    newline()
  }
}

AND predgemat(m, n) BE
{ newline()
  FOR i = 0 TO n-1 DO
  { LET rowi = m + i*n
    writef("row %i2:", i)
    FOR j = 0 TO n-1 DO
    { LET d = rowi!j
      TEST d=10 THEN writef(" .")
                ELSE writef(" %n", rowi!j)
      IF j MOD 2 = 1 DO wrch(' ')
    }
    IF i MOD 2 = 1 DO newline()
    newline()
  }
}

AND prmoves(moves) BE IF moves DO
{ prmoves(moves>>8)
  wrch(moves&255)
}

AND corncost(piece, corner) = VALOF
{ LET d = piece MOD 3
  LET res = corncostv!(piece-d)!(3*corner+d)
  //writef("corner piece = %n/%n corner = %n cost = %n*n",
  //        piece/3, piece MOD 3, corner, res)
  RESULTIS res
}

AND edgecost(piece, edge) = VALOF
{ LET res = edgecostv!piece!(2*edge)
  //writef("edge piece = %i2/%n edge = %i2 cost = %n*n",
  //        piece/2, piece MOD 2, edge, res)
  RESULTIS res
}

AND costfn() = VALOF
{ // Return the cost of the position in qWRB, etc
  // This is the sum of the minimum number of moves
  // required for each piece.
  LET c = ?
//writef("costfn: entered*n")
  c :=     corncost(qWRB, cWRB)
  c := c + corncost(qWBO, cWBO)
  c := c + corncost(qWOG, cWOG)
  c := c + corncost(qWGR, cWGR)
  c := c + corncost(qYBR, cYBR)
  c := c + corncost(qYOB, cYOB)
  c := c + corncost(qYGO, cYGO)
  c := c + corncost(qYRG, cYRG)

  c := c + edgecost(qWR, eWR)
  c := c + edgecost(qWB, eWB)
  c := c + edgecost(qWO, eWO)
  c := c + edgecost(qWG, eWG)

  c := c + edgecost(qBR, eBR)
  c := c + edgecost(qOB, eOB)
  c := c + edgecost(qGO, eGO)
  c := c + edgecost(qRG, eRG)

  c := c + edgecost(qYR, eYR)
  c := c + edgecost(qYB, eYB)
  c := c + edgecost(qYO, eYO)
  c := c + edgecost(qYG, eYG)
//writef("costfn: cost = %n*n", c)
//abort(4000)

  RESULTIS c * c // Square to discourage pieces many moves
                 // from their required positions.
}

AND scorenode(node) = VALOF
{ cube2pieces(node, @qWRB)
  RESULTIS score()+goalscore(node)
}

AND score() = costfn()

AND prcosts() BE
{ newline()
  prcorncost("WRB0: ", WRB0)
  prcorncost("WRB1: ", WRB1)
  prcorncost("WRB2: ", WRB2)
  newline()
  prcorncost("WBO0: ", WBO0)
  prcorncost("WBO1: ", WBO1)
  prcorncost("WBO2: ", WBO2)
  newline()
  prcorncost("WOG0: ", WOG0)
  prcorncost("WOG1: ", WOG1)
  prcorncost("WOG2: ", WOG2)
  newline()
  prcorncost("WGR0: ", WGR0)
  prcorncost("WGR1: ", WGR1)
  prcorncost("WGR2: ", WGR2)
  newline()
  prcorncost("YBR0: ", YBR0)
  prcorncost("YBR1: ", YBR1)
  prcorncost("YBR2: ", YBR2)
  newline()
  prcorncost("YOB0: ", YOB0)
  prcorncost("YOB1: ", YOB1)
  prcorncost("YOB2: ", YOB2)
  newline()
  prcorncost("YGO0: ", YGO0)
  prcorncost("YGO1: ", YGO1)
  prcorncost("YGO2: ", YGO2)
  newline()
  prcorncost("YRG0: ", YRG0)
  prcorncost("YRG1: ", YRG1)
  prcorncost("YRG2: ", YRG2)

  newline()

  predgecost("WR0:  ", WR0)
  predgecost("WR1:  ", WR1)
  newline()
  predgecost("WB0:  ", WB0)
  predgecost("WB1:  ", WB1)
  newline()
  predgecost("WO0:  ", WO0)
  predgecost("WO1:  ", WO1)
  newline()
  predgecost("WG0:  ", WG0)
  predgecost("WG1:  ", WG1)
  newline()

  predgecost("BR0:  ", BR0)
  predgecost("BR1:  ", BR1)
  newline()
  predgecost("OB0:  ", OB0)
  predgecost("OB1:  ", OB1)
  newline()
  predgecost("GO0:  ", GO0)
  predgecost("GO1:  ", GO1)
  newline()
  predgecost("RG0:  ", RG0)
  predgecost("RG1:  ", RG1)
  newline()

  predgecost("YR0:  ", YR0)
  predgecost("YR1:  ", YR1)
  newline()
  predgecost("YB0:  ", YB0)
  predgecost("YB1:  ", YB1)
  newline()
  predgecost("YO0:  ", YO0)
  predgecost("YO1:  ", YO1)
  newline()
  predgecost("YG0:  ", YG0)
  predgecost("YG1:  ", YG1)
  newline()
}

AND prcorncost(str, piece) BE
{ writef("%s: ", str)
  FOR corner = 0 TO 7 DO writef(" %i3", corncost(piece, corner))
  newline()
}

AND predgecost(str, piece) BE
{ writef("%s: ", str)
  FOR edge = 0 TO 11 DO writef(" %i3", edgecost(piece, edge))
  newline()
}

AND prsolution(node) BE
{ IF s_prev!node DO
  { prsolution(s_prev!node)
    writef("move %c*n", s_move!node)
  }
  prcube(node)
}

AND wrcornerpiece(piece) BE
{ SWITCHON piece/3 INTO
  {
    CASE cWRB: writef(" WRB"); ENDCASE
    CASE cWBO: writef(" WBO"); ENDCASE
    CASE cWOG: writef(" WOG"); ENDCASE
    CASE cWGR: writef(" WGR"); ENDCASE
    CASE cYBR: writef(" YBR"); ENDCASE
    CASE cYOB: writef(" YOB"); ENDCASE
    CASE cYGO: writef(" YGO"); ENDCASE
    CASE cYRG: writef(" YRG"); ENDCASE
  }
  writef("%n", piece MOD 3)
}

AND wredgepiece(piece) BE
{ SWITCHON piece/2 INTO
  {
    CASE eWR: writef(" WR"); ENDCASE
    CASE eWB: writef(" WB"); ENDCASE
    CASE eWO: writef(" WO"); ENDCASE
    CASE eWG: writef(" WG"); ENDCASE

    CASE eBR: writef(" BR"); ENDCASE
    CASE eOB: writef(" OB"); ENDCASE
    CASE eGO: writef(" GO"); ENDCASE
    CASE eRG: writef(" RG"); ENDCASE

    CASE eYB: writef(" YB"); ENDCASE
    CASE eYO: writef(" YO"); ENDCASE
    CASE eYG: writef(" YG"); ENDCASE
    CASE eYR: writef(" YR"); ENDCASE
  }
  writef("%n ", piece MOD 2)
}

AND prpieces(pieces) BE
{ LET c = VEC 4
  pieces2cube(pieces, c)
  wrcornerpiece(c%0)
  wrcornerpiece(c%1)
  wrcornerpiece(c%2)
  wrcornerpiece(c%3)
  wrcornerpiece(c%4)
  wrcornerpiece(c%5)
  wrcornerpiece(c%6)
  wrcornerpiece(c%7)
  newline()
  wredgepiece(c%8)
  wredgepiece(c%9)
  wredgepiece(c%10)
  wredgepiece(c%11)
  wredgepiece(c%12)
  wredgepiece(c%13)
  wredgepiece(c%14)
  wredgepiece(c%15)
  wredgepiece(c%16)
  wredgepiece(c%17)
  wredgepiece(c%18)
  wredgepiece(c%19)
  newline()
  prcube(c)
}

AND prnode(node) BE
{  //writef("node=%n prev=%n*n",
   //        node, s_prev!node)
   prcube(node)
}

AND prcube(cube) BE
{ /* Typical output is either

  WWWWWWWWW GGGGGGGGG RRRRRRRRR BBBBBBBBB OOOOOOOOO YYYYYYYYY

  or

          W W W
          W W W
          W W W
   G G G  R R R  B B B  O O O
   G G G  R R R  B B B  O O O
   G G G  R R R  B B B  O O O
          Y Y Y
          Y Y Y
          Y Y Y
  */

  cube2cols(cube, colour)

  IF compact DO
  { writef("%c%c%c%c%c%c%c%c%c ",          // Upper face
             colour!0, colour!1, colour!2,
             colour!3, colour!4, colour!5,
             colour!6, colour!7, colour!8)
    writef("%c%c%c%c%c%c%c%c%c ",          // Left face
             colour!36, colour!37, colour!38,
             colour!39, colour!40, colour!41,
             colour!42, colour!43, colour!44)
    writef("%c%c%c%c%c%c%c%c%c ",          // Front face
             colour! 9, colour!10, colour!11,
             colour!12, colour!13, colour!14,
             colour!15, colour!16, colour!17)
    writef("%c%c%c%c%c%c%c%c%c ",          // Right face
             colour!18, colour!19, colour!20,
             colour!21, colour!22, colour!23,
             colour!24, colour!25, colour!26)
    writef("%c%c%c%c%c%c%c%c%c ",          // Back face
             colour!27, colour!28, colour!29,
             colour!30, colour!31, colour!32,
             colour!33, colour!34, colour!35)
    writef("%c%c%c%c%c%c%c%c%c*n",          // Down face
             colour!45, colour!46, colour!47,
             colour!48, colour!49, colour!50,
             colour!51, colour!52, colour!53)
    RETURN
  }

  writef("         %c %c %c*n", colour!0, colour!1, colour!2)
  writef("         %c %c %c*n", colour!3, colour!4, colour!5)
  writef("         %c %c %c*n", colour!6, colour!7, colour!8)

  writef(" %c %c %c  ", colour!36, colour!37, colour!38)
  writef(" %c %c %c  ", colour! 9, colour!10, colour!11)
  writef(" %c %c %c  ", colour!18, colour!19, colour!20)
  writef(" %c %c %c*n", colour!27, colour!28, colour!29)

  writef(" %c %c %c  ", colour!39, colour!40, colour!41)
  writef(" %c %c %c  ", colour!12, colour!13, colour!14)
  writef(" %c %c %c  ", colour!21, colour!22, colour!23)
  writef(" %c %c %c*n", colour!30, colour!31, colour!32)

  writef(" %c %c %c  ", colour!42, colour!43, colour!44)
  writef(" %c %c %c  ", colour!15, colour!16, colour!17)
  writef(" %c %c %c  ", colour!24, colour!25, colour!26)
  writef(" %c %c %c*n", colour!33, colour!34, colour!35)

  writef("         %c %c %c*n", colour!45, colour!46, colour!47)
  writef("         %c %c %c*n", colour!48, colour!49, colour!50)
  writef("         %c %c %c*n", colour!51, colour!52, colour!53)

}

AND setface(n, ch, str) BE
{ LET face = @colour!(9*n)
  UNLESS str%0=9 & capitalch(str%5)=ch DO
  { writef("Bad face colours %c %s*n", ch, str)
    errors := TRUE
  }
  FOR i = 1 TO str%0 DO face!(i-1) := capitalch(str%i)
}

AND corner(a, b, c) = VALOF SWITCHON a<<16 | b<<8 | c INTO
{ DEFAULT:  writef("*nBad corner: %c%c%c*n", a, b, c)
            errors := TRUE
            RESULTIS 0

  CASE 'W'<<16 | 'R'<<8 | 'B': RESULTIS WRB0
  CASE 'B'<<16 | 'W'<<8 | 'R': RESULTIS WRB1
  CASE 'R'<<16 | 'B'<<8 | 'W': RESULTIS WRB2

  CASE 'W'<<16 | 'B'<<8 | 'O': RESULTIS WBO0
  CASE 'O'<<16 | 'W'<<8 | 'B': RESULTIS WBO1
  CASE 'B'<<16 | 'O'<<8 | 'W': RESULTIS WBO2

  CASE 'W'<<16 | 'O'<<8 | 'G': RESULTIS WOG0
  CASE 'G'<<16 | 'W'<<8 | 'O': RESULTIS WOG1
  CASE 'O'<<16 | 'G'<<8 | 'W': RESULTIS WOG2

  CASE 'W'<<16 | 'G'<<8 | 'R': RESULTIS WGR0
  CASE 'R'<<16 | 'W'<<8 | 'G': RESULTIS WGR1
  CASE 'G'<<16 | 'R'<<8 | 'W': RESULTIS WGR2

  CASE 'Y'<<16 | 'B'<<8 | 'R': RESULTIS YBR0
  CASE 'R'<<16 | 'Y'<<8 | 'B': RESULTIS YBR1
  CASE 'B'<<16 | 'R'<<8 | 'Y': RESULTIS YBR2

  CASE 'Y'<<16 | 'O'<<8 | 'B': RESULTIS YOB0
  CASE 'B'<<16 | 'Y'<<8 | 'O': RESULTIS YOB1
  CASE 'O'<<16 | 'B'<<8 | 'Y': RESULTIS YOB2

  CASE 'Y'<<16 | 'G'<<8 | 'O': RESULTIS YGO0
  CASE 'O'<<16 | 'Y'<<8 | 'G': RESULTIS YGO1
  CASE 'G'<<16 | 'O'<<8 | 'Y': RESULTIS YGO2

  CASE 'Y'<<16 | 'R'<<8 | 'G': RESULTIS YRG0
  CASE 'G'<<16 | 'Y'<<8 | 'R': RESULTIS YRG1
  CASE 'R'<<16 | 'G'<<8 | 'Y': RESULTIS YRG2
}

AND edge(a, b) = VALOF SWITCHON a<<8 | b INTO
{ DEFAULT:  writef("*nBad edge: %c%c*n", a, b)
            errors := TRUE
            RESULTIS 0

  CASE 'W'<<8 | 'R': RESULTIS WR0
  CASE 'R'<<8 | 'W': RESULTIS WR1
  CASE 'W'<<8 | 'B': RESULTIS WB0
  CASE 'B'<<8 | 'W': RESULTIS WB1
  CASE 'W'<<8 | 'O': RESULTIS WO0
  CASE 'O'<<8 | 'W': RESULTIS WO1
  CASE 'W'<<8 | 'G': RESULTIS WG0
  CASE 'G'<<8 | 'W': RESULTIS WG1

  CASE 'B'<<8 | 'R': RESULTIS BR0
  CASE 'R'<<8 | 'B': RESULTIS BR1
  CASE 'O'<<8 | 'B': RESULTIS OB0
  CASE 'B'<<8 | 'O': RESULTIS OB1
  CASE 'G'<<8 | 'O': RESULTIS GO0
  CASE 'O'<<8 | 'G': RESULTIS GO1
  CASE 'R'<<8 | 'G': RESULTIS RG0
  CASE 'G'<<8 | 'R': RESULTIS RG1

  CASE 'Y'<<8 | 'R': RESULTIS YR0
  CASE 'R'<<8 | 'Y': RESULTIS YR1
  CASE 'Y'<<8 | 'B': RESULTIS YB0
  CASE 'B'<<8 | 'Y': RESULTIS YB1
  CASE 'Y'<<8 | 'O': RESULTIS YO0
  CASE 'O'<<8 | 'Y': RESULTIS YO1
  CASE 'Y'<<8 | 'G': RESULTIS YG0
  CASE 'G'<<8 | 'Y': RESULTIS YG1
}

AND cols2cube(cv, cube) BE
{ // Colour coordinates

  //            0  1  2
  //            3  4  5
  //            6  7  8
  // 36 37 38   9 10 11  18 19 20  27 28 29
  // 39 40 41  12 13 14  21 22 23  30 31 32
  // 42 43 44  15 16 17  24 25 26  33 34 35
  //           45 46 47
  //           48 49 50
  //           51 52 53

  cube%iWRB := corner(cv! 8, cv!11, cv!18)
  cube%iWBO := corner(cv! 2, cv!20, cv!27)
  cube%iWOG := corner(cv! 0, cv!29, cv!36)
  cube%iWGR := corner(cv! 6, cv!38, cv! 9)
  cube%iYBR := corner(cv!47, cv!24, cv!17)
  cube%iYOB := corner(cv!53, cv!33, cv!26)
  cube%iYGO := corner(cv!51, cv!42, cv!35)
  cube%iYRG := corner(cv!45, cv!15, cv!44)

  cube%iWR  := edge(cv! 7, cv!10)
  cube%iWB  := edge(cv! 5, cv!19)
  cube%iWO  := edge(cv! 1, cv!28)
  cube%iWG  := edge(cv! 3, cv!37)

  cube%iBR  := edge(cv!21, cv!14)
  cube%iOB  := edge(cv!30, cv!23)
  cube%iGO  := edge(cv!39, cv!32)
  cube%iRG  := edge(cv!12, cv!41)

  cube%iYR  := edge(cv!46, cv!16)
  cube%iYB  := edge(cv!50, cv!25)
  cube%iYO  := edge(cv!52, cv!34)
  cube%iYG  := edge(cv!48, cv!43)
}

AND cube2cols(cube, cv) BE
{ // Colour coordinates

  //            0  1  2
  //            3  4  5
  //            6  7  8
  // 36 37 38   9 10 11  18 19 20  27 28 29
  // 39 40 41  12 13 14  21 22 23  30 31 32
  // 42 43 44  15 16 17  24 25 26  33 34 35
  //           45 46 47
  //           48 49 50
  //           51 52 53

  cv! 4 := 'W'  // Fixed colours
  cv!13 := 'R'
  cv!22 := 'B'
  cv!31 := 'O'
  cv!40 := 'G'
  cv!49 := 'Y'

  setcornercols(cv, cube%iWRB,  8, 11, 18) // Corner pieces
  setcornercols(cv, cube%iWBO,  2, 20, 27) 
  setcornercols(cv, cube%iWOG,  0, 29, 36) 
  setcornercols(cv, cube%iWGR,  6, 38,  9) 
  setcornercols(cv, cube%iYBR, 47, 24, 17) 
  setcornercols(cv, cube%iYOB, 53, 33, 26) 
  setcornercols(cv, cube%iYGO, 51, 42, 35) 
  setcornercols(cv, cube%iYRG, 45, 15, 44)
 
  setedgecols(cv, cube%iWR,  7, 10)  // edge piece, left sq, right sq
  setedgecols(cv, cube%iWB,  5, 19)
  setedgecols(cv, cube%iWO,  1, 28)
  setedgecols(cv, cube%iWG,  3, 37)

  setedgecols(cv, cube%iBR, 21, 14)
  setedgecols(cv, cube%iOB, 30, 23)
  setedgecols(cv, cube%iGO, 39, 32)
  setedgecols(cv, cube%iRG, 12, 41)

  setedgecols(cv, cube%iYR, 46, 16)
  setedgecols(cv, cube%iYB, 50, 25)
  setedgecols(cv, cube%iYO, 52, 34)
  setedgecols(cv, cube%iYG, 48, 43)
}

AND setcornercols(cv, piece, i, j, k) BE
{ // i, j, k are corner face numbers in anti-clockwise order
  //writef("setcornercols %i2 %i2 %i2 %i2*n", piece, i, j, k)
  SWITCHON piece INTO
  { DEDAULT:    writef("System error in setcornercols: piece=%n*n", piece)

    CASE WRB0:  cv!i, cv!j, cv!k := 'W', 'R', 'B'; RETURN
    CASE WRB1:  cv!j, cv!k, cv!i := 'W', 'R', 'B'; RETURN
    CASE WRB2:  cv!k, cv!i, cv!j := 'W', 'R', 'B'; RETURN
    CASE WBO0:  cv!i, cv!j, cv!k := 'W', 'B', 'O'; RETURN
    CASE WBO1:  cv!j, cv!k, cv!i := 'W', 'B', 'O'; RETURN
    CASE WBO2:  cv!k, cv!i, cv!j := 'W', 'B', 'O'; RETURN
    CASE WOG0:  cv!i, cv!j, cv!k := 'W', 'O', 'G'; RETURN
    CASE WOG1:  cv!j, cv!k, cv!i := 'W', 'O', 'G'; RETURN
    CASE WOG2:  cv!k, cv!i, cv!j := 'W', 'O', 'G'; RETURN
    CASE WGR0:  cv!i, cv!j, cv!k := 'W', 'G', 'R'; RETURN
    CASE WGR1:  cv!j, cv!k, cv!i := 'W', 'G', 'R'; RETURN
    CASE WGR2:  cv!k, cv!i, cv!j := 'W', 'G', 'R'; RETURN

    CASE YBR0:  cv!i, cv!j, cv!k := 'Y', 'B', 'R'; RETURN
    CASE YBR1:  cv!j, cv!k, cv!i := 'Y', 'B', 'R'; RETURN
    CASE YBR2:  cv!k, cv!i, cv!j := 'Y', 'B', 'R'; RETURN
    CASE YOB0:  cv!i, cv!j, cv!k := 'Y', 'O', 'B'; RETURN
    CASE YOB1:  cv!j, cv!k, cv!i := 'Y', 'O', 'B'; RETURN
    CASE YOB2:  cv!k, cv!i, cv!j := 'Y', 'O', 'B'; RETURN
    CASE YGO0:  cv!i, cv!j, cv!k := 'Y', 'G', 'O'; RETURN
    CASE YGO1:  cv!j, cv!k, cv!i := 'Y', 'G', 'O'; RETURN
    CASE YGO2:  cv!k, cv!i, cv!j := 'Y', 'G', 'O'; RETURN
    CASE YRG0:  cv!i, cv!j, cv!k := 'Y', 'R', 'G'; RETURN
    CASE YRG1:  cv!j, cv!k, cv!i := 'Y', 'R', 'G'; RETURN
    CASE YRG2:  cv!k, cv!i, cv!j := 'Y', 'R', 'G'; RETURN
  }
}

AND setedgecols(cv, piece, i, j) BE
{ //writef("setedgecols(%i2, %i2, %i2)*n", piece, i, j)
  SWITCHON piece INTO
  { DEFAULT:    writef("System error in setedgecols: piece=%n*n", piece)
                abort(999)

    CASE WR0:  cv!i, cv!j := 'W', 'R'; RETURN
    CASE WR1:  cv!j, cv!i := 'W', 'R'; RETURN
    CASE WB0:  cv!i, cv!j := 'W', 'B'; RETURN
    CASE WB1:  cv!j, cv!i := 'W', 'B'; RETURN
    CASE WO0:  cv!i, cv!j := 'W', 'O'; RETURN
    CASE WO1:  cv!j, cv!i := 'W', 'O'; RETURN
    CASE WG0:  cv!i, cv!j := 'W', 'G'; RETURN
    CASE WG1:  cv!j, cv!i := 'W', 'G'; RETURN

    CASE BR0:  cv!i, cv!j := 'B', 'R'; RETURN
    CASE BR1:  cv!j, cv!i := 'B', 'R'; RETURN
    CASE OB0:  cv!i, cv!j := 'O', 'B'; RETURN
    CASE OB1:  cv!j, cv!i := 'O', 'B'; RETURN
    CASE GO0:  cv!i, cv!j := 'G', 'O'; RETURN
    CASE GO1:  cv!j, cv!i := 'G', 'O'; RETURN
    CASE RG0:  cv!i, cv!j := 'R', 'G'; RETURN
    CASE RG1:  cv!j, cv!i := 'R', 'G'; RETURN

    CASE YR0:  cv!i, cv!j := 'Y', 'R'; RETURN
    CASE YR1:  cv!j, cv!i := 'Y', 'R'; RETURN
    CASE YB0:  cv!i, cv!j := 'Y', 'B'; RETURN
    CASE YB1:  cv!j, cv!i := 'Y', 'B'; RETURN
    CASE YO0:  cv!i, cv!j := 'Y', 'O'; RETURN
    CASE YO1:  cv!j, cv!i := 'Y', 'O'; RETURN
    CASE YG0:  cv!i, cv!j := 'Y', 'G'; RETURN
    CASE YG1:  cv!j, cv!i := 'Y', 'G'; RETURN
  }
}

AND goalscore(cube) = VALOF
{ LET k = ?
  LET piece = ?

  //writef("goalscore:*n")
  //prnode(cube)
//writef("upper edges WR=%n/%n WB=%n/%n WO=%n/%n WG=%n/%n*n",
//        cube%iWR, WR0,
//        cube%iWB, WB0,
//        cube%iWO, WO0,
//        cube%iWG, WG0)

  // Upper edges
  // Penalties
  // right edge wrong orientation  900
  // wrong edge                   1000
  k := 4*1000
  piece := cube%iWR
  IF piece=WR0 DO k := k-1000
  IF piece=WR1 DO k := k-100
  piece := cube%iWB
  IF piece=WB0 DO k := k-1000
  IF piece=WB1 DO k := k-100
  piece := cube%iWO
  IF piece=WO0 DO k := k-1000
  IF piece=WO1 DO k := k-100
  piece := cube%iWG
  IF piece=WG0 DO k := k-1000
  IF piece=WG1 DO k := k-100

  // If k=0 upper four edges are correct

  // Upper corners
  // Penalties
  // right corner wrong orientation  700
  // wrong corner                    800

  k := k + 4*800

  piece := cube%iWRB
  IF piece=WRB0 DO k := k-800
  IF piece=WRB1 DO k := k-100
  IF piece=WRB2 DO k := k-100
  piece := cube%iWBO
  IF piece=WBO0 DO k := k-800
  IF piece=WBO1 DO k := k-100
  IF piece=WBO2 DO k := k-100
  piece := cube%iWOG
  IF piece=WOG0 DO k := k-800
  IF piece=WOG1 DO k := k-100
  IF piece=WOG2 DO k := k-100
  piece := cube%iWGR
  IF piece=WGR0 DO k := k-800
  IF piece=WGR1 DO k := k-100
  IF piece=WGR2 DO k := k-100

  // If k=0 upper layer is now correct

  // Middle layer edges
  // Penalties
  // right edge wrong orientation  250
  // wrong edge                    300

  k := k + 4*300

  piece := cube%iBR
  IF piece=BR0 DO k := k-300
  IF piece=BR1 DO k := k- 50
  piece := cube%iOB
  IF piece=OB0 DO k := k-300
  IF piece=OB1 DO k := k- 50
  piece := cube%iGO
  IF piece=GO0 DO k := k-300
  IF piece=GO1 DO k := k- 50
  piece := cube%iRG
  IF piece=RG0 DO k := k-300
  IF piece=RG1 DO k := k- 50

  // If k=0 upper and middle layers are now correct

  // Lower level edges
  // Penalties
  // right edge wrong orientation  30
  // wrong edge                    40

  k := k + 4*40

  piece := cube%iYR
  IF piece=YR0 DO k := k-40
  IF piece=YR1 DO k := k-10
  piece := cube%iYB
  IF piece=YB0 DO k := k-40
  IF piece=YB1 DO k := k-10
  piece := cube%iYO
  IF piece=YO0 DO k := k-40
  IF piece=YO1 DO k := k-10
  piece := cube%iYG
  IF piece=YG0 DO k := k-40
  IF piece=YG1 DO k := k-10

  // If k=0 upper and middle layers are now correct
  // and down face edges are correct

  // Lower level corners
  // Penalties
  // right edge wrong orientation  15
  // wrong edge                    20

  k := k+4*20

  piece := cube%iYBR
  IF piece=YBR0 DO k := k-20
  IF piece=YBR1 DO k := k- 5
  IF piece=YBR2 DO k := k- 5
  piece := cube%iYOB
  IF piece=YOB0 DO k := k-20
  IF piece=YOB1 DO k := k- 5
  IF piece=YOB2 DO k := k- 5
  piece := cube%iYGO
  IF piece=YGO0 DO k := k-20
  IF piece=YGO1 DO k := k- 5
  IF piece=YGO2 DO k := k- 5
  piece := cube%iYRG
  IF piece=YRG0 DO k := k-20
  IF piece=YRG1 DO k := k- 5
  IF piece=YRG2 DO k := k- 5

  // If k=0 all positions are correct so the Rubik Cube has been solved
  //writef("goalscore: returning %n*n", k)
  //abort(9000)
  RESULTIS k
} 
