//SECTION "BLIB4"
// 37764: 03E8 BCPL  Section     size   784 bytes

GET "com16/LIBHDR.h"
GET "com16/SYSHDR.h"

LET COMPCH(ch1, ch2) = VALOF
{ // 37780.
  RESULTIS CAPCH(ch1) - CAPCH(ch2)
}

AND COMPSTRING(s1, s2) = VALOF
{ MANIFEST { casediff = 'A'-'a' }
  // 37800.
  LET l1 = s1 % 0   // p5
  LET l2 = s2 % 0   // p6

  LET s  = (l1 < l2 -> s1, s2)  // p7
  LET i  = 1                    // p8
  AND n = s%0                   // p9

  // 37820.
  WHILE i <= n DO
  { // 37822.
    LET diff = COMPCH(s1 % i, s2 % i)  // p10
    IF diff ~= 0 RESULTIS diff
    i := i + 1
  }

  IF l1=l2 RESULTIS 0
  IF s=s1 RESULTIS -1
  RESULTIS 1
}

AND FINDARG(keys, w) = VALOF  // =argno if found
                              // =-1 otherwise
{ // 37872.
  MANIFEST { matching = 0; skipping = 1 }
  // 37872.
  LET state, wp, argno = matching, 0, 0  // p5  p6  p7
  // 37876.
  FOR i = 1 TO keys % 0 DO // p8  p9   -> 37949
  { // 37882.
    LET kch = keys % i    // p10
    // 37886.
    IF state = matching DO
    { IF  // 37889. 
         (kch = '=' |
          // 37894.
          kch = '/' |
          // 37898.
          kch =',') &
          // 37903.
          wp = w % 0 DO // 37909. 
                        RESULTIS argno
      // 37912.
      wp := wp + 1
      UNLESS // 37915.
             COMPCH(kch,w % wp) = 0 DO
        // 37924.
        state := skipping
    }
    IF // 37926.
       kch = ',' |
       // 37931
       kch = '=' DO // 37935. 
                    state, wp := matching, 0
    IF // 37938.
       kch = ',' DO // 37943.
                    argno := argno+1
    // 37946. increment i and conditional jump
  }
  
  RESULTIS // 37953.
           state = matching &
           // 37956.
           wp = w % 0 -> // 37962.
                         argno,
                         // 37965.
                         -1
}

AND RDARGS(keys, argv, size) = VALOF
{ // 37978.
  LET w = argv         // p6
  LET numbargs = ?     // p7
  // 37980.
  !w := 0
  // 37983.
  FOR p = 1 TO keys%0 DO  // p8  p9  -> 38052
  { // 37991.
    LET kch = keys%p      // p10
    // 37995.
    IF  kch = '/' DO      // -> 38038
    { // 37999.
      LET c = CAPCH(keys%(p+1))   // p11
      // 38007.
      IF  c = 'A' DO !w := !w | 1
      // 38016.
      IF  c = 'K' DO !w := !w | 2
      // 38026.
      IF  c = 'S' DO !w := !w | 4
      // 38036.
      LOOP      // -> 38049
    }
    // 38038. 
    IF kch = ',' DO // -> 38049
    { // 38043.
      w  := w+1
      // 38046.
      !w := 0
    }
    // 38049. increment p and conditional jump to 37991
  }
  // 38056.
  w := w+1
  // 38059.
  numbargs := w-argv

// At this stage, the argument elements of argv have been
// initialised to  0    -
//                 1   /A
//                 2   /K
//                 3   /A/K
//                 4   /S
//                 5   /S/A
//                 6   /S/K
//                 7   /S/A/K

  { // 38062.
    LET argno = -1     // p8
    // 38064.
    LET wsize = size + argv - w       // p9
    // 38069.
    SWITCHON rditem(w, wsize) INTO    // -> 38270
    { DEFAULT:
         // 38071.
         // NOP
 err: { LET ch = ?                    // p10
        // 38072.
        UNRDCH()
        // 38074.
        ch := rdch() REPEATUNTIL // 38077.
                                 ch=5    |
                                 // 38080.
                                 ch='*N' |
                                 // 38084.
                                 ch=';'  |
                                 // 38099.
                                 ch=endstreamch  // -> 38074
        // 38092.
        RESULTIS 0
      }

      CASE 0:  // *N, *E, ;, endstreamch
      CASE -3: //
        // 38095. 
        FOR i = 0 TO numbargs - 1 DO  // p10  p11  -> 38126
        { // 38102.
          LET a = argv!i              // p12
          // 39105.
          IF 0 <= a <= 7 TEST // 38110. 
                              (a & 1) = 0    // ->38120
                         THEN // 38115.
                              argv!i := 0
                         ELSE // 38120.
                              GOTO err
          // 38123.   increment i and cond jump to 38102
        }
        //38130.
        RESULTIS w

      CASE 1: // Ordinary item
              //38133.
              argno := FINDARG(keys, w)
              TEST // 38139.
                   argno>=0                  //  -> 38179
              THEN // get and check argument
                   TEST // 38141.
                        4 <= argv!argno <= 7  //  -> 38155
                   THEN { // no value for key
                          // 38150.
                          argv!argno := -1
                          // 38153. 
                          LOOP                //  -> 38062
                        }
                   ELSE { // 38155.
                          LET item = RDITEM(w,wsize)
                          // 38161.
                          IF item  = -2 DO // 38165. 
                                           item := rditem(w,wsize)
                          // 38171.
                          IF item <=  0 DO // 38174.
                                           GOTO err
                          // 38177.  -> 38202
                        }
              ELSE TEST // 38179.
                        rdch()='*N' & COMPSTRING("?", w)=0  // -> 38200
                   THEN { // help facility
                          // 38192.
                          WRITEF("%S: *n", keys)
                          // 38198.
                          ENDCASE  //  -> 38296
                        }
                   ELSE // 38200.
                        UNRDCH()

      CASE 2: // Quoted item (i.e. arg value)
              // 38202.
              IF argno<0 // 38205.
                         FOR i = 0 TO numbargs-1 DO //  p10  p11  -> 37247
                         { // 38212.
                           SWITCHON argv!i INTO          //  -> 38221
                           { CASE 0: CASE 1: // 38214.
                                             argno := i
                                             // 38216.
                                             BREAK       //  -> 38251
                             CASE 2: CASE 3: // 38218.
                                             GOTO err    //  -> 38072
                             // SWB on 4 cases
                             DEFAULT:
                           }
                           // 38244. increment i and conditional jump to 38212
                         }

              // 38251.
              UNLESS argno>=0 //38254.
                              GOTO err
              // 38257.
              argv!argno := w
              // 38260.
              w := w + w%0/BYTESPERWORD + 1
    }
  } REPEAT      //  -> 38296
}

AND RDITEM(v, size) = VALOF
{ // 38318.
  LET p      = ?                         //  p5
  // 38320.
  LET pmax   = ((size+1)<<1)-1           //  p6
  // 38326.
  LET ch     = ?                         //  p7
  // 38326.
  LET quoted = FALSE                     //  p8

  // 38328.
  UNLESS 0 <= size <= 1000 DO
  { // 38336.
    RESULTIS TRUE
  }
  // 38339.
  v!0 := 0
  // 38341.
  MOVE(v, v+1, size-1)
  // 38350.

  ch := RDCH() REPEATWHILE // 38353.
                           ch='*S' |  // -> 38350
                           // 38357.
                           ch='*T'    // -> 38350
  // 38361.
  IF ch='"' DO // 38365.  -> 38370
               quoted, ch := TRUE, RDCH()
  // 38370.
  UNTIL ch=5 | ch='*N' | ch=ENDSTREAMCH DO
  { TEST quoted
    THEN { IF ch='"'  RESULTIS 2
           IF ch='**' DO
           { ch := RDCH()
             IF CAPCH(ch)='E' DO ch :=  5      //'*E'
             IF CAPCH(ch)='N' DO ch := '*N'
           }
         }
    ELSE IF ch=';'  |
            ch='*S' |
            ch='='  BREAK

    p   := p+1
    IF p>pmax RESULTIS -1
    v%p := ch
    v%0 := p
    ch  := RDCH()
  }

  UNRDCH()
  IF quoted RESULTIS -1
  TEST p=0
  THEN { IF ch='=' DO
         { RDCH()
           RESULTIS -2
         }
         RESULTIS 0
       }
  ELSE RESULTIS 1
}
