// Reconstruction of bbccin/JOINCIN using map/JOINCIN.map

SECTION "JOINCIN"

GET "libhdr.h"

GLOBAL {
  612:12     // Unknown library functions
  g60:60
}

STATIC {
  stdout=0     // L336
  instream=0   // L338
  outstream=0  // L340
  tofilename=0 // L342
}

LET start() BE
{ LET reslen = 1                              // P3
  LET v = VEC 31   // 5 .. 36                 // P4
  LET form = "FROM/A,,,,,,,,,,,,AS=TO/A/K"    // P37
  LET argv = VEC 110 // 39 ..149              // P38
  LET badformat = "FILE %S - INVALID FORMAT"  // P150
  stdout := OUTPUT()                          // L336
  instream := 0                               // L338
  outstream := 0                              // L340
  UNLESS RDARGS(form, argv, 110) DO           // 42 - 57
     STOP(11)                                 // 58 - 63


  f584(argv)                                  // 64 - 69
  tofilename := argv!12                       // 70 - 76
  outstream := FINDOUTPUT(tofilename)         // 77 - 82
  UNLESS outstream DO                         // 83 - 84
    error("CANNOT OPEN OUTPUT FILE %S",       // 85 - 98
           tofilename, RESULT2)

  SELECTOUTPUT(outstream)                     // 99 - 104

  FOR i = 0 TO 11 DO                          // 105 - 294
  { LET word, p153 = ?, ?                     //              P152 and P153
    LET name = argv!i                         // 110 - 116    P154
    UNLESS name BREAK                         // 117 - 120
    instream := FINDINPUT(name)               // 121 - 128    instream=L338
    UNLESS instream DO                        // 129 - 130
       error("CANNOT OPEN INPUT FILE %S",     // 131 - 144
              name, RESULT2)
   SELECTINPUT(instream)                      // 145 - 150
   word := rdword()                           // 151 - 156

   WHILE (word & -8) = 1000 DO                // 157 - 258
    { LET len = rdword()
      wrword(word)
      wrword(len)
      reslen := reslen + len + 2
      WHILE len>0 DO
      { LET n = len<32 -> len, 32
        UNLESS READWORDS(v, n) = n DO
          error(badformat, name, 40)
        WRITEWORDS(v, n)
        len := len - n
      }
      word := rdword()
    }

    UNLESS word=T.END DO
      error(badformat, name, 40)
    ENDREAD()
  } 
  ENDWRITE(wrword(T.END))
  instream := 0
  outstream := 0
  SELECTOUTPUT(stdout)
  WRITEF("%I5 word file %S created*n", reslen, tofilename)
  STOP(0)
}

AND rdword() = VALOF
{ LET byte = RDBIN()
  RESULTIS RDBIN()<<8 | byte
}

AND wrword(w) BE
{ WRBIN(w)
  WRBIN(w>>8)
}

AND error(mess, arg, returncode) BE
{ UNLESS instream DO
    ENDREAD()
  UNLESS outstream DO
    DELFILE(tofilename)
  SELECTOUTPUT(stdout)
  WRITEF(mess, arg)
  WRITES("*nJOIN OF CINTCODE FAILED*n")
  STOP(returncode)
}

AND f2126(p3) BE
{ LET p4 = g60(p3!12, 2)
  LET p5 = g12%0 >> 1
  LET p6 = GETVEC(p5)
  LET p7 = ?
  TRAP(p6, p6, p5+1)
  FOR p8 = 0 TO 11 DO
  { UNLESS p3!p8 BREAK
    p7 := g60(p3!p8, 1)
    UNLESS p7=p4 LOOP
    UNLESS COPYSTRING(g12, p6) LOOP
    FREEVEC(p6)
    error("SAME FILE FOR INPUT AND OUTPUT", 0, 11)
  }
  FREEVEC(p6)
}
